(changelog)=

# Changelog

<!-- <START NEW CHANGELOG ENTRY> -->

## 5.10.4

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.10.3...be5ff0a81d544238599b9df4fcefa19e235a8898))

### Maintenance and upkeep improvements

- Set all min deps [#399](https://github.com/jupyter/nbformat/pull/399) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#398](https://github.com/jupyter/nbformat/pull/398) ([@pre-commit-ci](https://github.com/pre-commit-ci))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2024-03-15&to=2024-04-04&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2024-03-15..2024-04-04&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2024-03-15..2024-04-04&type=Issues)

<!-- <END NEW CHANGELOG ENTRY> -->

## 5.10.3

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.10.2...c17a251a1b1c5e2a7b9fe1fce866d4c110dd12eb))

### Bugs fixed

- Revert PR #378 (Simplify NotebookNotary.\_data_dir_default) [#397](https://github.com/jupyter/nbformat/pull/397) ([@krassowski](https://github.com/krassowski))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2024-03-12&to=2024-03-15&type=c))

[@krassowski](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Akrassowski+updated%3A2024-03-12..2024-03-15&type=Issues)

## 5.10.2

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.10.1...cf61c0ef37312e33efe3ca61ba1f13a4cb5ca901))

### Maintenance and upkeep improvements

- Restore usage of npm token [#395](https://github.com/jupyter/nbformat/pull/395) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2024-03-12&to=2024-03-12&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2024-03-12..2024-03-12&type=Issues)

## 5.10.1

No merged PRs

## 5.10.0

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.9.2...e690de194660e7e4b3ac083001ce21633d418e3a))

### Maintenance and upkeep improvements

- Update Release Scripts [#394](https://github.com/jupyter/nbformat/pull/394) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#391](https://github.com/jupyter/nbformat/pull/391) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- chore: update pre-commit hooks [#390](https://github.com/jupyter/nbformat/pull/390) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Update ruff and typings [#388](https://github.com/jupyter/nbformat/pull/388) ([@blink1073](https://github.com/blink1073))
- update incorrect warning text [#386](https://github.com/jupyter/nbformat/pull/386) ([@Carreau](https://github.com/Carreau))
- chore: update pre-commit hooks [#385](https://github.com/jupyter/nbformat/pull/385) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Clean up lint handling [#384](https://github.com/jupyter/nbformat/pull/384) ([@blink1073](https://github.com/blink1073))
- Adopt ruff format [#383](https://github.com/jupyter/nbformat/pull/383) ([@blink1073](https://github.com/blink1073))
- Update typings for mypy 1.6 [#381](https://github.com/jupyter/nbformat/pull/381) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#380](https://github.com/jupyter/nbformat/pull/380) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Fix typing error [#379](https://github.com/jupyter/nbformat/pull/379) ([@blink1073](https://github.com/blink1073))
- Simplify NotebookNotary.\_data_dir_default [#378](https://github.com/jupyter/nbformat/pull/378) ([@cmd-ntrf](https://github.com/cmd-ntrf))
- Adopt sp-repo-review [#377](https://github.com/jupyter/nbformat/pull/377) ([@blink1073](https://github.com/blink1073))
- Bump actions/checkout from 3 to 4 [#375](https://github.com/jupyter/nbformat/pull/375) ([@dependabot](https://github.com/dependabot))

### Documentation improvements

- update incorrect warning text [#386](https://github.com/jupyter/nbformat/pull/386) ([@Carreau](https://github.com/Carreau))
- Improve project URLs that display on PyPI [#374](https://github.com/jupyter/nbformat/pull/374) ([@pydanny](https://github.com/pydanny))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2023-07-31&to=2024-03-12&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2023-07-31..2024-03-12&type=Issues) | [@Carreau](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3ACarreau+updated%3A2023-07-31..2024-03-12&type=Issues) | [@cmd-ntrf](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Acmd-ntrf+updated%3A2023-07-31..2024-03-12&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Adependabot+updated%3A2023-07-31..2024-03-12&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2023-07-31..2024-03-12&type=Issues) | [@pydanny](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apydanny+updated%3A2023-07-31..2024-03-12&type=Issues)

## 5.9.2

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.9.1...80dd726ec87218e0b428a857b4cc656e7e9950d3))

### Bugs fixed

- Fix version handling [#372](https://github.com/jupyter/nbformat/pull/372) ([@blink1073](https://github.com/blink1073))

### Maintenance and upkeep improvements

- Fix encoding warnings [#371](https://github.com/jupyter/nbformat/pull/371) ([@blink1073](https://github.com/blink1073))
- Update link to notebook security [#370](https://github.com/jupyter/nbformat/pull/370) ([@blink1073](https://github.com/blink1073))

### Documentation improvements

- Update link to notebook security [#370](https://github.com/jupyter/nbformat/pull/370) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2023-07-10&to=2023-07-31&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2023-07-10..2023-07-31&type=Issues)

## 5.9.1

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.9.0...c348f9d12f05b4e0350413c74f58cd9e4f54a550))

### Maintenance and upkeep improvements

- Fix deprecation warning when importing from jsonschema [#368](https://github.com/jupyter/nbformat/pull/368) ([@eladkal](https://github.com/eladkal))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2023-05-31&to=2023-07-10&type=c))

[@eladkal](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Aeladkal+updated%3A2023-05-31..2023-07-10&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2023-05-31..2023-07-10&type=Issues)

## 5.9.0

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.8.0...1b5e8e4e9af98f9c9b0843ba155b8756103d094d))

### Maintenance and upkeep improvements

- Support Python 3.12 [#363](https://github.com/jupyter/nbformat/pull/363) ([@blink1073](https://github.com/blink1073))
- Use local coverage [#360](https://github.com/jupyter/nbformat/pull/360) ([@blink1073](https://github.com/blink1073))
- Bump actions/checkout from 2 to 3 [#350](https://github.com/jupyter/nbformat/pull/350) ([@dependabot](https://github.com/dependabot))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2023-03-20&to=2023-05-31&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2023-03-20..2023-05-31&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Adependabot+updated%3A2023-03-20..2023-05-31&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2023-03-20..2023-05-31&type=Issues)

## 5.8.0

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.7.3...85917af9c77beae326531e1923e0ec47725e590b))

### Enhancements made

- Add strip_invalid_metadata argument to validator normalize method [#355](https://github.com/jupyter/nbformat/pull/355) ([@jonabc](https://github.com/jonabc))

### Maintenance and upkeep improvements

- Fix codecov badge [#352](https://github.com/jupyter/nbformat/pull/352) ([@blink1073](https://github.com/blink1073))
- Add license [#348](https://github.com/jupyter/nbformat/pull/348) ([@dcsaba89](https://github.com/dcsaba89))
- Add more linting [#345](https://github.com/jupyter/nbformat/pull/345) ([@blink1073](https://github.com/blink1073))
- Only add ellipsis to NotJSONError message if message is truncated [#344](https://github.com/jupyter/nbformat/pull/344) ([@rschroll](https://github.com/rschroll))

### Documentation improvements

- DOC: README: capitalization, title [#346](https://github.com/jupyter/nbformat/pull/346) ([@westurner](https://github.com/westurner))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2023-01-12&to=2023-03-20&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2023-01-12..2023-03-20&type=Issues) | [@dcsaba89](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Adcsaba89+updated%3A2023-01-12..2023-03-20&type=Issues) | [@jonabc](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ajonabc+updated%3A2023-01-12..2023-03-20&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2023-01-12..2023-03-20&type=Issues) | [@rschroll](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Arschroll+updated%3A2023-01-12..2023-03-20&type=Issues) | [@westurner](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Awesturner+updated%3A2023-01-12..2023-03-20&type=Issues)

## 5.7.3

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.7.2...1eefc29edff5da06f78c0087e7c06e644a6abcc9))

### Maintenance and upkeep improvements

- Undeprecate validate(nb, relax_add_props=True) [#343](https://github.com/jupyter/nbformat/pull/343) ([@minrk](https://github.com/minrk))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2023-01-11&to=2023-01-12&type=c))

[@minrk](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Aminrk+updated%3A2023-01-11..2023-01-12&type=Issues)

## 5.7.2

([Full Changelog](https://github.com/jupyter/nbformat/compare/v5.7.1...30f3d81e7113ad7628443fc4cd389ca16b2d186a))

### Bugs fixed

- Only require nbformat_minor for v4 [#342](https://github.com/jupyter/nbformat/pull/342) ([@minrk](https://github.com/minrk))

### Maintenance and upkeep improvements

- Fix check release [#341](https://github.com/jupyter/nbformat/pull/341) ([@blink1073](https://github.com/blink1073))
- Add spell checker and enforce docstrings [#339](https://github.com/jupyter/nbformat/pull/339) ([@blink1073](https://github.com/blink1073))
- Fix docs build [#338](https://github.com/jupyter/nbformat/pull/338) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2022-12-19&to=2023-01-11&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2022-12-19..2023-01-11&type=Issues) | [@minrk](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Aminrk+updated%3A2022-12-19..2023-01-11&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2022-12-19..2023-01-11&type=Issues)

## 5.7.1

([Full Changelog](https://github.com/jupyter/nbformat/compare/5.7.0...45ff0cd6dbc5e46a3b620124deeda00aaeebfa29))

### Maintenance and upkeep improvements

- Expose more attributes for typing [#337](https://github.com/jupyter/nbformat/pull/337) ([@blink1073](https://github.com/blink1073))
- Fix lint [#336](https://github.com/jupyter/nbformat/pull/336) ([@blink1073](https://github.com/blink1073))
- Adopt ruff and address lint [#333](https://github.com/jupyter/nbformat/pull/333) ([@blink1073](https://github.com/blink1073))
- Use base setup dependency type [#329](https://github.com/jupyter/nbformat/pull/329) ([@blink1073](https://github.com/blink1073))
- Switch to using Jupyter Releaser [#326](https://github.com/jupyter/nbformat/pull/326) ([@blink1073](https://github.com/blink1073))
- More maintenance cleanup [#325](https://github.com/jupyter/nbformat/pull/325) ([@blink1073](https://github.com/blink1073))
- Handle warning from jupyter client [#322](https://github.com/jupyter/nbformat/pull/322) ([@blink1073](https://github.com/blink1073))
- Add dependabot [#320](https://github.com/jupyter/nbformat/pull/320) ([@blink1073](https://github.com/blink1073))
- Clean up docs and maintenance [#314](https://github.com/jupyter/nbformat/pull/314) ([@blink1073](https://github.com/blink1073))

### Documentation improvements

- Fix changelog target [#321](https://github.com/jupyter/nbformat/pull/321) ([@chrisjsewell](https://github.com/chrisjsewell))
- Clean up docs and maintenance [#314](https://github.com/jupyter/nbformat/pull/314) ([@blink1073](https://github.com/blink1073))

### Other merged PRs

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/nbformat/graphs/contributors?from=2022-10-10&to=2022-12-19&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Ablink1073+updated%3A2022-10-10..2022-12-19&type=Issues) | [@chrisjsewell](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Achrisjsewell+updated%3A2022-10-10..2022-12-19&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fnbformat+involves%3Apre-commit-ci+updated%3A2022-10-10..2022-12-19&type=Issues)

# Changes in nbformat

## 5.7.0

- Always use jsonschema to handle error reporting.
- Fix deprecation warning suggestion.

## 5.6.1

- Fix handling of `__version__` on Python 3.7.

## 5.6.0

- Fix docs and type annotations for `validator.normalize`.
- Switch to hatch build backend.

## 5.5.0

The biggest change in `nbformat` 5.5.0 is the deprecation of arguments
to `validate()` that try to fix notebooks errors during validation.

`validate()` is a function that is core to the security model of
Jupyter, and is assumed in a number of places to not mutate it's
argument, or try to fix notebooks passed to it.

Auto fixing of notebook in validate can also hide subtle bugs, and will
therefore be updated in a near future to not take any of the argument
related to auto-fixing, and fail instead of silently modifying its
parameters on invalid notebooks.

`nbformat` now contain a `normalize` function that will return a
normalized copy of a notebook that is suitable for validation. While
offered as a convenience we discourage its use and suggest library make
sure to generate valid notebooks.

### Other changes

- `nbformat` is now built with flit, and uses `pyproject.toml`
- Documentation and Deprecations have been updated with version number
  and stack levels.

## 5.4.0

- Add project URLs to `setup.py`
- Fix import in `nbformat.current`
- Add `mypy` and typings support
- Improve CI

## 5.3.0

- Use `fastjsonschema` by default
- Adopt `pre-commit` and auto-formatters
- Increase minimum `jsonschema` to 2.6, handle warnings

## 5.2.0

- Add ability to capture validation errors
- Update supported python versions
- Ensure nbformat minor version is present when upgrading
- Only fix cell ID validation issues if asked
- Return the notebook when no conversion is needed
- Catch AttributeErrors stemming from ipython_genutils as
  ValidationErrors on read
- Don't list pytest-cov as a test dependency
- Remove dependency on IPython genutils
- Include tests in sdist but not wheel

## 5.1.3

- Change id generation to be hash based to avoid problematic word
  combinations
- Added tests for python 3.9
- Fixed setup.py build operations to include package data

## 5.1.2

- Fixed missing file in manifest

## 5.1.1

- Changes convert.upgrade to upgrade minor 4.x versions to 4.5

## 5.1.0

- Implemented CellIds from JEP-62
- Fixed a regression introduced when using fastjsonschema, which does
  not directly support to validate a "reference"/"subschema"
- Removed unreachable/unneeded code
- Added CI workflow for package release on tag push

## 5.0.8

- Add optional support for using \[fastjsonschema\]{.title-ref} as the
  JSON validation library. To enable fast validation, install
  \[fastjsonschema\]{.title-ref} and set the environment variable
  \[NBFORMAT_VALIDATOR\]{.title-ref} to the value
  \[fastjsonschema\]{.title-ref}.

## 5.0.7

- Fixed a bug where default values for validator.get_validator()
  failed with an import error

## 5.0.6

- nbformat.read() function has a better duck-type interface and will
  raise more meaningful error messages if it can't parse a notebook
  document.

## 5.0.5

- Allow notebook format 4.0 and 4.1 to have the arbitrary JSON
  mimebundles from format 4.2 for pragmatic purposes.
- Support reading/writing path-like objects has been added to read
  operations.

## 5.0.4

- Fixed issue causing python 2 to pick up 5.0.x releases.

## 5.0.3

- Removed debug print statements from project.

## 5.0.2

- Added schema validation files for older versions. This was breaking
  notebook generation.

## 5.0.1

## 5.0

[5.0 on GitHub](https://github.com/jupyter/nbformat/milestone/5)

- Starting with 5.0, `nbformat` is now Python 3 only (>= 3.5)
- Add execution timings in code cell metadata for v4 spec.
  `"metadata": { "execution": {...}}` should be populated with
  kernel-specific timing information.
- Documentation for how markup is used in notebooks added
- Link to json schema docs from format page added
- Documented the editable metadata flag
- Update description for collapsed field
- Documented notebook format versions 4.0-4.3 with accurate json
  schema specification files
- Clarified info about name's meaning for cells
- Added a default execution_count of None for
  new_output_cell('execute_result')
- Added support for handling nbjson kwargs
- Wheels now correctly have a LICENSE file
- Travis builds now have a few more execution environments

## 4.4

[4.4 on GitHub](https://github.com/jupyter/nbformat/milestone/9)

- Explicitly state that metadata fields can be ignored.
- Introduce official jupyter namespace inside metadata
  (`metadata.jupyter`).
- Introduce `source_hidden` and `outputs_hidden` as official front-end
  metadata fields to indicate hiding source and outputs areas. **NB**:
  These fields should not be used to hide elements in exported
  formats.
- Fix ending the redundant storage of signatures in the signature
  database.
- `nbformat.validate` can be set to not
  raise a ValidationError if additional properties are included.
- Fix for errors with connecting and backing up the signature
  database.
- Dict-like objects added to NotebookNode attributes are now
  transformed to be NotebookNode objects; transformation also works
  for \[.update()\]{.title-ref}.

## 4.3

[4.3 on GitHub](https://github.com/jupyter/nbformat/milestone/7)

- A new pluggable `SignatureStore` class allows specifying different
  ways to record the signatures of trusted notebooks. The default is
  still an SQLite database. See
  `pluggable_signature_store` for more
  information.
- `nbformat.read` and
  `nbformat.write` accept file paths as
  bytes as well as unicode.
- Fix for calling `nbformat.validate`
  on an empty dictionary.
- Fix for running the tests where the locale makes ASCII the default
  encoding.
- Include nbformat-schema files (v3 and v4) in nbformat-schema npm
  package.
- Include configuration for appveyor's continuous integration
  service.

## 4.2

### 4.2.0

[4.2 on GitHub](https://github.com/jupyter/nbformat/milestones/4.2)

- Update nbformat spec version to 4.2, allowing JSON outputs to have
  any JSONable type, not just `object`, and mime-types of the form
  `application/anything+json`.
- Define basics of `authors` in notebook metadata.
  `nb.metadata.authors` shall be a list of objects with the property
  `name`, a string of each author's full name.
- Update use of traitlets API to require traitlets 4.1.
- Support trusting notebooks on stdin with
  `cat notebook | jupyter trust`

## 4.1

### 4.1.0

[4.1 on GitHub](https://github.com/jupyter/nbformat/milestones/4.1)

- Update nbformat spec version to 4.1, adding support for attachments
  on markdown and raw cells.
- Catch errors opening trust database, falling back on `:memory:` if
  the database cannot be opened.

## 4.0

[4.0 on GitHub](https://github.com/jupyter/nbformat/milestones/4.0)

The first release of nbformat as its own package.
