// This file implements the IExplorerBrowserEvents Interface and Gateway for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIExplorerBrowserEvents.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIExplorerBrowserEvents::PyIExplorerBrowserEvents(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIExplorerBrowserEvents::~PyIExplorerBrowserEvents() {}

/* static */ IExplorerBrowserEvents *PyIExplorerBrowserEvents::GetI(PyObject *self)
{
    return (IExplorerBrowserEvents *)PyIUnknown::GetI(self);
}

// @pymethod |PyIExplorerBrowserEvents|OnNavigationPending|Description of OnNavigationPending.
PyObject *PyIExplorerBrowserEvents::OnNavigationPending(PyObject *self, PyObject *args)
{
    IExplorerBrowserEvents *pIEBE = GetI(self);
    if (pIEBE == NULL)
        return NULL;
    PCIDLIST_ABSOLUTE pidlFolder;
    PyObject *obpidlFolder;
    // @pyparm <o PyPCIDLIST_ABSOLUTE>|pidlFolder||Description for pidlFolder
    if (!PyArg_ParseTuple(args, "O:OnNavigationPending", &obpidlFolder))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy && !PyObject_AsPCIDLIST_ABSOLUTE(obpidlFolder, &pidlFolder))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIEBE->OnNavigationPending(pidlFolder);
    PyObject_FreePCIDLIST_ABSOLUTE(pidlFolder);

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEBE, IID_IExplorerBrowserEvents);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIExplorerBrowserEvents|OnViewCreated|Description of OnViewCreated.
PyObject *PyIExplorerBrowserEvents::OnViewCreated(PyObject *self, PyObject *args)
{
    IExplorerBrowserEvents *pIEBE = GetI(self);
    if (pIEBE == NULL)
        return NULL;
    // @pyparm <o PyIShellView>|psv||Description for psv
    PyObject *obpsv;
    IShellView *psv;
    if (!PyArg_ParseTuple(args, "O:OnViewCreated", &obpsv))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy &&
        !PyCom_InterfaceFromPyInstanceOrObject(obpsv, IID_IShellView, (void **)&psv, TRUE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIEBE->OnViewCreated(psv);
    if (psv)
        psv->Release();

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEBE, IID_IExplorerBrowserEvents);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIExplorerBrowserEvents|OnNavigationComplete|Description of OnNavigationComplete.
PyObject *PyIExplorerBrowserEvents::OnNavigationComplete(PyObject *self, PyObject *args)
{
    IExplorerBrowserEvents *pIEBE = GetI(self);
    if (pIEBE == NULL)
        return NULL;
    PCIDLIST_ABSOLUTE pidlFolder;
    PyObject *obpidlFolder;
    // @pyparm <o PyPCIDLIST_ABSOLUTE>|pidlFolder||Description for pidlFolder
    if (!PyArg_ParseTuple(args, "O:OnNavigationComplete", &obpidlFolder))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy && !PyObject_AsPCIDLIST_ABSOLUTE(obpidlFolder, &pidlFolder))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIEBE->OnNavigationComplete(pidlFolder);
    PyObject_FreePCIDLIST_ABSOLUTE(pidlFolder);

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEBE, IID_IExplorerBrowserEvents);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIExplorerBrowserEvents|OnNavigationFailed|Description of OnNavigationFailed.
PyObject *PyIExplorerBrowserEvents::OnNavigationFailed(PyObject *self, PyObject *args)
{
    IExplorerBrowserEvents *pIEBE = GetI(self);
    if (pIEBE == NULL)
        return NULL;
    PCIDLIST_ABSOLUTE pidlFolder;
    PyObject *obpidlFolder;
    // @pyparm <o PyPCIDLIST_ABSOLUTE>|pidlFolder||Description for pidlFolder
    if (!PyArg_ParseTuple(args, "O:OnNavigationFailed", &obpidlFolder))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy && !PyObject_AsPCIDLIST_ABSOLUTE(obpidlFolder, &pidlFolder))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIEBE->OnNavigationFailed(pidlFolder);
    PyObject_FreePCIDLIST_ABSOLUTE(pidlFolder);

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEBE, IID_IExplorerBrowserEvents);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIExplorerBrowserEvents|Description of the interface
static struct PyMethodDef PyIExplorerBrowserEvents_methods[] = {
    {"OnNavigationPending", PyIExplorerBrowserEvents::OnNavigationPending,
     1},  // @pymeth OnNavigationPending|Description of OnNavigationPending
    {"OnViewCreated", PyIExplorerBrowserEvents::OnViewCreated,
     1},  // @pymeth OnViewCreated|Description of OnViewCreated
    {"OnNavigationComplete", PyIExplorerBrowserEvents::OnNavigationComplete,
     1},  // @pymeth OnNavigationComplete|Description of OnNavigationComplete
    {"OnNavigationFailed", PyIExplorerBrowserEvents::OnNavigationFailed,
     1},  // @pymeth OnNavigationFailed|Description of OnNavigationFailed
    {NULL}};

PyComTypeObject PyIExplorerBrowserEvents::type("PyIExplorerBrowserEvents", &PyIUnknown::type,
                                               sizeof(PyIExplorerBrowserEvents), PyIExplorerBrowserEvents_methods,
                                               GET_PYCOM_CTOR(PyIExplorerBrowserEvents));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGExplorerBrowserEvents::OnNavigationPending(
    /* [in] */ PCIDLIST_ABSOLUTE pidlFolder)
{
    PY_GATEWAY_METHOD;
    PyObject *obpidlFolder = PyObject_FromPCIDLIST_ABSOLUTE(pidlFolder, FALSE);
    if (obpidlFolder == NULL)
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("OnNavigationPending");
    HRESULT hr = InvokeViaPolicy("OnNavigationPending", NULL, "O", obpidlFolder);
    Py_DECREF(obpidlFolder);
    return hr;
}

STDMETHODIMP PyGExplorerBrowserEvents::OnViewCreated(
    /* [in] */ IShellView *psv)
{
    PY_GATEWAY_METHOD;
    PyObject *obpsv;
    obpsv = PyCom_PyObjectFromIUnknown(psv, IID_IShellView, TRUE);
    HRESULT hr = InvokeViaPolicy("OnViewCreated", NULL, "O", obpsv);
    Py_XDECREF(obpsv);
    return hr;
}

STDMETHODIMP PyGExplorerBrowserEvents::OnNavigationComplete(
    /* [in] */ PCIDLIST_ABSOLUTE pidlFolder)
{
    PY_GATEWAY_METHOD;
    PyObject *obpidlFolder = PyObject_FromPCIDLIST_ABSOLUTE(pidlFolder, FALSE);
    if (obpidlFolder == NULL)
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("OnNavigationComplete");
    HRESULT hr = InvokeViaPolicy("OnNavigationComplete", NULL, "O", obpidlFolder);
    Py_DECREF(obpidlFolder);
    return hr;
}

STDMETHODIMP PyGExplorerBrowserEvents::OnNavigationFailed(
    /* [in] */ PCIDLIST_ABSOLUTE pidlFolder)
{
    PY_GATEWAY_METHOD;
    PyObject *obpidlFolder = PyObject_FromPCIDLIST_ABSOLUTE(pidlFolder, FALSE);
    if (obpidlFolder == NULL)
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("OnNavigationFailed");
    HRESULT hr = InvokeViaPolicy("OnNavigationFailed", NULL, "O", obpidlFolder);
    Py_DECREF(obpidlFolder);
    return hr;
}
