---
title: "SMB / CIFS"
description: "Rclone docs for SMB backend"
versionIntroduced: "v1.60"
---

# {{< icon "fa fa-server" >}} SMB

SMB is [a communication protocol to share files over network](https://en.wikipedia.org/wiki/Server_Message_Block).

This relies on [go-smb2 library](https://github.com/hirochachacha/go-smb2/) for communication with SMB protocol.

Paths are specified as `remote:sharename` (or `remote:` for the `lsd`
command.)  You may put subdirectories in too, e.g. `remote:item/path/to/dir`.

## Notes

The first path segment must be the name of the share, which you entered when you started to share on Windows. On smbd, it's the section title in `smb.conf` (usually in `/etc/samba/`) file.
You can find shares by querying the root if you're unsure (e.g. `rclone lsd remote:`).

You can't access to the shared printers from rclone, obviously.

You can't use Anonymous access for logging in. You have to use the `guest` user with an empty password instead.
The rclone client tries to avoid 8.3 names when uploading files by encoding trailing spaces and periods.
Alternatively, [the local backend](/local/#paths-on-windows) on Windows can access SMB servers using UNC paths, by `\\server\share`. This doesn't apply to non-Windows OSes, such as Linux and macOS.

## Configuration

Here is an example of making a SMB configuration.

First run

    rclone config

This will guide you through an interactive setup process.

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> remote
Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
XX / SMB / CIFS
   \ (smb)
Storage> smb

Option host.
Samba hostname to connect to.
E.g. "example.com".
Enter a value.
host> localhost

Option user.
Samba username.
Enter a string value. Press Enter for the default (lesmi).
user> guest

Option port.
Samba port number.
Enter a signed integer. Press Enter for the default (445).
port> 

Option pass.
Samba password.
Choose an alternative below. Press Enter for the default (n).
y) Yes, type in my own password
g) Generate random password
n) No, leave this optional password blank (default)
y/g/n> g
Password strength in bits.
64 is just about memorable
128 is secure
1024 is the maximum
Bits> 64
Your password is: XXXX
Use this password? Please note that an obscured version of this 
password (and not the password itself) will be stored under your 
configuration file, so keep this generated password in a safe place.
y) Yes (default)
n) No
y/n> y

Option domain.
Domain name for NTLM authentication.
Enter a string value. Press Enter for the default (WORKGROUP).
domain> 

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Configuration complete.
Options:
- type: samba
- host: localhost
- user: guest
- pass: *** ENCRYPTED ***
Keep this "remote" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> d
```

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/smb/smb.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to smb (SMB / CIFS).

#### --smb-host

SMB server hostname to connect to.

E.g. "example.com".

Properties:

- Config:      host
- Env Var:     RCLONE_SMB_HOST
- Type:        string
- Required:    true

#### --smb-user

SMB username.

Properties:

- Config:      user
- Env Var:     RCLONE_SMB_USER
- Type:        string
- Default:     "$USER"

#### --smb-port

SMB port number.

Properties:

- Config:      port
- Env Var:     RCLONE_SMB_PORT
- Type:        int
- Default:     445

#### --smb-pass

SMB password.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      pass
- Env Var:     RCLONE_SMB_PASS
- Type:        string
- Required:    false

#### --smb-domain

Domain name for NTLM authentication.

Properties:

- Config:      domain
- Env Var:     RCLONE_SMB_DOMAIN
- Type:        string
- Default:     "WORKGROUP"

#### --smb-spn

Service principal name.

Rclone presents this name to the server. Some servers use this as further
authentication, and it often needs to be set for clusters. For example:

    cifs/remotehost:1020

Leave blank if not sure.


Properties:

- Config:      spn
- Env Var:     RCLONE_SMB_SPN
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to smb (SMB / CIFS).

#### --smb-idle-timeout

Max time before closing idle connections.

If no connections have been returned to the connection pool in the time
given, rclone will empty the connection pool.

Set to 0 to keep connections indefinitely.


Properties:

- Config:      idle_timeout
- Env Var:     RCLONE_SMB_IDLE_TIMEOUT
- Type:        Duration
- Default:     1m0s

#### --smb-hide-special-share

Hide special shares (e.g. print$) which users aren't supposed to access.

Properties:

- Config:      hide_special_share
- Env Var:     RCLONE_SMB_HIDE_SPECIAL_SHARE
- Type:        bool
- Default:     true

#### --smb-case-insensitive

Whether the server is configured to be case-insensitive.

Always true on Windows shares.

Properties:

- Config:      case_insensitive
- Env Var:     RCLONE_SMB_CASE_INSENSITIVE
- Type:        bool
- Default:     true

#### --smb-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_SMB_ENCODING
- Type:        Encoding
- Default:     Slash,LtGt,DoubleQuote,Colon,Question,Asterisk,Pipe,BackSlash,Ctl,RightSpace,RightPeriod,InvalidUtf8,Dot

#### --smb-description

Description of the remote

Properties:

- Config:      description
- Env Var:     RCLONE_SMB_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}
