// @HEADER
// *****************************************************************************
//        MueLu: A package for multigrid based preconditioning
//
// Copyright 2012 NTESS and the MueLu contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

/*
 * MueLu_NoFactory.cpp
 *
 *  Created on: Sep 13, 2011
 *      Author: wiesner
 */

#include "MueLu_Level.hpp"

#include "MueLu_NoFactory.hpp"

namespace MueLu {

const NoFactory* NoFactory::get() {
  return getRCP().get();
}

RCP<const NoFactory> NoFactory::noFactory_ = Teuchos::null;

void NoFactory::CallBuild(Level& requestedLevel) const {
  GetOStream(Errors) << "MueLu::NoFactory::Build(): this method cannot be called." << std::endl
                     << std::endl;
  GetOStream(Errors) << "Maybe, the required variable has been generated by another factory?" << std::endl;
  GetOStream(Errors) << "Here is a list of all available data on the current level:" << std::endl;
  requestedLevel.print(GetOStream(Errors), MueLu::Debug);
  throw Exceptions::RuntimeError("MueLu::NoFactory::Build(): this method cannot be called.");
}

}  // namespace MueLu
