/* The copyright in this software is being made available under the BSD
   License, included below. This software may be subject to contributor and
   other third party rights, including patent rights, and no such rights are
   granted under this license.

   Copyright (c) 2020, Samsung Electronics Co., Ltd.
   All Rights Reserved. */
/*
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   - Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

   - Neither the name of the copyright owner, nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

#include "xevem_type.h"

#define NA 255 //never split
#define NB 14  //not reach in current setting of max AR 1:4
#define NC 15  //not reach in current setting of max AR 1:4
const u8 xevem_tbl_split_flag_ctx[6][6] =
{
    { NA,  4,  4, NB, NC, NC },
    { 4,   4,  3,  3,  2,  2 },
    { 4,   3,  3,  2,  2,  1 },
    { NB,  3,  2,  2,  1,  1 },
    { NC,  2,  2,  1,  1,  0 },
    { NC,  2,  1,  1,  0,  0 },
};

const int xevem_tbl_dq_scale[6] = {40, 45, 51, 57, 64, 72};
const int xevem_tbl_ipred_adi[32][4]=
{
    { 32, 64, 32,  0 },
    { 31, 63, 33,  1 },
    { 30, 62, 34,  2 },
    { 29, 61, 35,  3 },
    { 28, 60, 36,  4 },
    { 27, 59, 37,  5 },
    { 26, 58, 38,  6 },
    { 25, 57, 39,  7 },
    { 24, 56, 40,  8 },
    { 23, 55, 41,  9 },
    { 22, 54, 42, 10 },
    { 21, 53, 43, 11 },
    { 20, 52, 44, 12 },
    { 19, 51, 45, 13 },
    { 18, 50, 46, 14 },
    { 17, 49, 47, 15 },
    { 16, 48, 48, 16 },
    { 15, 47, 49, 17 },
    { 14, 46, 50, 18 },
    { 13, 45, 51, 19 },
    { 12, 44, 52, 20 },
    { 11, 43, 53, 21 },
    { 10, 42, 54, 22 },
    {  9, 41, 55, 23 },
    {  8, 40, 56, 24 },
    {  7, 39, 57, 25 },
    {  6, 38, 58, 26 },
    {  5, 37, 59, 27 },
    {  4, 36, 60, 28 },
    {  3, 35, 61, 29 },
    {  2, 34, 62, 30 },
    {  1, 33, 63, 31 },
};

const int xevem_tbl_ipred_dxdy[IPD_CNT][2] = /* {dx/dy, dy/dx} */
{
    { 0,0 },
    { 0,0 },{ 0,0 },{ 2816,372 },{ 2048,512 },{ 1408,744 },
    { 1024,1024 },{ 744,1408 },{ 512,2048 },{ 372,2816 },{ 256,4096 },
    { 128,8192 },{ 0,0 },{ 128,8192 },{ 256,4096 },{ 372,2816 },
    { 512,2048 },{ 744,1408 },{ 1024,1024 },{ 1408,744 },{ 2048,512 },
    { 2816,372 },{ 4096,256 },{ 8192,128 },{ 0,0 },{ 8192,128 },
    { 4096,256 },{ 2816,372 },{ 2048,512 },{ 1408,744 },{ 1024,1024 },
    { 744,1408 },{ 512,2048 },
};

const int xevem_tbl_qp_chroma_ajudst[XEVE_MAX_QP_TABLE_SIZE] =
{
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    29, 30, 31, 32, 33, 34, 35, 36, 37, 37,
    38, 39, 40, 40, 41, 42, 43, 44, 45, 46,
    47, 48, 49, 50, 51, 52, 53, 54
};

const s16 xevem_init_skip_flag[2][NUM_CTX_SKIP_FLAG] =
{
    {    0,    0, },
    {  711,  233, },
};

const s16 xevem_init_ibc_flag[2][NUM_CTX_IBC_FLAG] =
{
    {    0,    0, },
    {  711,  233, },
};

const s16 xevem_init_mmvd_flag[2][NUM_CTX_MMVD_FLAG] =
{
    {    0, },
    {  194, },
};

const s16 xevem_init_mmvd_merge_idx[2][NUM_CTX_MMVD_MERGE_IDX] =
{
    {    0,    0,    0, },
    {   49,  129,   82, },
};

const s16 xevem_init_mmvd_distance_idx[2][NUM_CTX_MMVD_DIST_IDX] =
{
    {    0,    0,    0,    0,    0,    0,    0, },
    {  179,    5,  133,  131,  227,   64,  128, },
};

const s16 xevem_init_mmvd_direction_idx[2][NUM_CTX_MMVD_DIRECTION_IDX] =
{
    {    0,    0, },
    {  161,   33, },
};

const s16 xevem_init_mmvd_group_idx[2][NUM_CTX_MMVD_GROUP_IDX] =
{
    {    0,    0, },
    {  453,   48, },
};

const s16 xevem_init_direct_mode_flag[2][NUM_CTX_DIRECT_MODE_FLAG] =
{
    {    0, },
    {    0, },
};

const s16 xevem_init_merge_mode_flag[2][NUM_CTX_MERGE_MODE_FLAG] =
{
    {    0, },
    {  464, },
};

const s16 xevem_init_inter_dir[2][NUM_CTX_INTER_PRED_IDC] =
{
    {    0,    0, },
    {  242,   80, },
};

const s16 xevem_init_intra_luma_pred_mpm_flag[2][NUM_CTX_INTRA_LUMA_PRED_MPM_FLAG] =
{
    {  263, },
    {  225, },
};

const s16 xevem_init_intra_luma_pred_mpm_idx[2][NUM_CTX_INTRA_LUMA_PRED_MPM_IDX] =
{
    {  436, },
    {  724, },
};

const s16 xevem_init_intra_chroma_pred_mode[2][NUM_CTX_INTRA_CHROMA_PRED_MODE] =
{
    {  465, },
    {  560, },
};

const s16 xevem_init_intra_dir[2][NUM_CTX_INTRA_PRED_MODE] =
{
    {    0,    0, },
    {    0,    0, },
};

const s16 xevem_init_pred_mode[2][NUM_CTX_PRED_MODE] =
{
    {   64,    0,    0, },
    {  481,   16,  368, },
};

const s16 xevem_init_mode_cons[2][NUM_CTX_MODE_CONS] =
{
    {   64,    0,    0, },
    {  481,   16,  368, },
};

const s16 xevem_init_refi[2][NUM_CTX_REF_IDX] =
{
    {    0,    0, },
    {  288,    0, },
};

const s16 xevem_init_merge_idx[2][NUM_CTX_MERGE_IDX] =
{
    {    0,    0,    0,  496,  496, },
    {   18,  128,  146,   37,   69, },
};

const s16 xevem_init_mvp_idx[2][NUM_CTX_MVP_IDX] =
{
    {    0,    0,    0, },
    {    0,    0,    0, },
};

const s16 xevem_init_affine_mvp_idx[2][NUM_CTX_AFFINE_MVP_IDX] =
{
    {    0, },
    {  161, },
};

const s16 xevem_init_mvr_idx[2][NUM_CTX_AMVR_IDX] =
{
    {    0,    0,    0,  496, },
    {  773,  101,  421,  199, },
};

const s16 xevem_init_bi_idx[2][NUM_CTX_BI_PRED_IDX] =
{
    {    0,    0, },
    {   49,   17, },
};

const s16 xevem_init_mvd[2][NUM_CTX_MVD] =
{
    {    0, },
    {   18, },
};

const s16 xevem_init_cbf_all[2][NUM_CTX_CBF_ALL] =
{
    {    0, },
    {  794, },
};

const s16 xevem_init_cbf_luma[2][NUM_CTX_CBF_LUMA] =
{
    {  664, },
    {  368, },
};

const s16 xevem_init_cbf_cb[2][NUM_CTX_CBF_CB] =
{
    {  384, },
    {  416, },
};

const s16 xevem_init_cbf_cr[2][NUM_CTX_CBF_CR] =
{
    {  320, },
    {  288, },
};

const s16 xevem_init_dqp[2][NUM_CTX_DELTA_QP] =
{
    {    4, },
    {    4, },
};

const s16 xevem_init_sig_coeff_flag[2][NUM_CTX_SIG_COEFF_FLAG] =
{
    {  387,   98,  233,  346,  717,  306,  233,   37,  321,  293,  244,   37,  329,  645,  408,  493,  164,  781,  101,  179,  369,  871,  585,  244,  361,  147,  416,  408,  628,  352,  406,  502,  566,  466,   54,   97,  521,  113,  147,  519,   36,  297,  132,  457,  308,  231,  534, },
    {   66,   34,  241,  321,  293,  113,   35,   83,  226,  519,  553,  229,  751,  224,  129,  133,  162,  227,  178,  165,  532,  417,  357,   33,  489,  199,  387,  939,  133,  515,   32,  131,    3,  305,  579,  323,   65,   99,  425,  453,  291,  329,  679,  683,  391,  751,   51, },
};

const s16 xevem_init_coeff_abs_level_greaterAB_flag[2][NUM_CTX_GTX] =
{
    {   40,  225,  306,  272,   85,  120,  389,  664,  209,  322,  291,  536,  338,  709,   54,  244,   19,  566, },
    {   38,  352,  340,   19,  305,  258,   18,   33,  209,  773,  517,  406,  719,  741,  613,  295,   37,  498, },
};

const s16 xevem_init_last_sig_coeff_x_prefix[2][NUM_CTX_LAST_SIG_COEFF] =
{
    {  762,  310,  288,  828,  342,  451,  502,   51,   97,  416,  662,  890,  340,  146,   20,  337,  468,  975,  216,   66,   54, },
    {  892,   84,  581,  600,  278,  419,  372,  568,  408,  485,  338,  632,  666,  732,   17,  178,  180,  585,  581,   34,  257, },
};

const s16 xevem_init_last_sig_coeff_y_prefix[2][NUM_CTX_LAST_SIG_COEFF] =
{
    {   81,  440,    4,  534,  406,  226,  370,  370,  259,   38,  598,  792,  860,  312,   88,  662,  924,  161,  248,   20,   54, },
    {  470,  376,  323,  276,  602,   52,  340,  600,  376,  378,  598,  502,  730,  538,   17,  195,  504,  378,  320,  160,  572, },
};

const s16 xevem_init_run[2][NUM_CTX_CC_RUN] =
{
    {   48,  112,  128,    0,  321,   82,  419,  160,  385,  323,  353,  129,  225,  193,  387,  389,  453,  227,  453,  161,  421,  161,  481,  225, },
    {  129,  178,  453,   97,  583,  259,  517,  259,  453,  227,  871,  355,  291,  227,  195,   97,  161,   65,   97,   33,   65,    1, 1003,  227, },
};

const s16 xevem_init_last[2][NUM_CTX_CC_LAST] =
{
    {  421,  337, },
    {   33,  790, },
};

const s16 xevem_init_level[2][NUM_CTX_CC_LEVEL] =
{
    {  416,   98,  128,   66,   32,   82,   17,   48,  272,  112,   52,   50,  448,  419,  385,  355,  161,  225,   82,   97,  210,    0,  416,  224, },
    {  805,  775,  775,  581,  355,  389,   65,  195,   48,   33,  224,  225,  775,  227,  355,  161,  129,   97,   33,   65,   16,    1,  841,  355, },
};

const s16 xevem_init_btt_split_flag[2][NUM_CTX_BTT_SPLIT_FLAG] =
{
    {  145,  560,  528,  308,  594,  560,  180,  500,  626,   84,  406,  662,  320,   36,  340, },
    {  536,  726,  594,   66,  338,  528,  258,  404,  464,   98,  342,  370,  384,  256,   65, },
};

const s16 xevem_init_btt_split_dir[2][NUM_CTX_BTT_SPLIT_DIR] =
{
    {    0,  417,  389,   99,    0, },
    {    0,  128,   81,   49,    0, },
};

const s16 xevem_init_btt_split_type[2][NUM_CTX_BTT_SPLIT_TYPE] =
{
    {  257, },
    {  225, },
};

const s16 xevem_init_affine_flag[2][NUM_CTX_AFFINE_FLAG] =
{
    {    0,    0, },
    {  320,  210, },
};

const s16 xevem_init_affine_mode[2][NUM_CTX_AFFINE_MODE] =
{
    {    0, },
    {  225, },
};

const s16 xevem_init_affine_mrg[2][NUM_CTX_AFFINE_MRG] =
{
    {    0,    0,    0,    0,    0, },
    {  193,  129,   32,  323,    0, },
};

const s16 xevem_init_affine_mvd_flag[2][NUM_CTX_AFFINE_MVD_FLAG] =
{
    {    0,    0, },
    {  547,  645, },
};

const s16 xevem_init_suco_flag[2][NUM_CTX_SUCO_FLAG] =
{
    {    0,    0,    0,    0,    0,    0,  545,    0,  481,  515,    0,   32,    0,    0, },
    {    0,    0,    0,    0,    0,    0,  577,    0,  481,    2,    0,   97,    0,    0, },
};

const s16 xevem_init_alf_ctb_flag[2][NUM_CTX_ALF_CTB_FLAG] =
{
    {    0, },
    {    0, },
};

const s16 xevem_init_split_cu_flag[2][NUM_CTX_SPLIT_CU_FLAG] =
{
    {    0, },
    {    0, },
};

const s16 xevem_init_ats_intra_cu[2][NUM_CTX_ATS_INTRA_CU_FLAG] =
{
    {  999, },
    { 1003, },
};

const s16 xevem_init_ats_mode[2][NUM_CTX_ATS_MODE_FLAG] =
{
    {  512, },
    {  673, },
};

const s16 xevem_init_ats_cu_inter_flag[2][NUM_CTX_ATS_INTER_FLAG] =
{
    {    0,    0, },
    {    0,    0, },
};

const s16 xevem_init_ats_cu_inter_quad_flag[2][NUM_CTX_ATS_INTER_QUAD_FLAG] =
{
    {    0, },
    {    0, },
};

const s16 xevem_init_ats_cu_inter_hor_flag[2][NUM_CTX_ATS_INTER_HOR_FLAG] =
{
    {    0,    0,    0, },
    {    0,    0,    0, },
};

const s16 xevem_init_ats_cu_inter_pos_flag[2][NUM_CTX_ATS_INTER_POS_FLAG] =
{
    {    0, },
    {    0, },
};


const int xevem_tbl_tr_subset_intra[4] = { DST7, DCT8 };

const s8 xevem_tbl_tr[NUM_TRANS_TYPE][4][1024] =
{
// DCT8
    {
        {
           84,   74,   55,   29,
           74,    0,  -74,  -74,
           55,  -74,  -29,   84,
           29,  -74,   84,  -55,
        },
        {
           87,   84,   79,   70,   59,   46,   32,   16,
           84,   59,   16,  -32,  -70,  -87,  -79,  -46,
           79,   16,  -59,  -87,  -46,   32,   84,   70,
           70,  -32,  -87,  -16,   79,   59,  -46,  -84,
           59,  -70,  -46,   79,   32,  -84,  -16,   87,
           46,  -87,   32,   59,  -84,   16,   70,  -79,
           32,  -79,   84,  -46,  -16,   70,  -87,   59,
           16,  -46,   70,  -84,   87,  -79,   59,  -32,
        },
        {
           89,   88,   87,   84,   81,   77,   73,   67,   62,   55,   48,   41,   33,   25,   17,    8,
           88,   81,   67,   48,   25,    0,  -25,  -48,  -67,  -81,  -88,  -88,  -81,  -67,  -48,  -25,
           87,   67,   33,   -8,  -48,  -77,  -89,  -81,  -55,  -17,   25,   62,   84,   88,   73,   41,
           84,   48,   -8,  -62,  -88,  -77,  -33,   25,   73,   89,   67,   17,  -41,  -81,  -87,  -55,
           81,   25,  -48,  -88,  -67,    0,   67,   88,   48,  -25,  -81,  -81,  -25,   48,   88,   67,
           77,    0,  -77,  -77,    0,   77,   77,    0,  -77,  -77,    0,   77,   77,    0,  -77,  -77,
           73,  -25,  -89,  -33,   67,   77,  -17,  -88,  -41,   62,   81,   -8,  -87,  -48,   55,   84,
           67,  -48,  -81,   25,   88,    0,  -88,  -25,   81,   48,  -67,  -67,   48,   81,  -25,  -88,
           62,  -67,  -55,   73,   48,  -77,  -41,   81,   33,  -84,  -25,   87,   17,  -88,   -8,   89,
           55,  -81,  -17,   89,  -25,  -77,   62,   48,  -84,   -8,   88,  -33,  -73,   67,   41,  -87,
           48,  -88,   25,   67,  -81,    0,   81,  -67,  -25,   88,  -48,  -48,   88,  -25,  -67,   81,
           41,  -88,   62,   17,  -81,   77,   -8,  -67,   87,  -33,  -48,   89,  -55,  -25,   84,  -73,
           33,  -81,   84,  -41,  -25,   77,  -87,   48,   17,  -73,   88,  -55,   -8,   67,  -89,   62,
           25,  -67,   88,  -81,   48,    0,  -48,   81,  -88,   67,  -25,  -25,   67,  -88,   81,  -48,
           17,  -48,   73,  -87,   88,  -77,   55,  -25,   -8,   41,  -67,   84,  -89,   81,  -62,   33,
            8,  -25,   41,  -55,   67,  -77,   84,  -88,   89,  -87,   81,  -73,   62,  -48,   33,  -17,
        },
        {
           90,   90,   89,   89,   88,   87,   85,   84,   82,   81,   78,   76,   74,   71,   69,   66,   63,   60,   56,   53,   49,   46,   42,   38,   34,   30,   26,   21,   17,   13,    9,    4,
           90,   88,   84,   78,   71,   63,   53,   42,   30,   17,    4,   -9,  -21,  -34,  -46,  -56,  -66,  -74,  -81,  -85,  -89,  -90,  -89,  -87,  -82,  -76,  -69,  -60,  -49,  -38,  -26,  -13,
           89,   84,   74,   60,   42,   21,    0,  -21,  -42,  -60,  -74,  -84,  -89,  -89,  -84,  -74,  -60,  -42,  -21,    0,   21,   42,   60,   74,   84,   89,   89,   84,   74,   60,   42,   21,
           89,   78,   60,   34,    4,  -26,  -53,  -74,  -87,  -90,  -82,  -66,  -42,  -13,   17,   46,   69,   84,   90,   85,   71,   49,   21,   -9,  -38,  -63,  -81,  -89,  -88,  -76,  -56,  -30,
           88,   71,   42,    4,  -34,  -66,  -85,  -89,  -76,  -49,  -13,   26,   60,   82,   90,   81,   56,   21,  -17,  -53,  -78,  -90,  -84,  -63,  -30,    9,   46,   74,   89,   87,   69,   38,
           87,   63,   21,  -26,  -66,  -88,  -85,  -60,  -17,   30,   69,   89,   84,   56,   13,  -34,  -71,  -89,  -82,  -53,   -9,   38,   74,   90,   81,   49,    4,  -42,  -76,  -90,  -78,  -46,
           85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,
           84,   42,  -21,  -74,  -89,  -60,    0,   60,   89,   74,   21,  -42,  -84,  -84,  -42,   21,   74,   89,   60,    0,  -60,  -89,  -74,  -21,   42,   84,   84,   42,  -21,  -74,  -89,  -60,
           82,   30,  -42,  -87,  -76,  -17,   53,   89,   69,    4,  -63,  -90,  -60,    9,   71,   89,   49,  -21,  -78,  -85,  -38,   34,   84,   81,   26,  -46,  -88,  -74,  -13,   56,   90,   66,
           81,   17,  -60,  -90,  -49,   30,   85,   74,    4,  -69,  -88,  -38,   42,   89,   66,   -9,  -76,  -84,  -26,   53,   90,   56,  -21,  -82,  -78,  -13,   63,   89,   46,  -34,  -87,  -71,
           78,    4,  -74,  -82,  -13,   69,   85,   21,  -63,  -88,  -30,   56,   89,   38,  -49,  -90,  -46,   42,   90,   53,  -34,  -89,  -60,   26,   87,   66,  -17,  -84,  -71,    9,   81,   76,
           76,   -9,  -84,  -66,   26,   89,   53,  -42,  -90,  -38,   56,   88,   21,  -69,  -82,   -4,   78,   74,  -13,  -85,  -63,   30,   89,   49,  -46,  -90,  -34,   60,   87,   17,  -71,  -81,
           74,  -21,  -89,  -42,   60,   84,    0,  -84,  -60,   42,   89,   21,  -74,  -74,   21,   89,   42,  -60,  -84,    0,   84,   60,  -42,  -89,  -21,   74,   74,  -21,  -89,  -42,   60,   84,
           71,  -34,  -89,  -13,   82,   56,  -53,  -84,    9,   89,   38,  -69,  -74,   30,   90,   17,  -81,  -60,   49,   85,   -4,  -88,  -42,   66,   76,  -26,  -90,  -21,   78,   63,  -46,  -87,
           69,  -46,  -84,   17,   90,   13,  -85,  -42,   71,   66,  -49,  -82,   21,   90,    9,  -87,  -38,   74,   63,  -53,  -81,   26,   89,    4,  -88,  -34,   76,   60,  -56,  -78,   30,   89,
           66,  -56,  -74,   46,   81,  -34,  -85,   21,   89,   -9,  -90,   -4,   89,   17,  -87,  -30,   82,   42,  -76,  -53,   69,   63,  -60,  -71,   49,   78,  -38,  -84,   26,   88,  -13,  -90,
           63,  -66,  -60,   69,   56,  -71,  -53,   74,   49,  -76,  -46,   78,   42,  -81,  -38,   82,   34,  -84,  -30,   85,   26,  -87,  -21,   88,   17,  -89,  -13,   89,    9,  -90,   -4,   90,
           60,  -74,  -42,   84,   21,  -89,    0,   89,  -21,  -84,   42,   74,  -60,  -60,   74,   42,  -84,  -21,   89,    0,  -89,   21,   84,  -42,  -74,   60,   60,  -74,  -42,   84,   21,  -89,
           56,  -81,  -21,   90,  -17,  -82,   53,   60,  -78,  -26,   90,  -13,  -84,   49,   63,  -76,  -30,   89,   -9,  -85,   46,   66,  -74,  -34,   89,   -4,  -87,   42,   69,  -71,  -38,   88,
           53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,
           49,  -89,   21,   71,  -78,   -9,   85,  -60,  -38,   90,  -34,  -63,   84,   -4,  -81,   69,   26,  -89,   46,   53,  -88,   17,   74,  -76,  -13,   87,  -56,  -42,   90,  -30,  -66,   82,
           46,  -90,   42,   49,  -90,   38,   53,  -89,   34,   56,  -89,   30,   60,  -88,   26,   63,  -87,   21,   66,  -85,   17,   69,  -84,   13,   71,  -82,    9,   74,  -81,    4,   76,  -78,
           42,  -89,   60,   21,  -84,   74,    0,  -74,   84,  -21,  -60,   89,  -42,  -42,   89,  -60,  -21,   84,  -74,    0,   74,  -84,   21,   60,  -89,   42,   42,  -89,   60,   21,  -84,   74,
           38,  -87,   74,   -9,  -63,   90,  -53,  -21,   81,  -82,   26,   49,  -89,   66,    4,  -71,   88,  -42,  -34,   85,  -76,   13,   60,  -90,   56,   17,  -78,   84,  -30,  -46,   89,  -69,
           34,  -82,   84,  -38,  -30,   81,  -85,   42,   26,  -78,   87,  -46,  -21,   76,  -88,   49,   17,  -74,   89,  -53,  -13,   71,  -89,   56,    9,  -69,   90,  -60,   -4,   66,  -90,   63,
           30,  -76,   89,  -63,    9,   49,  -85,   84,  -46,  -13,   66,  -90,   74,  -26,  -34,   78,  -89,   60,   -4,  -53,   87,  -82,   42,   17,  -69,   90,  -71,   21,   38,  -81,   88,  -56,
           26,  -69,   89,  -81,   46,    4,  -53,   84,  -88,   63,  -17,  -34,   74,  -90,   76,  -38,  -13,   60,  -87,   85,  -56,    9,   42,  -78,   90,  -71,   30,   21,  -66,   89,  -82,   49,
           21,  -60,   84,  -89,   74,  -42,    0,   42,  -74,   89,  -84,   60,  -21,  -21,   60,  -84,   89,  -74,   42,    0,  -42,   74,  -89,   84,  -60,   21,   21,  -60,   84,  -89,   74,  -42,
           17,  -49,   74,  -88,   89,  -76,   53,  -21,  -13,   46,  -71,   87,  -89,   78,  -56,   26,    9,  -42,   69,  -85,   90,  -81,   60,  -30,   -4,   38,  -66,   84,  -90,   82,  -63,   34,
           13,  -38,   60,  -76,   87,  -90,   85,  -74,   56,  -34,    9,   17,  -42,   63,  -78,   88,  -90,   84,  -71,   53,  -30,    4,   21,  -46,   66,  -81,   89,  -89,   82,  -69,   49,  -26,
            9,  -26,   42,  -56,   69,  -78,   85,  -89,   90,  -87,   81,  -71,   60,  -46,   30,  -13,   -4,   21,  -38,   53,  -66,   76,  -84,   89,  -90,   88,  -82,   74,  -63,   49,  -34,   17,
            4,  -13,   21,  -30,   38,  -46,   53,  -60,   66,  -71,   76,  -81,   84,  -87,   89,  -90,   90,  -89,   88,  -85,   82,  -78,   74,  -69,   63,  -56,   49,  -42,   34,  -26,   17,   -9,
        },
    },
// DST7
    {
        {
           29,   55,   74,   84,
           74,   74,    0,  -74,
           84,  -29,  -74,   55,
           55,  -84,   74,  -29,
        },
        {
           16,   32,   46,   59,   70,   79,   84,   87,
           46,   79,   87,   70,   32,  -16,  -59,  -84,
           70,   84,   32,  -46,  -87,  -59,   16,   79,
           84,   46,  -59,  -79,   16,   87,   32,  -70,
           87,  -16,  -84,   32,   79,  -46,  -70,   59,
           79,  -70,  -16,   84,  -59,  -32,   87,  -46,
           59,  -87,   70,  -16,  -46,   84,  -79,   32,
           32,  -59,   79,  -87,   84,  -70,   46,  -16,
        },
        {
            8,   17,   25,   33,   41,   48,   55,   62,   67,   73,   77,   81,   84,   87,   88,   89,
           25,   48,   67,   81,   88,   88,   81,   67,   48,   25,    0,  -25,  -48,  -67,  -81,  -88,
           41,   73,   88,   84,   62,   25,  -17,  -55,  -81,  -89,  -77,  -48,   -8,   33,   67,   87,
           55,   87,   81,   41,  -17,  -67,  -89,  -73,  -25,   33,   77,   88,   62,    8,  -48,  -84,
           67,   88,   48,  -25,  -81,  -81,  -25,   48,   88,   67,    0,  -67,  -88,  -48,   25,   81,
           77,   77,    0,  -77,  -77,    0,   77,   77,    0,  -77,  -77,    0,   77,   77,    0,  -77,
           84,   55,  -48,  -87,   -8,   81,   62,  -41,  -88,  -17,   77,   67,  -33,  -89,  -25,   73,
           88,   25,  -81,  -48,   67,   67,  -48,  -81,   25,   88,    0,  -88,  -25,   81,   48,  -67,
           89,   -8,  -88,   17,   87,  -25,  -84,   33,   81,  -41,  -77,   48,   73,  -55,  -67,   62,
           87,  -41,  -67,   73,   33,  -88,    8,   84,  -48,  -62,   77,   25,  -89,   17,   81,  -55,
           81,  -67,  -25,   88,  -48,  -48,   88,  -25,  -67,   81,    0,  -81,   67,   25,  -88,   48,
           73,  -84,   25,   55,  -89,   48,   33,  -87,   67,    8,  -77,   81,  -17,  -62,   88,  -41,
           62,  -89,   67,   -8,  -55,   88,  -73,   17,   48,  -87,   77,  -25,  -41,   84,  -81,   33,
           48,  -81,   88,  -67,   25,   25,  -67,   88,  -81,   48,    0,  -48,   81,  -88,   67,  -25,
           33,  -62,   81,  -89,   84,  -67,   41,   -8,  -25,   55,  -77,   88,  -87,   73,  -48,   17,
           17,  -33,   48,  -62,   73,  -81,   87,  -89,   88,  -84,   77,  -67,   55,  -41,   25,   -8,
        },
        {
            4,    9,   13,   17,   21,   26,   30,   34,   38,   42,   46,   49,   53,   56,   60,   63,   66,   69,   71,   74,   76,   78,   81,   82,   84,   85,   87,   88,   89,   89,   90,   90,
           13,   26,   38,   49,   60,   69,   76,   82,   87,   89,   90,   89,   85,   81,   74,   66,   56,   46,   34,   21,    9,   -4,  -17,  -30,  -42,  -53,  -63,  -71,  -78,  -84,  -88,  -90,
           21,   42,   60,   74,   84,   89,   89,   84,   74,   60,   42,   21,    0,  -21,  -42,  -60,  -74,  -84,  -89,  -89,  -84,  -74,  -60,  -42,  -21,    0,   21,   42,   60,   74,   84,   89,
           30,   56,   76,   88,   89,   81,   63,   38,    9,  -21,  -49,  -71,  -85,  -90,  -84,  -69,  -46,  -17,   13,   42,   66,   82,   90,   87,   74,   53,   26,   -4,  -34,  -60,  -78,  -89,
           38,   69,   87,   89,   74,   46,    9,  -30,  -63,  -84,  -90,  -78,  -53,  -17,   21,   56,   81,   90,   82,   60,   26,  -13,  -49,  -76,  -89,  -85,  -66,  -34,    4,   42,   71,   88,
           46,   78,   90,   76,   42,   -4,  -49,  -81,  -90,  -74,  -38,    9,   53,   82,   89,   71,   34,  -13,  -56,  -84,  -89,  -69,  -30,   17,   60,   85,   88,   66,   26,  -21,  -63,  -87,
           53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,
           60,   89,   74,   21,  -42,  -84,  -84,  -42,   21,   74,   89,   60,    0,  -60,  -89,  -74,  -21,   42,   84,   84,   42,  -21,  -74,  -89,  -60,    0,   60,   89,   74,   21,  -42,  -84,
           66,   90,   56,  -13,  -74,  -88,  -46,   26,   81,   84,   34,  -38,  -85,  -78,  -21,   49,   89,   71,    9,  -60,  -90,  -63,    4,   69,   89,   53,  -17,  -76,  -87,  -42,   30,   82,
           71,   87,   34,  -46,  -89,  -63,   13,   78,   82,   21,  -56,  -90,  -53,   26,   84,   76,    9,  -66,  -89,  -42,   38,   88,   69,   -4,  -74,  -85,  -30,   49,   90,   60,  -17,  -81,
           76,   81,    9,  -71,  -84,  -17,   66,   87,   26,  -60,  -89,  -34,   53,   90,   42,  -46,  -90,  -49,   38,   89,   56,  -30,  -88,  -63,   21,   85,   69,  -13,  -82,  -74,    4,   78,
           81,   71,  -17,  -87,  -60,   34,   90,   46,  -49,  -89,  -30,   63,   85,   13,  -74,  -78,    4,   82,   69,  -21,  -88,  -56,   38,   90,   42,  -53,  -89,  -26,   66,   84,    9,  -76,
           84,   60,  -42,  -89,  -21,   74,   74,  -21,  -89,  -42,   60,   84,    0,  -84,  -60,   42,   89,   21,  -74,  -74,   21,   89,   42,  -60,  -84,    0,   84,   60,  -42,  -89,  -21,   74,
           87,   46,  -63,  -78,   21,   90,   26,  -76,  -66,   42,   88,    4,  -85,  -49,   60,   81,  -17,  -90,  -30,   74,   69,  -38,  -89,   -9,   84,   53,  -56,  -82,   13,   89,   34,  -71,
           89,   30,  -78,  -56,   60,   76,  -34,  -88,    4,   89,   26,  -81,  -53,   63,   74,  -38,  -87,    9,   90,   21,  -82,  -49,   66,   71,  -42,  -85,   13,   90,   17,  -84,  -46,   69,
           90,   13,  -88,  -26,   84,   38,  -78,  -49,   71,   60,  -63,  -69,   53,   76,  -42,  -82,   30,   87,  -17,  -89,    4,   90,    9,  -89,  -21,   85,   34,  -81,  -46,   74,   56,  -66,
           90,   -4,  -90,    9,   89,  -13,  -89,   17,   88,  -21,  -87,   26,   85,  -30,  -84,   34,   82,  -38,  -81,   42,   78,  -46,  -76,   49,   74,  -53,  -71,   56,   69,  -60,  -66,   63,
           89,  -21,  -84,   42,   74,  -60,  -60,   74,   42,  -84,  -21,   89,    0,  -89,   21,   84,  -42,  -74,   60,   60,  -74,  -42,   84,   21,  -89,    0,   89,  -21,  -84,   42,   74,  -60,
           88,  -38,  -71,   69,   42,  -87,   -4,   89,  -34,  -74,   66,   46,  -85,   -9,   89,  -30,  -76,   63,   49,  -84,  -13,   90,  -26,  -78,   60,   53,  -82,  -17,   90,  -21,  -81,   56,
           85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,
           82,  -66,  -30,   90,  -42,  -56,   87,  -13,  -76,   74,   17,  -88,   53,   46,  -89,   26,   69,  -81,   -4,   84,  -63,  -34,   90,  -38,  -60,   85,   -9,  -78,   71,   21,  -89,   49,
           78,  -76,   -4,   81,  -74,   -9,   82,  -71,  -13,   84,  -69,  -17,   85,  -66,  -21,   87,  -63,  -26,   88,  -60,  -30,   89,  -56,  -34,   89,  -53,  -38,   90,  -49,  -42,   90,  -46,
           74,  -84,   21,   60,  -89,   42,   42,  -89,   60,   21,  -84,   74,    0,  -74,   84,  -21,  -60,   89,  -42,  -42,   89,  -60,  -21,   84,  -74,    0,   74,  -84,   21,   60,  -89,   42,
           69,  -89,   46,   30,  -84,   78,  -17,  -56,   90,  -60,  -13,   76,  -85,   34,   42,  -88,   71,   -4,  -66,   89,  -49,  -26,   82,  -81,   21,   53,  -90,   63,    9,  -74,   87,  -38,
           63,  -90,   66,   -4,  -60,   90,  -69,    9,   56,  -89,   71,  -13,  -53,   89,  -74,   17,   49,  -88,   76,  -21,  -46,   87,  -78,   26,   42,  -85,   81,  -30,  -38,   84,  -82,   34,
           56,  -88,   81,  -38,  -21,   71,  -90,   69,  -17,  -42,   82,  -87,   53,    4,  -60,   89,  -78,   34,   26,  -74,   90,  -66,   13,   46,  -84,   85,  -49,   -9,   63,  -89,   76,  -30,
           49,  -82,   89,  -66,   21,   30,  -71,   90,  -78,   42,    9,  -56,   85,  -87,   60,  -13,  -38,   76,  -90,   74,  -34,  -17,   63,  -88,   84,  -53,    4,   46,  -81,   89,  -69,   26,
           42,  -74,   89,  -84,   60,  -21,  -21,   60,  -84,   89,  -74,   42,    0,  -42,   74,  -89,   84,  -60,   21,   21,  -60,   84,  -89,   74,  -42,    0,   42,  -74,   89,  -84,   60,  -21,
           34,  -63,   82,  -90,   84,  -66,   38,   -4,  -30,   60,  -81,   90,  -85,   69,  -42,    9,   26,  -56,   78,  -89,   87,  -71,   46,  -13,  -21,   53,  -76,   89,  -88,   74,  -49,   17,
           26,  -49,   69,  -82,   89,  -89,   81,  -66,   46,  -21,   -4,   30,  -53,   71,  -84,   90,  -88,   78,  -63,   42,  -17,   -9,   34,  -56,   74,  -85,   90,  -87,   76,  -60,   38,  -13,
           17,  -34,   49,  -63,   74,  -82,   88,  -90,   89,  -84,   76,  -66,   53,  -38,   21,   -4,  -13,   30,  -46,   60,  -71,   81,  -87,   90,  -89,   85,  -78,   69,  -56,   42,  -26,    9,
            9,  -17,   26,  -34,   42,  -49,   56,  -63,   69,  -74,   78,  -82,   85,  -88,   89,  -90,   90,  -89,   87,  -84,   81,  -76,   71,  -66,   60,  -53,   46,  -38,   30,  -21,   13,   -4,
        },
    },
};

const s8 xevem_tbl_inv_tr[NUM_TRANS_TYPE][4][1024] =
{
// DCT8
    {
        {
           84,   74,   55,   29,
           74,    0,  -74,  -74,
           55,  -74,  -29,   84,
           29,  -74,   84,  -55,
        },
        {
           87,   84,   79,   70,   59,   46,   32,   16,
           84,   59,   16,  -32,  -70,  -87,  -79,  -46,
           79,   16,  -59,  -87,  -46,   32,   84,   70,
           70,  -32,  -87,  -16,   79,   59,  -46,  -84,
           59,  -70,  -46,   79,   32,  -84,  -16,   87,
           46,  -87,   32,   59,  -84,   16,   70,  -79,
           32,  -79,   84,  -46,  -16,   70,  -87,   59,
           16,  -46,   70,  -84,   87,  -79,   59,  -32,
        },
        {
           89,   88,   87,   84,   81,   77,   73,   67,   62,   55,   48,   41,   33,   25,   17,    8,
           88,   81,   67,   48,   25,    0,  -25,  -48,  -67,  -81,  -88,  -88,  -81,  -67,  -48,  -25,
           87,   67,   33,   -8,  -48,  -77,  -89,  -81,  -55,  -17,   25,   62,   84,   88,   73,   41,
           84,   48,   -8,  -62,  -88,  -77,  -33,   25,   73,   89,   67,   17,  -41,  -81,  -87,  -55,
           81,   25,  -48,  -88,  -67,    0,   67,   88,   48,  -25,  -81,  -81,  -25,   48,   88,   67,
           77,    0,  -77,  -77,    0,   77,   77,    0,  -77,  -77,    0,   77,   77,    0,  -77,  -77,
           73,  -25,  -89,  -33,   67,   77,  -17,  -88,  -41,   62,   81,   -8,  -87,  -48,   55,   84,
           67,  -48,  -81,   25,   88,    0,  -88,  -25,   81,   48,  -67,  -67,   48,   81,  -25,  -88,
           62,  -67,  -55,   73,   48,  -77,  -41,   81,   33,  -84,  -25,   87,   17,  -88,   -8,   89,
           55,  -81,  -17,   89,  -25,  -77,   62,   48,  -84,   -8,   88,  -33,  -73,   67,   41,  -87,
           48,  -88,   25,   67,  -81,    0,   81,  -67,  -25,   88,  -48,  -48,   88,  -25,  -67,   81,
           41,  -88,   62,   17,  -81,   77,   -8,  -67,   87,  -33,  -48,   89,  -55,  -25,   84,  -73,
           33,  -81,   84,  -41,  -25,   77,  -87,   48,   17,  -73,   88,  -55,   -8,   67,  -89,   62,
           25,  -67,   88,  -81,   48,    0,  -48,   81,  -88,   67,  -25,  -25,   67,  -88,   81,  -48,
           17,  -48,   73,  -87,   88,  -77,   55,  -25,   -8,   41,  -67,   84,  -89,   81,  -62,   33,
            8,  -25,   41,  -55,   67,  -77,   84,  -88,   89,  -87,   81,  -73,   62,  -48,   33,  -17,
        },
        {
           90,   90,   89,   89,   88,   87,   85,   84,   82,   81,   78,   76,   74,   71,   69,   66,   63,   60,   56,   53,   49,   46,   42,   38,   34,   30,   26,   21,   17,   13,    9,    4,
           90,   88,   84,   78,   71,   63,   53,   42,   30,   17,    4,   -9,  -21,  -34,  -46,  -56,  -66,  -74,  -81,  -85,  -89,  -90,  -89,  -87,  -82,  -76,  -69,  -60,  -49,  -38,  -26,  -13,
           89,   84,   74,   60,   42,   21,    0,  -21,  -42,  -60,  -74,  -84,  -89,  -89,  -84,  -74,  -60,  -42,  -21,    0,   21,   42,   60,   74,   84,   89,   89,   84,   74,   60,   42,   21,
           89,   78,   60,   34,    4,  -26,  -53,  -74,  -87,  -90,  -82,  -66,  -42,  -13,   17,   46,   69,   84,   90,   85,   71,   49,   21,   -9,  -38,  -63,  -81,  -89,  -88,  -76,  -56,  -30,
           88,   71,   42,    4,  -34,  -66,  -85,  -89,  -76,  -49,  -13,   26,   60,   82,   90,   81,   56,   21,  -17,  -53,  -78,  -90,  -84,  -63,  -30,    9,   46,   74,   89,   87,   69,   38,
           87,   63,   21,  -26,  -66,  -88,  -85,  -60,  -17,   30,   69,   89,   84,   56,   13,  -34,  -71,  -89,  -82,  -53,   -9,   38,   74,   90,   81,   49,    4,  -42,  -76,  -90,  -78,  -46,
           85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,    0,  -53,  -85,  -85,  -53,    0,   53,   85,   85,   53,
           84,   42,  -21,  -74,  -89,  -60,    0,   60,   89,   74,   21,  -42,  -84,  -84,  -42,   21,   74,   89,   60,    0,  -60,  -89,  -74,  -21,   42,   84,   84,   42,  -21,  -74,  -89,  -60,
           82,   30,  -42,  -87,  -76,  -17,   53,   89,   69,    4,  -63,  -90,  -60,    9,   71,   89,   49,  -21,  -78,  -85,  -38,   34,   84,   81,   26,  -46,  -88,  -74,  -13,   56,   90,   66,
           81,   17,  -60,  -90,  -49,   30,   85,   74,    4,  -69,  -88,  -38,   42,   89,   66,   -9,  -76,  -84,  -26,   53,   90,   56,  -21,  -82,  -78,  -13,   63,   89,   46,  -34,  -87,  -71,
           78,    4,  -74,  -82,  -13,   69,   85,   21,  -63,  -88,  -30,   56,   89,   38,  -49,  -90,  -46,   42,   90,   53,  -34,  -89,  -60,   26,   87,   66,  -17,  -84,  -71,    9,   81,   76,
           76,   -9,  -84,  -66,   26,   89,   53,  -42,  -90,  -38,   56,   88,   21,  -69,  -82,   -4,   78,   74,  -13,  -85,  -63,   30,   89,   49,  -46,  -90,  -34,   60,   87,   17,  -71,  -81,
           74,  -21,  -89,  -42,   60,   84,    0,  -84,  -60,   42,   89,   21,  -74,  -74,   21,   89,   42,  -60,  -84,    0,   84,   60,  -42,  -89,  -21,   74,   74,  -21,  -89,  -42,   60,   84,
           71,  -34,  -89,  -13,   82,   56,  -53,  -84,    9,   89,   38,  -69,  -74,   30,   90,   17,  -81,  -60,   49,   85,   -4,  -88,  -42,   66,   76,  -26,  -90,  -21,   78,   63,  -46,  -87,
           69,  -46,  -84,   17,   90,   13,  -85,  -42,   71,   66,  -49,  -82,   21,   90,    9,  -87,  -38,   74,   63,  -53,  -81,   26,   89,    4,  -88,  -34,   76,   60,  -56,  -78,   30,   89,
           66,  -56,  -74,   46,   81,  -34,  -85,   21,   89,   -9,  -90,   -4,   89,   17,  -87,  -30,   82,   42,  -76,  -53,   69,   63,  -60,  -71,   49,   78,  -38,  -84,   26,   88,  -13,  -90,
           63,  -66,  -60,   69,   56,  -71,  -53,   74,   49,  -76,  -46,   78,   42,  -81,  -38,   82,   34,  -84,  -30,   85,   26,  -87,  -21,   88,   17,  -89,  -13,   89,    9,  -90,   -4,   90,
           60,  -74,  -42,   84,   21,  -89,    0,   89,  -21,  -84,   42,   74,  -60,  -60,   74,   42,  -84,  -21,   89,    0,  -89,   21,   84,  -42,  -74,   60,   60,  -74,  -42,   84,   21,  -89,
           56,  -81,  -21,   90,  -17,  -82,   53,   60,  -78,  -26,   90,  -13,  -84,   49,   63,  -76,  -30,   89,   -9,  -85,   46,   66,  -74,  -34,   89,   -4,  -87,   42,   69,  -71,  -38,   88,
           53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,    0,   85,  -53,  -53,   85,    0,  -85,   53,   53,  -85,
           49,  -89,   21,   71,  -78,   -9,   85,  -60,  -38,   90,  -34,  -63,   84,   -4,  -81,   69,   26,  -89,   46,   53,  -88,   17,   74,  -76,  -13,   87,  -56,  -42,   90,  -30,  -66,   82,
           46,  -90,   42,   49,  -90,   38,   53,  -89,   34,   56,  -89,   30,   60,  -88,   26,   63,  -87,   21,   66,  -85,   17,   69,  -84,   13,   71,  -82,    9,   74,  -81,    4,   76,  -78,
           42,  -89,   60,   21,  -84,   74,    0,  -74,   84,  -21,  -60,   89,  -42,  -42,   89,  -60,  -21,   84,  -74,    0,   74,  -84,   21,   60,  -89,   42,   42,  -89,   60,   21,  -84,   74,
           38,  -87,   74,   -9,  -63,   90,  -53,  -21,   81,  -82,   26,   49,  -89,   66,    4,  -71,   88,  -42,  -34,   85,  -76,   13,   60,  -90,   56,   17,  -78,   84,  -30,  -46,   89,  -69,
           34,  -82,   84,  -38,  -30,   81,  -85,   42,   26,  -78,   87,  -46,  -21,   76,  -88,   49,   17,  -74,   89,  -53,  -13,   71,  -89,   56,    9,  -69,   90,  -60,   -4,   66,  -90,   63,
           30,  -76,   89,  -63,    9,   49,  -85,   84,  -46,  -13,   66,  -90,   74,  -26,  -34,   78,  -89,   60,   -4,  -53,   87,  -82,   42,   17,  -69,   90,  -71,   21,   38,  -81,   88,  -56,
           26,  -69,   89,  -81,   46,    4,  -53,   84,  -88,   63,  -17,  -34,   74,  -90,   76,  -38,  -13,   60,  -87,   85,  -56,    9,   42,  -78,   90,  -71,   30,   21,  -66,   89,  -82,   49,
           21,  -60,   84,  -89,   74,  -42,    0,   42,  -74,   89,  -84,   60,  -21,  -21,   60,  -84,   89,  -74,   42,    0,  -42,   74,  -89,   84,  -60,   21,   21,  -60,   84,  -89,   74,  -42,
           17,  -49,   74,  -88,   89,  -76,   53,  -21,  -13,   46,  -71,   87,  -89,   78,  -56,   26,    9,  -42,   69,  -85,   90,  -81,   60,  -30,   -4,   38,  -66,   84,  -90,   82,  -63,   34,
           13,  -38,   60,  -76,   87,  -90,   85,  -74,   56,  -34,    9,   17,  -42,   63,  -78,   88,  -90,   84,  -71,   53,  -30,    4,   21,  -46,   66,  -81,   89,  -89,   82,  -69,   49,  -26,
            9,  -26,   42,  -56,   69,  -78,   85,  -89,   90,  -87,   81,  -71,   60,  -46,   30,  -13,   -4,   21,  -38,   53,  -66,   76,  -84,   89,  -90,   88,  -82,   74,  -63,   49,  -34,   17,
            4,  -13,   21,  -30,   38,  -46,   53,  -60,   66,  -71,   76,  -81,   84,  -87,   89,  -90,   90,  -89,   88,  -85,   82,  -78,   74,  -69,   63,  -56,   49,  -42,   34,  -26,   17,   -9,
        },
    },
// DST7
    {
        {
           29,   74,   84,   55,
           55,   74,  -29,  -84,
           74,    0,  -74,   74,
           84,  -74,   55,  -29,
        },
        {
           16,   46,   70,   84,   87,   79,   59,   32,
           32,   79,   84,   46,  -16,  -70,  -87,  -59,
           46,   87,   32,  -59,  -84,  -16,   70,   79,
           59,   70,  -46,  -79,   32,   84,  -16,  -87,
           70,   32,  -87,   16,   79,  -59,  -46,   84,
           79,  -16,  -59,   87,  -46,  -32,   84,  -70,
           84,  -59,   16,   32,  -70,   87,  -79,   46,
           87,  -84,   79,  -70,   59,  -46,   32,  -16,
        },
        {
            8,   25,   41,   55,   67,   77,   84,   88,   89,   87,   81,   73,   62,   48,   33,   17,
           17,   48,   73,   87,   88,   77,   55,   25,   -8,  -41,  -67,  -84,  -89,  -81,  -62,  -33,
           25,   67,   88,   81,   48,    0,  -48,  -81,  -88,  -67,  -25,   25,   67,   88,   81,   48,
           33,   81,   84,   41,  -25,  -77,  -87,  -48,   17,   73,   88,   55,   -8,  -67,  -89,  -62,
           41,   88,   62,  -17,  -81,  -77,   -8,   67,   87,   33,  -48,  -89,  -55,   25,   84,   73,
           48,   88,   25,  -67,  -81,    0,   81,   67,  -25,  -88,  -48,   48,   88,   25,  -67,  -81,
           55,   81,  -17,  -89,  -25,   77,   62,  -48,  -84,    8,   88,   33,  -73,  -67,   41,   87,
           62,   67,  -55,  -73,   48,   77,  -41,  -81,   33,   84,  -25,  -87,   17,   88,   -8,  -89,
           67,   48,  -81,  -25,   88,    0,  -88,   25,   81,  -48,  -67,   67,   48,  -81,  -25,   88,
           73,   25,  -89,   33,   67,  -77,  -17,   88,  -41,  -62,   81,    8,  -87,   48,   55,  -84,
           77,    0,  -77,   77,    0,  -77,   77,    0,  -77,   77,    0,  -77,   77,    0,  -77,   77,
           81,  -25,  -48,   88,  -67,    0,   67,  -88,   48,   25,  -81,   81,  -25,  -48,   88,  -67,
           84,  -48,   -8,   62,  -88,   77,  -33,  -25,   73,  -89,   67,  -17,  -41,   81,  -87,   55,
           87,  -67,   33,    8,  -48,   77,  -89,   81,  -55,   17,   25,  -62,   84,  -88,   73,  -41,
           88,  -81,   67,  -48,   25,    0,  -25,   48,  -67,   81,  -88,   88,  -81,   67,  -48,   25,
           89,  -88,   87,  -84,   81,  -77,   73,  -67,   62,  -55,   48,  -41,   33,  -25,   17,   -8,
        },
        {
            4,   13,   21,   30,   38,   46,   53,   60,   66,   71,   76,   81,   84,   87,   89,   90,   90,   89,   88,   85,   82,   78,   74,   69,   63,   56,   49,   42,   34,   26,   17,    9,
            9,   26,   42,   56,   69,   78,   85,   89,   90,   87,   81,   71,   60,   46,   30,   13,   -4,  -21,  -38,  -53,  -66,  -76,  -84,  -89,  -90,  -88,  -82,  -74,  -63,  -49,  -34,  -17,
           13,   38,   60,   76,   87,   90,   85,   74,   56,   34,    9,  -17,  -42,  -63,  -78,  -88,  -90,  -84,  -71,  -53,  -30,   -4,   21,   46,   66,   81,   89,   89,   82,   69,   49,   26,
           17,   49,   74,   88,   89,   76,   53,   21,  -13,  -46,  -71,  -87,  -89,  -78,  -56,  -26,    9,   42,   69,   85,   90,   81,   60,   30,   -4,  -38,  -66,  -84,  -90,  -82,  -63,  -34,
           21,   60,   84,   89,   74,   42,    0,  -42,  -74,  -89,  -84,  -60,  -21,   21,   60,   84,   89,   74,   42,    0,  -42,  -74,  -89,  -84,  -60,  -21,   21,   60,   84,   89,   74,   42,
           26,   69,   89,   81,   46,   -4,  -53,  -84,  -88,  -63,  -17,   34,   74,   90,   76,   38,  -13,  -60,  -87,  -85,  -56,   -9,   42,   78,   90,   71,   30,  -21,  -66,  -89,  -82,  -49,
           30,   76,   89,   63,    9,  -49,  -85,  -84,  -46,   13,   66,   90,   74,   26,  -34,  -78,  -89,  -60,   -4,   53,   87,   82,   42,  -17,  -69,  -90,  -71,  -21,   38,   81,   88,   56,
           34,   82,   84,   38,  -30,  -81,  -85,  -42,   26,   78,   87,   46,  -21,  -76,  -88,  -49,   17,   74,   89,   53,  -13,  -71,  -89,  -56,    9,   69,   90,   60,   -4,  -66,  -90,  -63,
           38,   87,   74,    9,  -63,  -90,  -53,   21,   81,   82,   26,  -49,  -89,  -66,    4,   71,   88,   42,  -34,  -85,  -76,  -13,   60,   90,   56,  -17,  -78,  -84,  -30,   46,   89,   69,
           42,   89,   60,  -21,  -84,  -74,    0,   74,   84,   21,  -60,  -89,  -42,   42,   89,   60,  -21,  -84,  -74,    0,   74,   84,   21,  -60,  -89,  -42,   42,   89,   60,  -21,  -84,  -74,
           46,   90,   42,  -49,  -90,  -38,   53,   89,   34,  -56,  -89,  -30,   60,   88,   26,  -63,  -87,  -21,   66,   85,   17,  -69,  -84,  -13,   71,   82,    9,  -74,  -81,   -4,   76,   78,
           49,   89,   21,  -71,  -78,    9,   85,   60,  -38,  -90,  -34,   63,   84,    4,  -81,  -69,   26,   89,   46,  -53,  -88,  -17,   74,   76,  -13,  -87,  -56,   42,   90,   30,  -66,  -82,
           53,   85,    0,  -85,  -53,   53,   85,    0,  -85,  -53,   53,   85,    0,  -85,  -53,   53,   85,    0,  -85,  -53,   53,   85,    0,  -85,  -53,   53,   85,    0,  -85,  -53,   53,   85,
           56,   81,  -21,  -90,  -17,   82,   53,  -60,  -78,   26,   90,   13,  -84,  -49,   63,   76,  -30,  -89,   -9,   85,   46,  -66,  -74,   34,   89,    4,  -87,  -42,   69,   71,  -38,  -88,
           60,   74,  -42,  -84,   21,   89,    0,  -89,  -21,   84,   42,  -74,  -60,   60,   74,  -42,  -84,   21,   89,    0,  -89,  -21,   84,   42,  -74,  -60,   60,   74,  -42,  -84,   21,   89,
           63,   66,  -60,  -69,   56,   71,  -53,  -74,   49,   76,  -46,  -78,   42,   81,  -38,  -82,   34,   84,  -30,  -85,   26,   87,  -21,  -88,   17,   89,  -13,  -89,    9,   90,   -4,  -90,
           66,   56,  -74,  -46,   81,   34,  -85,  -21,   89,    9,  -90,    4,   89,  -17,  -87,   30,   82,  -42,  -76,   53,   69,  -63,  -60,   71,   49,  -78,  -38,   84,   26,  -88,  -13,   90,
           69,   46,  -84,  -17,   90,  -13,  -85,   42,   71,  -66,  -49,   82,   21,  -90,    9,   87,  -38,  -74,   63,   53,  -81,  -26,   89,   -4,  -88,   34,   76,  -60,  -56,   78,   30,  -89,
           71,   34,  -89,   13,   82,  -56,  -53,   84,    9,  -89,   38,   69,  -74,  -30,   90,  -17,  -81,   60,   49,  -85,   -4,   88,  -42,  -66,   76,   26,  -90,   21,   78,  -63,  -46,   87,
           74,   21,  -89,   42,   60,  -84,    0,   84,  -60,  -42,   89,  -21,  -74,   74,   21,  -89,   42,   60,  -84,    0,   84,  -60,  -42,   89,  -21,  -74,   74,   21,  -89,   42,   60,  -84,
           76,    9,  -84,   66,   26,  -89,   53,   42,  -90,   38,   56,  -88,   21,   69,  -82,    4,   78,  -74,  -13,   85,  -63,  -30,   89,  -49,  -46,   90,  -34,  -60,   87,  -17,  -71,   81,
           78,   -4,  -74,   82,  -13,  -69,   85,  -21,  -63,   88,  -30,  -56,   89,  -38,  -49,   90,  -46,  -42,   90,  -53,  -34,   89,  -60,  -26,   87,  -66,  -17,   84,  -71,   -9,   81,  -76,
           81,  -17,  -60,   90,  -49,  -30,   85,  -74,    4,   69,  -88,   38,   42,  -89,   66,    9,  -76,   84,  -26,  -53,   90,  -56,  -21,   82,  -78,   13,   63,  -89,   46,   34,  -87,   71,
           82,  -30,  -42,   87,  -76,   17,   53,  -89,   69,   -4,  -63,   90,  -60,   -9,   71,  -89,   49,   21,  -78,   85,  -38,  -34,   84,  -81,   26,   46,  -88,   74,  -13,  -56,   90,  -66,
           84,  -42,  -21,   74,  -89,   60,    0,  -60,   89,  -74,   21,   42,  -84,   84,  -42,  -21,   74,  -89,   60,    0,  -60,   89,  -74,   21,   42,  -84,   84,  -42,  -21,   74,  -89,   60,
           85,  -53,    0,   53,  -85,   85,  -53,    0,   53,  -85,   85,  -53,    0,   53,  -85,   85,  -53,    0,   53,  -85,   85,  -53,    0,   53,  -85,   85,  -53,    0,   53,  -85,   85,  -53,
           87,  -63,   21,   26,  -66,   88,  -85,   60,  -17,  -30,   69,  -89,   84,  -56,   13,   34,  -71,   89,  -82,   53,   -9,  -38,   74,  -90,   81,  -49,    4,   42,  -76,   90,  -78,   46,
           88,  -71,   42,   -4,  -34,   66,  -85,   89,  -76,   49,  -13,  -26,   60,  -82,   90,  -81,   56,  -21,  -17,   53,  -78,   90,  -84,   63,  -30,   -9,   46,  -74,   89,  -87,   69,  -38,
           89,  -78,   60,  -34,    4,   26,  -53,   74,  -87,   90,  -82,   66,  -42,   13,   17,  -46,   69,  -84,   90,  -85,   71,  -49,   21,    9,  -38,   63,  -81,   89,  -88,   76,  -56,   30,
           89,  -84,   74,  -60,   42,  -21,    0,   21,  -42,   60,  -74,   84,  -89,   89,  -84,   74,  -60,   42,  -21,    0,   21,  -42,   60,  -74,   84,  -89,   89,  -84,   74,  -60,   42,  -21,
           90,  -88,   84,  -78,   71,  -63,   53,  -42,   30,  -17,    4,    9,  -21,   34,  -46,   56,  -66,   74,  -81,   85,  -89,   90,  -89,   87,  -82,   76,  -69,   60,  -49,   38,  -26,   13,
           90,  -90,   89,  -89,   88,  -87,   85,  -84,   82,  -81,   78,  -76,   74,  -71,   69,  -66,   63,  -60,   56,  -53,   49,  -46,   42,  -38,   34,  -30,   26,  -21,   17,  -13,    9,   -4,
        },
    },
};

const u8 xevem_addb_alpha_tbl[52] = { 0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,4,4,5,6,  7,8,9,10,12,13,15,17,  20,22,25,28,32,36,40,45,  50,56,63,71,80,90,101,113,  127,144,162,182,203,226,255,255 };
const u8 xevem_addb_beta_tbl[52]  = { 0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,2,2,2,3,  3,3,3, 4, 4, 4, 6, 6,   7, 7, 8, 8, 9, 9,10,10,  11,11,12,12,13,13, 14, 14,   15, 15, 16, 16, 17, 17, 18, 18 };
const u8 xevem_addb_clip_tbl[52][5] =
{
    { 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },{ 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },{ 0, 0, 0, 1, 1 },{ 0, 0, 0, 1, 1 },{ 0, 0, 0, 1, 1 },{ 0, 0, 0, 1, 1 },{ 0, 0, 1, 1, 1 },{ 0, 0, 1, 1, 1 },{ 0, 1, 1, 1, 1 },
    { 0, 1, 1, 1, 1 },{ 0, 1, 1, 1, 1 },{ 0, 1, 1, 1, 1 },{ 0, 1, 1, 2, 2 },{ 0, 1, 1, 2, 2 },{ 0, 1, 1, 2, 2 },{ 0, 1, 1, 2, 2 },{ 0, 1, 2, 3, 3 },
    { 0, 1, 2, 3, 3 },{ 0, 2, 2, 3, 3 },{ 0, 2, 2, 4, 4 },{ 0, 2, 3, 4, 4 },{ 0, 2, 3, 4, 4 },{ 0, 3, 3, 5, 5 },{ 0, 3, 4, 6, 6 },{ 0, 3, 4, 6, 6 },
    { 0, 4, 5, 7, 7 },{ 0, 4, 5, 8, 8 },{ 0, 4, 6, 9, 9 },{ 0, 5, 7,10,10 },{ 0, 6, 8,11,11 },{ 0, 6, 8,13,13 },{ 0, 7,10,14,14 },{ 0, 8,11,16,16 },
    { 0, 9,12,18,18 },{ 0,10,13,20,20 },{ 0,11,15,23,23 },{ 0,13,17,25,25 }
};

// input to table is in the range 0<input<256, as a result of multiplication of 2 scales with max value of <16.
const int xevem_dra_chroma_qp_offset_tbl[NUM_CHROMA_QP_OFFSET_LOG] =  // Approximation of Log function at accuracy 1<<9 bits
{
  0, 1, 1, 1, 1, 1, 2, 2, 3, 4, 4, 6, 7, 9, 11, 14, 18, 23, 29, 36, 45,
  57, 72, 91, 114, 144, 181, 228, 287, 362, 456, 575, 724, 912, 1149, 1448, 1825, 2299,
  2896, 3649, 4598, 5793, 7298, 9195, 11585, 14596, 18390, 23170, 29193, 36781, 46341, 58386, 73562, 92682, 116772
};

// input to this table is deltaQP introduced to QPi (lumaQP+chromaQPoffset) by the chromaQPOffset table. Currently max offset 6 is supported, increase to 12 (?).
const int xevem_dra_exp_nom_v2[NUM_CHROMA_QP_SCALE_EXP] =   // Approximation of exp function at accuracy 1 << 9 bits
{
    128, 144, 161, 181, 203, 228, 256, 287, 322, 362, 406, 456, 512, 574, 645, 724, 812, 912, 1024, 1149, 1290, 1448, 1625, 1825, 2048
};


const s8 xevem_tbl_poc_gop_offset[9][31] =
{
    {  -1,  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },  /* gop_size = 2 */
    {  -2,    -3,   -1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },  /* gop_size = 4 */
    {  -4,    -6,   -7,   -5,   -2,   -3,   -1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },  /* gop_size = 8 */
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },  /* gop_size = 12 */
    {  -8,   -12,  -14,  -15,  -13,  -10,  -11,   -9,   -4,   -6,   -7,   -5,   -2,   -3,   -1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },  /* gop_size = 16 */
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    {  -16,  -24,  -28,  -30,  -31,  -29,  -26,  -27,  -25,  -20,  -22,  -23,  -21,  -18,  -19,  -17,   -8,  -12,  -14,  -15,  -13,  -10,  -11,   -9,   -4,   -6,   -7,   -5,   -2,   -3,   -1 },  /* gop_size = 32 */
};

const s8 xevem_tbl_slice_depth_orig[9][32] =
{
    /* gop_size = 2 */
    {
        FRM_DEPTH_2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    /* gop_size = 4 */
    {
        FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    /* gop_size = 8 */
    {
        FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_4, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_4, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    /* gop_size = 12 */
    {
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    /* gop_size = 16 */
    {
        FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_5, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_5,
        FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_5, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_5, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    {
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    {
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    {
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
    },
    /* gop_size = 32 */
    {
        FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6, FRM_DEPTH_5, FRM_DEPTH_6,
        FRM_DEPTH_6, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6,
        FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6,
        FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6, FRM_DEPTH_5, FRM_DEPTH_6, FRM_DEPTH_6, 0xFF
    },
};

