from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

THAI_LANG_MODEL = {
    6: {  # 'ก'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.POSITIVE,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.LIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.LIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.LIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.POSITIVE,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.POSITIVE,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.LIKELY,  # 'ๆ'
        34: SequenceLikelihood.POSITIVE,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    31: {  # 'ข'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.LIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.POSITIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    81: {  # 'ฃ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    22: {  # 'ค'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.LIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.LIKELY,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.LIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    82: {  # 'ฅ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.NEGATIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    66: {  # 'ฆ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.UNLIKELY,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    8: {  # 'ง'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.POSITIVE,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.POSITIVE,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.POSITIVE,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.LIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.LIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    27: {  # 'จ'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.POSITIVE,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.POSITIVE,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.LIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    54: {  # 'ฉ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    35: {  # 'ช'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    44: {  # 'ซ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.POSITIVE,  # 'ึ'
        33: SequenceLikelihood.LIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    79: {  # 'ฌ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    50: {  # 'ญ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.LIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    61: {  # 'ฎ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    60: {  # 'ฏ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    53: {  # 'ฐ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    63: {  # 'ฑ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    58: {  # 'ฒ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    43: {  # 'ณ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.LIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.LIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.POSITIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    16: {  # 'ด'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.LIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.LIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.LIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.LIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    20: {  # 'ต'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.LIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.LIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.LIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.LIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.POSITIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    40: {  # 'ถ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.POSITIVE,  # 'ึ'
        33: SequenceLikelihood.LIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    17: {  # 'ท'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.LIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.POSITIVE,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.POSITIVE,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    48: {  # 'ธ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    2: {  # 'น'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.POSITIVE,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.POSITIVE,  # 'ช'
        44: SequenceLikelihood.LIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.LIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.POSITIVE,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.POSITIVE,  # 'พ'
        46: SequenceLikelihood.LIKELY,  # 'ฟ'
        47: SequenceLikelihood.LIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.POSITIVE,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.POSITIVE,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.POSITIVE,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.POSITIVE,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.LIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.POSITIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    19: {  # 'บ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.LIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    25: {  # 'ป'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.LIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.POSITIVE,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    41: {  # 'ผ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    52: {  # 'ฝ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    29: {  # 'พ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.LIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.LIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    46: {  # 'ฟ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    47: {  # 'ภ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.LIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    9: {  # 'ม'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.POSITIVE,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.POSITIVE,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.UNLIKELY,  # '๛'
    },
    15: {  # 'ย'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.LIKELY,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.LIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.POSITIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    3: {  # 'ร'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.POSITIVE,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.POSITIVE,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.POSITIVE,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.LIKELY,  # 'ศ'
        49: SequenceLikelihood.LIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.POSITIVE,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.LIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.POSITIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    57: {  # 'ฤ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.LIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    12: {  # 'ล'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.POSITIVE,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.POSITIVE,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.POSITIVE,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    84: {  # 'ฦ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.NEGATIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.NEGATIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.NEGATIVE,  # 'เ'
        26: SequenceLikelihood.NEGATIVE,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    14: {  # 'ว'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.LIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.POSITIVE,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    45: {  # 'ศ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.LIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.LIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    49: {  # 'ษ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.LIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    18: {  # 'ส'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.LIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.POSITIVE,  # 'ำ'
        21: SequenceLikelihood.POSITIVE,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.LIKELY,  # 'ื'
        32: SequenceLikelihood.POSITIVE,  # 'ุ'
        37: SequenceLikelihood.POSITIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.POSITIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    23: {  # 'ห'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.POSITIVE,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.LIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.LIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.UNLIKELY,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    62: {  # 'ฬ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    5: {  # 'อ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.LIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.POSITIVE,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.LIKELY,  # 'ำ'
        21: SequenceLikelihood.LIKELY,  # 'ิ'
        13: SequenceLikelihood.POSITIVE,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.LIKELY,  # 'ื'
        32: SequenceLikelihood.LIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.LIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    55: {  # 'ฮ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    59: {  # 'ฯ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    24: {  # 'ะ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.POSITIVE,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.UNLIKELY,  # '๛'
    },
    11: {  # 'ั'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.POSITIVE,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.LIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.LIKELY,  # 'ฒ'
        43: SequenceLikelihood.LIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    1: {  # 'า'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.POSITIVE,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.POSITIVE,  # 'ช'
        44: SequenceLikelihood.LIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.LIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.LIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.POSITIVE,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.LIKELY,  # 'ศ'
        49: SequenceLikelihood.LIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.POSITIVE,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.UNLIKELY,  # '๛'
    },
    38: {  # 'ำ'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    21: {  # 'ิ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.LIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.LIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.LIKELY,  # 'ศ'
        49: SequenceLikelihood.LIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.POSITIVE,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.LIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    13: {  # 'ี'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.LIKELY,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    42: {  # 'ึ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    33: {  # 'ื'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    32: {  # 'ุ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.POSITIVE,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.LIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    37: {  # 'ู'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.POSITIVE,  # '่'
        10: SequenceLikelihood.POSITIVE,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    74: {  # 'ฺ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    75: {  # '฿'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    7: {  # 'เ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.POSITIVE,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.LIKELY,  # 'ฉ'
        35: SequenceLikelihood.POSITIVE,  # 'ช'
        44: SequenceLikelihood.POSITIVE,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.LIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.POSITIVE,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.POSITIVE,  # 'พ'
        46: SequenceLikelihood.LIKELY,  # 'ฟ'
        47: SequenceLikelihood.LIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.LIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    26: {  # 'แ'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.LIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    39: {  # 'โ'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.LIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.POSITIVE,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    30: {  # 'ใ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.POSITIVE,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    28: {  # 'ไ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.LIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.POSITIVE,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.POSITIVE,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.LIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.POSITIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.POSITIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    80: {  # 'ๅ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.UNLIKELY,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    51: {  # 'ๆ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    34: {  # '็'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.LIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.POSITIVE,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.LIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.LIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    4: {  # '่'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.POSITIVE,  # 'ต'
        40: SequenceLikelihood.LIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.POSITIVE,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.UNLIKELY,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.LIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.LIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    10: {  # '้'
        6: SequenceLikelihood.POSITIVE,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.POSITIVE,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.POSITIVE,  # 'ง'
        27: SequenceLikelihood.POSITIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.LIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.POSITIVE,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.LIKELY,  # 'ป'
        41: SequenceLikelihood.LIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.POSITIVE,  # 'ม'
        15: SequenceLikelihood.LIKELY,  # 'ย'
        3: SequenceLikelihood.POSITIVE,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.POSITIVE,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.POSITIVE,  # 'ส'
        23: SequenceLikelihood.LIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.POSITIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.POSITIVE,  # 'า'
        38: SequenceLikelihood.POSITIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.POSITIVE,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.POSITIVE,  # 'ใ'
        28: SequenceLikelihood.POSITIVE,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    56: {  # '๊'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.UNLIKELY,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    64: {  # '๋'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.UNLIKELY,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    36: {  # '์'
        6: SequenceLikelihood.LIKELY,  # 'ก'
        31: SequenceLikelihood.LIKELY,  # 'ข'
        81: SequenceLikelihood.UNLIKELY,  # 'ฃ'
        22: SequenceLikelihood.LIKELY,  # 'ค'
        82: SequenceLikelihood.UNLIKELY,  # 'ฅ'
        66: SequenceLikelihood.UNLIKELY,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.LIKELY,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.UNLIKELY,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.UNLIKELY,  # 'ฎ'
        60: SequenceLikelihood.UNLIKELY,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.UNLIKELY,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.LIKELY,  # 'ด'
        20: SequenceLikelihood.LIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.POSITIVE,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.LIKELY,  # 'น'
        19: SequenceLikelihood.LIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.UNLIKELY,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.LIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.LIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.LIKELY,  # 'ร'
        57: SequenceLikelihood.UNLIKELY,  # 'ฤ'
        12: SequenceLikelihood.LIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.LIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.LIKELY,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.UNLIKELY,  # 'ี'
        42: SequenceLikelihood.UNLIKELY,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.UNLIKELY,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.UNLIKELY,  # 'ฺ'
        75: SequenceLikelihood.UNLIKELY,  # '฿'
        7: SequenceLikelihood.POSITIVE,  # 'เ'
        26: SequenceLikelihood.LIKELY,  # 'แ'
        39: SequenceLikelihood.LIKELY,  # 'โ'
        30: SequenceLikelihood.LIKELY,  # 'ใ'
        28: SequenceLikelihood.LIKELY,  # 'ไ'
        80: SequenceLikelihood.UNLIKELY,  # 'ๅ'
        51: SequenceLikelihood.UNLIKELY,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    65: {  # 'ํ'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.UNLIKELY,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.UNLIKELY,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.UNLIKELY,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.UNLIKELY,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.UNLIKELY,  # 'ั'
        1: SequenceLikelihood.LIKELY,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.UNLIKELY,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.UNLIKELY,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.UNLIKELY,  # '์'
        65: SequenceLikelihood.UNLIKELY,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    86: {  # '๎'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.NEGATIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.UNLIKELY,  # 'า'
        38: SequenceLikelihood.UNLIKELY,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.NEGATIVE,  # 'เ'
        26: SequenceLikelihood.NEGATIVE,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    83: {  # '๏'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.NEGATIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.NEGATIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.NEGATIVE,  # 'เ'
        26: SequenceLikelihood.NEGATIVE,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.UNLIKELY,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    70: {  # '๐'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.UNLIKELY,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    68: {  # '๑'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.UNLIKELY,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    67: {  # '๒'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.UNLIKELY,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    71: {  # '๓'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.UNLIKELY,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.UNLIKELY,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    73: {  # '๔'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.UNLIKELY,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.UNLIKELY,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    69: {  # '๕'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.UNLIKELY,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.UNLIKELY,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.UNLIKELY,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.UNLIKELY,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    72: {  # '๖'
        6: SequenceLikelihood.UNLIKELY,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.UNLIKELY,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.UNLIKELY,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    78: {  # '๗'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.UNLIKELY,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.UNLIKELY,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.NEGATIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.UNLIKELY,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.UNLIKELY,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.NEGATIVE,  # 'เ'
        26: SequenceLikelihood.NEGATIVE,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    77: {  # '๘'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.UNLIKELY,  # 'บ'
        25: SequenceLikelihood.UNLIKELY,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.UNLIKELY,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.UNLIKELY,  # 'ฮ'
        59: SequenceLikelihood.UNLIKELY,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.UNLIKELY,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    76: {  # '๙'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.UNLIKELY,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.UNLIKELY,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.UNLIKELY,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.UNLIKELY,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.UNLIKELY,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.NEGATIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.UNLIKELY,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.UNLIKELY,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.UNLIKELY,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.UNLIKELY,  # 'เ'
        26: SequenceLikelihood.UNLIKELY,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.UNLIKELY,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.UNLIKELY,  # '๐'
        68: SequenceLikelihood.UNLIKELY,  # '๑'
        67: SequenceLikelihood.UNLIKELY,  # '๒'
        71: SequenceLikelihood.UNLIKELY,  # '๓'
        73: SequenceLikelihood.UNLIKELY,  # '๔'
        69: SequenceLikelihood.UNLIKELY,  # '๕'
        72: SequenceLikelihood.UNLIKELY,  # '๖'
        78: SequenceLikelihood.UNLIKELY,  # '๗'
        77: SequenceLikelihood.UNLIKELY,  # '๘'
        76: SequenceLikelihood.UNLIKELY,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    87: {  # '๚'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.NEGATIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.NEGATIVE,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.NEGATIVE,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.NEGATIVE,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.NEGATIVE,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.NEGATIVE,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.UNLIKELY,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.NEGATIVE,  # 'เ'
        26: SequenceLikelihood.NEGATIVE,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.NEGATIVE,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
    85: {  # '๛'
        6: SequenceLikelihood.NEGATIVE,  # 'ก'
        31: SequenceLikelihood.NEGATIVE,  # 'ข'
        81: SequenceLikelihood.NEGATIVE,  # 'ฃ'
        22: SequenceLikelihood.NEGATIVE,  # 'ค'
        82: SequenceLikelihood.NEGATIVE,  # 'ฅ'
        66: SequenceLikelihood.NEGATIVE,  # 'ฆ'
        8: SequenceLikelihood.NEGATIVE,  # 'ง'
        27: SequenceLikelihood.NEGATIVE,  # 'จ'
        54: SequenceLikelihood.NEGATIVE,  # 'ฉ'
        35: SequenceLikelihood.UNLIKELY,  # 'ช'
        44: SequenceLikelihood.NEGATIVE,  # 'ซ'
        79: SequenceLikelihood.NEGATIVE,  # 'ฌ'
        50: SequenceLikelihood.NEGATIVE,  # 'ญ'
        61: SequenceLikelihood.NEGATIVE,  # 'ฎ'
        60: SequenceLikelihood.NEGATIVE,  # 'ฏ'
        53: SequenceLikelihood.NEGATIVE,  # 'ฐ'
        63: SequenceLikelihood.NEGATIVE,  # 'ฑ'
        58: SequenceLikelihood.NEGATIVE,  # 'ฒ'
        43: SequenceLikelihood.NEGATIVE,  # 'ณ'
        16: SequenceLikelihood.NEGATIVE,  # 'ด'
        20: SequenceLikelihood.NEGATIVE,  # 'ต'
        40: SequenceLikelihood.NEGATIVE,  # 'ถ'
        17: SequenceLikelihood.UNLIKELY,  # 'ท'
        48: SequenceLikelihood.NEGATIVE,  # 'ธ'
        2: SequenceLikelihood.NEGATIVE,  # 'น'
        19: SequenceLikelihood.NEGATIVE,  # 'บ'
        25: SequenceLikelihood.NEGATIVE,  # 'ป'
        41: SequenceLikelihood.NEGATIVE,  # 'ผ'
        52: SequenceLikelihood.NEGATIVE,  # 'ฝ'
        29: SequenceLikelihood.UNLIKELY,  # 'พ'
        46: SequenceLikelihood.NEGATIVE,  # 'ฟ'
        47: SequenceLikelihood.NEGATIVE,  # 'ภ'
        9: SequenceLikelihood.NEGATIVE,  # 'ม'
        15: SequenceLikelihood.NEGATIVE,  # 'ย'
        3: SequenceLikelihood.UNLIKELY,  # 'ร'
        57: SequenceLikelihood.NEGATIVE,  # 'ฤ'
        12: SequenceLikelihood.NEGATIVE,  # 'ล'
        84: SequenceLikelihood.NEGATIVE,  # 'ฦ'
        14: SequenceLikelihood.NEGATIVE,  # 'ว'
        45: SequenceLikelihood.NEGATIVE,  # 'ศ'
        49: SequenceLikelihood.NEGATIVE,  # 'ษ'
        18: SequenceLikelihood.UNLIKELY,  # 'ส'
        23: SequenceLikelihood.NEGATIVE,  # 'ห'
        62: SequenceLikelihood.NEGATIVE,  # 'ฬ'
        5: SequenceLikelihood.NEGATIVE,  # 'อ'
        55: SequenceLikelihood.NEGATIVE,  # 'ฮ'
        59: SequenceLikelihood.NEGATIVE,  # 'ฯ'
        24: SequenceLikelihood.NEGATIVE,  # 'ะ'
        11: SequenceLikelihood.NEGATIVE,  # 'ั'
        1: SequenceLikelihood.NEGATIVE,  # 'า'
        38: SequenceLikelihood.NEGATIVE,  # 'ำ'
        21: SequenceLikelihood.NEGATIVE,  # 'ิ'
        13: SequenceLikelihood.NEGATIVE,  # 'ี'
        42: SequenceLikelihood.NEGATIVE,  # 'ึ'
        33: SequenceLikelihood.NEGATIVE,  # 'ื'
        32: SequenceLikelihood.NEGATIVE,  # 'ุ'
        37: SequenceLikelihood.NEGATIVE,  # 'ู'
        74: SequenceLikelihood.NEGATIVE,  # 'ฺ'
        75: SequenceLikelihood.NEGATIVE,  # '฿'
        7: SequenceLikelihood.NEGATIVE,  # 'เ'
        26: SequenceLikelihood.NEGATIVE,  # 'แ'
        39: SequenceLikelihood.NEGATIVE,  # 'โ'
        30: SequenceLikelihood.NEGATIVE,  # 'ใ'
        28: SequenceLikelihood.UNLIKELY,  # 'ไ'
        80: SequenceLikelihood.NEGATIVE,  # 'ๅ'
        51: SequenceLikelihood.NEGATIVE,  # 'ๆ'
        34: SequenceLikelihood.NEGATIVE,  # '็'
        4: SequenceLikelihood.NEGATIVE,  # '่'
        10: SequenceLikelihood.NEGATIVE,  # '้'
        56: SequenceLikelihood.NEGATIVE,  # '๊'
        64: SequenceLikelihood.NEGATIVE,  # '๋'
        36: SequenceLikelihood.NEGATIVE,  # '์'
        65: SequenceLikelihood.NEGATIVE,  # 'ํ'
        86: SequenceLikelihood.NEGATIVE,  # '๎'
        83: SequenceLikelihood.NEGATIVE,  # '๏'
        70: SequenceLikelihood.NEGATIVE,  # '๐'
        68: SequenceLikelihood.NEGATIVE,  # '๑'
        67: SequenceLikelihood.NEGATIVE,  # '๒'
        71: SequenceLikelihood.NEGATIVE,  # '๓'
        73: SequenceLikelihood.NEGATIVE,  # '๔'
        69: SequenceLikelihood.NEGATIVE,  # '๕'
        72: SequenceLikelihood.NEGATIVE,  # '๖'
        78: SequenceLikelihood.NEGATIVE,  # '๗'
        77: SequenceLikelihood.NEGATIVE,  # '๘'
        76: SequenceLikelihood.NEGATIVE,  # '๙'
        87: SequenceLikelihood.NEGATIVE,  # '๚'
        85: SequenceLikelihood.NEGATIVE,  # '๛'
    },
}

# Character Mapping Table(s):
CP874_THAI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.UNDEFINED,  # None
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.UNDEFINED,  # None
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.UNDEFINED,  # None
    135: CharacterCategory.UNDEFINED,  # None
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.UNDEFINED,  # None
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.UNDEFINED,  # None
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.UNDEFINED,  # None
    142: CharacterCategory.UNDEFINED,  # None
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.UNDEFINED,  # None
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.UNDEFINED,  # None
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.UNDEFINED,  # None
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 6,  # 'ก'
    162: 31,  # 'ข'
    163: 81,  # 'ฃ'
    164: 22,  # 'ค'
    165: 82,  # 'ฅ'
    166: 66,  # 'ฆ'
    167: 8,  # 'ง'
    168: 27,  # 'จ'
    169: 54,  # 'ฉ'
    170: 35,  # 'ช'
    171: 44,  # 'ซ'
    172: 79,  # 'ฌ'
    173: 50,  # 'ญ'
    174: 61,  # 'ฎ'
    175: 60,  # 'ฏ'
    176: 53,  # 'ฐ'
    177: 63,  # 'ฑ'
    178: 58,  # 'ฒ'
    179: 43,  # 'ณ'
    180: 16,  # 'ด'
    181: 20,  # 'ต'
    182: 40,  # 'ถ'
    183: 17,  # 'ท'
    184: 48,  # 'ธ'
    185: 2,  # 'น'
    186: 19,  # 'บ'
    187: 25,  # 'ป'
    188: 41,  # 'ผ'
    189: 52,  # 'ฝ'
    190: 29,  # 'พ'
    191: 46,  # 'ฟ'
    192: 47,  # 'ภ'
    193: 9,  # 'ม'
    194: 15,  # 'ย'
    195: 3,  # 'ร'
    196: 57,  # 'ฤ'
    197: 12,  # 'ล'
    198: 84,  # 'ฦ'
    199: 14,  # 'ว'
    200: 45,  # 'ศ'
    201: 49,  # 'ษ'
    202: 18,  # 'ส'
    203: 23,  # 'ห'
    204: 62,  # 'ฬ'
    205: 5,  # 'อ'
    206: 55,  # 'ฮ'
    207: 59,  # 'ฯ'
    208: 24,  # 'ะ'
    209: 11,  # 'ั'
    210: 1,  # 'า'
    211: 38,  # 'ำ'
    212: 21,  # 'ิ'
    213: 13,  # 'ี'
    214: 42,  # 'ึ'
    215: 33,  # 'ื'
    216: 32,  # 'ุ'
    217: 37,  # 'ู'
    218: 74,  # 'ฺ'
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: 75,  # '฿'
    224: 7,  # 'เ'
    225: 26,  # 'แ'
    226: 39,  # 'โ'
    227: 30,  # 'ใ'
    228: 28,  # 'ไ'
    229: 80,  # 'ๅ'
    230: 51,  # 'ๆ'
    231: 34,  # '็'
    232: 4,  # '่'
    233: 10,  # '้'
    234: 56,  # '๊'
    235: 64,  # '๋'
    236: 36,  # '์'
    237: 65,  # 'ํ'
    238: 86,  # '๎'
    239: 83,  # '๏'
    240: 70,  # '๐'
    241: 68,  # '๑'
    242: 67,  # '๒'
    243: 71,  # '๓'
    244: 73,  # '๔'
    245: 69,  # '๕'
    246: 72,  # '๖'
    247: 78,  # '๗'
    248: 77,  # '๘'
    249: 76,  # '๙'
    250: 87,  # '๚'
    251: 85,  # '๛'
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.UNDEFINED,  # None
    254: CharacterCategory.UNDEFINED,  # None
    255: CharacterCategory.UNDEFINED,  # None
}

CP874_THAI_MODEL = SingleByteCharSetModel(
    charset_name="CP874",
    language="Thai",
    char_to_order_map=CP874_THAI_CHAR_TO_ORDER,
    language_model=THAI_LANG_MODEL,
    typical_positive_ratio=0.816545116382814,
    keep_ascii_letters=False,
    alphabet="กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛",
)

ISO_8859_11_THAI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 6,  # 'ก'
    162: 31,  # 'ข'
    163: 81,  # 'ฃ'
    164: 22,  # 'ค'
    165: 82,  # 'ฅ'
    166: 66,  # 'ฆ'
    167: 8,  # 'ง'
    168: 27,  # 'จ'
    169: 54,  # 'ฉ'
    170: 35,  # 'ช'
    171: 44,  # 'ซ'
    172: 79,  # 'ฌ'
    173: 50,  # 'ญ'
    174: 61,  # 'ฎ'
    175: 60,  # 'ฏ'
    176: 53,  # 'ฐ'
    177: 63,  # 'ฑ'
    178: 58,  # 'ฒ'
    179: 43,  # 'ณ'
    180: 16,  # 'ด'
    181: 20,  # 'ต'
    182: 40,  # 'ถ'
    183: 17,  # 'ท'
    184: 48,  # 'ธ'
    185: 2,  # 'น'
    186: 19,  # 'บ'
    187: 25,  # 'ป'
    188: 41,  # 'ผ'
    189: 52,  # 'ฝ'
    190: 29,  # 'พ'
    191: 46,  # 'ฟ'
    192: 47,  # 'ภ'
    193: 9,  # 'ม'
    194: 15,  # 'ย'
    195: 3,  # 'ร'
    196: 57,  # 'ฤ'
    197: 12,  # 'ล'
    198: 84,  # 'ฦ'
    199: 14,  # 'ว'
    200: 45,  # 'ศ'
    201: 49,  # 'ษ'
    202: 18,  # 'ส'
    203: 23,  # 'ห'
    204: 62,  # 'ฬ'
    205: 5,  # 'อ'
    206: 55,  # 'ฮ'
    207: 59,  # 'ฯ'
    208: 24,  # 'ะ'
    209: 11,  # 'ั'
    210: 1,  # 'า'
    211: 38,  # 'ำ'
    212: 21,  # 'ิ'
    213: 13,  # 'ี'
    214: 42,  # 'ึ'
    215: 33,  # 'ื'
    216: 32,  # 'ุ'
    217: 37,  # 'ู'
    218: 74,  # 'ฺ'
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: 75,  # '฿'
    224: 7,  # 'เ'
    225: 26,  # 'แ'
    226: 39,  # 'โ'
    227: 30,  # 'ใ'
    228: 28,  # 'ไ'
    229: 80,  # 'ๅ'
    230: 51,  # 'ๆ'
    231: 34,  # '็'
    232: 4,  # '่'
    233: 10,  # '้'
    234: 56,  # '๊'
    235: 64,  # '๋'
    236: 36,  # '์'
    237: 65,  # 'ํ'
    238: 86,  # '๎'
    239: 83,  # '๏'
    240: 70,  # '๐'
    241: 68,  # '๑'
    242: 67,  # '๒'
    243: 71,  # '๓'
    244: 73,  # '๔'
    245: 69,  # '๕'
    246: 72,  # '๖'
    247: 78,  # '๗'
    248: 77,  # '๘'
    249: 76,  # '๙'
    250: 87,  # '๚'
    251: 85,  # '๛'
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.UNDEFINED,  # None
    254: CharacterCategory.UNDEFINED,  # None
    255: CharacterCategory.UNDEFINED,  # None
}

ISO_8859_11_THAI_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-11",
    language="Thai",
    char_to_order_map=ISO_8859_11_THAI_CHAR_TO_ORDER,
    language_model=THAI_LANG_MODEL,
    typical_positive_ratio=0.816545116382814,
    keep_ascii_letters=False,
    alphabet="กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛",
)

TIS_620_THAI_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.UNDEFINED,  # None
    161: 6,  # 'ก'
    162: 31,  # 'ข'
    163: 81,  # 'ฃ'
    164: 22,  # 'ค'
    165: 82,  # 'ฅ'
    166: 66,  # 'ฆ'
    167: 8,  # 'ง'
    168: 27,  # 'จ'
    169: 54,  # 'ฉ'
    170: 35,  # 'ช'
    171: 44,  # 'ซ'
    172: 79,  # 'ฌ'
    173: 50,  # 'ญ'
    174: 61,  # 'ฎ'
    175: 60,  # 'ฏ'
    176: 53,  # 'ฐ'
    177: 63,  # 'ฑ'
    178: 58,  # 'ฒ'
    179: 43,  # 'ณ'
    180: 16,  # 'ด'
    181: 20,  # 'ต'
    182: 40,  # 'ถ'
    183: 17,  # 'ท'
    184: 48,  # 'ธ'
    185: 2,  # 'น'
    186: 19,  # 'บ'
    187: 25,  # 'ป'
    188: 41,  # 'ผ'
    189: 52,  # 'ฝ'
    190: 29,  # 'พ'
    191: 46,  # 'ฟ'
    192: 47,  # 'ภ'
    193: 9,  # 'ม'
    194: 15,  # 'ย'
    195: 3,  # 'ร'
    196: 57,  # 'ฤ'
    197: 12,  # 'ล'
    198: 84,  # 'ฦ'
    199: 14,  # 'ว'
    200: 45,  # 'ศ'
    201: 49,  # 'ษ'
    202: 18,  # 'ส'
    203: 23,  # 'ห'
    204: 62,  # 'ฬ'
    205: 5,  # 'อ'
    206: 55,  # 'ฮ'
    207: 59,  # 'ฯ'
    208: 24,  # 'ะ'
    209: 11,  # 'ั'
    210: 1,  # 'า'
    211: 38,  # 'ำ'
    212: 21,  # 'ิ'
    213: 13,  # 'ี'
    214: 42,  # 'ึ'
    215: 33,  # 'ื'
    216: 32,  # 'ุ'
    217: 37,  # 'ู'
    218: 74,  # 'ฺ'
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: 75,  # '฿'
    224: 7,  # 'เ'
    225: 26,  # 'แ'
    226: 39,  # 'โ'
    227: 30,  # 'ใ'
    228: 28,  # 'ไ'
    229: 80,  # 'ๅ'
    230: 51,  # 'ๆ'
    231: 34,  # '็'
    232: 4,  # '่'
    233: 10,  # '้'
    234: 56,  # '๊'
    235: 64,  # '๋'
    236: 36,  # '์'
    237: 65,  # 'ํ'
    238: 86,  # '๎'
    239: 83,  # '๏'
    240: 70,  # '๐'
    241: 68,  # '๑'
    242: 67,  # '๒'
    243: 71,  # '๓'
    244: 73,  # '๔'
    245: 69,  # '๕'
    246: 72,  # '๖'
    247: 78,  # '๗'
    248: 77,  # '๘'
    249: 76,  # '๙'
    250: 87,  # '๚'
    251: 85,  # '๛'
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.UNDEFINED,  # None
    254: CharacterCategory.UNDEFINED,  # None
    255: CharacterCategory.UNDEFINED,  # None
}

TIS_620_THAI_MODEL = SingleByteCharSetModel(
    charset_name="TIS-620",
    language="Thai",
    char_to_order_map=TIS_620_THAI_CHAR_TO_ORDER,
    language_model=THAI_LANG_MODEL,
    typical_positive_ratio=0.816545116382814,
    keep_ascii_letters=False,
    alphabet="กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛",
)
