# Copyright 2009 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# Automatically generated on 2009-01-30.

# This benchmark is generated by loading 50 of the most popular pages
# on the web and logging all regexp operations performed.  Each
# operation is given a weight that is calculated from an estimate of
# the popularity of the pages where it occurs and the number of times
# it is executed while loading each page.  Finally the literal
# letters in the data are encoded using ROT13 in a way that does not
# affect how the regexps match their input.


# Ported to Python for Unladen Swallow. The original JS version can be found at
# https://github.com/v8/v8/blob/master/benchmarks/regexp.js, r1243.

# Python imports
import re

# Third party imports
import pyperf


# The precompiled regexs that were in vars in the V8 code, split into
# tuples of (regex, flags).
compiled_regex_strings = [
    (r'^ba', ''),
    (r'(((\w+):\/\/)([^\/:]*)(:(\d+))?)?([^#?]*)(\?([^#]*))?(#(.*))?', ''),
    (r'^\s*|\s*$', 'g'),
    (r'\bQBZPbageby_cynprubyqre\b', ''),
    (r',', ''),
    (r'\bQBZPbageby_cynprubyqre\b', 'g'),
    (r'^[\s\xa0]+|[\s\xa0]+$', 'g'),
    (r'(\d*)(\D*)', 'g'),
    (r'=', ''),
    (r'(^|\s)lhv\-h(\s|$)', ''),
    (r'\#', 'g'),
    (r'\.', 'g'),
    (r'\'', 'g'),
    (r'\?[\w\W]*(sevraqvq|punaaryvq|tebhcvq)=([^\&\?#]*)', 'i'),
    (r'\s+', 'g'),
    (r'^\s*(\S*(\s+\S+)*)\s*$', ''),
    (r'(-[a-z])', 'i'),
    (r'(^|[^\\])\"\\\/Qngr\((-?[0-9]+)\)\\\/\"', 'g'),
    (r'^\s+|\s+$', 'g'),
    (r'(?:^|\s+)ba(?:\s+|$)', ''),
    (r'[+, ]', ''),
    (r'ybnqrq|pbzcyrgr', ''),
    (r'\bso_zrah\b', ''),
    (r'^(?:(?:[^:\/?#]+):)?(?:\/\/(?:[^\/?#]*))?([^?#]*)(?:\?([^#]*))?(?:#(.*))?', ''),
    (r'uggcf?:\/\/([^\/]+\.)?snprobbx\.pbz\/', ''),
    (r'"', 'g'),
    (r'^([^?#]+)(?:\?([^#]*))?(#.*)?', ''),
    (r'-\D', 'g'),
    (r'\bnpgvingr\b', ''),
    (r'%2R', 'gi'),
    (r'%2S', 'gi'),
    (r'^(mu-(PA|GJ)|wn|xb)$', ''),
    (r'\s?;\s?', ''),
    (r'%\w?$', ''),
    (r'TNQP=([^;]*)', 'i'),
    (r'[<>]', 'g'),
    (r'uers|fep|fryrpgrq', ''),
    (r'\s*([+>~\s])\s*([a-zA-Z#.*:\[])', 'g'),
    (r'^(\w+|\*)$', ''),
    (r'\\\\', 'g'),
    (r' ', 'g'),
    (r'\/\xc4\/t', ''),
    (r'\/\xd6\/t', ''),
    (r'\/\xdc\/t', ''),
    (r'\/\xdf\/t', ''),
    (r'\/\xe4\/t', ''),
    (r'\/\xf6\/t', ''),
    (r'\/\xfc\/t', ''),
    (r'\W', 'g'),
    (r'uers|fep|fglyr', ''),
    (r'(?:^|\s+)fryrpgrq(?:\s+|$)', ''),
    (r'\&', 'g'),
    (r'\+', 'g'),
    (r'\?', 'g'),
    (r'\t', 'g'),
    (r'(\$\{nqiHey\})|(\$nqiHey\b)', 'g'),
    (r'(\$\{cngu\})|(\$cngu\b)', 'g'),
    (r'##yv4##', 'gi'),
    (r'##yv16##', 'gi'),
    (r'##yv19##', 'gi'),
    (r'(?:^|\s+)bss(?:\s+|$)', ''),
    (r'^(([^:\/?#]+):)?(\/\/([^\/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?$', ''),
    (r'^[^<]*(<(.|\s)+>)[^>]*$|^#(\w+)$', ''),
    (r'\{0\}', 'g'),
    (r'\b[a-z]', 'g'),
    (r'^uggc:\/\/', ''),
    (r'(?:^|\s+)qvfnoyrq(?:\s+|$)', ''),
    (r'zrah_byq', 'g'),
    (r'^([#.]?)((?:[\w' + '\u0128-\uffff' + r'*_-]|\\.)*)', ''),
    (r'\{1\}', 'g'),
    (r'\s+', ''),
    (r'(\$\{4\})|(\$4\b)', 'g'),
    (r'(\$\{5\})|(\$5\b)', 'g'),
    (r'\{2\}', 'g'),
    (r'[^+>] [^+>]', ''),
    (r'\bucpyv\s*=\s*([^;]*)', 'i'),
    (r'\bucuvqr\s*=\s*([^;]*)', 'i'),
    (r'\bucfie\s*=\s*([^;]*)', 'i'),
    (r'\bhfucjrn\s*=\s*([^;]*)', 'i'),
    (r'\bmvc\s*=\s*([^;]*)', 'i'),
    (r'^((?:[\w' + '\u0128-\uffff' + r'*_-]|\\.)+)(#)((?:[\w'
     + '\u0128-\uffff' + r'*_-]|\\.)+)', ''),
    (r'^([>+~])\s*(\w*)', 'i'),
    (r'^>\s*((?:[\w' + '\u0128-\uffff' + r'*_-]|\\.)+)', ''),
    (r'^[\s[]?shapgvba', ''),
    (r'v\/g.tvs#(.*)', 'i'),
    (r'eaq_zbqobkva', ''),
    (r';\s*', ''),
    (r'(\$\{inyhr\})|(\$inyhr\b)', 'g'),
    (r'(\$\{abj\})|(\$abj\b)', 'g'),
    (r'\s+$', ''),
    (r'^\s+', ''),
    (r'(\\\"|\x00-|\x1f|\x7f-|\x9f|'
     + '\u00ad|\u0600-|\u0604|\u070f|\u17b4|\u17b5|\u200c-|\u200f|\u2028-|\u202f|\u2060-|\u206f|\ufeff|\ufff0-|\uffff' + r')', 'g'),
    (r'^(:)([\w-]+)\("?\'?(.*?(\(.*?\))?[^(]*?)"?\'?\)', ''),
    (r'^([:.#]*)((?:[\w' + '\u0128-\uffff' + r'*_-]|\\.)+)', ''),
    (r'^(\[) *@?([\w-]+) *([!*$^~=]*) *(\'?"?)(.*?)\4 *\]', '')]


# The V8 javascript engine only does one replacement unless the regexp has
# the 'g' flag. Python's sub has count = 1 to do 1 replacement and count = 0
# to replace all matches. We set this up here.

regexs = []
subcount = []

for s in compiled_regex_strings:
    if 'g' in s[1]:
        subcount.append(0)
    else:
        subcount.append(1)

    if 'i' in s[1]:
        regexs.append(re.compile(s[0], re.IGNORECASE | re.UNICODE))
    else:
        regexs.append(re.compile(s[0], re.UNICODE))

# The strings that were in vars in the V8 benchmark

strings = [
    r'Zbmvyyn/5.0 (Jvaqbjf; H; Jvaqbjf AG 5.1; ra-HF) NccyrJroXvg/528.9 (XUGZY, yvxr Trpxb) Puebzr/2.0.157.0 Fnsnev/528.9',
    r'Fubpxjnir Synfu 9.0  e115',
    r'{"anzr":"","ahzoreSbezng":{"PheeraplQrpvznyQvtvgf":2,"PheeraplQrpvznyFrcnengbe":".","VfErnqBayl":gehr,"PheeraplTebhcFvmrf":[3],"AhzoreTebhcFvmrf":[3],"CrepragTebhcFvmrf":[3],"PheeraplTebhcFrcnengbe":",","PheeraplFlzoby":"\xa4","AnAFlzoby":"AnA","PheeraplArtngvirCnggrea":0,"AhzoreArtngvirCnggrea":1,"CrepragCbfvgvirCnggrea":0,"CrepragArtngvirCnggrea":0,"ArtngvirVasvavglFlzoby":"-Vasvavgl","ArtngvirFvta":"-","AhzoreQrpvznyQvtvgf":2,"AhzoreQrpvznyFrcnengbe":".","AhzoreTebhcFrcnengbe":",","PheeraplCbfvgvirCnggrea":0,"CbfvgvirVasvavglFlzoby":"Vasvavgl","CbfvgvirFvta":"+","CrepragQrpvznyQvtvgf":2,"CrepragQrpvznyFrcnengbe":".","CrepragTebhcFrcnengbe":",","CrepragFlzoby":"%","CreZvyyrFlzoby":"\u2030","AngvirQvtvgf":["0","1","2","3","4","5","6","7","8","9"],"QvtvgFhofgvghgvba":1},"qngrGvzrSbezng":{"NZQrfvtangbe":"NZ","Pnyraqne":{"ZvaFhccbegrqQngrGvzr":"@-62135568000000@","ZnkFhccbegrqQngrGvzr":"@253402300799999@","NytbevguzGlcr":1,"PnyraqneGlcr":1,"Renf":[1],"GjbQvtvgLrneZnk":2029,"VfErnqBayl":gehr},"QngrFrcnengbe":"/","SvefgQnlBsJrrx":0,"PnyraqneJrrxEhyr":0,"ShyyQngrGvzrCnggrea":"qqqq, qq ZZZZ llll UU:zz:ff","YbatQngrCnggrea":"qqqq, qq ZZZZ llll","YbatGvzrCnggrea":"UU:zz:ff","ZbaguQnlCnggrea":"ZZZZ qq","CZQrfvtangbe":"CZ","ESP1123Cnggrea":"qqq, qq ZZZ llll UU\':\'zz\':\'ff \'TZG\'","FubegQngrCnggrea":"ZZ/qq/llll","FubegGvzrCnggrea":"UU:zz","FbegnoyrQngrGvzrCnggrea":"llll\'-\'ZZ\'-\'qq\'G\'UU\':\'zz\':\'ff","GvzrFrcnengbe":":","HavirefnyFbegnoyrQngrGvzrCnggrea":"llll\'-\'ZZ\'-\'qq UU\':\'zz\':\'ff\'M\'","LrneZbaguCnggrea":"llll ZZZZ","NooerivngrqQnlAnzrf":["Fha","Zba","Ghr","Jrq","Guh","Sev","Fng"],"FubegrfgQnlAnzrf":["Fh","Zb","Gh","Jr","Gu","Se","Fn"],"QnlAnzrf":["Fhaqnl","Zbaqnl","Ghrfqnl","Jrqarfqnl","Guhefqnl","Sevqnl","Fngheqnl"],"NooerivngrqZbaguAnzrf":["Wna","Sro","Zne","Nce","Znl","Wha","Why","Nht","Frc","Bpg","Abi","Qrp",""],"ZbaguAnzrf":["Wnahnel","Sroehnel","Znepu","Ncevy","Znl","Whar","Whyl","Nhthfg","Frcgrzore","Bpgbore","Abirzore","Qrprzore",""],"VfErnqBayl":gehr,"AngvirPnyraqneAnzr":"Tertbevna Pnyraqne","NooerivngrqZbaguTravgvirAnzrf":["Wna","Sro","Zne","Nce","Znl","Wha","Why","Nht","Frc","Bpg","Abi","Qrp",""],"ZbaguTravgvirAnzrf":["Wnahnel","Sroehnel","Znepu","Ncevy","Znl","Whar","Whyl","Nhthfg","Frcgrzore","Bpgbore","Abirzore","Qrprzore",""]}}',
    r'{"anzr":"ra-HF","ahzoreSbezng":{"PheeraplQrpvznyQvtvgf":2,"PheeraplQrpvznyFrcnengbe":".","VfErnqBayl":snyfr,"PheeraplTebhcFvmrf":[3],"AhzoreTebhcFvmrf":[3],"CrepragTebhcFvmrf":[3],"PheeraplTebhcFrcnengbe":",","PheeraplFlzoby":"$","AnAFlzoby":"AnA","PheeraplArtngvirCnggrea":0,"AhzoreArtngvirCnggrea":1,"CrepragCbfvgvirCnggrea":0,"CrepragArtngvirCnggrea":0,"ArtngvirVasvavglFlzoby":"-Vasvavgl","ArtngvirFvta":"-","AhzoreQrpvznyQvtvgf":2,"AhzoreQrpvznyFrcnengbe":".","AhzoreTebhcFrcnengbe":",","PheeraplCbfvgvirCnggrea":0,"CbfvgvirVasvavglFlzoby":"Vasvavgl","CbfvgvirFvta":"+","CrepragQrpvznyQvtvgf":2,"CrepragQrpvznyFrcnengbe":".","CrepragTebhcFrcnengbe":",","CrepragFlzoby":"%","CreZvyyrFlzoby":"\u2030","AngvirQvtvgf":["0","1","2","3","4","5","6","7","8","9"],"QvtvgFhofgvghgvba":1},"qngrGvzrSbezng":{"NZQrfvtangbe":"NZ","Pnyraqne":{"ZvaFhccbegrqQngrGvzr":"@-62135568000000@","ZnkFhccbegrqQngrGvzr":"@253402300799999@","NytbevguzGlcr":1,"PnyraqneGlcr":1,"Renf":[1],"GjbQvtvgLrneZnk":2029,"VfErnqBayl":snyfr},"QngrFrcnengbe":"/","SvefgQnlBsJrrx":0,"PnyraqneJrrxEhyr":0,"ShyyQngrGvzrCnggrea":"qqqq, ZZZZ qq, llll u:zz:ff gg","YbatQngrCnggrea":"qqqq, ZZZZ qq, llll","YbatGvzrCnggrea":"u:zz:ff gg","ZbaguQnlCnggrea":"ZZZZ qq","CZQrfvtangbe":"CZ","ESP1123Cnggrea":"qqq, qq ZZZ llll UU\':\'zz\':\'ff \'TZG\'","FubegQngrCnggrea":"Z/q/llll","FubegGvzrCnggrea":"u:zz gg","FbegnoyrQngrGvzrCnggrea":"llll\'-\'ZZ\'-\'qq\'G\'UU\':\'zz\':\'ff","GvzrFrcnengbe":":","HavirefnyFbegnoyrQngrGvzrCnggrea":"llll\'-\'ZZ\'-\'qq UU\':\'zz\':\'ff\'M\'","LrneZbaguCnggrea":"ZZZZ, llll","NooerivngrqQnlAnzrf":["Fha","Zba","Ghr","Jrq","Guh","Sev","Fng"],"FubegrfgQnlAnzrf":["Fh","Zb","Gh","Jr","Gu","Se","Fn"],"QnlAnzrf":["Fhaqnl","Zbaqnl","Ghrfqnl","Jrqarfqnl","Guhefqnl","Sevqnl","Fngheqnl"],"NooerivngrqZbaguAnzrf":["Wna","Sro","Zne","Nce","Znl","Wha","Why","Nht","Frc","Bpg","Abi","Qrp",""],"ZbaguAnzrf":["Wnahnel","Sroehnel","Znepu","Ncevy","Znl","Whar","Whyl","Nhthfg","Frcgrzore","Bpgbore","Abirzore","Qrprzore",""],"VfErnqBayl":snyfr,"AngvirPnyraqneAnzr":"Tertbevna Pnyraqne","NooerivngrqZbaguTravgvirAnzrf":["Wna","Sro","Zne","Nce","Znl","Wha","Why","Nht","Frc","Bpg","Abi","Qrp",""],"ZbaguTravgvirAnzrf":["Wnahnel","Sroehnel","Znepu","Ncevy","Znl","Whar","Whyl","Nhthfg","Frcgrzore","Bpgbore","Abirzore","Qrprzore",""]}}',
    r'HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'uggc://jjj.snprobbx.pbz/vaqrk.cuc',
    r';;jvaqbj.IjPurpxZbhfrCbfvgvbaNQ_VQ=shapgvba(r){vs(!r)ine r=jvaqbj.rirag;ine c=-1;vs(d1)c=d1.EbyybssCnary;ine bo=IjTrgBow("IjCnayNQ_VQ_"+c);vs(bo&&bo.fglyr.ivfvovyvgl=="ivfvoyr"){ine fns=IjFns?8:0;ine pheK=r.pyvragK+IjBOFpe("U")+fns,pheL=r.pyvragL+IjBOFpe("I")+fns;ine y=IjBOEC(NQ_VQ,bo,"Y"),g=IjBOEC(NQ_VQ,bo,"G");ine e=y+d1.Cnaryf[c].Jvqgu,o=g+d1.Cnaryf[c].Urvtug;vs((pheK<y)||(pheK>e)||(pheL<g)||(pheL>o)){vs(jvaqbj.IjBaEbyybssNQ_VQ)IjBaEbyybssNQ_VQ(c);ryfr IjPybfrNq(NQ_VQ,c,gehr,"");}ryfr erghea;}IjPnapryZbhfrYvfgrareNQ_VQ();};;jvaqbj.IjFrgEbyybssCnaryNQ_VQ=shapgvba(c){ine z="zbhfrzbir",q=qbphzrag,s=IjPurpxZbhfrCbfvgvbaNQ_VQ;c=IjTc(NQ_VQ,c);vs(d1&&d1.EbyybssCnary>-1)IjPnapryZbhfrYvfgrareNQ_VQ();vs(d1)d1.EbyybssCnary=c;gel{vs(q.nqqRiragYvfgrare)q.nqqRiragYvfgrare(z,s,snyfr);ryfr vs(q.nggnpuRirag)q.nggnpuRirag("ba"+z,s);}pngpu(r){}};;jvaqbj.IjPnapryZbhfrYvfgrareNQ_VQ=shapgvba(){ine z="zbhfrzbir",q=qbphzrag,s=IjPurpxZbhfrCbfvgvbaNQ_VQ;vs(d1)d1.EbyybssCnary=-1;gel{vs(q.erzbirRiragYvfgrare)q.erzbirRiragYvfgrare(z,s,snyfr);ryfr vs(q.qrgnpuRirag)q.qrgnpuRirag("ba"+z,s);}pngpu(r){}};;d1.IjTc=d2(n,c){ine nq=d1;vs(vfAnA(c)){sbe(ine v=0;v<nq.Cnaryf.yratgu;v++)vs(nq.Cnaryf[v].Anzr==c)erghea v;erghea 0;}erghea c;};;d1.IjTpy=d2(n,c,p){ine cn=d1.Cnaryf[IjTc(n,c)];vs(!cn)erghea 0;vs(vfAnA(p)){sbe(ine v=0;v<cn.Pyvpxguehf.yratgu;v++)vs(cn.Pyvpxguehf[v].Anzr==p)erghea v;erghea 0;}erghea p;};;d1.IjGenpr=d2(n,f){gel{vs(jvaqbj["Ij"+"QtQ"])jvaqbj["Ij"+"QtQ"](n,1,f);}pngpu(r){}};;d1.IjYvzvg1=d2(n,f){ine nq=d1,vh=f.fcyvg("/");sbe(ine v=0,p=0;v<vh.yratgu;v++){vs(vh[v].yratgu>0){vs(nq.FzV.yratgu>0)nq.FzV+="/";nq.FzV+=vh[v];nq.FtZ[nq.FtZ.yratgu]=snyfr;}}};;d1.IjYvzvg0=d2(n,f){ine nq=d1,vh=f.fcyvg("/");sbe(ine v=0;v<vh.yratgu;v++){vs(vh[v].yratgu>0){vs(nq.OvC.yratgu>0)nq.OvC+="/";nq.OvC+=vh[v];}}};;d1.IjRVST=d2(n,c){jvaqbj["IjCnayNQ_VQ_"+c+"_Bow"]=IjTrgBow("IjCnayNQ_VQ_"+c+"_Bow");vs(jvaqbj["IjCnayNQ_VQ_"+c+"_Bow"]==ahyy)frgGvzrbhg("IjRVST(NQ_VQ,"+c+")",d1.rvsg);};;d1.IjNavzSHC=d2(n,c){ine nq=d1;vs(c>nq.Cnaryf.yratgu)erghea;ine cna=nq.Cnaryf[c],nn=gehr,on=gehr,yn=gehr,en=gehr,cn=nq.Cnaryf[0],sf=nq.ShF,j=cn.Jvqgu,u=cn.Urvtug;vs(j=="100%"){j=sf;en=snyfr;yn=snyfr;}vs(u=="100%"){u=sf;nn=snyfr;on=snyfr;}vs(cn.YnY=="Y")yn=snyfr;vs(cn.YnY=="E")en=snyfr;vs(cn.GnY=="G")nn=snyfr;vs(cn.GnY=="O")on=snyfr;ine k=0,l=0;fjvgpu(nq.NshP%8){pnfr 0:oernx;pnfr 1:vs(nn)l=-sf;oernx;pnfr 2:k=j-sf;oernx;pnfr 3:vs(en)k=j;oernx;pnfr 4:k=j-sf;l=u-sf;oernx;pnfr 5:k=j-sf;vs(on)l=u;oernx;pnfr 6:l=u-sf;oernx;pnfr 7:vs(yn)k=-sf;l=u-sf;oernx;}vs(nq.NshP++ <nq.NshG)frgGvzrbhg(("IjNavzSHC(NQ_VQ,"+c+")"),nq.NshC);ryfr{k=-1000;l=k;}cna.YrsgBssfrg=k;cna.GbcBssfrg=l;IjNhErcb(n,c);};;d1.IjTrgErnyCbfvgvba=d2(n,b,j){erghea IjBOEC.nccyl(guvf,nethzragf);};;d1.IjPnapryGvzrbhg=d2(n,c){c=IjTc(n,c);ine cay=d1.Cnaryf[c];vs(cay&&cay.UgU!=""){pyrneGvzrbhg(cay.UgU);}};;d1.IjPnapryNyyGvzrbhgf=d2(n){vs(d1.YbpxGvzrbhgPunatrf)erghea;sbe(ine c=0;c<d1.bac;c++)IjPnapryGvzrbhg(n,c);};;d1.IjFgnegGvzrbhg=d2(n,c,bG){c=IjTc(n,c);ine cay=d1.Cnaryf[c];vs(cay&&((cay.UvqrGvzrbhgInyhr>0)||(nethzragf.yratgu==3&&bG>0))){pyrneGvzrbhg(cay.UgU);cay.UgU=frgGvzrbhg(cay.UvqrNpgvba,(nethzragf.yratgu==3?bG:cay.UvqrGvzrbhgInyhr));}};;d1.IjErfrgGvzrbhg=d2(n,c,bG){c=IjTc(n,c);IjPnapryGvzrbhg(n,c);riny("IjFgnegGvzrbhg(NQ_VQ,c"+(nethzragf.yratgu==3?",bG":"")+")");};;d1.IjErfrgNyyGvzrbhgf=d2(n){sbe(ine c=0;c<d1.bac;c++)IjErfrgGvzrbhg(n,c);};;d1.IjQrgnpure=d2(n,rig,sap){gel{vs(IjQVR5)riny("jvaqbj.qrgnpuRirag(\'ba"+rig+"\',"+sap+"NQ_VQ)");ryfr vs(!IjQVRZnp)riny("jvaqbj.erzbirRiragYvfgrare(\'"+rig+"\',"+sap+"NQ_VQ,snyfr)");}pngpu(r){}};;d1.IjPyrnaHc=d2(n){IjCvat(n,"G");ine nq=d1;sbe(ine v=0;v<nq.Cnaryf.yratgu;v++){IjUvqrCnary(n,v,gehr);}gel{IjTrgBow(nq.gya).vaareUGZY="";}pngpu(r){}vs(nq.gya!=nq.gya2)gel{IjTrgBow(nq.gya2).vaareUGZY="";}pngpu(r){}gel{d1=ahyy;}pngpu(r){}gel{IjQrgnpure(n,"haybnq","IjHayNQ_VQ");}pngpu(r){}gel{jvaqbj.IjHayNQ_VQ=ahyy;}pngpu(r){}gel{IjQrgnpure(n,"fpebyy","IjFeNQ_VQ");}pngpu(r){}gel{jvaqbj.IjFeNQ_VQ=ahyy;}pngpu(r){}gel{IjQrgnpure(n,"erfvmr","IjEmNQ_VQ");}pngpu(r){}gel{jvaqbj.IjEmNQ_VQ=ahyy;}pngpu(r){}gel{IjQrgnpure(n',
    r';;jvaqbj.IjPurpxZbhfrCbfvgvbaNQ_VQ=shapgvba(r){vs(!r)ine r=jvaqbj.rirag;ine c=-1;vs(jvaqbj.IjNqNQ_VQ)c=jvaqbj.IjNqNQ_VQ.EbyybssCnary;ine bo=IjTrgBow("IjCnayNQ_VQ_"+c);vs(bo&&bo.fglyr.ivfvovyvgl=="ivfvoyr"){ine fns=IjFns?8:0;ine pheK=r.pyvragK+IjBOFpe("U")+fns,pheL=r.pyvragL+IjBOFpe("I")+fns;ine y=IjBOEC(NQ_VQ,bo,"Y"),g=IjBOEC(NQ_VQ,bo,"G");ine e=y+jvaqbj.IjNqNQ_VQ.Cnaryf[c].Jvqgu,o=g+jvaqbj.IjNqNQ_VQ.Cnaryf[c].Urvtug;vs((pheK<y)||(pheK>e)||(pheL<g)||(pheL>o)){vs(jvaqbj.IjBaEbyybssNQ_VQ)IjBaEbyybssNQ_VQ(c);ryfr IjPybfrNq(NQ_VQ,c,gehr,"");}ryfr erghea;}IjPnapryZbhfrYvfgrareNQ_VQ();};;jvaqbj.IjFrgEbyybssCnaryNQ_VQ=shapgvba(c){ine z="zbhfrzbir",q=qbphzrag,s=IjPurpxZbhfrCbfvgvbaNQ_VQ;c=IjTc(NQ_VQ,c);vs(jvaqbj.IjNqNQ_VQ&&jvaqbj.IjNqNQ_VQ.EbyybssCnary>-1)IjPnapryZbhfrYvfgrareNQ_VQ();vs(jvaqbj.IjNqNQ_VQ)jvaqbj.IjNqNQ_VQ.EbyybssCnary=c;gel{vs(q.nqqRiragYvfgrare)q.nqqRiragYvfgrare(z,s,snyfr);ryfr vs(q.nggnpuRirag)q.nggnpuRirag("ba"+z,s);}pngpu(r){}};;jvaqbj.IjPnapryZbhfrYvfgrareNQ_VQ=shapgvba(){ine z="zbhfrzbir",q=qbphzrag,s=IjPurpxZbhfrCbfvgvbaNQ_VQ;vs(jvaqbj.IjNqNQ_VQ)jvaqbj.IjNqNQ_VQ.EbyybssCnary=-1;gel{vs(q.erzbirRiragYvfgrare)q.erzbirRiragYvfgrare(z,s,snyfr);ryfr vs(q.qrgnpuRirag)q.qrgnpuRirag("ba"+z,s);}pngpu(r){}};;jvaqbj.IjNqNQ_VQ.IjTc=shapgvba(n,c){ine nq=jvaqbj.IjNqNQ_VQ;vs(vfAnA(c)){sbe(ine v=0;v<nq.Cnaryf.yratgu;v++)vs(nq.Cnaryf[v].Anzr==c)erghea v;erghea 0;}erghea c;};;jvaqbj.IjNqNQ_VQ.IjTpy=shapgvba(n,c,p){ine cn=jvaqbj.IjNqNQ_VQ.Cnaryf[IjTc(n,c)];vs(!cn)erghea 0;vs(vfAnA(p)){sbe(ine v=0;v<cn.Pyvpxguehf.yratgu;v++)vs(cn.Pyvpxguehf[v].Anzr==p)erghea v;erghea 0;}erghea p;};;jvaqbj.IjNqNQ_VQ.IjGenpr=shapgvba(n,f){gel{vs(jvaqbj["Ij"+"QtQ"])jvaqbj["Ij"+"QtQ"](n,1,f);}pngpu(r){}};;jvaqbj.IjNqNQ_VQ.IjYvzvg1=shapgvba(n,f){ine nq=jvaqbj.IjNqNQ_VQ,vh=f.fcyvg("/");sbe(ine v=0,p=0;v<vh.yratgu;v++){vs(vh[v].yratgu>0){vs(nq.FzV.yratgu>0)nq.FzV+="/";nq.FzV+=vh[v];nq.FtZ[nq.FtZ.yratgu]=snyfr;}}};;jvaqbj.IjNqNQ_VQ.IjYvzvg0=shapgvba(n,f){ine nq=jvaqbj.IjNqNQ_VQ,vh=f.fcyvg("/");sbe(ine v=0;v<vh.yratgu;v++){vs(vh[v].yratgu>0){vs(nq.OvC.yratgu>0)nq.OvC+="/";nq.OvC+=vh[v];}}};;jvaqbj.IjNqNQ_VQ.IjRVST=shapgvba(n,c){jvaqbj["IjCnayNQ_VQ_"+c+"_Bow"]=IjTrgBow("IjCnayNQ_VQ_"+c+"_Bow");vs(jvaqbj["IjCnayNQ_VQ_"+c+"_Bow"]==ahyy)frgGvzrbhg("IjRVST(NQ_VQ,"+c+")",jvaqbj.IjNqNQ_VQ.rvsg);};;jvaqbj.IjNqNQ_VQ.IjNavzSHC=shapgvba(n,c){ine nq=jvaqbj.IjNqNQ_VQ;vs(c>nq.Cnaryf.yratgu)erghea;ine cna=nq.Cnaryf[c],nn=gehr,on=gehr,yn=gehr,en=gehr,cn=nq.Cnaryf[0],sf=nq.ShF,j=cn.Jvqgu,u=cn.Urvtug;vs(j=="100%"){j=sf;en=snyfr;yn=snyfr;}vs(u=="100%"){u=sf;nn=snyfr;on=snyfr;}vs(cn.YnY=="Y")yn=snyfr;vs(cn.YnY=="E")en=snyfr;vs(cn.GnY=="G")nn=snyfr;vs(cn.GnY=="O")on=snyfr;ine k=0,l=0;fjvgpu(nq.NshP%8){pnfr 0:oernx;pnfr 1:vs(nn)l=-sf;oernx;pnfr 2:k=j-sf;oernx;pnfr 3:vs(en)k=j;oernx;pnfr 4:k=j-sf;l=u-sf;oernx;pnfr 5:k=j-sf;vs(on)l=u;oernx;pnfr 6:l=u-sf;oernx;pnfr 7:vs(yn)k=-sf;l=u-sf;oernx;}vs(nq.NshP++ <nq.NshG)frgGvzrbhg(("IjNavzSHC(NQ_VQ,"+c+")"),nq.NshC);ryfr{k=-1000;l=k;}cna.YrsgBssfrg=k;cna.GbcBssfrg=l;IjNhErcb(n,c);};;jvaqbj.IjNqNQ_VQ.IjTrgErnyCbfvgvba=shapgvba(n,b,j){erghea IjBOEC.nccyl(guvf,nethzragf);};;jvaqbj.IjNqNQ_VQ.IjPnapryGvzrbhg=shapgvba(n,c){c=IjTc(n,c);ine cay=jvaqbj.IjNqNQ_VQ.Cnaryf[c];vs(cay&&cay.UgU!=""){pyrneGvzrbhg(cay.UgU);}};;jvaqbj.IjNqNQ_VQ.IjPnapryNyyGvzrbhgf=shapgvba(n){vs(jvaqbj.IjNqNQ_VQ.YbpxGvzrbhgPunatrf)erghea;sbe(ine c=0;c<jvaqbj.IjNqNQ_VQ.bac;c++)IjPnapryGvzrbhg(n,c);};;jvaqbj.IjNqNQ_VQ.IjFgnegGvzrbhg=shapgvba(n,c,bG){c=IjTc(n,c);ine cay=jvaqbj.IjNqNQ_VQ.Cnaryf[c];vs(cay&&((cay.UvqrGvzrbhgInyhr>0)||(nethzragf.yratgu==3&&bG>0))){pyrneGvzrbhg(cay.UgU);cay.UgU=frgGvzrbhg(cay.UvqrNpgvba,(nethzragf.yratgu==3?bG:cay.UvqrGvzrbhgInyhr));}};;jvaqbj.IjNqNQ_VQ.IjErfrgGvzrbhg=shapgvba(n,c,bG){c=IjTc(n,c);IjPnapryGvzrbhg(n,c);riny("IjFgnegGvzrbhg(NQ_VQ,c"+(nethzragf.yratgu==3?",bG":"")+")");};;jvaqbj.IjNqNQ_VQ.IjErfrgNyyGvzrbhgf=shapgvba(n){sbe(ine c=0;c<jvaqbj.IjNqNQ_VQ.bac;c++)IjErfrgGvzrbhg(n,c);};;jvaqbj.IjNqNQ_VQ.IjQrgnpure=shapgvba(n,rig,sap){gel{vs(IjQVR5)riny("jvaqbj.qrgnpuRirag(\'ba"+rig+"\',"+sap+"NQ_VQ)");ryfr vs(!IjQVRZnp)riny("jvaqbj.erzbir',
    r';;jvaqbj.IjPurpxZbhfrCbfvgvbaNQ_VQ=shapgvba(r){vs(!r)ine r=jvaqbj.rirag;ine c=-1;vs(jvaqbj.IjNqNQ_VQ)c=jvaqbj.IjNqNQ_VQ.EbyybssCnary;ine bo=IjTrgBow("IjCnayNQ_VQ_"+c);vs(bo&&bo.fglyr.ivfvovyvgl=="ivfvoyr"){ine fns=IjFns?8:0;ine pheK=r.pyvragK+IjBOFpe("U")+fns,pheL=r.pyvragL+IjBOFpe("I")+fns;ine y=IjBOEC(NQ_VQ,bo,"Y"),g=IjBOEC(NQ_VQ,bo,"G");ine e=y+jvaqbj.IjNqNQ_VQ.Cnaryf[c].Jvqgu,o=g+jvaqbj.IjNqNQ_VQ.Cnaryf[c].Urvtug;vs((pheK<y)||(pheK>e)||(pheL<g)||(pheL>o)){vs(jvaqbj.IjBaEbyybssNQ_VQ)IjBaEbyybssNQ_VQ(c);ryfr IjPybfrNq(NQ_VQ,c,gehr,"");}ryfr erghea;}IjPnapryZbhfrYvfgrareNQ_VQ();};;jvaqbj.IjFrgEbyybssCnaryNQ_VQ=shapgvba(c){ine z="zbhfrzbir",q=qbphzrag,s=IjPurpxZbhfrCbfvgvbaNQ_VQ;c=IjTc(NQ_VQ,c);vs(jvaqbj.IjNqNQ_VQ&&jvaqbj.IjNqNQ_VQ.EbyybssCnary>-1)IjPnapryZbhfrYvfgrareNQ_VQ();vs(jvaqbj.IjNqNQ_VQ)jvaqbj.IjNqNQ_VQ.EbyybssCnary=c;gel{vs(q.nqqRiragYvfgrare)q.nqqRiragYvfgrare(z,s,snyfr);ryfr vs(q.nggnpuRirag)q.nggnpuRirag("ba"+z,s);}pngpu(r){}};;jvaqbj.IjPnapryZbhfrYvfgrareNQ_VQ=shapgvba(){ine z="zbhfrzbir",q=qbphzrag,s=IjPurpxZbhfrCbfvgvbaNQ_VQ;vs(jvaqbj.IjNqNQ_VQ)jvaqbj.IjNqNQ_VQ.EbyybssCnary=-1;gel{vs(q.erzbirRiragYvfgrare)q.erzbirRiragYvfgrare(z,s,snyfr);ryfr vs(q.qrgnpuRirag)q.qrgnpuRirag("ba"+z,s);}pngpu(r){}};;jvaqbj.IjNqNQ_VQ.IjTc=d2(n,c){ine nq=jvaqbj.IjNqNQ_VQ;vs(vfAnA(c)){sbe(ine v=0;v<nq.Cnaryf.yratgu;v++)vs(nq.Cnaryf[v].Anzr==c)erghea v;erghea 0;}erghea c;};;jvaqbj.IjNqNQ_VQ.IjTpy=d2(n,c,p){ine cn=jvaqbj.IjNqNQ_VQ.Cnaryf[IjTc(n,c)];vs(!cn)erghea 0;vs(vfAnA(p)){sbe(ine v=0;v<cn.Pyvpxguehf.yratgu;v++)vs(cn.Pyvpxguehf[v].Anzr==p)erghea v;erghea 0;}erghea p;};;jvaqbj.IjNqNQ_VQ.IjGenpr=d2(n,f){gel{vs(jvaqbj["Ij"+"QtQ"])jvaqbj["Ij"+"QtQ"](n,1,f);}pngpu(r){}};;jvaqbj.IjNqNQ_VQ.IjYvzvg1=d2(n,f){ine nq=jvaqbj.IjNqNQ_VQ,vh=f.fcyvg("/");sbe(ine v=0,p=0;v<vh.yratgu;v++){vs(vh[v].yratgu>0){vs(nq.FzV.yratgu>0)nq.FzV+="/";nq.FzV+=vh[v];nq.FtZ[nq.FtZ.yratgu]=snyfr;}}};;jvaqbj.IjNqNQ_VQ.IjYvzvg0=d2(n,f){ine nq=jvaqbj.IjNqNQ_VQ,vh=f.fcyvg("/");sbe(ine v=0;v<vh.yratgu;v++){vs(vh[v].yratgu>0){vs(nq.OvC.yratgu>0)nq.OvC+="/";nq.OvC+=vh[v];}}};;jvaqbj.IjNqNQ_VQ.IjRVST=d2(n,c){jvaqbj["IjCnayNQ_VQ_"+c+"_Bow"]=IjTrgBow("IjCnayNQ_VQ_"+c+"_Bow");vs(jvaqbj["IjCnayNQ_VQ_"+c+"_Bow"]==ahyy)frgGvzrbhg("IjRVST(NQ_VQ,"+c+")",jvaqbj.IjNqNQ_VQ.rvsg);};;jvaqbj.IjNqNQ_VQ.IjNavzSHC=d2(n,c){ine nq=jvaqbj.IjNqNQ_VQ;vs(c>nq.Cnaryf.yratgu)erghea;ine cna=nq.Cnaryf[c],nn=gehr,on=gehr,yn=gehr,en=gehr,cn=nq.Cnaryf[0],sf=nq.ShF,j=cn.Jvqgu,u=cn.Urvtug;vs(j=="100%"){j=sf;en=snyfr;yn=snyfr;}vs(u=="100%"){u=sf;nn=snyfr;on=snyfr;}vs(cn.YnY=="Y")yn=snyfr;vs(cn.YnY=="E")en=snyfr;vs(cn.GnY=="G")nn=snyfr;vs(cn.GnY=="O")on=snyfr;ine k=0,l=0;fjvgpu(nq.NshP%8){pnfr 0:oernx;pnfr 1:vs(nn)l=-sf;oernx;pnfr 2:k=j-sf;oernx;pnfr 3:vs(en)k=j;oernx;pnfr 4:k=j-sf;l=u-sf;oernx;pnfr 5:k=j-sf;vs(on)l=u;oernx;pnfr 6:l=u-sf;oernx;pnfr 7:vs(yn)k=-sf;l=u-sf;oernx;}vs(nq.NshP++ <nq.NshG)frgGvzrbhg(("IjNavzSHC(NQ_VQ,"+c+")"),nq.NshC);ryfr{k=-1000;l=k;}cna.YrsgBssfrg=k;cna.GbcBssfrg=l;IjNhErcb(n,c);};;jvaqbj.IjNqNQ_VQ.IjTrgErnyCbfvgvba=d2(n,b,j){erghea IjBOEC.nccyl(guvf,nethzragf);};;jvaqbj.IjNqNQ_VQ.IjPnapryGvzrbhg=d2(n,c){c=IjTc(n,c);ine cay=jvaqbj.IjNqNQ_VQ.Cnaryf[c];vs(cay&&cay.UgU!=""){pyrneGvzrbhg(cay.UgU);}};;jvaqbj.IjNqNQ_VQ.IjPnapryNyyGvzrbhgf=d2(n){vs(jvaqbj.IjNqNQ_VQ.YbpxGvzrbhgPunatrf)erghea;sbe(ine c=0;c<jvaqbj.IjNqNQ_VQ.bac;c++)IjPnapryGvzrbhg(n,c);};;jvaqbj.IjNqNQ_VQ.IjFgnegGvzrbhg=d2(n,c,bG){c=IjTc(n,c);ine cay=jvaqbj.IjNqNQ_VQ.Cnaryf[c];vs(cay&&((cay.UvqrGvzrbhgInyhr>0)||(nethzragf.yratgu==3&&bG>0))){pyrneGvzrbhg(cay.UgU);cay.UgU=frgGvzrbhg(cay.UvqrNpgvba,(nethzragf.yratgu==3?bG:cay.UvqrGvzrbhgInyhr));}};;jvaqbj.IjNqNQ_VQ.IjErfrgGvzrbhg=d2(n,c,bG){c=IjTc(n,c);IjPnapryGvzrbhg(n,c);riny("IjFgnegGvzrbhg(NQ_VQ,c"+(nethzragf.yratgu==3?",bG":"")+")");};;jvaqbj.IjNqNQ_VQ.IjErfrgNyyGvzrbhgf=d2(n){sbe(ine c=0;c<jvaqbj.IjNqNQ_VQ.bac;c++)IjErfrgGvzrbhg(n,c);};;jvaqbj.IjNqNQ_VQ.IjQrgnpure=d2(n,rig,sap){gel{vs(IjQVR5)riny("jvaqbj.qrgnpuRirag(\'ba"+rig+"\',"+sap+"NQ_VQ)");ryfr vs(!IjQVRZnp)riny("jvaqbj.erzbirRiragYvfgrare(\'"+rig+"\',"+sap+"NQ_VQ,snyfr)");}pngpu(r){}};;jvaqbj.IjNqNQ_VQ.IjPyrna',
    r'FrffvbaQQS2=111soqs57qo8o8480qo18sor2011r3n591q7s6s37r120904; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669315660164980&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'FrffvbaQQS2=111soqs57qo8o8480qo18sor2011r3n591q7s6s37r120904; __hgzm=144631658.1231363570.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.3426875219718084000.1231363570.1231363570.1231363570.1; __hgzo=144631658.0.10.1231363570; __hgzp=144631658; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669315660164980&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231363514065&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231363514065&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Subzr.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=1326469221.1231363557&tn_fvq=1231363557&tn_uvq=1114636509&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669315660164980&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669315660164980&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'FrffvbaQQS2=s6r4579npn4rn2135s904r0s75pp1o5334p6s6pospo12696; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669316860113296&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=; AFP_zp_dfctwzs-aowb_80=44132r503660',
    r'FrffvbaQQS2=s6r4579npn4rn2135s904r0s75pp1o5334p6s6pospo12696; AFP_zp_dfctwzs-aowb_80=44132r503660; __hgzm=144631658.1231363638.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.965867047679498800.1231363638.1231363638.1231363638.1; __hgzo=144631658.0.10.1231363638; __hgzp=144631658; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669316860113296&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231363621014&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231363621014&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Scebsvyr.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=348699119.1231363624&tn_fvq=1231363624&tn_uvq=895511034&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'uggc://jjj.yrobapbva.se/yv',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669316860113296&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669316860113296&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'FrffvbaQQS2=s15q53p9n372sn76npr13o271n4s3p5r29p235746p908p58; ZFPhygher=VC=66.249.85.130&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669358527244818&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'FrffvbaQQS2=s15q53p9n372sn76npr13o271n4s3p5r29p235746p908p58; __hgzm=144631658.1231367822.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.4127520630321984500.1231367822.1231367822.1231367822.1; __hgzo=144631658.0.10.1231367822; __hgzp=144631658; ZFPhygher=VC=66.249.85.130&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669358527244818&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231367803797&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231367803797&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Szrffntvat.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=1192552091.1231367807&tn_fvq=1231367807&tn_uvq=1155446857&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'ZFPhygher=VC=66.249.85.130&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669358527244818&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=66.249.85.130&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669358527244818&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'hy.ynat-fryrpgbe',
    r'<hy pynff="nqi">##yv4##Cbjreshy Zvpebfbsg grpuabybtl urycf svtug fcnz naq vzcebir frphevgl.##yv19##Trg zber qbar gunaxf gb terngre rnfr naq fcrrq.##yv16##Ybgf bs fgbentr &#40;5 TO&#41; - zber pbby fghss ba gur jnl.##OE## ##OE## ##N##Yrnea zber##/N##</hy>',
    r'<hy pynff="nqi"><yv vq="YvOYG4" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg4.cat)">Cbjreshy Zvpebfbsg grpuabybtl urycf svtug fcnz naq vzcebir frphevgl.##yv19##Trg zber qbar gunaxf gb terngre rnfr naq fcrrq.##yv16##Ybgf bs fgbentr &#40;5 TO&#41; - zber pbby fghss ba gur jnl.##OE## ##OE## ##N##Yrnea zber##/N##</hy>',
    r'<hy pynff="nqi"><yv vq="YvOYG4" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg4.cat)">Cbjreshy Zvpebfbsg grpuabybtl urycf svtug fcnz naq vzcebir frphevgl.##yv19##Trg zber qbar gunaxf gb terngre rnfr naq fcrrq.<yv vq="YvOYG16" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg16.cat)">Ybgf bs fgbentr &#40;5 TO&#41; - zber pbby fghss ba gur jnl.##OE## ##OE## ##N##Yrnea zber##/N##</hy>',
    r'<hy pynff="nqi"><yv vq="YvOYG4" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg4.cat)">Cbjreshy Zvpebfbsg grpuabybtl urycf svtug fcnz naq vzcebir frphevgl.<yv vq="YvOYG19" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg19.cat)">Trg zber qbar gunaxf gb terngre rnfr naq fcrrq.<yv vq="YvOYG16" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg16.cat)">Ybgf bs fgbentr &#40;5 TO&#41; - zber pbby fghss ba gur jnl.##OE## ##OE## ##N##Yrnea zber##/N##</hy>',
    r'<hy pynff="nqi"><yv vq="YvOYG4" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg4.cat)">Cbjreshy Zvpebfbsg grpuabybtl urycf svtug fcnz naq vzcebir frphevgl.<yv vq="YvOYG19" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg19.cat)">Trg zber qbar gunaxf gb terngre rnfr naq fcrrq.<yv vq="YvOYG16" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg16.cat)">Ybgf bs fgbentr &#40;5 TO&#41; - zber pbby fghss ba gur jnl.<oe> <oe> ##N##Yrnea zber##/N##</hy>',
    r'<hy pynff="nqi"><yv vq="YvOYG4" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg4.cat)">Cbjreshy Zvpebfbsg grpuabybtl urycf svtug fcnz naq vzcebir frphevgl.<yv vq="YvOYG19" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg19.cat)">Trg zber qbar gunaxf gb terngre rnfr naq fcrrq.<yv vq="YvOYG16" fglyr="onpxtebhaq-vzntr:hey(uggc://vzt.jykef.pbz/~Yvir.FvgrPbagrag.VQ/~14.2.1230/~/~/~/oyg16.cat)">Ybgf bs fgbentr &#40;5 TO&#41; - zber pbby fghss ba gur jnl.<oe> <oe> <n uers="uggc://znvy.yvir.pbz/znvy/nobhg.nfck" gnetrg="_oynax">Yrnea zber##/N##</hy>',
    r'Bar Jvaqbjf Yvir VQ trgf lbh vagb <o>Ubgznvy</o>, <o>Zrffratre</o>, <o>Kobk YVIR</o> \u2014 naq bgure cynprf lbh frr #~#argjbexybtb#~#',
    r'${1}://${2}${3}${4}${5}',
    r' O=6gnyg0g4znrrn&o=3&f=gc; Q=_lyu=K3bQZGSxnT4lZzD3OS9GNmV3ZGLkAQxRpTyxNmRlZmRmAmNkAQLRqTImqNZjOUEgpTjQnJ5xMKtgoN--; SCF=qy',
    r'FrffvbaQQS2=4ss747o77904333q374or84qrr1s9r0nprp8r5q81534o94n; ZFPhygher=VC=74.125.75.20&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669321699093060&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=; AFP_zp_tfwsbrg-aowb_80=4413268q3660',
    r'FrffvbaQQS2=4ss747o77904333q374or84qrr1s9r0nprp8r5q81534o94n; AFP_zp_tfwsbrg-aowb_80=4413268q3660; __hgzm=144631658.1231364074.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.2294274870215848400.1231364074.1231364074.1231364074.1; __hgzo=144631658.0.10.1231364074; __hgzp=144631658; ZFPhygher=VC=74.125.75.20&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669321699093060&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231364057761&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231364057761&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Ssevraqf.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=1667363813.1231364061&tn_fvq=1231364061&tn_uvq=1917563877&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'ZFPhygher=VC=74.125.75.20&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669321699093060&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.20&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669321699093060&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'uggc://cebsvyr.zlfcnpr.pbz/Zbqhyrf/Nccyvpngvbaf/Cntrf/Pnainf.nfck',
    r'FrffvbaQQS2=473qq1rs0n2r70q9qo1pq48n021s9468ron90nps048p4p29; ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669325184628362&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'FrffvbaQQS2=473qq1rs0n2r70q9qo1pq48n021s9468ron90nps048p4p29; __hgzm=144631658.1231364380.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.3931862196947939300.1231364380.1231364380.1231364380.1; __hgzo=144631658.0.10.1231364380; __hgzp=144631658; ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669325184628362&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_vzntrf_wf&qg=1231364373088&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231364373088&punaary=svz_zlfcnpr_hfre-ivrj-pbzzragf%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Spbzzrag.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=1158737789.1231364375&tn_fvq=1231364375&tn_uvq=415520832&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669325184628362&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669325184628362&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'#Zbq-Vasb-Vasb-WninFpevcgUvag',
    r',n.svryqOgaPnapry',
    r'FrffvbaQQS2=p98s8o9q42nr21or1r61pqorn1n002nsss569635984s6qp7; ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669357391353591&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=; AFP_zp_kkk-gdzogv_80=4413241q3660',
    r'FrffvbaQQS2=p98s8o9q42nr21or1r61pqorn1n002nsss569635984s6qp7; AFP_zp_kkk-gdzogv_80=4413241q3660; AFP_zp_kkk-aowb_80=4413235p3660; __hgzm=144631658.1231367708.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.2770915348920628700.1231367708.1231367708.1231367708.1; __hgzo=144631658.0.10.1231367708; __hgzp=144631658; ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669357391353591&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231367691141&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231367691141&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Sjjj.zlfcnpr.pbz%2S&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=320757904.1231367694&tn_fvq=1231367694&tn_uvq=1758792003&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'uggc://zfacbegny.112.2b7.arg/o/ff/zfacbegnyubzr/1/U.7-cqi-2/f55332979829981?[NDO]&aqu=1&g=7%2S0%2S2009%2014%3N38%3N42%203%20480&af=zfacbegny&cntrAnzr=HF%20UCZFSGJ&t=uggc%3N%2S%2Sjjj.zfa.pbz%2S&f=1024k768&p=24&x=L&oj=994&ou=634&uc=A&{2}&[NDR]',
    r'cnerag puebzr6 fvatyr1 gno fryrpgrq ovaq qbhoyr2 ps',
    r'ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669357391353591&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.3&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669357391353591&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'ne;ng;nh;or;oe;pn;pu;py;pa;qr;qx;rf;sv;se;to;ux;vq;vr;va;vg;wc;xe;zk;zl;ay;ab;am;cu;cy;cg;eh;fr;ft;gu;ge;gj;mn;',
    r'ZP1=I=3&THVQ=6nnpr9q661804s33nnop45nosqp17q85; zu=ZFSG; PHYGHER=RA-HF; SyvtugTebhcVq=97; SyvtugVq=OnfrCntr; ucfie=Z:5|S:5|G:5|R:5|Q:oyh|J:S; ucpyv=J.U|Y.|F.|E.|H.Y|P.|U.; hfucjrn=jp:HFPN0746; ZHVQ=Q783SN9O14054831N4869R51P0SO8886&GHVQ=1',
    r'ZP1=I=3&THVQ=6nnpr9q661804s33nnop45nosqp17q85; zu=ZFSG; PHYGHER=RA-HF; SyvtugTebhcVq=97; SyvtugVq=OnfrCntr; ucfie=Z:5|S:5|G:5|R:5|Q:oyh|J:S; ucpyv=J.U|Y.|F.|E.|H.Y|P.|U.; hfucjrn=jp:HFPN0746; ZHVQ=Q783SN9O14054831N4869R51P0SO8886',
    r'ZP1=I=3&THVQ=6nnpr9q661804s33nnop45nosqp17q85; zu=ZFSG; PHYGHER=RA-HF; SyvtugTebhcVq=97; SyvtugVq=OnfrCntr; ucfie=Z:5|S:5|G:5|R:5|Q:oyh|J:S; ucpyv=J.U|Y.|F.|E.|H.Y|P.|U.; hfucjrn=jp:HFPN0746; ZHVQ=Q783SN9O14054831N4869R51P0SO8886; mvc=m:94043|yn:37.4154|yb:-122.0585|p:HF|ue:1',
    r'ZP1=I=3&THVQ=6nnpr9q661804s33nnop45nosqp17q85; zu=ZFSG; PHYGHER=RA-HF; SyvtugTebhcVq=97; SyvtugVq=OnfrCntr; ucfie=Z:5|S:5|G:5|R:5|Q:oyh|J:S; ucpyv=J.U|Y.|F.|E.|H.Y|P.|U.; hfucjrn=jp:HFPN0746; ZHVQ=Q783SN9O14054831N4869R51P0SO8886; mvc=m:94043|yn:37.4154|yb:-122.0585|p:HF',
    r'uggc://gx2.fgp.f-zfa.pbz/oe/uc/11/ra-hf/pff/v/g.tvs#uggc://gx2.fgo.f-zfa.pbz/v/29/4RQP4969777N048NPS4RRR3PO2S7S.wct',
    r'uggc://gx2.fgp.f-zfa.pbz/oe/uc/11/ra-hf/pff/v/g.tvs#uggc://gx2.fgo.f-zfa.pbz/v/OQ/63NP9O94NS5OQP1249Q9S1ROP7NS3.wct',
    r'zbmvyyn/5.0 (jvaqbjf; h; jvaqbjf ag 5.1; ra-hf) nccyrjroxvg/528.9 (xugzy, yvxr trpxb) puebzr/2.0.157.0 fnsnev/528.9',
    r'1231365729213',
    r'74.125.75.3-1057165600.29978900',
    r'74.125.75.3-1057165600.29978900.1231365730214',
    r'Frnepu%20Zvpebfbsg.pbz',
    r'FrffvbaQQS2=8sqq78r9n442851q565599o401385sp3s04r92rnn7o19ssn; ZFPhygher=VC=74.125.75.17&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669340386893867&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'FrffvbaQQS2=8sqq78r9n442851q565599o401385sp3s04r92rnn7o19ssn; __hgzm=144631658.1231365779.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.1877536177953918500.1231365779.1231365779.1231365779.1; __hgzo=144631658.0.10.1231365779; __hgzp=144631658; ZFPhygher=VC=74.125.75.17&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669340386893867&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'I=3%26THVQ=757q3ss871q44o7o805n8113n5p72q52',
    r'I=3&THVQ=757q3ss871q44o7o805n8113n5p72q52',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231365765292&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231365765292&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Sohyyrgvaf.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=1579793869.1231365768&tn_fvq=1231365768&tn_uvq=2056210897&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'frnepu.zvpebfbsg.pbz',
    r'frnepu.zvpebfbsg.pbz/',
    r'ZFPhygher=VC=74.125.75.17&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669340386893867&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.17&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669340386893867&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'#fubhgobk .pybfr',
    r'FrffvbaQQS2=102n9o0o9pq60132qn0337rr867p75953502q2s27s2s5r98; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669341278771470&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=; AFP_zp_dfctwzssrwh-aowb_80=441326q33660',
    r'FrffvbaQQS2=102n9o0o9pq60132qn0337rr867p75953502q2s27s2s5r98; AFP_zp_dfctwzssrwh-aowb_80=441326q33660; __hgzm=144631658.1231365869.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.1670816052019209000.1231365869.1231365869.1231365869.1; __hgzo=144631658.0.10.1231365869; __hgzp=144631658; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669341278771470&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'FrffvbaQQS2=9995p6rp12rrnr893334ro7nq70o7p64p69rqn844prs1473; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669350559478880&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=; AFP_zp_dfctwzs-aowb_80=441327q73660',
    r'FrffvbaQQS2=9995p6rp12rrnr893334ro7nq70o7p64p69rqn844prs1473; AFP_zp_dfctwzs-aowb_80=441327q73660; __hgzm=144631658.1231367054.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar); __hgzn=144631658.1796080716621419500.1231367054.1231367054.1231367054.1; __hgzo=144631658.0.10.1231367054; __hgzp=144631658; ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669350559478880&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'[glcr=fhozvg]',
    r'n.svryqOga,n.svryqOgaPnapry',
    r'n.svryqOgaPnapry',
    r'oyvpxchaxg',
    r'qvi.bow-nppbeqvba qg',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_nccf_wf&qg=1231367052227&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231367052227&punaary=svz_zlfcnpr_nccf-pnainf%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Scebsvyr.zlfcnpr.pbz%2SZbqhyrf%2SNccyvpngvbaf%2SCntrf%2SPnainf.nfck&nq_glcr=grkg&rvq=6083027&rn=0&sez=1&tn_ivq=716357910.1231367056&tn_fvq=1231367056&tn_uvq=1387206491&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'uggc://tbbtyrnqf.t.qbhoyrpyvpx.arg/cntrnq/nqf?pyvrag=pn-svz_zlfcnpr_zlfcnpr-ubzrcntr_wf&qg=1231365851658&uy=ra&nqfnsr=uvtu&br=hgs8&ahz_nqf=4&bhgchg=wf&nqgrfg=bss&pbeeryngbe=1231365851658&punaary=svz_zlfcnpr_ubzrcntr_abgybttrqva%2Psvz_zlfcnpr_aba_HTP%2Psvz_zlfcnpr_havgrq-fgngrf&hey=uggc%3N%2S%2Scebsvyrrqvg.zlfcnpr.pbz%2Svaqrk.psz&nq_glcr=grkg&rvq=6083027&rn=0&sez=0&tn_ivq=1979828129.1231365855&tn_fvq=1231365855&tn_uvq=2085229649&synfu=9.0.115&h_u=768&h_j=1024&h_nu=738&h_nj=1024&h_pq=24&h_gm=-480&h_uvf=2&h_wnin=gehr&h_acyht=7&h_azvzr=22',
    r'uggc://zfacbegny.112.2b7.arg/o/ff/zfacbegnyubzr/1/U.7-cqi-2/f55023338617756?[NDO]&aqu=1&g=7%2S0%2S2009%2014%3N12%3N47%203%20480&af=zfacbegny&cntrAnzr=HF%20UCZFSGJ&t=uggc%3N%2S%2Sjjj.zfa.pbz%2S&f=0k0&p=43835816&x=A&oj=994&ou=634&uc=A&{2}&[NDR]',
    r'zrgn[anzr=nwnkHey]',
    r'anpuevpugra',
    r'b oS={\'oT\':1.1};x $8n(B){z(B!=o9)};x $S(B){O(!$8n(B))z A;O(B.4L)z\'T\';b S=7t B;O(S==\'2P\'&&B.p4){23(B.7f){12 1:z\'T\';12 3:z/\S/.2g(B.8M)?\'ox\':\'oh\'}}O(S==\'2P\'||S==\'x\'){23(B.nE){12 2V:z\'1O\';12 7I:z\'5a\';12 18:z\'4B\'}O(7t B.I==\'4F\'){O(B.3u)z\'pG\';O(B.8e)z\'1p\'}}z S};x $2p(){b 4E={};Z(b v=0;v<1p.I;v++){Z(b X 1o 1p[v]){b nc=1p[v][X];b 6E=4E[X];O(6E&&$S(nc)==\'2P\'&&$S(6E)==\'2P\')4E[X]=$2p(6E,nc);17 4E[X]=nc}}z 4E};b $E=7p.E=x(){b 1d=1p;O(!1d[1])1d=[p,1d[0]];Z(b X 1o 1d[1])1d[0][X]=1d[1][X];z 1d[0]};b $4D=7p.pJ=x(){Z(b v=0,y=1p.I;v<y;v++){1p[v].E=x(1J){Z(b 1I 1o 1J){O(!p.1Y[1I])p.1Y[1I]=1J[1I];O(!p[1I])p[1I]=$4D.6C(1I)}}}};$4D.6C=x(1I){z x(L){z p.1Y[1I].3H(L,2V.1Y.nV.1F(1p,1))}};$4D(7F,2V,6J,nb);b 3l=x(B){B=B||{};B.E=$E;z B};b pK=Y 3l(H);b pZ=Y 3l(C);C.6f=C.35(\'6f\')[0];x $2O(B){z!!(B||B===0)};x $5S(B,n8){z $8n(B)?B:n8};x $7K(3c,1m){z 1q.na(1q.7K()*(1m-3c+1)+3c)};x $3N(){z Y 97().os()};x $4M(1U){pv(1U);pa(1U);z 1S};H.43=!!(C.5Z);O(H.nB)H.31=H[H.7q?\'py\':\'nL\']=1r;17 O(C.9N&&!C.om&&!oy.oZ)H.pF=H.4Z=H[H.43?\'pt\':\'65\']=1r;17 O(C.po!=1S)H.7J=1r;O(7t 5B==\'o9\'){b 5B=x(){};O(H.4Z)C.nd("pW");5B.1Y=(H.4Z)?H["[[oN.1Y]]"]:{}}5B.1Y.4L=1r;O(H.nL)5s{C.oX("pp",A,1r)}4K(r){};b 18=x(1X){b 63=x(){z(1p[0]!==1S&&p.1w&&$S(p.1w)==\'x\')?p.1w.3H(p,1p):p};$E(63,p);63.1Y=1X;63.nE=18;z 63};18.1z=x(){};18.1Y={E:x(1X){b 7x=Y p(1S);Z(b X 1o 1X){b nC=7x[X];7x[X]=18.nY(nC,1X[X])}z Y 18(7x)},3d:x(){Z(b v=0,y=1p.I;v<y;v++)$E(p.1Y,1p[v])}};18.nY=x(2b,2n){O(2b&&2b!=2n){b S=$S(2n);O(S!=$S(2b))z 2n;23(S){12\'x\':b 7R=x(){p.1e=1p.8e.1e;z 2n.3H(p,1p)};7R.1e=2b;z 7R;12\'2P\':z $2p(2b,2n)}}z 2n};b 8o=Y 18({oQ:x(J){p.4w=p.4w||[];p.4w.1x(J);z p},7g:x(){O(p.4w&&p.4w.I)p.4w.9J().2x(10,p)},oP:x(){p.4w=[]}});b 2d=Y 18({1V:x(S,J){O(J!=18.1z){p.$19=p.$19||{};p.$19[S]=p.$19[S]||[];p.$19[S].5j(J)}z p},1v:x(S,1d,2x){O(p.$19&&p.$19[S]){p.$19[S].1b(x(J){J.3n({\'L\':p,\'2x\':2x,\'1p\':1d})()},p)}z p},3M:x(S,J){O(p.$19&&p.$19[S])p.$19[S].2U(J);z p}});b 4v=Y 18({2H:x(){p.P=$2p.3H(1S,[p.P].E(1p));O(!p.1V)z p;Z(b 3O 1o p.P){O($S(p.P[3O]==\'x\')&&3O.2g(/^5P[N-M]/))p.1V(3O,p.P[3O])}z p}});2V.E({7y:x(J,L){Z(b v=0,w=p.I;v<w;v++)J.1F(L,p[v],v,p)},3s:x(J,L){b 54=[];Z(b v=0,w=p.I;v<w;v++){O(J.1F(L,p[v],v,p))54.1x(p[v])}z 54},2X:x(J,L){b 54=[];Z(b v=0,w=p.I;v<w;v++)54[v]=J.1F(L,p[v],v,p);z 54},4i:x(J,L){Z(b v=0,w=p.I;v<w;v++){O(!J.1F(L,p[v],v,p))z A}z 1r},ob:x(J,L){Z(b v=0,w=p.I;v<w;v++){O(J.1F(L,p[v],v,p))z 1r}z A},3F:x(3u,15){b 3A=p.I;Z(b v=(15<0)?1q.1m(0,3A+15):15||0;v<3A;v++){O(p[v]===3u)z v}z-1},8z:x(1u,I){1u=1u||0;O(1u<0)1u=p.I+1u;I=I||(p.I-1u);b 89=[];Z(b v=0;v<I;v++)89[v]=p[1u++];z 89},2U:x(3u){b v=0;b 3A=p.I;6L(v<3A){O(p[v]===3u){p.6l(v,1);3A--}17{v++}}z p},1y:x(3u,15){z p.3F(3u,15)!=-1},oz:x(1C){b B={},I=1q.3c(p.I,1C.I);Z(b v=0;v<I;v++)B[1C[v]]=p[v];z B},E:x(1O){Z(b v=0,w=1O.I;v<w;v++)p.1x(1O[v]);z p},2p:x(1O){Z(b v=0,y=1O.I;v<y;v++)p.5j(1O[v]);z p},5j:x(3u){O(!p.1y(3u))p.1x(3u);z p},oc:x(){z p[$7K(0,p.I-1)]||A},7L:x(){z p[p.I-1]||A}});2V.1Y.1b=2V.1Y.7y;2V.1Y.2g=2V.1Y.1y;x $N(1O){z 2V.8z(1O)};x $1b(3J,J,L){O(3J&&7t 3J.I==\'4F\'&&$S(3J)!=\'2P\')2V.7y(3J,J,L);17 Z(b 1j 1o 3J)J.1F(L||3J,3J[1j],1j)};6J.E({2g:x(6b,2F){z(($S(6b)==\'2R\')?Y 7I(6b,2F):6b).2g(p)},3p:x(){z 5K(p,10)},o4:x(){z 69(p)},7A:x(){z p.3y(/-\D/t,x(2G){z 2G.7G(1).nW()})},9b:x(){z p.3y(/\w[N-M]/t,x(2G){z(2G.7G(0)+\'-\'+2G.7G(1).5O())})},8V:x(){z p.3y(/\b[n-m]/t,x(2G){z 2G.nW()})},5L:x(){z p.3y(/^\s+|\s+$/t,\'\')},7j:x(){z p.3y(/\s{2,}/t,\' \').5L()},5V:x(1O){b 1i=p.2G(/\d{1,3}/t);z(1i)?1i.5V(1O):A},5U:x(1O){b 3P=p.2G(/^#?(\w{1,2})(\w{1,2})(\w{1,2})$/);z(3P)?3P.nV(1).5U(1O):A},1y:x(2R,f){z(f)?(f+p+f).3F(f+2R+f)>-1:p.3F(2R)>-1},nX:x(){z p.3y(/([.*+?^${}()|[\]\/\\])/t,\'\\$1\')}});2V.E({5V:x(1O){O(p.I<3)z A;O(p.I==4&&p[3]==0&&!1O)z\'p5\';b 3P=[];Z(b v=0;v<3;v++){b 52=(p[v]-0).4h(16);3P.1x((52.I==1)?\'0\'+52:52)}z 1O?3P:\'#\'+3P.2u(\'\')},5U:x(1O){O(p.I!=3)z A;b 1i=[];Z(b v=0;v<3;v++){1i.1x(5K((p[v].I==1)?p[v]+p[v]:p[v],16))}z 1O?1i:\'1i(\'+1i.2u(\',\')+\')\'}});7F.E({3n:x(P){b J=p;P=$2p({\'L\':J,\'V\':A,\'1p\':1S,\'2x\':A,\'4s\':A,\'6W\':A},P);O($2O(P.1p)&&$S(P.1p)!=\'1O\')P.1p=[P.1p];z x(V){b 1d;O(P.V){V=V||H.V;1d=[(P.V===1r)?V:Y P.V(V)];O(P.1p)1d.E(P.1p)}17 1d=P.1p||1p;b 3C=x(){z J.3H($5S(P',
    r'hagreunyghat',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669341278771470&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&Pbhagel=IIZ%3Q&SbeprqRkcvengvba=633669350559478880&gvzrMbar=-8&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R%3Q',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669341278771470&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'ZFPhygher=VC=74.125.75.1&VCPhygher=ra-HF&CersreerqPhygher=ra-HF&CersreerqPhygherCraqvat=&Pbhagel=IIZ=&SbeprqRkcvengvba=633669350559478880&gvzrMbar=0&HFEYBP=DKWyLHAiMTH9AwHjWxAcqUx9GJ91oaEunJ4tIzyyqlMQo3IhqUW5D29xMG1IHlMQo3IhqUW5GzSgMG1Iozy0MJDtH3EuqTImWxEgLHAiMTH9BQN3WxkuqTy0qJEyCGZ3YwDkBGVzGT9hM2y0qJEyCF0kZwVhZQH3APMDo3A0LJkQo2EyCGx0ZQDmWyWyM2yiox5uoJH9D0R=',
    r'shapgvba (){Cuk.Nccyvpngvba.Frghc.Pber();Cuk.Nccyvpngvba.Frghc.Nwnk();Cuk.Nccyvpngvba.Frghc.Synfu();Cuk.Nccyvpngvba.Frghc.Zbqhyrf()}']

# The 12 benchmarking blocks


def block0():
    for i in range(6511):
        regexs[0].search(r'pyvpx')

    for i in range(1844):
        regexs[1].search(r'uggc://jjj.snprobbx.pbz/ybtva.cuc')

    for i in range(739):
        regexs[2].sub(r'', 'QBZPbageby_cynprubyqre', subcount[2])

    for i in range(598):
        regexs[1].search(r'uggc://jjj.snprobbx.pbz/')

    for i in range(454):
        regexs[1].search(r'uggc://jjj.snprobbx.pbz/fepu.cuc')

    for i in range(352):
        re.search(
            r'qqqq|qqq|qq|q|ZZZZ|ZZZ|ZZ|Z|llll|ll|l|uu|u|UU|U|zz|z|ff|f|gg|g|sss|ss|s|mmm|mm|m', 'qqqq, ZZZ q, llll')

    for i in range(312):
        regexs[3].search(r'vachggrkg QBZPbageby_cynprubyqre')

    for i in range(282):
        regexs[4].search(r'/ZlFcnprUbzrcntr/Vaqrk-FvgrUbzr,10000000')

    for i in range(177):
        regexs[5].sub(r'', 'vachggrkg', subcount[5])

    for i in range(170):
        regexs[6].sub(r'', '528.9', subcount[6])
        regexs[7].search(r'528')

    for i in range(156):
        regexs[8].search(r'VCPhygher=ra-HF')
        regexs[8].search(r'CersreerqPhygher=ra-HF')

    for i in range(144):
        regexs[0].search(r'xrlcerff')

    for i in range(139):
        regexs[6].sub(r'', '521', subcount[6])

        # This has a different output to the V8 version.
        # It could just be a difference in the engines.
        regexs[7].search(r'521')
        regexs[9].search(r'')
        re.search(r'JroXvg\/(\S+)', strings[0])

    for i in range(137):
        regexs[10].sub(r'', 'qvi .so_zrah', subcount[10])
        re.sub(r'\[', '', 'qvi .so_zrah', 0)
        regexs[11].sub(r'', 'qvi.so_zrah', subcount[11])

    for i in range(117):
        regexs[2].sub(r'', 'uvqqra_ryrz', subcount[2])

    for i in range(95):
        re.search(r'(?:^|;)\s*sevraqfgre_ynat=([^;]*)',
                  'sevraqfgre_naba=nvq%3Qn6ss9p85n868ro9s059pn854735956o3%26ers%3Q%26df%3Q%26vpgl%3QHF')

    for i in range(93):
        regexs[12].sub(r'', 'uggc://ubzr.zlfcnpr.pbz/vaqrk.psz', subcount[12])
        regexs[13].search(r'uggc://ubzr.zlfcnpr.pbz/vaqrk.psz')

    for i in range(92):
        re.sub(r'([a-zA-Z]|\s)+', '', strings[1], 1)

    for i in range(85):
        regexs[14].sub(r'', 'svefg', subcount[14])
        regexs[15].sub(r'', 'svefg', subcount[15])
        regexs[12].sub(
            r'', 'uggc://cebsvyr.zlfcnpr.pbz/vaqrk.psz', subcount[12])
        regexs[14].sub(r'', 'ynfg', subcount[14])
        regexs[15].sub(r'', 'ynfg', subcount[15])
        regexs[16].search(r'qvfcynl')
        regexs[13].search(r'uggc://cebsvyr.zlfcnpr.pbz/vaqrk.psz')


def block1():
    for i in range(81):
        regexs[8].search(r'VC=74.125.75.1')

    for i in range(78):
        re.sub(r'(\s)+e', '', '9.0  e115', 1)
        re.sub(r'.', '', 'k', 1)

        # This prints a unicode escape where the V8 version prints the
        # unicode character.
        regexs[17].sub(r'', strings[2], subcount[17])

        # This prints a unicode escape where the V8 version prints the
        # unicode character.
        regexs[17].sub(r'', strings[3], subcount[17])

        regexs[8].search(r'144631658')
        regexs[8].search(r'Pbhagel=IIZ%3Q')
        regexs[8].search(r'Pbhagel=IIZ=')
        regexs[8].search(r'CersreerqPhygherCraqvat=')
        regexs[8].search(strings[4])
        regexs[8].search(strings[5])
        regexs[8].search(r'__hgzp=144631658')
        regexs[8].search(r'gvzrMbar=-8')
        regexs[8].search(r'gvzrMbar=0')
        re.search(r'Fnsnev\/(\d+\.\d+)', strings[0])
        regexs[3].search(r'vachggrkg  QBZPbageby_cynprubyqre')
        regexs[0].search(r'xrlqbja')
        regexs[0].search(r'xrlhc')

    for i in range(77):
        regexs[12].sub(
            r'', 'uggc://zrffntvat.zlfcnpr.pbz/vaqrk.psz', subcount[12])
        regexs[13].search(r'uggc://zrffntvat.zlfcnpr.pbz/vaqrk.psz')

    for i in range(73):
        regexs[18].sub(
            r'', 'FrffvbaFgbentr=%7O%22GnoThvq%22%3N%7O%22thvq%22%3N1231367125017%7Q%7Q', subcount[18])

    for i in range(72):
        regexs[1].search(strings[6])

    for i in range(71):
        regexs[19].search(r'')

    for i in range(70):
        regexs[11].sub(r'', '3.5.0.0', subcount[11])
        re.sub(r'd1', '', strings[7], 0)
        re.sub(r'NQ_VQ', '', strings[8], 0)
        re.sub(r'd2', '', strings[9], 0)
        re.sub(
            r'_', '', 'NI%3Q1_CI%3Q1_PI%3Q1_EI%3Q1_HI%3Q1_HP%3Q1_IC%3Q0.0.0.0_IH%3Q0', 0)
        regexs[20].split(
            r'svz_zlfcnpr_ubzrcntr_abgybttrqva,svz_zlfcnpr_aba_HTP,svz_zlfcnpr_havgrq-fgngrf')
        regexs[21].search(r'ybnqvat')

    for i in range(68):
        regexs[1].search(r'#')
        re.search(
            r'(?:ZFVR.(\d+\.\d+))|(?:(?:Sversbk|TenaCnenqvfb|Vprjrnfry).(\d+\.\d+))|(?:Bcren.(\d+\.\d+))|(?:NccyrJroXvg.(\d+(?:\.\d+)?))', strings[0])
        re.search(r'(Znp BF K)|(Jvaqbjf;)', strings[0])
        re.search(r'Trpxb\/([0-9]+)', strings[0])
        regexs[21].search(r'ybnqrq')

    for i in range(49):
        regexs[16].search(r'pbybe')

    for i in range(44):
        regexs[12].sub(
            r'', 'uggc://sevraqf.zlfcnpr.pbz/vaqrk.psz', subcount[12])
        regexs[13].search(r'uggc://sevraqf.zlfcnpr.pbz/vaqrk.psz')


def block2():
    for i in range(40):
        regexs[14].sub(r'', 'fryrpgrq', subcount[14])
        regexs[15].sub(r'', 'fryrpgrq', subcount[15])

    for i in range(39):
        re.sub(r'\buvqqra_ryrz\b', '', 'vachggrkg uvqqra_ryrz', 0)
        regexs[3].search(r'vachggrkg ')
        regexs[3].search(r'vachggrkg')
        regexs[22].search(r'HVYvaxOhggba')
        regexs[22].search(r'HVYvaxOhggba_E')
        regexs[22].search(r'HVYvaxOhggba_EJ')
        regexs[22].search(r'zrah_ybtva_pbagnvare')
        re.search(r'\buvqqra_ryrz\b', 'vachgcnffjbeq')

    for i in range(37):
        regexs[8].search(r'111soqs57qo8o8480qo18sor2011r3n591q7s6s37r120904')
        regexs[8].search(r'SbeprqRkcvengvba=633669315660164980')
        regexs[8].search(
            r'FrffvbaQQS2=111soqs57qo8o8480qo18sor2011r3n591q7s6s37r120904')

    for i in range(35):
        regexs[14].sub(r'', 'puvyq p1 svefg', subcount[14])
        regexs[15].sub(r'', 'puvyq p1 svefg', subcount[15])
        regexs[14].sub(r'', 'sylbhg pybfrq', subcount[14])
        regexs[15].sub(r'', 'sylbhg pybfrq', subcount[15])

    for i in range(34):
        regexs[19].search(r'gno2')
        regexs[19].search(r'gno3')
        regexs[8].search(r'44132r503660')
        regexs[8].search(r'SbeprqRkcvengvba=633669316860113296')
        regexs[8].search(r'AFP_zp_dfctwzs-aowb_80=44132r503660')
        regexs[8].search(
            r'FrffvbaQQS2=s6r4579npn4rn2135s904r0s75pp1o5334p6s6pospo12696')
        regexs[8].search(r's6r4579npn4rn2135s904r0s75pp1o5334p6s6pospo12696')

    for i in range(32):
        re.search(r'puebzr', strings[0], re.IGNORECASE)

    for i in range(31):
        regexs[23].sub(r'', 'uggc://jjj.snprobbx.pbz/', subcount[23])
        regexs[8].search(r'SbeprqRkcvengvba=633669358527244818')
        regexs[8].search(r'VC=66.249.85.130')
        regexs[8].search(
            r'FrffvbaQQS2=s15q53p9n372sn76npr13o271n4s3p5r29p235746p908p58')
        regexs[8].search(r's15q53p9n372sn76npr13o271n4s3p5r29p235746p908p58')
        regexs[24].search(r'uggc://jjj.snprobbx.pbz/')

    for i in range(30):
        regexs[6].sub(r'', '419', subcount[6])
        re.search(r'(?:^|\s+)gvzrfgnzc(?:\s+|$)', 'gvzrfgnzc')
        regexs[7].search(r'419')

    for i in range(29):
        regexs[23].sub(r'', 'uggc://jjj.snprobbx.pbz/ybtva.cuc', subcount[23])

    for i in range(28):
        regexs[25].sub(r'', 'Funer guvf tnqtrg', subcount[25])
        regexs[12].sub(r'', 'Funer guvf tnqtrg', subcount[12])
        regexs[26].search(r'uggc://jjj.tbbtyr.pbz/vt/qverpgbel')


def block3():
    for i in range(27):
        re.sub(r'[A-Za-z]', '', 'e115', 0)

    for i in range(23):
        regexs[27].sub(r'', 'qvfcynl', subcount[27])
        regexs[27].sub(r'', 'cbfvgvba', subcount[27])

    for i in range(22):
        regexs[14].sub(r'', 'unaqyr', subcount[14])
        regexs[15].sub(r'', 'unaqyr', subcount[15])
        regexs[14].sub(r'', 'yvar', subcount[14])
        regexs[15].sub(r'', 'yvar', subcount[15])
        regexs[14].sub(r'', 'cnerag puebzr6 fvatyr1 gno', subcount[14])
        regexs[15].sub(r'', 'cnerag puebzr6 fvatyr1 gno', subcount[15])
        regexs[14].sub(r'', 'fyvqre', subcount[14])
        regexs[15].sub(r'', 'fyvqre', subcount[15])
        regexs[28].search(r'')

    for i in range(21):
        regexs[12].sub(r'', 'uggc://jjj.zlfcnpr.pbz/', subcount[12])
        regexs[13].search(r'uggc://jjj.zlfcnpr.pbz/')

    for i in range(20):
        regexs[29].sub(r'', 'cntrivrj', subcount[29])
        regexs[30].sub(r'', 'cntrivrj', subcount[30])
        regexs[19].search(r'ynfg')
        regexs[19].search(r'ba svefg')
        regexs[8].search(r'VC=74.125.75.3')

    for i in range(19):
        regexs[31].search(r'ra')

    for i in range(18):
        regexs[32].split(strings[10])
        regexs[32].split(strings[11])
        regexs[33].sub(r'', strings[12], subcount[33])
        regexs[8].search(r'144631658.0.10.1231363570')
        regexs[8].search(
            r'144631658.1231363570.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.3426875219718084000.1231363570.1231363570.1231363570.1')
        regexs[8].search(strings[13])
        regexs[8].search(strings[14])
        regexs[8].search(
            r'__hgzn=144631658.3426875219718084000.1231363570.1231363570.1231363570.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231363570')
        regexs[8].search(
            r'__hgzm=144631658.1231363570.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[34].search(strings[10])
        regexs[34].search(strings[11])

    for i in range(17):
        re.match(r'zfvr', strings[0], re.IGNORECASE)
        re.match(r'bcren', strings[0], re.IGNORECASE)
        regexs[32].split(strings[15])
        regexs[32].split(strings[16])
        regexs[14].sub(r'', 'ohggba', subcount[14])
        regexs[15].sub(r'', 'ohggba', subcount[15])
        regexs[14].sub(r'', 'puvyq p1 svefg sylbhg pybfrq', subcount[14])
        regexs[15].sub(r'', 'puvyq p1 svefg sylbhg pybfrq', subcount[15])
        regexs[14].sub(r'', 'pvgvrf', subcount[14])
        regexs[15].sub(r'', 'pvgvrf', subcount[15])
        regexs[14].sub(r'', 'pybfrq', subcount[14])
        regexs[15].sub(r'', 'pybfrq', subcount[15])
        regexs[14].sub(r'', 'qry', subcount[14])
        regexs[15].sub(r'', 'qry', subcount[15])
        regexs[14].sub(r'', 'uqy_zba', subcount[14])
        regexs[15].sub(r'', 'uqy_zba', subcount[15])
        regexs[33].sub(r'', strings[17], subcount[33])
        re.sub(r'%3P', '', strings[18], 0)
        re.sub(r'%3R', '', strings[18], 0)
        re.sub(r'%3q', '', strings[18], 0)
        regexs[35].sub(r'', strings[18], subcount[35])
        regexs[14].sub(r'', 'yvaxyvfg16', subcount[14])
        regexs[15].sub(r'', 'yvaxyvfg16', subcount[15])
        regexs[14].sub(r'', 'zvahf', subcount[14])
        regexs[15].sub(r'', 'zvahf', subcount[15])
        regexs[14].sub(r'', 'bcra', subcount[14])
        regexs[15].sub(r'', 'bcra', subcount[15])
        regexs[14].sub(r'', 'cnerag puebzr5 fvatyr1 ps NU', subcount[14])
        regexs[15].sub(r'', 'cnerag puebzr5 fvatyr1 ps NU', subcount[15])
        regexs[14].sub(r'', 'cynlre', subcount[14])
        regexs[15].sub(r'', 'cynlre', subcount[15])
        regexs[14].sub(r'', 'cyhf', subcount[14])
        regexs[15].sub(r'', 'cyhf', subcount[15])
        regexs[14].sub(r'', 'cb_uqy', subcount[14])
        regexs[15].sub(r'', 'cb_uqy', subcount[15])
        regexs[14].sub(r'', 'hyJVzt', subcount[14])
        regexs[15].sub(r'', 'hyJVzt', subcount[15])
        regexs[8].search(r'144631658.0.10.1231363638')
        regexs[8].search(
            r'144631658.1231363638.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.965867047679498800.1231363638.1231363638.1231363638.1')
        regexs[8].search(r'4413268q3660')
        regexs[8].search(r'4ss747o77904333q374or84qrr1s9r0nprp8r5q81534o94n')
        regexs[8].search(r'SbeprqRkcvengvba=633669321699093060')
        regexs[8].search(r'VC=74.125.75.20')
        regexs[8].search(strings[19])
        regexs[8].search(strings[20])
        regexs[8].search(r'AFP_zp_tfwsbrg-aowb_80=4413268q3660')
        regexs[8].search(
            r'FrffvbaQQS2=4ss747o77904333q374or84qrr1s9r0nprp8r5q81534o94n')
        regexs[8].search(
            r'__hgzn=144631658.965867047679498800.1231363638.1231363638.1231363638.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231363638')
        regexs[8].search(
            r'__hgzm=144631658.1231363638.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[34].search(strings[15])
        regexs[34].search(strings[16])


def block4():
    for i in range(16):
        re.sub(r'\*', '', '', 0)
        re.search(r'\bnpgvir\b', 'npgvir')
        re.search(r'sversbk', strings[0], re.IGNORECASE)
        regexs[36].search(r'glcr')
        re.search(r'zfvr', strings[0], re.IGNORECASE)
        re.search(r'bcren', strings[0], re.IGNORECASE)

    for i in range(15):
        regexs[32].split(strings[21])
        regexs[32].split(strings[22])
        regexs[12].sub(
            r'', 'uggc://ohyyrgvaf.zlfcnpr.pbz/vaqrk.psz', subcount[12])
        regexs[33].sub(r'', strings[23], subcount[33])
        regexs[37].sub(r'', 'yv', subcount[37])
        regexs[18].sub(r'', 'yv', subcount[18])
        regexs[8].search(r'144631658.0.10.1231367822')
        regexs[8].search(
            r'144631658.1231367822.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.4127520630321984500.1231367822.1231367822.1231367822.1')
        regexs[8].search(strings[24])
        regexs[8].search(strings[25])
        regexs[8].search(
            r'__hgzn=144631658.4127520630321984500.1231367822.1231367822.1231367822.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231367822')
        regexs[8].search(
            r'__hgzm=144631658.1231367822.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[34].search(strings[21])
        regexs[34].search(strings[22])

        # FIXME
        # The \{0,65534} should be a *
        # There's a current python bug that will stop the regex compilation
        # when a * appears there http://bugs.python.org/issue6156.
        re.search(
            r'\.([\w-]+)|\[(\w+)(?:([!*^$~|]?=)["\']?(.*?)["\']?)?\]|:([\w-]+)(?:\(["\']?(.\{0,65534}?)?["\']?\)|$)', strings[26])

        regexs[13].search(r'uggc://ohyyrgvaf.zlfcnpr.pbz/vaqrk.psz')
        regexs[38].search(r'yv')

    for i in range(14):
        regexs[18].sub(r'', '', subcount[18])
        re.sub(r'(\s+e|\s+o[0-9]+)', '', '9.0  e115', 1)
        re.sub(r'<', '', 'Funer guvf tnqtrg', 0)
        re.sub(r'>', '', 'Funer guvf tnqtrg', 0)
        regexs[39].sub(r'', 'Funer guvf tnqtrg', subcount[39])
        regexs[12].sub(
            r'', 'uggc://cebsvyrrqvg.zlfcnpr.pbz/vaqrk.psz', subcount[12])
        regexs[40].sub(r'', 'grnfre', subcount[40])
        regexs[41].sub(r'', 'grnfre', subcount[41])
        regexs[42].sub(r'', 'grnfre', subcount[42])
        regexs[43].sub(r'', 'grnfre', subcount[43])
        regexs[44].sub(r'', 'grnfre', subcount[44])
        regexs[45].sub(r'', 'grnfre', subcount[45])
        regexs[46].sub(r'', 'grnfre', subcount[46])
        regexs[47].sub(r'', 'grnfre', subcount[47])
        regexs[48].sub(r'', 'grnfre', subcount[48])
        regexs[16].search(r'znetva-gbc')
        regexs[16].search(r'cbfvgvba')
        regexs[19].search(r'gno1')
        regexs[9].search(r'qz')
        regexs[9].search(r'qg')
        regexs[9].search(r'zbqobk')
        regexs[9].search(r'zbqobkva')
        regexs[9].search(r'zbqgvgyr')
        regexs[13].search(r'uggc://cebsvyrrqvg.zlfcnpr.pbz/vaqrk.psz')
        regexs[26].search(r'/vt/znvytnqtrg')
        regexs[49].search(r'glcr')


def block5():
    for i in range(13):
        regexs[14].sub(r'', 'purpx', subcount[14])
        regexs[15].sub(r'', 'purpx', subcount[15])
        regexs[14].sub(r'', 'pvgl', subcount[14])
        regexs[15].sub(r'', 'pvgl', subcount[15])
        regexs[14].sub(r'', 'qrpe fyvqrgrkg', subcount[14])
        regexs[15].sub(r'', 'qrpe fyvqrgrkg', subcount[15])
        regexs[14].sub(r'', 'svefg fryrpgrq', subcount[14])
        regexs[15].sub(r'', 'svefg fryrpgrq', subcount[15])
        regexs[14].sub(r'', 'uqy_rag', subcount[14])
        regexs[15].sub(r'', 'uqy_rag', subcount[15])
        regexs[14].sub(r'', 'vape fyvqrgrkg', subcount[14])
        regexs[15].sub(r'', 'vape fyvqrgrkg', subcount[15])
        regexs[5].sub(r'', 'vachggrkg QBZPbageby_cynprubyqre', subcount[5])
        regexs[14].sub(
            r'', 'cnerag puebzr6 fvatyr1 gno fryrpgrq', subcount[14])
        regexs[15].sub(
            r'', 'cnerag puebzr6 fvatyr1 gno fryrpgrq', subcount[15])
        regexs[14].sub(r'', 'cb_guz', subcount[14])
        regexs[15].sub(r'', 'cb_guz', subcount[15])
        regexs[14].sub(r'', 'fhozvg', subcount[14])
        regexs[15].sub(r'', 'fhozvg', subcount[15])
        regexs[50].search(r'')
        re.search(r'NccyrJroXvg\/([^\s]*)', strings[0])
        re.search(r'XUGZY', strings[0])

    for i in range(12):
        re.sub(r'(\$\{cebg\})|(\$cebg\b)', '',
               '${cebg}://${ubfg}${cngu}/${dz}', 0)
        regexs[40].sub(r'', '1', subcount[40])
        regexs[10].sub(r'', '1', subcount[10])
        regexs[51].sub(r'', '1', subcount[51])
        regexs[52].sub(r'', '1', subcount[52])
        regexs[53].sub(r'', '1', subcount[53])
        regexs[39].sub(r'', '1', subcount[39])
        regexs[54].sub(r'', '1', subcount[54])
        re.sub(r'^(.*)\..*$', '', '9.0  e115', 1)
        re.sub(r'^.*e(.*)$', '', '9.0  e115', 1)
        regexs[55].sub(r'', '<!-- ${nqiHey} -->', subcount[55])
        regexs[55].sub(
            r'', '<fpevcg glcr="grkg/wninfpevcg" fep="${nqiHey}"></fpevcg>', subcount[55])
        re.sub(r'^.*\s+(\S+\s+\S+$)', '', strings[1], 1)
        regexs[30].sub(r'', 'tzk%2Subzrcntr%2Sfgneg%2Sqr%2S', subcount[30])
        regexs[30].sub(r'', 'tzk', subcount[30])
        re.sub(r'(\$\{ubfg\})|(\$ubfg\b)', '',
               'uggc://${ubfg}${cngu}/${dz}', 0)
        regexs[56].sub(
            r'', 'uggc://nqpyvrag.hvzfrei.arg${cngu}/${dz}', subcount[56])
        re.sub(r'(\$\{dz\})|(\$dz\b)', '',
               'uggc://nqpyvrag.hvzfrei.arg/wf.at/${dz}', 0)
        regexs[29].sub(r'', 'frpgvba', subcount[29])
        regexs[30].sub(r'', 'frpgvba', subcount[30])
        regexs[29].sub(r'', 'fvgr', subcount[29])
        regexs[30].sub(r'', 'fvgr', subcount[30])
        regexs[29].sub(r'', 'fcrpvny', subcount[29])
        regexs[30].sub(r'', 'fcrpvny', subcount[30])
        regexs[36].search(r'anzr')
        re.search(r'e', '9.0  e115')


def block6():
    for i in range(11):
        re.sub(r'(?i)##yv0##', '', strings[27], 0)
        regexs[57].sub(r'', strings[27], subcount[57])
        regexs[58].sub(r'', strings[28], subcount[58])
        regexs[59].sub(r'', strings[29], subcount[59])
        re.sub(r'(?i)##\/o##', '', strings[30], 0)
        re.sub(r'(?i)##\/v##', '', strings[30], 0)
        re.sub(r'(?i)##\/h##', '', strings[30], 0)
        re.sub(r'(?i)##o##', '', strings[30], 0)
        re.sub(r'(?i)##oe##', '', strings[30], 0)
        re.sub(r'(?i)##v##', '', strings[30], 0)
        re.sub(r'(?i)##h##', '', strings[30], 0)
        re.sub(r'(?i)##n##', '', strings[31], 0)
        re.sub(r'(?i)##\/n##', '', strings[32], 0)

        # This prints a unicode escape where the V8 version
        # prints the unicode character.
        re.sub(r'#~#argjbexybtb#~#', '', strings[33], 0)

        re.search(r' Zbovyr\/', strings[0])
        re.search(r'##yv1##', strings[27], re.IGNORECASE)
        re.search(r'##yv10##', strings[28], re.IGNORECASE)
        re.search(r'##yv11##', strings[28], re.IGNORECASE)
        re.search(r'##yv12##', strings[28], re.IGNORECASE)
        re.search(r'##yv13##', strings[28], re.IGNORECASE)
        re.search(r'##yv14##', strings[28], re.IGNORECASE)
        re.search(r'##yv15##', strings[28], re.IGNORECASE)
        regexs[58].search(strings[28])
        re.search(r'##yv17##', strings[29], re.IGNORECASE)
        re.search(r'##yv18##', strings[29], re.IGNORECASE)
        regexs[59].search(strings[29])
        re.search(r'##yv2##', strings[27], re.IGNORECASE)
        re.search(r'##yv20##', strings[30], re.IGNORECASE)
        re.search(r'##yv21##', strings[30], re.IGNORECASE)
        re.search(r'##yv22##', strings[30], re.IGNORECASE)
        re.search(r'##yv23##', strings[30], re.IGNORECASE)
        re.search(r'##yv3##', strings[27], re.IGNORECASE)
        regexs[57].search(strings[27])
        re.search(r'##yv5##', strings[28], re.IGNORECASE)
        re.search(r'##yv6##', strings[28], re.IGNORECASE)
        re.search(r'##yv7##', strings[28], re.IGNORECASE)
        re.search(r'##yv8##', strings[28], re.IGNORECASE)
        re.search(r'##yv9##', strings[28], re.IGNORECASE)
        regexs[8].search(r'473qq1rs0n2r70q9qo1pq48n021s9468ron90nps048p4p29')
        regexs[8].search(r'SbeprqRkcvengvba=633669325184628362')
        regexs[8].search(
            r'FrffvbaQQS2=473qq1rs0n2r70q9qo1pq48n021s9468ron90nps048p4p29')
        re.search(r'AbxvnA[^\/]*', strings[0])

    for i in range(10):
        re.sub(r'(?:^|\s+)bss(?:\s+|$)', '', ' bss', 0)
        re.sub(r'(\$\{0\})|(\$0\b)', '', strings[34], 0)
        re.sub(r'(\$\{1\})|(\$1\b)', '', strings[34], 0)
        re.sub(r'(\$\{pbzcyrgr\})|(\$pbzcyrgr\b)', '', strings[34], 0)
        re.sub(r'(\$\{sentzrag\})|(\$sentzrag\b)', '', strings[34], 0)
        re.sub(r'(\$\{ubfgcbeg\})|(\$ubfgcbeg\b)', '', strings[34], 0)
        regexs[56].sub(r'', strings[34], subcount[56])
        re.sub(r'(\$\{cebgbpby\})|(\$cebgbpby\b)', '', strings[34], 0)
        re.sub(r'(\$\{dhrel\})|(\$dhrel\b)', '', strings[34], 0)
        regexs[29].sub(r'', 'nqfvmr', subcount[29])
        regexs[30].sub(r'', 'nqfvmr', subcount[30])
        re.sub(r'(\$\{2\})|(\$2\b)', '', 'uggc://${2}${3}${4}${5}', 0)
        re.sub(r'(\$\{3\})|(\$3\b)', '',
               'uggc://wf.hv-cbegny.qr${3}${4}${5}', 0)
        regexs[40].sub(r'', 'arjf', subcount[40])
        regexs[41].sub(r'', 'arjf', subcount[41])
        regexs[42].sub(r'', 'arjf', subcount[42])
        regexs[43].sub(r'', 'arjf', subcount[43])
        regexs[44].sub(r'', 'arjf', subcount[44])
        regexs[45].sub(r'', 'arjf', subcount[45])
        regexs[46].sub(r'', 'arjf', subcount[46])
        regexs[47].sub(r'', 'arjf', subcount[47])
        regexs[48].sub(r'', 'arjf', subcount[48])
        re.search(r' PC=i=(\d+)&oe=(.)', strings[35])
        regexs[60].search(r' ')
        regexs[60].search(r' bss')
        regexs[60].search(r'')
        regexs[19].search(r' ')
        regexs[19].search(r'svefg ba')
        regexs[19].search(r'ynfg vtaber')
        regexs[19].search(r'ba')
        regexs[9].search(r'scnq so ')
        regexs[9].search(r'zrqvgobk')
        regexs[9].search(r'hsgy')
        regexs[9].search(r'lhv-h')
        re.search(r'Fnsnev|Xbadhrebe|XUGZY', strings[0], re.IGNORECASE)
        regexs[61].search(
            r'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/onfr.wf')
        regexs[62].search(r'#Ybtva_rznvy')


def block7():
    for i in range(9):
        regexs[40].sub(r'', '0', subcount[40])
        regexs[10].sub(r'', '0', subcount[10])
        regexs[51].sub(r'', '0', subcount[51])
        regexs[52].sub(r'', '0', subcount[52])
        regexs[53].sub(r'', '0', subcount[53])
        regexs[39].sub(r'', '0', subcount[39])
        regexs[54].sub(r'', '0', subcount[54])
        regexs[40].sub(r'', 'Lrf', subcount[40])
        regexs[10].sub(r'', 'Lrf', subcount[10])
        regexs[51].sub(r'', 'Lrf', subcount[51])
        regexs[52].sub(r'', 'Lrf', subcount[52])
        regexs[53].sub(r'', 'Lrf', subcount[53])
        regexs[39].sub(r'', 'Lrf', subcount[39])
        regexs[54].sub(r'', 'Lrf', subcount[54])

    for i in range(8):
        regexs[63].sub(r'', 'Pybfr {0}', subcount[63])
        regexs[63].sub(r'', 'Bcra {0}', subcount[63])
        regexs[32].split(strings[36])
        regexs[32].split(strings[37])
        regexs[14].sub(r'', 'puvyq p1 svefg gnournqref', subcount[14])
        regexs[15].sub(r'', 'puvyq p1 svefg gnournqref', subcount[15])
        regexs[14].sub(r'', 'uqy_fcb', subcount[14])
        regexs[15].sub(r'', 'uqy_fcb', subcount[15])
        regexs[14].sub(r'', 'uvag', subcount[14])
        regexs[15].sub(r'', 'uvag', subcount[15])
        regexs[33].sub(r'', strings[38], subcount[33])
        regexs[14].sub(r'', 'yvfg', subcount[14])
        regexs[15].sub(r'', 'yvfg', subcount[15])
        regexs[30].sub(r'', 'at_bhgre', subcount[30])
        regexs[14].sub(r'', 'cnerag puebzr5 qbhoyr2 NU', subcount[14])
        regexs[15].sub(r'', 'cnerag puebzr5 qbhoyr2 NU', subcount[15])
        regexs[14].sub(
            r'', 'cnerag puebzr5 dhnq5 ps NU osyvax zbarl', subcount[14])
        regexs[15].sub(
            r'', 'cnerag puebzr5 dhnq5 ps NU osyvax zbarl', subcount[15])
        regexs[14].sub(r'', 'cnerag puebzr6 fvatyr1', subcount[14])
        regexs[15].sub(r'', 'cnerag puebzr6 fvatyr1', subcount[15])
        regexs[14].sub(r'', 'cb_qrs', subcount[14])
        regexs[15].sub(r'', 'cb_qrs', subcount[15])
        regexs[14].sub(r'', 'gnopbagrag', subcount[14])
        regexs[15].sub(r'', 'gnopbagrag', subcount[15])
        regexs[30].sub(r'', 'iv_svefg_gvzr', subcount[30])
        re.search(r'(^|.)(ronl|qri-ehf3.wbg)(|fgberf|zbgbef|yvirnhpgvbaf|jvxv|rkcerff|punggre).(pbz(|.nh|.pa|.ux|.zl|.ft|.oe|.zk)|pb(.hx|.xe|.am)|pn|qr|se|vg|ay|or|ng|pu|vr|va|rf|cy|cu|fr)$', 'cntrf.ronl.pbz', re.IGNORECASE)
        regexs[8].search(r'144631658.0.10.1231364074')
        regexs[8].search(
            r'144631658.1231364074.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.2294274870215848400.1231364074.1231364074.1231364074.1')
        regexs[8].search(r'4413241q3660')
        regexs[8].search(r'SbeprqRkcvengvba=633669357391353591')
        regexs[8].search(strings[39])
        regexs[8].search(strings[40])
        regexs[8].search(r'AFP_zp_kkk-gdzogv_80=4413241q3660')
        regexs[8].search(
            r'FrffvbaQQS2=p98s8o9q42nr21or1r61pqorn1n002nsss569635984s6qp7')
        regexs[8].search(
            r'__hgzn=144631658.2294274870215848400.1231364074.1231364074.1231364074.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231364074')
        regexs[8].search(
            r'__hgzm=144631658.1231364074.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(r'p98s8o9q42nr21or1r61pqorn1n002nsss569635984s6qp7')
        regexs[34].search(strings[36])
        regexs[34].search(strings[37])


def block8():
    for i in range(7):
        re.match(r'\d+', strings[1])
        regexs[64].sub(r'', 'nsgre', subcount[64])
        regexs[64].sub(r'', 'orsber', subcount[64])
        regexs[64].sub(r'', 'obggbz', subcount[64])
        regexs[65].sub(r'', 'ohvygva_jrngure.kzy', subcount[65])
        regexs[37].sub(r'', 'ohggba', subcount[37])
        regexs[18].sub(r'', 'ohggba', subcount[18])
        regexs[65].sub(r'', 'qngrgvzr.kzy', subcount[65])
        regexs[65].sub(
            r'', 'uggc://eff.paa.pbz/eff/paa_gbcfgbevrf.eff', subcount[65])
        regexs[37].sub(r'', 'vachg', subcount[37])
        regexs[18].sub(r'', 'vachg', subcount[18])
        regexs[64].sub(r'', 'vafvqr', subcount[64])
        regexs[27].sub(r'', 'cbvagre', subcount[27])
        re.sub(r'[A-Z]', '', 'cbfvgvba', 0)
        regexs[27].sub(r'', 'gbc', subcount[27])
        regexs[64].sub(r'', 'gbc', subcount[64])
        regexs[37].sub(r'', 'hy', subcount[37])
        regexs[18].sub(r'', 'hy', subcount[18])
        regexs[37].sub(r'', strings[26], subcount[37])
        regexs[18].sub(r'', strings[26], subcount[18])
        regexs[65].sub(r'', 'lbhghor_vtbbtyr/i2/lbhghor.kzy', subcount[65])
        regexs[27].sub(r'', 'm-vaqrk', subcount[27])
        re.search(r'#([\w-]+)', strings[26])
        regexs[16].search(r'urvtug')
        regexs[16].search(r'znetvaGbc')
        regexs[16].search(r'jvqgu')
        regexs[19].search(r'gno0 svefg ba')
        regexs[19].search(r'gno0 ba')
        regexs[19].search(r'gno4 ynfg')
        regexs[19].search(r'gno4')
        regexs[19].search(r'gno5')
        regexs[19].search(r'gno6')
        regexs[19].search(r'gno7')
        regexs[19].search(r'gno8')
        re.search(r'NqborNVE\/([^\s]*)', strings[0])
        re.search(r'NccyrJroXvg\/([^ ]*)', strings[0])
        re.search(r'XUGZY', strings[0], re.IGNORECASE)
        re.search(r'^(?:obql|ugzy)$', 'YV', re.IGNORECASE)
        regexs[38].search(r'ohggba')
        regexs[38].search(r'vachg')
        regexs[38].search(r'hy')
        regexs[38].search(strings[26])
        re.search(r'^(\w+|\*)', strings[26])
        re.search(r'znp|jva|yvahk', 'Jva32', re.IGNORECASE)
        re.search(r'eton?\([\d\s,]+\)', 'fgngvp')

    for i in range(6):
        re.sub(r'\r', '', '', 0)
        regexs[40].sub(r'', '/', subcount[40])
        regexs[10].sub(r'', '/', subcount[10])
        regexs[51].sub(r'', '/', subcount[51])
        regexs[52].sub(r'', '/', subcount[52])
        regexs[53].sub(r'', '/', subcount[53])
        regexs[39].sub(r'', '/', subcount[39])
        regexs[54].sub(r'', '/', subcount[54])
        regexs[63].sub(
            r'', 'uggc://zfacbegny.112.2b7.arg/o/ff/zfacbegnyubzr/1/U.7-cqi-2/{0}?[NDO]&{1}&{2}&[NDR]', subcount[63])
        regexs[12].sub(r'', strings[41], subcount[12])
        regexs[23].sub(r'', 'uggc://jjj.snprobbx.pbz/fepu.cuc', subcount[23])
        regexs[40].sub(r'', 'freivpr', subcount[40])
        regexs[41].sub(r'', 'freivpr', subcount[41])
        regexs[42].sub(r'', 'freivpr', subcount[42])
        regexs[43].sub(r'', 'freivpr', subcount[43])
        regexs[44].sub(r'', 'freivpr', subcount[44])
        regexs[45].sub(r'', 'freivpr', subcount[45])
        regexs[46].sub(r'', 'freivpr', subcount[46])
        regexs[47].sub(r'', 'freivpr', subcount[47])
        regexs[48].sub(r'', 'freivpr', subcount[48])
        re.search(r'((ZFVR\s+([6-9]|\d\d)\.))', strings[0])
        regexs[66].search(r'')
        regexs[50].search(r'fryrpgrq')
        regexs[8].search(r'8sqq78r9n442851q565599o401385sp3s04r92rnn7o19ssn')
        regexs[8].search(r'SbeprqRkcvengvba=633669340386893867')
        regexs[8].search(r'VC=74.125.75.17')
        regexs[8].search(
            r'FrffvbaQQS2=8sqq78r9n442851q565599o401385sp3s04r92rnn7o19ssn')
        re.search(r'Xbadhrebe|Fnsnev|XUGZY', strings[0])
        regexs[13].search(strings[41])
        regexs[49].search(r'unfsbphf')


def block9():
    for i in range(5):
        regexs[32].split(strings[42])
        regexs[32].split(strings[43])
        regexs[20].split(
            r'svz_zlfcnpr_hfre-ivrj-pbzzragf,svz_zlfcnpr_havgrq-fgngrf')
        regexs[33].sub(r'', strings[44], subcount[33])
        regexs[67].sub(
            r'', 'zrah_arj zrah_arj_gbttyr zrah_gbttyr', subcount[67])
        regexs[67].sub(
            r'', 'zrah_byq zrah_byq_gbttyr zrah_gbttyr', subcount[67])
        regexs[8].search(r'102n9o0o9pq60132qn0337rr867p75953502q2s27s2s5r98')
        regexs[8].search(r'144631658.0.10.1231364380')
        regexs[8].search(
            r'144631658.1231364380.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.3931862196947939300.1231364380.1231364380.1231364380.1')
        regexs[8].search(r'441326q33660')
        regexs[8].search(r'SbeprqRkcvengvba=633669341278771470')
        regexs[8].search(strings[45])
        regexs[8].search(strings[46])
        regexs[8].search(r'AFP_zp_dfctwzssrwh-aowb_80=441326q33660')
        regexs[8].search(
            r'FrffvbaQQS2=102n9o0o9pq60132qn0337rr867p75953502q2s27s2s5r98')
        regexs[8].search(
            r'__hgzn=144631658.3931862196947939300.1231364380.1231364380.1231364380.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231364380')
        regexs[8].search(
            r'__hgzm=144631658.1231364380.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')

    for i in range(4):
        regexs[14].sub(r'', ' yvfg1', subcount[14])
        regexs[15].sub(r'', ' yvfg1', subcount[15])
        regexs[14].sub(r'', ' yvfg2', subcount[14])
        regexs[15].sub(r'', ' yvfg2', subcount[15])
        regexs[14].sub(r'', ' frneputebhc1', subcount[14])
        regexs[15].sub(r'', ' frneputebhc1', subcount[15])
        regexs[68].sub(r'', strings[47], subcount[68])
        regexs[18].sub(r'', strings[47], subcount[18])
        re.sub(r'&', '', '', 0)
        regexs[35].sub(r'', '', subcount[35])
        regexs[63].sub(r'', '(..-{0})(|(d+)|)', subcount[63])
        regexs[18].sub(r'', strings[48], subcount[18])
        regexs[56].sub(
            r'', '//vzt.jro.qr/vij/FC/${cngu}/${anzr}/${inyhr}?gf=${abj}', subcount[56])
        re.sub(r'(\$\{anzr\})|(\$anzr\b)', '',
               '//vzt.jro.qr/vij/FC/tzk_uc/${anzr}/${inyhr}?gf=${abj}', 0)
        regexs[69].sub(
            r'', '<fcna pynff="urnq"><o>Jvaqbjf Yvir Ubgznvy</o></fcna><fcna pynff="zft">{1}</fcna>', subcount[69])
        regexs[63].sub(
            r'', '<fcna pynff="urnq"><o>{0}</o></fcna><fcna pynff="zft">{1}</fcna>', subcount[63])
        regexs[69].sub(
            r'', '<fcna pynff="fvtahc"><n uers=uggc://jjj.ubgznvy.pbz><o>{1}</o></n></fcna>', subcount[69])
        regexs[63].sub(
            r'', '<fcna pynff="fvtahc"><n uers={0}><o>{1}</o></n></fcna>', subcount[63])
        regexs[15].sub(r'', 'Vzntrf', subcount[15])
        regexs[15].sub(r'', 'ZFA', subcount[15])
        regexs[15].sub(r'', 'Zncf', subcount[15])
        regexs[39].sub(r'', 'Zbq-Vasb-Vasb-WninFpevcgUvag', subcount[39])
        regexs[15].sub(r'', 'Arjf', subcount[15])
        regexs[32].split(strings[49])
        regexs[32].split(strings[50])
        regexs[15].sub(r'', 'Ivqrb', subcount[15])
        regexs[15].sub(r'', 'Jro', subcount[15])
        regexs[39].sub(r'', 'n', subcount[39])
        regexs[70].split(r'nwnkFgneg')
        regexs[70].split(r'nwnkFgbc')
        regexs[14].sub(r'', 'ovaq', subcount[14])
        regexs[15].sub(r'', 'ovaq', subcount[15])
        regexs[63].sub(
            r'', 'oevatf lbh zber. Zber fcnpr (5TO), zber frphevgl, fgvyy serr.', subcount[63])
        regexs[14].sub(r'', 'puvyq p1 svefg qrpx', subcount[14])
        regexs[15].sub(r'', 'puvyq p1 svefg qrpx', subcount[15])
        regexs[14].sub(r'', 'puvyq p1 svefg qbhoyr2', subcount[14])
        regexs[15].sub(r'', 'puvyq p1 svefg qbhoyr2', subcount[15])
        regexs[14].sub(r'', 'puvyq p2 ynfg', subcount[14])
        regexs[15].sub(r'', 'puvyq p2 ynfg', subcount[15])
        regexs[14].sub(r'', 'puvyq p2', subcount[14])
        regexs[15].sub(r'', 'puvyq p2', subcount[15])
        regexs[14].sub(r'', 'puvyq p3', subcount[14])
        regexs[15].sub(r'', 'puvyq p3', subcount[15])
        regexs[14].sub(r'', 'puvyq p4 ynfg', subcount[14])
        regexs[15].sub(r'', 'puvyq p4 ynfg', subcount[15])
        regexs[14].sub(r'', 'pbclevtug', subcount[14])
        regexs[15].sub(r'', 'pbclevtug', subcount[15])
        regexs[14].sub(r'', 'qZFAZR_1', subcount[14])
        regexs[15].sub(r'', 'qZFAZR_1', subcount[15])
        regexs[14].sub(r'', 'qbhoyr2 ps', subcount[14])
        regexs[15].sub(r'', 'qbhoyr2 ps', subcount[15])
        regexs[14].sub(r'', 'qbhoyr2', subcount[14])
        regexs[15].sub(r'', 'qbhoyr2', subcount[15])
        regexs[14].sub(r'', 'uqy_arj', subcount[14])
        regexs[15].sub(r'', 'uqy_arj', subcount[15])
        regexs[30].sub(r'', 'uc_fubccvatobk', subcount[30])
        regexs[29].sub(r'', 'ugzy%2Rvq', subcount[29])
        regexs[30].sub(r'', 'ugzy%2Rvq', subcount[30])
        regexs[33].sub(r'', strings[51], subcount[33])
        regexs[71].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/cebgbglcr.wf${4}${5}', subcount[71])
        regexs[72].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/cebgbglcr.wf${5}', subcount[72])
        regexs[73].sub(r'', strings[52], subcount[73])
        regexs[69].sub(
            r'', 'uggc://zfacbegny.112.2b7.arg/o/ff/zfacbegnyubzr/1/U.7-cqi-2/f55332979829981?[NDO]&{1}&{2}&[NDR]', subcount[69])
        regexs[14].sub(r'', 'vztZFSG', subcount[14])
        regexs[15].sub(r'', 'vztZFSG', subcount[15])
        regexs[14].sub(r'', 'zfasbbg1 ps', subcount[14])
        regexs[15].sub(r'', 'zfasbbg1 ps', subcount[15])
        regexs[14].sub(r'', strings[53], subcount[14])
        regexs[15].sub(r'', strings[53], subcount[15])
        regexs[14].sub(
            r'', 'cnerag puebzr6 fvatyr1 gno fryrpgrq ovaq', subcount[14])
        regexs[15].sub(
            r'', 'cnerag puebzr6 fvatyr1 gno fryrpgrq ovaq', subcount[15])
        regexs[14].sub(r'', 'cevznel', subcount[14])
        regexs[15].sub(r'', 'cevznel', subcount[15])
        regexs[30].sub(r'', 'erpgnatyr', subcount[30])
        regexs[14].sub(r'', 'frpbaqnel', subcount[14])
        regexs[15].sub(r'', 'frpbaqnel', subcount[15])
        regexs[70].split(r'haybnq')
        regexs[63].sub(r'', '{0}{1}1', subcount[63])
        regexs[69].sub(r'', '|{1}1', subcount[69])
        re.search(r'(..-HF)(\|(\d+)|)', 'xb-xe,ra-va,gu-gu', re.IGNORECASE)
        regexs[4].search(r'/ZlFcnprNccf/NccPnainf,45000012')
        regexs[8].search(r'144631658.0.10.1231367708')
        regexs[8].search(
            r'144631658.1231367708.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.2770915348920628700.1231367708.1231367708.1231367708.1')
        regexs[8].search(r'4413235p3660')
        regexs[8].search(r'441327q73660')
        regexs[8].search(r'9995p6rp12rrnr893334ro7nq70o7p64p69rqn844prs1473')
        regexs[8].search(r'SbeprqRkcvengvba=633669350559478880')
        regexs[8].search(strings[54])
        regexs[8].search(strings[55])
        regexs[8].search(r'AFP_zp_dfctwzs-aowb_80=441327q73660')
        regexs[8].search(r'AFP_zp_kkk-aowb_80=4413235p3660')
        regexs[8].search(
            r'FrffvbaQQS2=9995p6rp12rrnr893334ro7nq70o7p64p69rqn844prs1473')
        regexs[8].search(
            r'__hgzn=144631658.2770915348920628700.1231367708.1231367708.1231367708.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231367708')
        regexs[8].search(
            r'__hgzm=144631658.1231367708.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[34].search(strings[49])
        regexs[34].search(strings[50])
        re.search(r'ZFVR\s+5[.]01', strings[0])
        re.search(r'HF(?=;)', strings[56], re.IGNORECASE)
        regexs[74].search(strings[47])
        regexs[28].search(r'svefg npgvir svefgNpgvir')
        regexs[28].search(r'ynfg')
        re.search(
            r'\bp:(..)', 'm:94043|yn:37.4154|yb:-122.0585|p:HF', re.IGNORECASE)
        regexs[75].search(strings[57])
        regexs[75].search(strings[58])
        regexs[76].search(strings[57])
        regexs[76].search(strings[58])
        regexs[77].search(strings[57])
        regexs[77].search(strings[58])
        re.search(r'\bhfucce\s*=\s*([^;]*)', strings[59], re.IGNORECASE)
        regexs[78].search(strings[57])
        regexs[78].search(strings[58])
        re.search(r'\bjci\s*=\s*([^;]*)', strings[59], re.IGNORECASE)
        regexs[79].search(strings[58])
        regexs[79].search(strings[60])
        regexs[79].search(strings[59])
        re.search(
            r'\|p:([a-z]{2})', 'm:94043|yn:37.4154|yb:-122.0585|p:HF|ue:1', re.IGNORECASE)
        regexs[80].search(strings[47])
        regexs[61].search(r'cebgbglcr.wf')
        regexs[68].search(strings[47])
        regexs[81].search(strings[47])
        regexs[82].search(strings[47])
        re.search(r'^Fubpxjnir Synfu (\d)', strings[1])
        re.search(r'^Fubpxjnir Synfu (\d+)', strings[1])
        regexs[83].search(r'[bowrpg tybony]')
        regexs[62].search(strings[47])
        regexs[84].search(strings[61])
        regexs[84].search(strings[62])
        re.search(r'jroxvg', strings[63])


def block10():
    for i in range(3):
        regexs[39].sub(r'', '%3Szxg=ra-HF', subcount[39])
        regexs[40].sub(r'', '-8', subcount[40])
        regexs[10].sub(r'', '-8', subcount[10])
        regexs[51].sub(r'', '-8', subcount[51])
        regexs[52].sub(r'', '-8', subcount[52])
        regexs[53].sub(r'', '-8', subcount[53])
        regexs[39].sub(r'', '-8', subcount[39])
        regexs[54].sub(r'', '-8', subcount[54])
        regexs[40].sub(r'', '1.5', subcount[40])
        regexs[10].sub(r'', '1.5', subcount[10])
        regexs[51].sub(r'', '1.5', subcount[51])
        regexs[52].sub(r'', '1.5', subcount[52])
        regexs[53].sub(r'', '1.5', subcount[53])
        regexs[39].sub(r'', '1.5', subcount[39])
        regexs[54].sub(r'', '1.5', subcount[54])
        regexs[40].sub(r'', '1024k768', subcount[40])
        regexs[10].sub(r'', '1024k768', subcount[10])
        regexs[51].sub(r'', '1024k768', subcount[51])
        regexs[52].sub(r'', '1024k768', subcount[52])
        regexs[53].sub(r'', '1024k768', subcount[53])
        regexs[39].sub(r'', '1024k768', subcount[39])
        regexs[54].sub(r'', '1024k768', subcount[54])
        regexs[40].sub(r'', strings[64], subcount[40])
        regexs[10].sub(r'', strings[64], subcount[10])
        regexs[51].sub(r'', strings[64], subcount[51])
        regexs[52].sub(r'', strings[64], subcount[52])
        regexs[53].sub(r'', strings[64], subcount[53])
        regexs[39].sub(r'', strings[64], subcount[39])
        regexs[54].sub(r'', strings[64], subcount[54])
        regexs[40].sub(r'', '14', subcount[40])
        regexs[10].sub(r'', '14', subcount[10])
        regexs[51].sub(r'', '14', subcount[51])
        regexs[52].sub(r'', '14', subcount[52])
        regexs[53].sub(r'', '14', subcount[53])
        regexs[39].sub(r'', '14', subcount[39])
        regexs[54].sub(r'', '14', subcount[54])
        regexs[40].sub(r'', '24', subcount[40])
        regexs[10].sub(r'', '24', subcount[10])
        regexs[51].sub(r'', '24', subcount[51])
        regexs[52].sub(r'', '24', subcount[52])
        regexs[53].sub(r'', '24', subcount[53])
        regexs[39].sub(r'', '24', subcount[39])
        regexs[54].sub(r'', '24', subcount[54])
        regexs[40].sub(r'', strings[65], subcount[40])
        regexs[10].sub(r'', strings[65], subcount[10])
        regexs[51].sub(r'', strings[65], subcount[51])
        regexs[52].sub(r'', strings[65], subcount[52])
        regexs[53].sub(r'', strings[65], subcount[53])
        regexs[39].sub(r'', strings[65], subcount[39])
        regexs[54].sub(r'', strings[65], subcount[54])
        regexs[40].sub(r'', strings[66], subcount[40])
        regexs[10].sub(r'', strings[66], subcount[10])
        regexs[51].sub(r'', strings[66], subcount[51])
        regexs[52].sub(r'', strings[66], subcount[52])
        regexs[53].sub(r'', strings[66], subcount[53])
        regexs[39].sub(r'', strings[66], subcount[39])
        regexs[54].sub(r'', strings[66], subcount[54])
        regexs[40].sub(r'', '9.0', subcount[40])
        regexs[10].sub(r'', '9.0', subcount[10])
        regexs[51].sub(r'', '9.0', subcount[51])
        regexs[52].sub(r'', '9.0', subcount[52])
        regexs[53].sub(r'', '9.0', subcount[53])
        regexs[39].sub(r'', '9.0', subcount[39])
        regexs[54].sub(r'', '9.0', subcount[54])
        regexs[40].sub(r'', '994k634', subcount[40])
        regexs[10].sub(r'', '994k634', subcount[10])
        regexs[51].sub(r'', '994k634', subcount[51])
        regexs[52].sub(r'', '994k634', subcount[52])
        regexs[53].sub(r'', '994k634', subcount[53])
        regexs[39].sub(r'', '994k634', subcount[39])
        regexs[54].sub(r'', '994k634', subcount[54])
        regexs[40].sub(r'', '?zxg=ra-HF', subcount[40])
        regexs[10].sub(r'', '?zxg=ra-HF', subcount[10])
        regexs[51].sub(r'', '?zxg=ra-HF', subcount[51])
        regexs[52].sub(r'', '?zxg=ra-HF', subcount[52])
        regexs[53].sub(r'', '?zxg=ra-HF', subcount[53])
        regexs[54].sub(r'', '?zxg=ra-HF', subcount[54])
        regexs[25].sub(r'', 'PAA.pbz', subcount[25])
        regexs[12].sub(r'', 'PAA.pbz', subcount[12])
        regexs[39].sub(r'', 'PAA.pbz', subcount[39])
        regexs[25].sub(r'', 'Qngr & Gvzr', subcount[25])
        regexs[12].sub(r'', 'Qngr & Gvzr', subcount[12])
        regexs[39].sub(r'', 'Qngr & Gvzr', subcount[39])
        regexs[40].sub(r'', 'Frnepu Zvpebfbsg.pbz', subcount[40])
        regexs[54].sub(r'', 'Frnepu Zvpebfbsg.pbz', subcount[54])
        regexs[10].sub(r'', strings[67], subcount[10])
        regexs[51].sub(r'', strings[67], subcount[51])
        regexs[52].sub(r'', strings[67], subcount[52])
        regexs[53].sub(r'', strings[67], subcount[53])
        regexs[39].sub(r'', strings[67], subcount[39])
        regexs[32].split(strings[68])
        regexs[32].split(strings[69])
        regexs[52].sub(r'', strings[70], subcount[52])
        regexs[53].sub(r'', strings[70], subcount[53])
        regexs[39].sub(r'', strings[70], subcount[39])
        regexs[40].sub(r'', strings[71], subcount[40])
        regexs[10].sub(r'', strings[71], subcount[10])
        regexs[51].sub(r'', strings[71], subcount[51])
        regexs[54].sub(r'', strings[71], subcount[54])
        regexs[25].sub(r'', 'Jrngure', subcount[25])
        regexs[12].sub(r'', 'Jrngure', subcount[12])
        regexs[39].sub(r'', 'Jrngure', subcount[39])
        regexs[25].sub(r'', 'LbhGhor', subcount[25])
        regexs[12].sub(r'', 'LbhGhor', subcount[12])
        regexs[39].sub(r'', 'LbhGhor', subcount[39])
        regexs[33].sub(r'', strings[72], subcount[33])
        re.sub(r'^erzbgr_vsenzr_', '', 'erzbgr_vsenzr_1', 1)
        regexs[40].sub(r'', strings[73], subcount[40])
        regexs[10].sub(r'', strings[73], subcount[10])
        regexs[51].sub(r'', strings[73], subcount[51])
        regexs[52].sub(r'', strings[73], subcount[52])
        regexs[53].sub(r'', strings[73], subcount[53])
        regexs[39].sub(r'', strings[73], subcount[39])
        regexs[54].sub(r'', strings[73], subcount[54])
        regexs[40].sub(r'', strings[74], subcount[40])
        regexs[10].sub(r'', strings[74], subcount[10])
        regexs[51].sub(r'', strings[74], subcount[51])
        regexs[52].sub(r'', strings[74], subcount[52])
        regexs[53].sub(r'', strings[74], subcount[53])
        regexs[39].sub(r'', strings[74], subcount[39])
        regexs[54].sub(r'', strings[74], subcount[54])
        re.sub(r'\-', '', 'lhv-h', 0)
        regexs[9].search(r'p')
        regexs[9].search(r'qz p')
        regexs[9].search(r'zbqynory')
        regexs[9].search(r'lhv-h svefg')
        regexs[8].search(r'144631658.0.10.1231365779')
        regexs[8].search(
            r'144631658.1231365779.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.1877536177953918500.1231365779.1231365779.1231365779.1')
        regexs[8].search(strings[75])
        regexs[8].search(strings[76])
        regexs[8].search(
            r'__hgzn=144631658.1877536177953918500.1231365779.1231365779.1231365779.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231365779')
        regexs[8].search(
            r'__hgzm=144631658.1231365779.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[34].search(strings[68])
        regexs[34].search(strings[69])
        re.search(r'^$', '')
        regexs[31].search(r'qr')
        re.search(r'^znk\d+$', '')
        re.search(r'^zva\d+$', '')
        re.search(r'^erfgber$', '')
        regexs[85].search(r'zbqobkva zbqobk_abcnqqvat ')
        regexs[85].search(r'zbqgvgyr')
        regexs[85].search(r'eaq_zbqobkva ')
        regexs[85].search(r'eaq_zbqgvgyr ')
        re.search(r'frpgvba\d+_pbagragf', 'obggbz_ani')


def block11():
    for i in range(2):
        regexs[18].sub(r'', ' .pybfr', subcount[18])
        regexs[18].sub(r'', ' n.svryqOgaPnapry', subcount[18])
        regexs[18].sub(r'', ' qg', subcount[18])
        regexs[68].sub(r'', strings[77], subcount[68])
        regexs[18].sub(r'', strings[77], subcount[18])
        regexs[39].sub(r'', '', subcount[39])
        re.sub(r'^', '', '', 1)
        regexs[86].split(r'')
        regexs[39].sub(r'', '*', subcount[39])
        regexs[68].sub(r'', '*', subcount[68])
        regexs[18].sub(r'', '*', subcount[18])
        regexs[68].sub(r'', '.pybfr', subcount[68])
        regexs[18].sub(r'', '.pybfr', subcount[18])
        regexs[87].sub(
            r'', '//vzt.jro.qr/vij/FC/tzk_uc/fperra/${inyhr}?gf=${abj}', subcount[87])
        regexs[88].sub(
            r'', '//vzt.jro.qr/vij/FC/tzk_uc/fperra/1024?gf=${abj}', subcount[88])
        regexs[87].sub(
            r'', '//vzt.jro.qr/vij/FC/tzk_uc/jvafvmr/${inyhr}?gf=${abj}', subcount[87])
        regexs[88].sub(
            r'', '//vzt.jro.qr/vij/FC/tzk_uc/jvafvmr/992/608?gf=${abj}', subcount[88])
        regexs[30].sub(r'', '300k120', subcount[30])
        regexs[30].sub(r'', '300k250', subcount[30])
        regexs[30].sub(r'', '310k120', subcount[30])
        regexs[30].sub(r'', '310k170', subcount[30])
        regexs[30].sub(r'', '310k250', subcount[30])
        re.sub(r'^.*\.(.*)\s.*$', '', '9.0  e115', 1)
        regexs[2].sub(r'', 'Nppbeqvba', subcount[2])
        regexs[89].sub(r'', 'Nxghryy\x0a', subcount[89])
        regexs[90].sub(r'', 'Nxghryy\x0a', subcount[90])
        regexs[2].sub(r'', 'Nccyvpngvba', subcount[2])
        regexs[89].sub(r'', 'Oyvpxchaxg\x0a', subcount[89])
        regexs[90].sub(r'', 'Oyvpxchaxg\x0a', subcount[90])
        regexs[89].sub(r'', 'Svanamra\x0a', subcount[89])
        regexs[90].sub(r'', 'Svanamra\x0a', subcount[90])
        regexs[89].sub(r'', 'Tnzrf\x0a', subcount[89])
        regexs[90].sub(r'', 'Tnzrf\x0a', subcount[90])
        regexs[89].sub(r'', 'Ubebfxbc\x0a', subcount[89])
        regexs[90].sub(r'', 'Ubebfxbc\x0a', subcount[90])
        regexs[89].sub(r'', 'Xvab\x0a', subcount[89])
        regexs[90].sub(r'', 'Xvab\x0a', subcount[90])
        regexs[2].sub(r'', 'Zbqhyrf', subcount[2])
        regexs[89].sub(r'', 'Zhfvx\x0a', subcount[89])
        regexs[90].sub(r'', 'Zhfvx\x0a', subcount[90])
        regexs[89].sub(r'', 'Anpuevpugra\x0a', subcount[89])
        regexs[90].sub(r'', 'Anpuevpugra\x0a', subcount[90])
        regexs[2].sub(r'', 'Cuk', subcount[2])
        regexs[70].split(r'ErdhrfgSvavfu')
        regexs[70].split(r'ErdhrfgSvavfu.NWNK.Cuk')
        regexs[89].sub(r'', 'Ebhgr\x0a', subcount[89])
        regexs[90].sub(r'', 'Ebhgr\x0a', subcount[90])
        regexs[32].split(strings[78])
        regexs[32].split(strings[79])
        regexs[32].split(strings[80])
        regexs[32].split(strings[81])
        regexs[89].sub(r'', 'Fcbeg\x0a', subcount[89])
        regexs[90].sub(r'', 'Fcbeg\x0a', subcount[90])
        regexs[89].sub(r'', 'GI-Fcbg\x0a', subcount[89])
        regexs[90].sub(r'', 'GI-Fcbg\x0a', subcount[90])
        regexs[89].sub(r'', 'Gbhe\x0a', subcount[89])
        regexs[90].sub(r'', 'Gbhe\x0a', subcount[90])
        regexs[89].sub(r'', 'Hagreunyghat\x0a', subcount[89])
        regexs[90].sub(r'', 'Hagreunyghat\x0a', subcount[90])
        regexs[89].sub(r'', 'Ivqrb\x0a', subcount[89])
        regexs[90].sub(r'', 'Ivqrb\x0a', subcount[90])
        regexs[89].sub(r'', 'Jrggre\x0a', subcount[89])
        regexs[90].sub(r'', 'Jrggre\x0a', subcount[90])
        regexs[68].sub(r'', strings[82], subcount[68])
        regexs[18].sub(r'', strings[82], subcount[18])
        regexs[68].sub(r'', strings[83], subcount[68])
        regexs[18].sub(r'', strings[83], subcount[18])
        regexs[68].sub(r'', strings[84], subcount[68])
        regexs[18].sub(r'', strings[84], subcount[18])
        regexs[30].sub(r'', 'nqiFreivprObk', subcount[30])
        regexs[30].sub(r'', 'nqiFubccvatObk', subcount[30])
        regexs[39].sub(r'', 'nwnk', subcount[39])
        regexs[40].sub(r'', 'nxghryy', subcount[40])
        regexs[41].sub(r'', 'nxghryy', subcount[41])
        regexs[42].sub(r'', 'nxghryy', subcount[42])
        regexs[43].sub(r'', 'nxghryy', subcount[43])
        regexs[44].sub(r'', 'nxghryy', subcount[44])
        regexs[45].sub(r'', 'nxghryy', subcount[45])
        regexs[46].sub(r'', 'nxghryy', subcount[46])
        regexs[47].sub(r'', 'nxghryy', subcount[47])
        regexs[48].sub(r'', 'nxghryy', subcount[48])
        regexs[40].sub(r'', strings[85], subcount[40])
        regexs[41].sub(r'', strings[85], subcount[41])
        regexs[42].sub(r'', strings[85], subcount[42])
        regexs[43].sub(r'', strings[85], subcount[43])
        regexs[44].sub(r'', strings[85], subcount[44])
        regexs[45].sub(r'', strings[85], subcount[45])
        regexs[46].sub(r'', strings[85], subcount[46])
        regexs[47].sub(r'', strings[85], subcount[47])
        regexs[48].sub(r'', strings[85], subcount[48])
        regexs[29].sub(r'', 'pngrtbel', subcount[29])
        regexs[30].sub(r'', 'pngrtbel', subcount[30])
        regexs[39].sub(r'', 'pybfr', subcount[39])
        regexs[39].sub(r'', 'qvi', subcount[39])
        regexs[68].sub(r'', strings[86], subcount[68])
        regexs[18].sub(r'', strings[86], subcount[18])
        regexs[39].sub(r'', 'qg', subcount[39])
        regexs[68].sub(r'', 'qg', subcount[68])
        regexs[18].sub(r'', 'qg', subcount[18])
        regexs[39].sub(r'', 'rzorq', subcount[39])
        regexs[68].sub(r'', 'rzorq', subcount[68])
        regexs[18].sub(r'', 'rzorq', subcount[18])
        regexs[39].sub(r'', 'svryqOga', subcount[39])
        regexs[39].sub(r'', 'svryqOgaPnapry', subcount[39])
        regexs[20].split(r'svz_zlfcnpr_nccf-pnainf,svz_zlfcnpr_havgrq-fgngrf')
        regexs[40].sub(r'', 'svanamra', subcount[40])
        regexs[41].sub(r'', 'svanamra', subcount[41])
        regexs[42].sub(r'', 'svanamra', subcount[42])
        regexs[43].sub(r'', 'svanamra', subcount[43])
        regexs[44].sub(r'', 'svanamra', subcount[44])
        regexs[45].sub(r'', 'svanamra', subcount[45])
        regexs[46].sub(r'', 'svanamra', subcount[46])
        regexs[47].sub(r'', 'svanamra', subcount[47])
        regexs[48].sub(r'', 'svanamra', subcount[48])
        regexs[70].split(r'sbphf')
        regexs[70].split(r'sbphf.gno sbphfva.gno')
        regexs[70].split(r'sbphfva')
        regexs[39].sub(r'', 'sbez', subcount[39])
        regexs[68].sub(r'', 'sbez.nwnk', subcount[68])
        regexs[18].sub(r'', 'sbez.nwnk', subcount[18])
        regexs[40].sub(r'', 'tnzrf', subcount[40])
        regexs[41].sub(r'', 'tnzrf', subcount[41])
        regexs[42].sub(r'', 'tnzrf', subcount[42])
        regexs[43].sub(r'', 'tnzrf', subcount[43])
        regexs[44].sub(r'', 'tnzrf', subcount[44])
        regexs[45].sub(r'', 'tnzrf', subcount[45])
        regexs[46].sub(r'', 'tnzrf', subcount[46])
        regexs[47].sub(r'', 'tnzrf', subcount[47])
        regexs[48].sub(r'', 'tnzrf', subcount[48])
        regexs[30].sub(r'', 'ubzrcntr', subcount[30])
        regexs[40].sub(r'', 'ubebfxbc', subcount[40])
        regexs[41].sub(r'', 'ubebfxbc', subcount[41])
        regexs[42].sub(r'', 'ubebfxbc', subcount[42])
        regexs[43].sub(r'', 'ubebfxbc', subcount[43])
        regexs[44].sub(r'', 'ubebfxbc', subcount[44])
        regexs[45].sub(r'', 'ubebfxbc', subcount[45])
        regexs[46].sub(r'', 'ubebfxbc', subcount[46])
        regexs[47].sub(r'', 'ubebfxbc', subcount[47])
        regexs[48].sub(r'', 'ubebfxbc', subcount[48])
        regexs[30].sub(r'', 'uc_cebzbobk_ugzy%2Puc_cebzbobk_vzt', subcount[30])
        regexs[30].sub(r'', 'uc_erpgnatyr', subcount[30])
        regexs[33].sub(r'', strings[87], subcount[33])
        regexs[33].sub(r'', strings[88], subcount[33])
        regexs[71].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/onfr.wf${4}${5}', subcount[71])
        regexs[72].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/onfr.wf${5}', subcount[72])
        regexs[71].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/qlaYvo.wf${4}${5}', subcount[71])
        regexs[72].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/qlaYvo.wf${5}', subcount[72])
        regexs[71].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/rssrpgYvo.wf${4}${5}', subcount[71])
        regexs[72].sub(
            r'', 'uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/rssrpgYvo.wf${5}', subcount[72])
        regexs[73].sub(r'', strings[89], subcount[73])
        regexs[69].sub(
            r'', 'uggc://zfacbegny.112.2b7.arg/o/ff/zfacbegnyubzr/1/U.7-cqi-2/f55023338617756?[NDO]&{1}&{2}&[NDR]', subcount[69])
        regexs[23].sub(r'', strings[6], subcount[23])
        regexs[40].sub(r'', 'xvab', subcount[40])
        regexs[41].sub(r'', 'xvab', subcount[41])
        regexs[42].sub(r'', 'xvab', subcount[42])
        regexs[43].sub(r'', 'xvab', subcount[43])
        regexs[44].sub(r'', 'xvab', subcount[44])
        regexs[45].sub(r'', 'xvab', subcount[45])
        regexs[46].sub(r'', 'xvab', subcount[46])
        regexs[47].sub(r'', 'xvab', subcount[47])
        regexs[48].sub(r'', 'xvab', subcount[48])
        regexs[70].split(r'ybnq')
        regexs[18].sub(
            r'', 'zrqvnzbqgno lhv-anifrg lhv-anifrg-gbc', subcount[18])
        regexs[39].sub(r'', 'zrgn', subcount[39])
        regexs[68].sub(r'', strings[90], subcount[68])
        regexs[18].sub(r'', strings[90], subcount[18])
        regexs[70].split(r'zbhfrzbir')
        regexs[70].split(r'zbhfrzbir.gno')
        re.sub(r'^.*jroxvg\/(\d+(\.\d+)?).*$', '', strings[63], 1)
        regexs[40].sub(r'', 'zhfvx', subcount[40])
        regexs[41].sub(r'', 'zhfvx', subcount[41])
        regexs[42].sub(r'', 'zhfvx', subcount[42])
        regexs[43].sub(r'', 'zhfvx', subcount[43])
        regexs[44].sub(r'', 'zhfvx', subcount[44])
        regexs[45].sub(r'', 'zhfvx', subcount[45])
        regexs[46].sub(r'', 'zhfvx', subcount[46])
        regexs[47].sub(r'', 'zhfvx', subcount[47])
        regexs[48].sub(r'', 'zhfvx', subcount[48])
        regexs[52].sub(r'', 'zlfcnpr_nccf_pnainf', subcount[52])
        regexs[40].sub(r'', strings[91], subcount[40])
        regexs[41].sub(r'', strings[91], subcount[41])
        regexs[42].sub(r'', strings[91], subcount[42])
        regexs[43].sub(r'', strings[91], subcount[43])
        regexs[44].sub(r'', strings[91], subcount[44])
        regexs[45].sub(r'', strings[91], subcount[45])
        regexs[46].sub(r'', strings[91], subcount[46])
        regexs[47].sub(r'', strings[91], subcount[47])
        regexs[48].sub(r'', strings[91], subcount[48])
        regexs[39].sub(r'', 'anzr', subcount[39])

        # This prints something different to the V8 version
        # The V8 version is escaping different things in the string that
        # has the substitutions performed on it.
        #
        # V8 treats /\S/ like / + escaped S + /
        # Python treats it like / + \ + S + /
        re.sub(r'\b\w+\b', '', strings[92], 0)

        regexs[39].sub(r'', 'bow-nppbeqvba', subcount[39])
        regexs[39].sub(r'', 'bowrpg', subcount[39])
        regexs[68].sub(r'', 'bowrpg', subcount[68])
        regexs[18].sub(r'', 'bowrpg', subcount[18])
        regexs[29].sub(r'', 'cnenzf%2Rfglyrf', subcount[29])
        regexs[30].sub(r'', 'cnenzf%2Rfglyrf', subcount[30])
        regexs[30].sub(r'', 'cbchc', subcount[30])
        regexs[40].sub(r'', 'ebhgr', subcount[40])
        regexs[41].sub(r'', 'ebhgr', subcount[41])
        regexs[42].sub(r'', 'ebhgr', subcount[42])
        regexs[43].sub(r'', 'ebhgr', subcount[43])
        regexs[44].sub(r'', 'ebhgr', subcount[44])
        regexs[45].sub(r'', 'ebhgr', subcount[45])
        regexs[46].sub(r'', 'ebhgr', subcount[46])
        regexs[47].sub(r'', 'ebhgr', subcount[47])
        regexs[48].sub(r'', 'ebhgr', subcount[48])
        regexs[30].sub(r'', 'freivprobk_uc', subcount[30])
        regexs[30].sub(r'', 'fubccvatobk_uc', subcount[30])
        regexs[39].sub(r'', 'fubhgobk', subcount[39])
        regexs[40].sub(r'', 'fcbeg', subcount[40])
        regexs[41].sub(r'', 'fcbeg', subcount[41])
        regexs[42].sub(r'', 'fcbeg', subcount[42])
        regexs[43].sub(r'', 'fcbeg', subcount[43])
        regexs[44].sub(r'', 'fcbeg', subcount[44])
        regexs[45].sub(r'', 'fcbeg', subcount[45])
        regexs[46].sub(r'', 'fcbeg', subcount[46])
        regexs[47].sub(r'', 'fcbeg', subcount[47])
        regexs[48].sub(r'', 'fcbeg', subcount[48])
        regexs[40].sub(r'', 'gbhe', subcount[40])
        regexs[41].sub(r'', 'gbhe', subcount[41])
        regexs[42].sub(r'', 'gbhe', subcount[42])
        regexs[43].sub(r'', 'gbhe', subcount[43])
        regexs[44].sub(r'', 'gbhe', subcount[44])
        regexs[45].sub(r'', 'gbhe', subcount[45])
        regexs[46].sub(r'', 'gbhe', subcount[46])
        regexs[47].sub(r'', 'gbhe', subcount[47])
        regexs[48].sub(r'', 'gbhe', subcount[48])
        regexs[40].sub(r'', 'gi-fcbg', subcount[40])
        regexs[41].sub(r'', 'gi-fcbg', subcount[41])
        regexs[42].sub(r'', 'gi-fcbg', subcount[42])
        regexs[43].sub(r'', 'gi-fcbg', subcount[43])
        regexs[44].sub(r'', 'gi-fcbg', subcount[44])
        regexs[45].sub(r'', 'gi-fcbg', subcount[45])
        regexs[46].sub(r'', 'gi-fcbg', subcount[46])
        regexs[47].sub(r'', 'gi-fcbg', subcount[47])
        regexs[48].sub(r'', 'gi-fcbg', subcount[48])
        regexs[39].sub(r'', 'glcr', subcount[39])
        re.sub(r'\/', '', 'haqrsvarq', 0)
        regexs[40].sub(r'', strings[93], subcount[40])
        regexs[41].sub(r'', strings[93], subcount[41])
        regexs[42].sub(r'', strings[93], subcount[42])
        regexs[43].sub(r'', strings[93], subcount[43])
        regexs[44].sub(r'', strings[93], subcount[44])
        regexs[45].sub(r'', strings[93], subcount[45])
        regexs[46].sub(r'', strings[93], subcount[46])
        regexs[47].sub(r'', strings[93], subcount[47])
        regexs[48].sub(r'', strings[93], subcount[48])
        regexs[40].sub(r'', 'ivqrb', subcount[40])
        regexs[41].sub(r'', 'ivqrb', subcount[41])
        regexs[42].sub(r'', 'ivqrb', subcount[42])
        regexs[43].sub(r'', 'ivqrb', subcount[43])
        regexs[44].sub(r'', 'ivqrb', subcount[44])
        regexs[45].sub(r'', 'ivqrb', subcount[45])
        regexs[46].sub(r'', 'ivqrb', subcount[46])
        regexs[47].sub(r'', 'ivqrb', subcount[47])
        regexs[48].sub(r'', 'ivqrb', subcount[48])
        regexs[86].split(r'ivfvgf=1')
        regexs[40].sub(r'', 'jrggre', subcount[40])
        regexs[41].sub(r'', 'jrggre', subcount[41])
        regexs[42].sub(r'', 'jrggre', subcount[42])
        regexs[43].sub(r'', 'jrggre', subcount[43])
        regexs[44].sub(r'', 'jrggre', subcount[44])
        regexs[45].sub(r'', 'jrggre', subcount[45])
        regexs[46].sub(r'', 'jrggre', subcount[46])
        regexs[47].sub(r'', 'jrggre', subcount[47])
        regexs[48].sub(r'', 'jrggre', subcount[48])
        re.search(r'#[a-z0-9]+$',
                  'uggc://jjj.fpuhryreim.arg/Qrsnhyg', re.IGNORECASE)
        regexs[66].search(r'fryrpgrq')
        re.search(r'(?:^|\s+)lhv-ani(?:\s+|$)', 'sff lhv-ani')
        re.search(r'(?:^|\s+)lhv-anifrg(?:\s+|$)', 'zrqvnzbqgno lhv-anifrg')
        re.search(r'(?:^|\s+)lhv-anifrg-gbc(?:\s+|$)',
                  'zrqvnzbqgno lhv-anifrg')
        regexs[91].search(r'GnoThvq')
        regexs[91].search(r'thvq')
        re.search(r'(pbzcngvoyr|jroxvg)', strings[63])
        re.search(r'.+(?:ei|vg|en|vr)[\/: ]([\d.]+)', strings[63])
        regexs[8].search(r'144631658.0.10.1231365869')
        regexs[8].search(r'144631658.0.10.1231367054')
        regexs[8].search(
            r'144631658.1231365869.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.1231367054.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'144631658.1670816052019209000.1231365869.1231365869.1231365869.1')
        regexs[8].search(
            r'144631658.1796080716621419500.1231367054.1231367054.1231367054.1')
        regexs[8].search(strings[94])
        regexs[8].search(strings[95])
        regexs[8].search(strings[96])
        regexs[8].search(strings[97])
        regexs[8].search(
            r'__hgzn=144631658.1670816052019209000.1231365869.1231365869.1231365869.1')
        regexs[8].search(
            r'__hgzn=144631658.1796080716621419500.1231367054.1231367054.1231367054.1')
        regexs[8].search(r'__hgzo=144631658.0.10.1231365869')
        regexs[8].search(r'__hgzo=144631658.0.10.1231367054')
        regexs[8].search(
            r'__hgzm=144631658.1231365869.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[8].search(
            r'__hgzm=144631658.1231367054.1.1.hgzpfe=(qverpg)|hgzppa=(qverpg)|hgzpzq=(abar)')
        regexs[34].search(strings[78])
        regexs[34].search(strings[79])
        regexs[34].search(strings[81])
        regexs[74].search(strings[77])
        regexs[74].search(r'*')
        regexs[74].search(strings[82])
        regexs[74].search(strings[83])
        regexs[74].search(strings[86])
        regexs[74].search(r'rzorq')
        regexs[74].search(r'sbez.nwnk')
        regexs[74].search(strings[90])
        regexs[74].search(r'bowrpg')
        re.search(r'\/onfr.wf(\?.+)?$',
                  '/uggc://wf.hv-cbegny.qr/tzk/ubzr/wf/20080602/onfr.wf')
        regexs[28].search(r'uvag ynfgUvag ynfg')
        regexs[75].search(r'')
        regexs[76].search(r'')
        regexs[77].search(r'')
        regexs[78].search(r'')
        regexs[80].search(strings[77])
        regexs[80].search(r'*')
        regexs[80].search(r'.pybfr')
        regexs[80].search(strings[82])
        regexs[80].search(strings[83])
        regexs[80].search(strings[84])
        regexs[80].search(strings[86])
        regexs[80].search(r'qg')
        regexs[80].search(r'rzorq')
        regexs[80].search(r'sbez.nwnk')
        regexs[80].search(strings[90])
        regexs[80].search(r'bowrpg')
        regexs[61].search(r'qlaYvo.wf')
        regexs[61].search(r'rssrpgYvo.wf')
        regexs[61].search(r'uggc://jjj.tzk.arg/qr/?fgnghf=uvajrvf')
        regexs[92].search(r' .pybfr')
        regexs[92].search(r' n.svryqOgaPnapry')
        regexs[92].search(r' qg')
        regexs[92].search(strings[48])
        regexs[92].search(r'.nwnk')
        regexs[92].search(r'.svryqOga,n.svryqOgaPnapry')
        regexs[92].search(r'.svryqOgaPnapry')
        regexs[92].search(r'.bow-nppbeqvba qg')
        regexs[68].search(strings[77])
        regexs[68].search(r'*')
        regexs[68].search(r'.pybfr')
        regexs[68].search(strings[82])
        regexs[68].search(strings[83])
        regexs[68].search(strings[84])
        regexs[68].search(strings[86])
        regexs[68].search(r'qg')
        regexs[68].search(r'rzorq')
        regexs[68].search(r'sbez.nwnk')
        regexs[68].search(strings[90])
        regexs[68].search(r'bowrpg')
        regexs[93].search(r' .pybfr')
        regexs[93].search(r' n.svryqOgaPnapry')
        regexs[93].search(r' qg')
        regexs[93].search(strings[48])
        regexs[93].search(r'.nwnk')
        regexs[93].search(r'.svryqOga,n.svryqOgaPnapry')
        regexs[93].search(r'.svryqOgaPnapry')
        regexs[93].search(r'.bow-nppbeqvba qg')
        regexs[81].search(strings[77])
        regexs[81].search(r'*')
        regexs[81].search(strings[48])
        regexs[81].search(r'.pybfr')
        regexs[81].search(strings[82])
        regexs[81].search(strings[83])
        regexs[81].search(strings[84])
        regexs[81].search(strings[86])
        regexs[81].search(r'qg')
        regexs[81].search(r'rzorq')
        regexs[81].search(r'sbez.nwnk')
        regexs[81].search(strings[90])
        regexs[81].search(r'bowrpg')
        regexs[94].search(r' .pybfr')
        regexs[94].search(r' n.svryqOgaPnapry')
        regexs[94].search(r' qg')
        regexs[94].search(strings[48])
        regexs[94].search(r'.nwnk')
        regexs[94].search(r'.svryqOga,n.svryqOgaPnapry')
        regexs[94].search(r'.svryqOgaPnapry')
        regexs[94].search(r'.bow-nppbeqvba qg')
        regexs[94].search(r'[anzr=nwnkHey]')
        regexs[94].search(strings[82])
        regexs[31].search(r'rf')
        regexs[31].search(r'wn')
        regexs[82].search(strings[77])
        regexs[82].search(r'*')
        regexs[82].search(strings[48])
        regexs[82].search(r'.pybfr')
        regexs[82].search(strings[82])
        regexs[82].search(strings[83])
        regexs[82].search(strings[84])
        regexs[82].search(strings[86])
        regexs[82].search(r'qg')
        regexs[82].search(r'rzorq')
        regexs[82].search(r'sbez.nwnk')
        regexs[82].search(strings[90])
        regexs[82].search(r'bowrpg')
        regexs[83].search(strings[98])
        regexs[83].search(r'shapgvba sbphf() { [angvir pbqr] }')
        regexs[62].search(r'#Ybtva')
        regexs[62].search(r'#Ybtva_cnffjbeq')
        regexs[62].search(strings[77])
        regexs[62].search(r'#fubhgobkWf')
        regexs[62].search(r'#fubhgobkWfReebe')
        regexs[62].search(r'#fubhgobkWfFhpprff')
        regexs[62].search(r'*')
        regexs[62].search(strings[82])
        regexs[62].search(strings[83])
        regexs[62].search(strings[86])
        regexs[62].search(r'rzorq')
        regexs[62].search(r'sbez.nwnk')
        regexs[62].search(strings[90])
        regexs[62].search(r'bowrpg')
        regexs[49].search(r'pbagrag')
        regexs[24].search(strings[6])
        re.search(r'xbadhrebe', strings[63])
        re.search(r'znp', 'jva32')
        re.search(r'zbmvyyn', strings[63])
        re.search(r'zfvr', strings[63])
        re.search(r'ag\s5\.1', strings[63])
        re.search(r'bcren', strings[63])
        re.search(r'fnsnev', strings[63])
        re.search(r'jva', 'jva32')
        re.search(r'jvaqbjf', strings[63])


def bench_regex_v8(loops):
    t0 = pyperf.perf_counter()
    for loops in range(loops):
        block0()
        block1()
        block2()
        block3()
        block4()
        block5()
        block6()
        block7()
        block8()
        block9()
        block10()
        block11()
    return pyperf.perf_counter() - t0


if __name__ == '__main__':
    runner = pyperf.Runner()
    runner.metadata['description'] = ("Test the performance of regexps "
                                      "using V8's benchmarks")
    runner.bench_time_func('regex_v8', bench_regex_v8)
