.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_exec" "" "2007-09-16" "" "PostgreSQL 7.4.18 Documentation"
.SH NAME
SPI_exec \- execute a command

.SH SYNOPSIS
.sp
.nf
int SPI_exec(const char * \fIcommand\fR, int \fIcount\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_exec\fR executes the specified SQL command
for \fIcount\fR rows.
.PP
This function should only be called from a connected procedure. If
\fIcount\fR is zero then it executes the command
for all rows that it applies to. If \fIcount\fR
is greater than 0, then the number of rows for which the command
will be executed is restricted (much like a
LIMIT clause). For example,
.sp
.nf
SPI_exec("INSERT INTO tab SELECT * FROM tab", 5);
.sp
.fi
will allow at most 5 rows to be inserted into the table.
.PP
You may pass multiple commands in one string, and the command may
be rewritten by rules. \fBSPI_exec\fR returns the
result for the command executed last.
.PP
The actual number of rows for which the (last) command was executed
is returned in the global variable SPI_processed
(unless the return value of the function is
\fBSPI_OK_UTILITY\fR). If the return value of the
function is \fBSPI_OK_SELECT\fR then you may the use
global pointer SPITupleTable *SPI_tuptable to
access the result rows.
.PP
The structure \fBSPITupleTable\fR is defined
thus:
.sp
.nf
typedef struct
{
    MemoryContext tuptabcxt;    /* memory context of result table */
    uint32      alloced;        /* number of alloced vals */
    uint32      free;           /* number of free vals */
    TupleDesc   tupdesc;        /* row descriptor */
    HeapTuple  *vals;           /* rows */
} SPITupleTable;
.sp
.fi
\fBvals\fR is an array of pointers to rows. (The number
of valid entries is given by SPI_processed).
\fBtupdesc\fR is a row descriptor which you may pass to
SPI functions dealing with rows. \fBtuptabcxt\fR,
\fBalloced\fR, and \fBfree\fR are internal
fields not intended for use by SPI callers.
.PP
\fBSPI_finish\fR frees all
\fBSPITupleTable\fRs allocated during the current
procedure. You can free a particular result table earlier, if you
are done with it, by calling \fBSPI_freetuptable\fR.
.SH "ARGUMENTS"
.TP
\fBconst char * \fIcommand\fB\fR
string containing command to execute
.TP
\fBint \fIcount\fB\fR
maximum number of rows to process or return
.SH "RETURN VALUE"
.PP
If the execution of the command was successful then one of the
following (nonnegative) values will be returned:
.TP
\fBSPI_OK_SELECT\fR
if a \fBSELECT\fR (but not \fBSELECT
\&... INTO\fR) was executed
.TP
\fBSPI_OK_SELINTO\fR
if a \fBSELECT ... INTO\fR was executed
.TP
\fBSPI_OK_DELETE\fR
if a \fBDELETE\fR was executed
.TP
\fBSPI_OK_INSERT\fR
if an \fBINSERT\fR was executed
.TP
\fBSPI_OK_UPDATE\fR
if an \fBUPDATE\fR was executed
.TP
\fBSPI_OK_UTILITY\fR
if a utility command (e.g., \fBCREATE TABLE\fR)
was executed
.PP
.PP
On error, one of the following negative values is returned:
.TP
\fBSPI_ERROR_ARGUMENT\fR
if \fIcommand\fR is \fBNULL\fR or
\fIcount\fR is less than 0
.TP
\fBSPI_ERROR_COPY\fR
if \fBCOPY TO stdout\fR or \fBCOPY FROM stdin\fR
was attempted
.TP
\fBSPI_ERROR_CURSOR\fR
if \fBDECLARE\fR, \fBCLOSE\fR, or \fBFETCH\fR
was attempted
.TP
\fBSPI_ERROR_TRANSACTION\fR
if \fBBEGIN\fR, \fBCOMMIT\fR, or
\fBROLLBACK\fR was attempted
.TP
\fBSPI_ERROR_OPUNKNOWN\fR
if the command type is unknown (shouldn't happen)
.TP
\fBSPI_ERROR_UNCONNECTED\fR
if called from an unconnected procedure
.PP
.SH "NOTES"
.PP
The functions \fBSPI_exec\fR,
\fBSPI_execp\fR, and
\fBSPI_prepare\fR change both
SPI_processed and
SPI_tuptable (just the pointer, not the contents
of the structure). Save these two global variables into local
procedure variables if you need to access the result of
\fBSPI_exec\fR or \fBSPI_execp\fR
across later calls.
