.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER SEQUENCE" "" "2010-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER SEQUENCE \- alter the definition of a sequence generator

.SH SYNOPSIS
.sp
.nf
ALTER SEQUENCE \fIname\fR [ INCREMENT [ BY ] \fIincrement\fR ]
    [ MINVALUE \fIminvalue\fR | NO MINVALUE ] [ MAXVALUE \fImaxvalue\fR | NO MAXVALUE ]
    [ RESTART [ WITH ] \fIstart\fR ] [ CACHE \fIcache\fR ] [ [ NO ] CYCLE ]
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER SEQUENCE\fR changes the parameters of an existing
sequence generator. Any parameter not specifically set in the
\fBALTER SEQUENCE\fR command retains its prior setting.
.SH "PARAMETERS"
.PP
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of a sequence to be altered.
.TP
\fB\fIincrement\fB\fR
The clause INCREMENT BY \fIincrement\fR is
optional. A positive value will make an ascending sequence, a
negative one a descending sequence. If unspecified, the old
increment value will be maintained.
.TP
\fB\fIminvalue\fB\fR
.TP
\fBNO MINVALUE\fR
The optional clause MINVALUE \fIminvalue\fR determines
the minimum value a sequence can generate. If NO
MINVALUE is specified, the defaults of 1 and
-263-1 for ascending and descending sequences,
respectively, will be used. If neither option is specified,
the current minimum value will be maintained.
.TP
\fB\fImaxvalue\fB\fR
.TP
\fBNO MAXVALUE\fR
The optional clause MAXVALUE \fImaxvalue\fR determines
the maximum value for the sequence. If NO
MAXVALUE is specified, the defaults are
263-1 and -1 for ascending and descending
sequences, respectively, will be used. If neither option is
specified, the current maximum value will be maintained.
.TP
\fB\fIstart\fB\fR
The optional clause RESTART WITH \fIstart\fR changes the
current value of the sequence.
.TP
\fB\fIcache\fB\fR
The clause CACHE \fIcache\fR enables
sequence numbers to be preallocated and stored in memory for
faster access. The minimum value is 1 (only one value can be
generated at a time, i.e., no cache). If unspecified, the old
cache value will be maintained.
.TP
\fBCYCLE\fR
The optional CYCLE key word may be used to enable
the sequence to wrap around when the
\fImaxvalue\fR or
\fIminvalue\fR has been
reached by
an ascending or descending sequence respectively. If the limit is
reached, the next number generated will be the
\fIminvalue\fR or
\fImaxvalue\fR,
respectively.
.TP
\fBNO CYCLE\fR
If the optional NO CYCLE key word is
specified, any calls to \fBnextval\fR after the
sequence has reached its maximum value will return an error.
If neither CYCLE or NO
CYCLE are specified, the old cycle behaviour will be
maintained.
.PP
.SH "EXAMPLES"
.PP
Restart a sequence called serial, at 105:
.sp
.nf
ALTER SEQUENCE serial RESTART WITH 105;
.sp
.fi
.SH "NOTES"
.PP
To avoid blocking of concurrent transactions that obtain numbers from the
same sequence, \fBALTER SEQUENCE\fR is never rolled back;
the changes take effect immediately and are not reversible.
.PP
\fBALTER SEQUENCE\fR will not immediately affect
nextval results in backends,
other than the current one, that have preallocated (cached) sequence
values. They will use up all cached values prior to noticing the changed
sequence parameters. The current backend will be affected immediately.
.SH "COMPATIBILITY"
.SS "SQL99"
.PP
\fBALTER SEQUENCE\fR is a PostgreSQL
language extension.
There is no \fBALTER SEQUENCE\fR statement
in SQL99.
