.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER GROUP" "" "2008-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER GROUP \- change a user group

.SH SYNOPSIS
.sp
.nf
ALTER GROUP \fIgroupname\fR ADD USER \fIusername\fR [, ... ]
ALTER GROUP \fIgroupname\fR DROP USER \fIusername\fR [, ... ]

ALTER GROUP \fIgroupname\fR RENAME TO \fInewname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER GROUP\fR changes the attributes of a user group.
.PP
The first two variants add users to a group or remove them from a group.
Only database superusers can use this command.
.PP
The third variant changes the name of the group. Only a database
superuser can rename groups.
.SH "PARAMETERS"
.TP
\fB\fIgroupname\fB\fR
The name of the group to modify.
.TP
\fB\fIusername\fB\fR
Users that are to be added to or removed from the group. The users
must already exist; \fBALTER GROUP\fR does not create or
drop users.
.TP
\fB\fInewname\fB\fR
The new name of the group.
.SH "EXAMPLES"
.PP
Add users to a group:
.sp
.nf
ALTER GROUP staff ADD USER karl, john;
.sp
.fi
Remove a user from a group:
.sp
.nf
ALTER GROUP workers DROP USER beth;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER GROUP\fR statement in the SQL
standard. The concept of roles is similar.
.SH "SEE ALSO"
CREATE GROUP [\fBcreate_group\fR(l)], DROP GROUP [\fBdrop_group\fR(l)]
