.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "VACUUM" "" "2008-10-31" "SQL - Language Statements" "SQL Commands"
.SH NAME
VACUUM \- garbage-collect and optionally analyze a database

.SH SYNOPSIS
.sp
.nf
VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] [ \fItable\fR ]
VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] ANALYZE [ \fItable\fR [ (\fIcolumn\fR [, ...] ) ] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBVACUUM\fR reclaims storage occupied by deleted tuples.
In normal PostgreSQL operation, tuples that
are deleted or obsoleted by an update are not physically removed from
their table; they remain present until a \fBVACUUM\fR is
done. Therefore it's necessary to do \fBVACUUM\fR
periodically, especially on frequently-updated tables.
.PP
With no parameter, \fBVACUUM\fR processes every table in the
current database. With a parameter, \fBVACUUM\fR processes
only that table.
.PP
\fBVACUUM ANALYZE\fR performs a \fBVACUUM\fR
and then an \fBANALYZE\fR for each selected table. This
is a handy combination form for routine maintenance scripts. See
ANALYZE [\fBanalyze\fR(l)]
for more details about its processing.
.PP
Plain \fBVACUUM\fR (without FULL) simply reclaims
space and makes it
available for re-use. This form of the command can operate in parallel
with normal reading and writing of the table, as an exclusive lock
is not obtained. \fBVACUUM
FULL\fR does more extensive processing, including moving of tuples
across blocks to try to compact the table to the minimum number of disk
blocks. This form is much slower and requires an exclusive lock on each
table while it is being processed.
.SH "PARAMETERS"
.TP
\fBFULL\fR
Selects ``full'' vacuum, which may reclaim more
space, but takes much longer and exclusively locks the table.
.TP
\fBFREEZE\fR
Selects aggressive ``freezing'' of tuples.
Specifying FREEZE is equivalent to performing
\fBVACUUM\fR with the
vacuum_freeze_min_age parameter
set to zero. The FREEZE option is deprecated and
will be removed in a future release; set the parameter instead.
.TP
\fBVERBOSE\fR
Prints a detailed vacuum activity report for each table.
.TP
\fBANALYZE\fR
Updates statistics used by the planner to determine the most
efficient way to execute a query.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of a specific table to
vacuum. Defaults to all tables in the current database.
.TP
\fB\fIcolumn\fB\fR
The name of a specific column to analyze. Defaults to all columns.
.SH "OUTPUTS"
.PP
When VERBOSE is specified, \fBVACUUM\fR emits
progress messages to indicate which table is currently being
processed. Various statistics about the tables are printed as well.
.SH "NOTES"
.PP
\fBVACUUM\fR cannot be executed inside a transaction block.
.PP
We recommend that active production databases be
vacuumed frequently (at least nightly), in order to
remove expired rows. After adding or deleting a large number
of rows, it may be a good idea to issue a \fBVACUUM
ANALYZE\fR command for the affected table. This will update the
system catalogs with
the results of all recent changes, and allow the
PostgreSQL query planner to make better
choices in planning queries.
.PP
The \fBFULL\fR option is not recommended for routine use,
but may be useful in special cases. An example is when you have deleted
most of the rows in a table and would like the table to physically shrink
to occupy less disk space. \fBVACUUM FULL\fR will usually
shrink the table more than a plain \fBVACUUM\fR would.
The \fBFULL\fR option does not shrink indexes; a periodic
\fBREINDEX\fR is still recommended. In fact, it is often faster
to drop all indexes, \fBVACUUM FULL\fR, and recreate the indexes.
.PP
\fBVACUUM\fR causes a substantial increase in I/O traffic,
which can cause poor performance for other active sessions. Therefore,
it is sometimes advisable to use the cost-based vacuum delay feature.
See in the documentation for details.
.PP
PostgreSQL includes an ``autovacuum''
facility which can automate routine vacuum maintenance. For more
information about automatic and manual vacuuming, see
in the documentation.
.SH "EXAMPLES"
.PP
The following is an example from running \fBVACUUM\fR on a
table in the regression database:
.sp
.nf
regression=# VACUUM VERBOSE ANALYZE onek;
INFO:  vacuuming "public.onek"
INFO:  index "onek_unique1" now contains 1000 tuples in 14 pages
DETAIL:  3000 index tuples were removed.
0 index pages have been deleted, 0 are currently reusable.
CPU 0.01s/0.08u sec elapsed 0.18 sec.
INFO:  index "onek_unique2" now contains 1000 tuples in 16 pages
DETAIL:  3000 index tuples were removed.
0 index pages have been deleted, 0 are currently reusable.
CPU 0.00s/0.07u sec elapsed 0.23 sec.
INFO:  index "onek_hundred" now contains 1000 tuples in 13 pages
DETAIL:  3000 index tuples were removed.
0 index pages have been deleted, 0 are currently reusable.
CPU 0.01s/0.08u sec elapsed 0.17 sec.
INFO:  index "onek_stringu1" now contains 1000 tuples in 48 pages
DETAIL:  3000 index tuples were removed.
0 index pages have been deleted, 0 are currently reusable.
CPU 0.01s/0.09u sec elapsed 0.59 sec.
INFO:  "onek": removed 3000 tuples in 108 pages
DETAIL:  CPU 0.01s/0.06u sec elapsed 0.07 sec.
INFO:  "onek": found 3000 removable, 1000 nonremovable tuples in 143 pages
DETAIL:  0 dead tuples cannot be removed yet.
There were 0 unused item pointers.
0 pages are entirely empty.
CPU 0.07s/0.39u sec elapsed 1.56 sec.
INFO:  analyzing "public.onek"
INFO:  "onek": 36 pages, 1000 rows sampled, 1000 estimated total rows
VACUUM
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBVACUUM\fR statement in the SQL standard.
.SH "SEE ALSO"
vacuumdb [\fBvacuumdb\fR(1)], in the documentation
