.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TABLE AS" "" "2011-04-15" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE AS \- define a new table from the results of a query

.SH SYNOPSIS
.sp
.nf
CREATE [ [ GLOBAL | LOCAL ] { TEMPORARY | TEMP } ] TABLE \fItable_name\fR
    [ (\fIcolumn_name\fR [, ...] ) ]
    [ WITH ( \fIstorage_parameter\fR [= \fIvalue\fR] [, ... ] ) | WITH OIDS | WITHOUT OIDS ]
    [ ON COMMIT { PRESERVE ROWS | DELETE ROWS | DROP } ]
    [ TABLESPACE \fItablespace\fR ]
    AS \fIquery\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE AS\fR creates a table and fills it
with data computed by a \fBSELECT\fR command.
The table columns have the
names and data types associated with the output columns of the
\fBSELECT\fR (except that you can override the column
names by giving an explicit list of new column names).
.PP
\fBCREATE TABLE AS\fR bears some resemblance to
creating a view, but it is really quite different: it creates a new
table and evaluates the query just once to fill the new table
initially. The new table will not track subsequent changes to the
source tables of the query. In contrast, a view re-evaluates its
defining \fBSELECT\fR statement whenever it is
queried.
.SH "PARAMETERS"
.TP
\fBGLOBAL or LOCAL\fR
Ignored for compatibility. Refer to CREATE TABLE [\fBcreate_table\fR(l)] for
details.
.PP
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created as a temporary table.
Refer to CREATE TABLE [\fBcreate_table\fR(l)] for details.
.TP
\fB\fItable_name\fB\fR
The name (optionally schema-qualified) of the table to be created.
.TP
\fB\fIcolumn_name\fB\fR
The name of a column in the new table. If column names are not
provided, they are taken from the output column names of the
query. If the table is created from an
\fBEXECUTE\fR command, a column name list cannot be
specified.
.TP
\fBWITH ( \fIstorage_parameter\fB [= \fIvalue\fB] [, ... ] )\fR
This clause specifies optional storage parameters for the new table;
see Storage Parameters [\fBcreate_table\fR(l)] for more
information. The WITH clause
can also include OIDS=TRUE (or just OIDS)
to specify that rows of the new table
should have OIDs (object identifiers) assigned to them, or
OIDS=FALSE to specify that the rows should not have OIDs.
See CREATE TABLE [\fBcreate_table\fR(l)] for more information.
.TP
\fBWITH OIDS\fR
.TP
\fBWITHOUT OIDS\fR
These are obsolescent syntaxes equivalent to WITH (OIDS)
and WITH (OIDS=FALSE), respectively. If you wish to give
both an OIDS setting and storage parameters, you must use
the WITH ( ... ) syntax; see above.
.TP
\fBON COMMIT\fR
The behavior of temporary tables at the end of a transaction
block can be controlled using ON COMMIT.
The three options are:
.RS
.TP
\fBPRESERVE ROWS\fR
No special action is taken at the ends of transactions.
This is the default behavior.
.TP
\fBDELETE ROWS\fR
All rows in the temporary table will be deleted at the end
of each transaction block. Essentially, an automatic TRUNCATE [\fBtruncate\fR(l)] is done
at each commit.
.TP
\fBDROP\fR
The temporary table will be dropped at the end of the current
transaction block.
.RE
.PP
.TP
\fBTABLESPACE \fItablespace\fB\fR
The \fItablespace\fR is the name
of the tablespace in which the new table is to be created.
If not specified,
default_tablespace is consulted, or
temp_tablespaces if the table is temporary.
.TP
\fB\fIquery\fB\fR
A SELECT [\fBselect\fR(l)] or
VALUES [\fBvalues\fR(l)] command,
or an EXECUTE [\fBexecute\fR(l)] command
that runs a prepared \fBSELECT\fR or \fBVALUES\fR query.
.SH "NOTES"
.PP
This command is functionally similar to SELECT INTO [\fBselect_into\fR(l)], but it is
preferred since it is less likely to be confused with other uses of
the \fBSELECT INTO\fR syntax. Furthermore, \fBCREATE
TABLE AS\fR offers a superset of the functionality offered
by \fBSELECT INTO\fR.
.PP
Prior to PostgreSQL 8.0, \fBCREATE
TABLE AS\fR always included OIDs in the table it
created. As of PostgreSQL 8.0,
the \fBCREATE TABLE AS\fR command allows the user to
explicitly specify whether OIDs should be included. If the
presence of OIDs is not explicitly specified,
the default_with_oids configuration variable is
used. As of PostgreSQL 8.1,
this variable is false by default, so the default behavior is not
identical to pre-8.0 releases. Applications that
require OIDs in the table created by \fBCREATE TABLE
AS\fR should explicitly specify WITH (OIDS)
to ensure proper behavior.
.SH "EXAMPLES"
.PP
Create a new table films_recent consisting of only
recent entries from the table films:
.sp
.nf
CREATE TABLE films_recent AS
  SELECT * FROM films WHERE date_prod >= '2002-01-01';
.sp
.fi
.PP
Create a new temporary table films_recent, consisting of
only recent entries from the table films, using a
prepared statement. The new table has OIDs and will be dropped at commit:
.sp
.nf
PREPARE recentfilms(date) AS
  SELECT * FROM films WHERE date_prod > $1;
CREATE TEMP TABLE films_recent WITH (OIDS) ON COMMIT DROP AS
  EXECUTE recentfilms('2002-01-01');
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE TABLE AS\fR conforms to the SQL
standard, with the following exceptions:
.TP 0.2i
\(bu
The standard requires parentheses around the subquery clause; in
PostgreSQL, these parentheses are
optional.
.TP 0.2i
\(bu
The standard defines a WITH [ NO ] DATA clause;
this is not currently implemented by PostgreSQL.
The behavior provided by PostgreSQL is equivalent
to the standard's WITH DATA case.
WITH NO DATA can be simulated by appending
LIMIT 0 to the query.
.TP 0.2i
\(bu
PostgreSQL handles temporary tables in a way
rather different from the standard; see
CREATE TABLE [\fBcreate_table\fR(l)]
for details.
.TP 0.2i
\(bu
The WITH clause is a PostgreSQL
extension; neither storage parameters nor OIDs are in the standard.
.TP 0.2i
\(bu
The PostgreSQL concept of tablespaces is not
part of the standard. Hence, the clause TABLESPACE
is an extension.
.PP
.SH "SEE ALSO"
CREATE TABLE [\fBcreate_table\fR(l)], EXECUTE [\fBexecute\fR(l)], SELECT [\fBselect\fR(l)], SELECT INTO [\fBselect_into\fR(l)], VALUES [\fBvalues\fR(l)]
