/*
*
*   Copyright (c) 2001-2002, Biswapesh Chattopadhyay
*
*   This source code is released for free distribution under the terms of the
*   GNU General Public License.
*
*/

#ifndef TM_TAGMANAGER_H
#define TM_TAGMANAGER_H

#include "tm_tag.h"
#include "tm_symbol.h"
#include "tm_file_entry.h"
#include "tm_workspace.h"
#include "tm_work_object.h"
#include "tm_source_file.h"
#include "tm_project.h"
#include "tm_parser.h"

/*! \mainpage Introduction
 \section Introduction
 TagManager is a library and a set of utility programs which can be integrated into
 Integrated Development Environments to provide features such as code completion,
 calltips, etc. Tag Manager is based on <a href="http://ctags.sourceforge.net">
 Exuberent Ctags</a> with some added features.
 \section Licence
 TagManager is <a href="http://www.gnu.org/philosophy/free-sw.html">free software</a>,
 licenced under the <a href="http://www.gnu.org/licenses/gpl.html">GPL</a>. You can only
 use it with free software (GPL compatible) projects. This is chiefly because it uses
 code from ctags which is under GPL.
*/

/*! \file
 Include this file in all programs using the tag manager library. Including this
 automatically includes all the necessary files, namely, tm_tag.h, tm_source_file.h
 , tm_project.h and tm_workspace.h
*/

#endif /* TM_TAGMANAGER_H */
