/* widgets.h */
/* header file for widgets.c */
/*
  gtkfind - a graphical "find" program
  Copyright (C) 1999  Matthew Grossman <mattg@oz.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef WIDGETS_H
#define WIDGETS_H

/*********************/
/* includes          */

#include<string.h>
#include<gtk/gtk.h>

/* reported needed on a debian system */
#include<X11/Xos.h>

#include<time.h>
#ifdef TM_IN_SYS_TIME
#include<sys/time.h>
#endif

#include<sys/types.h>
#include<sys/wait.h>

#include"create.h"
#include"save.h"
#include"util.h"
#include"config.h"
#include"flags.h"

#ifdef HAVE_ALLOCA_H
#include<alloca.h>
#endif /* HAVE_ALLOCA_H */

/*********************/
/* globals           */

/* unfortunately, there are rather more of these than one would like */

GtkWidget *toplevel; /* the toplevel widget */

GtkWidget *directory; /* the directory to search in */

GtkWidget *pattern;  /* the file pattern to search for */
GtkWidget *content_pattern; /* match on a string in a file */

GtkWidget *shell_command; /* if we run a shell command, this is it */

GtkWidget *login_entry;
GtkWidget *group_entry;

GtkWidget *atime_day_spin, *atime_month_spin, *atime_year_spin,
  *atime_hour_spin, *atime_minute_spin, *atime_second_spin;

GtkWidget *mtime_day_spin, *mtime_month_spin, *mtime_year_spin,
  *mtime_hour_spin, *mtime_minute_spin, *mtime_second_spin;

GtkWidget *ctime_day_spin, *ctime_month_spin, *ctime_year_spin,
  *ctime_hour_spin, *ctime_minute_spin, *ctime_second_spin;

GtkWidget *stop_button;

int stop_flag;

/*********************/
/* externs           */

extern void quit(gpointer *quit_button);
extern void find(gpointer *find_button, gpointer *pattern);
extern void print_error(const char *format, ...);

/*********************/
/* prototypes        */


void make_widgets();
void make_button_widgets(GtkWidget *parent);
void make_notebook_widgets(GtkWidget *parent);

void make_match_contents_widgets(GtkWidget *notebook);
void make_match_filename_widgets(GtkWidget *notebook);
void make_match_atime_widgets(GtkWidget *notebook);
void make_match_ctime_widgets(GtkWidget *notebook);
void make_match_mtime_widgets(GtkWidget *notebook);
void make_match_mode_widgets(GtkWidget *notebook);
void make_match_type_widgets(GtkWidget *notebook);
void make_match_login_widgets(GtkWidget *notebook);

void make_directory_widgets(GtkWidget *parent);
void make_shell_widgets(GtkWidget *parent);

void print_filename_anyway_toggle_callback();
void search_subdirs_toggle_callback();
void regexp_toggle_callback();
void shell_command_toggle_callback();
void print_to_stdout_toggle_callback();
void print_to_window_toggle_callback();

void owner_read_toggle_callback();
void group_read_toggle_callback();
void world_read_toggle_callback();

void owner_write_toggle_callback();
void group_write_toggle_callback();
void world_write_toggle_callback();

void owner_exec_toggle_callback();
void group_exec_toggle_callback();
void world_exec_toggle_callback();

void setuid_toggle_callback();
void setgid_toggle_callback();
void sticky_toggle_callback();

void directory_toggle_callback();
void regular_toggle_callback();

void raw_device_toggle_callback();
void block_device_toggle_callback();
void symlink_toggle_callback();
void socket_toggle_callback();
void fifo_toggle_callback();

void uid_not_login_toggle_callback();
void gid_not_group_toggle_callback();

void atime_eq_toggle_callback();
void atime_et_toggle_callback();
void atime_lt_toggle_callback();

void mtime_eq_toggle_callback();
void mtime_et_toggle_callback();
void mtime_lt_toggle_callback();

void ctime_eq_toggle_callback();
void ctime_et_toggle_callback();
void ctime_lt_toggle_callback();

void find_directory_callback();
void filesel_ok_callback(GtkWidget *w, GtkFileSelection *filesel);
void filesel_cancel_callback(GtkWidget *w, GtkFileSelection *filesel);

GtkWidget *make_spin_button(float *default_value, float min_value,
			    float max_value);

void make_all_spinners(GtkWidget *parent, 
		       GtkWidget **day, GtkWidget **month, GtkWidget **year,
		       GtkWidget **hour, GtkWidget **minute,
		       GtkWidget **second);

void get_current_mdy(gfloat *current_day, gfloat *current_month,
		     gfloat *current_year);

void clear_find_callback();
void reset_widget(GtkWidget *widget, gpointer callback_data);

void reset_entry(GtkWidget *widget);
void reset_toggle_button_up(GtkWidget *widget);
void reset_toggle_button_down(GtkWidget *widget);
void reset_time_spin_button(GtkWidget *widget);

void output_format_toggle_callback();

void stop_find_callback();

void content_search_toggle_callback();
void filename_match_toggle_callback();

void year_changed_callback(GtkWidget *widget, gpointer callback_data);
void month_changed_callback(GtkWidget *widget, gpointer callback_data);

void help_callback();
void save_search_callback();
void save_search_ok(GtkWidget *w, GtkFileSelection *filesel);
void save_search_cancel(GtkWidget *w, GtkFileSelection *filesel);

void nouser_toggle_callback();
void nogroup_toggle_callback();

#endif /* !WIDGETS_H */
