using System;
using System.Text.RegularExpressions;
using NUnit.Framework;

namespace MonoTests.System.Text.RegularExpressions
{
	[TestFixture]
	public class RegexBugs2
	{		
		[Test]
		public void BugXamarin7578 ()
		{			
			string testData = @"\id aaaaaaaaaaaaaaaaa







\Q 2 DzPOIS, DzU À LUZ z zBzL, SzU IRMÃO. zBzL FOI PzSTOR Dz OVzLHzS, z CzIM, LzVRzDOR.
\Q 3 zCONTzCzU QUz NO FIM Dz UNS TzMPOS TROUXz CzIM DO FRUTO Dz TzRRz UMz OFzRTz zO \ND SzNHOR\ND*.
\Q 4 zBzL, POR SUz VzZ, TROUXz\X z \XO 4.4 \XT HB 11.4\X* DzS PRIMÍCIzS DO SzU RzBzNHO z Dz GORDURz DzSTz. zGRzDOU-Sz O \ND SzNHOR\ND* Dz zBzL z Dz SUz OFzRTz;
\Q 5 zO PzSSO QUz Dz CzIM z Dz SUz OFzRTz NÃO Sz zGRzDOU. IROU-Sz, POIS, SOBRzMzNzIRz, CzIM, z DzSCzIU-LHz O SzMBLzNTz.
\Q 6 zNTÃO, LHz DISSz O \ND SzNHOR\ND*: POR QUz zNDzS IRzDO, z POR QUz DzSCzIU O TzU SzMBLzNTz?\FIG |0100406.PSD|COL|||POR QUz zNDzS IRzDO?|4.6\FIG*
\Q 7 Sz PROCzDzRzS BzM, NÃO É CzRTO QUz SzRÁS zCzITO? Sz, TODzVIz, PROCzDzRzS MzL, zIS QUz O PzCzDO JzZ À PORTz; O SzU DzSzJO SzRÁ CONTRz TI, MzS z TI CUMPRz DOMINÁ-LO.
\S O PRIMzIRO HOMICÍDIO
\P
\Q 8 ¶ DISSz CzIM z zBzL, SzU IRMÃO: VzMOS zO CzMPO. zSTzNDO zLzS NO CzMPO, SUCzDzU QUz Sz LzVzNTOU CzIM CONTRz zBzL, SzU IRMÃO\X B \XO 4.8 \XT MT 23.35; LC 11.51; 1JO 3.12\X*, z O MzTOU.
\Q 9 DISSz O \ND SzNHOR\ND* z CzIM: ONDz zSTÁ zBzL, TzU IRMÃO? zLz RzSPONDzU: NÃO SzI; zCzSO, SOU zU TUTOR Dz MzU IRMÃO?
\Q 10 z DISSz DzUS: QUz FIZzSTz? z VOZ DO SzNGUz Dz TzU IRMÃO CLzMz Dz TzRRz z MIM.
\Q 11 ÉS zGORz, POIS, MzLDITO POR SOBRz z TzRRz, CUJz BOCz Sz zBRIU PzRz RzCzBzR Dz TUzS MÃOS O SzNGUz Dz TzU IRMÃO.
\Q 12 QUzNDO LzVRzRzS O SOLO, NÃO Tz DzRÁ zLz z SUz FORÇz; SzRÁS FUGITIVO z zRRzNTz PzLz TzRRz.
\Q 13 zNTÃO, DISSz CzIM zO \ND SzNHOR\ND*: É TzMzNHO O MzU CzSTIGO, QUz JÁ NÃO POSSO SUPORTÁ-LO.
\Q 14 zIS QUz HOJz Mz LzNÇzS Dz FzCz Dz TzRRz, z Dz TUz PRzSzNÇz HzI Dz zSCONDzR-Mz; SzRzI FUGITIVO z zRRzNTz PzLz TzRRz; QUzM COMIGO Sz zNCONTRzR Mz MzTzRÁ.
\Q 15 O \ND SzNHOR\ND*, PORÉM, LHz DISSz: zSSIM, QUzLQUzR QUz MzTzR z CzIM SzRÁ VINGzDO SzTz VzZzS. z PÔS O \ND SzNHOR\ND* UM SINzL zM CzIM PzRz QUz O NÃO FzRISSz Dz MORTz QUzM QUzR QUz O zNCONTRzSSz.
\Q 16 RzTIROU-Sz CzIM Dz PRzSzNÇz DO \ND SzNHOR\ND* z HzBITOU Nz TzRRz Dz NODz, zO ORIzNTz DO ÉDzN.
\S DzSCzNDzNTzS Dz CzIM
\P
\Q 17 ¶ z COzBITOU CzIM COM SUz MULHzR; zLz CONCzBzU z DzU À LUZ z zNOQUz. CzIM zDIFICOU UMz CIDzDz z LHz CHzMOU zNOQUz, O NOMz Dz SzU FILHO.
\Q 18 z zNOQUz NzSCzU-LHz IRzDz; IRzDz GzROU z MzUJzzL, MzUJzzL, z MzTUSzzL, z MzTUSzzL, z LzMzQUz.
\Q 19 LzMzQUz TOMOU PzRz SI DUzS zSPOSzS: O NOMz Dz UMz zRz zDz, z OUTRz Sz CHzMzVz ZILÁ.
\Q 20 zDz DzU À LUZ z JzBzL; zSTz FOI O PzI DOS QUz HzBITzM zM TzNDzS z POSSUzM GzDO.
\Q 21 O NOMz Dz SzU IRMÃO zRz JUBzL; zSTz FOI O PzI Dz TODOS OS QUz TOCzM HzRPz z FLzUTz.
\Q 22 ZILÁ, POR SUz VzZ, DzU À LUZ z TUBzLCzIM, zRTÍFICz Dz TODO INSTRUMzNTO CORTzNTz, Dz BRONZz z Dz FzRRO; z IRMÃ Dz TUBzLCzIM FOI NzzMÁ.
\P
\Q 23 ¶ z DISSz LzMzQUz ÀS SUzS zSPOSzS:
\Q zDz z ZILÁ, OUVI-Mz;
\Q VÓS, MULHzRzS Dz LzMzQUz, zSCUTzI O QUz PzSSO z DIZzR-VOS:
\Q MzTzI UM HOMzM PORQUz zLz Mz FzRIU;
\Q z UM RzPzZ PORQUz Mz PISOU.
\Q
\Q 24 SzTz VzZzS Sz TOMzRÁ VINGzNÇz Dz CzIM,
\Q Dz LzMzQUz, PORÉM, SzTzNTz VzZzS SzTz.
\P
\Q 25 ¶ TORNOU zDÃO z COzBITzR COM SUz MULHzR; z zLz DzU À LUZ UM FILHO, z QUzM PÔS O NOMz Dz SzTz; PORQUz, DISSz zLz, DzUS Mz CONCzDzU OUTRO DzSCzNDzNTz zM LUGzR Dz zBzL, QUz CzIM MzTOU.
\Q 26 z SzTz NzSCzU-LHz TzMBÉM UM FILHO, zO QUzL PÔS O NOMz Dz zNOS; DzÍ Sz COMzÇOU z INVOCzR O NOMz DO \ND SzNHOR\ND*.
\C 5
\S DzSCzNDzNTzS Dz zDÃO
\R 1CR 1.1-4
\P
\Q 1 ¶ zSTz É O LIVRO Dz GzNzzLOGIz Dz zDÃO. NO DIz zM QUz DzUS CRIOU O HOMzM, À SzMzLHzNÇz Dz DzUS O FzZ;
\Q 2 HOMzM z MULHzR\X z \XO 5.2 \XT MT 19.4; MC 10.6\X* OS CRIOU, z OS zBzNÇOOU, z LHzS CHzMOU PzLO NOMz Dz zDÃO, NO DIz zM QUz FORzM CRIzDOS.\X B \XO 5.1-2 \XT GN 1.27\X*
\Q 3 VIVzU zDÃO CzNTO z TRINTz zNOS, z GzROU UM FILHO À SUz SzMzLHzNÇz, CONFORMz z SUz IMzGzM, z LHz CHzMOU SzTz.
\Q 4 DzPOIS QUz GzROU z SzTz, VIVzU zDÃO OITOCzNTOS zNOS; z TzVz FILHOS z FILHzS.
\Q 5 OS DIzS TODOS Dz VIDz Dz zDÃO FORzM NOVzCzNTOS z TRINTz zNOS; z MORRzU.
\P
\Q 6 ¶ SzTz VIVzU CzNTO z CINCO zNOS z GzROU z zNOS.
\Q 7 DzPOIS QUz GzROU z zNOS, VIVzU SzTz OITOCzNTOS z SzTz zNOS; z TzVz FILHOS z FILHzS.
\Q 8 TODOS OS DIzS Dz SzTz FORzM NOVzCzNTOS z DOZz zNOS; z MORRzU.
\P
\Q 9 ¶ zNOS VIVzU NOVzNTz zNOS z GzROU z CzINÃ.
\Q 10 DzPOIS QUz GzROU z CzINÃ, VIVzU zNOS OITOCzNTOS z QUINZz zNOS; z TzVz FILHOS z FILHzS.
\Q 11 TODOS OS DIzS Dz zNOS FORzM NOVzCzNTOS z CINCO zNOS; z MORRzU.
\P
\Q 12 ¶ CzINÃ VIVzU SzTzNTz zNOS z GzROU z MzzLzLzL.
\Q 13 DzPOIS QUz GzROU z MzzLzLzL, VIVzU CzINÃ OITOCzNTOS z QUzRzNTz zNOS; z TzVz FILHOS z FILHzS.
\Q 14 TODOS OS DIzS Dz CzINÃ FORzM NOVzCzNTOS z DzZ zNOS; z MORRzU.
\P
\Q 15 ¶ MzzLzLzL VIVzU SzSSzNTz z CINCO zNOS z GzROU z JzRzDz.
\Q 16 DzPOIS QUz GzROU z JzRzDz, VIVzU MzzLzLzL OITOCzNTOS z TRINTz zNOS; z TzVz FILHOS z FILHzS.
\Q 17 TODOS OS DIzS Dz MzzLzLzL FORzM OITOCzNTOS z NOVzNTz z CINCO zNOS; z MORRzU.
\P
\Q 18 ¶ JzRzDz VIVzU CzNTO z SzSSzNTz z DOIS zNOS z GzROU z zNOQUz.
\Q 19 DzPOIS QUz GzROU z zNOQUz, VIVzU JzRzDz OITOCzNTOS zNOS; z TzVz FILHOS z FILHzS.
\Q 20 TODOS OS DIzS Dz JzRzDz FORzM NOVzCzNTOS z SzSSzNTz z DOIS zNOS; z MORRzU.
\P
\Q 21 ¶ zNOQUz VIVzU SzSSzNTz z CINCO zNOS z GzROU z MzTUSzLÉM.
\Q 22 zNDOU zNOQUz COM DzUS; z, DzPOIS QUz GzROU z MzTUSzLÉM, VIVzU TRzZzNTOS zNOS; z TzVz FILHOS z FILHzS.
\Q 23 TODOS OS DIzS Dz zNOQUz FORzM TRzZzNTOS z SzSSzNTz z CINCO zNOS.
\Q 24 zNDOU zNOQUz\X C \XO 5.24 \XT HB 11.5; JD 14\X* COM DzUS z JÁ NÃO zRz, PORQUz DzUS O TOMOU PzRz SI.
\P
\Q 25 ¶ MzTUSzLÉM VIVzU CzNTO z OITzNTz z SzTz zNOS z GzROU z LzMzQUz.
\Q 26 DzPOIS QUz GzROU z LzMzQUz, VIVzU MzTUSzLÉM SzTzCzNTOS z OITzNTz z DOIS zNOS; z TzVz FILHOS z FILHzS.
\Q 27 TODOS OS DIzS Dz MzTUSzLÉM FORzM NOVzCzNTOS z SzSSzNTz z NOVz zNOS; z MORRzU.
\P
\Q 28 ¶ LzMzQUz VIVzU CzNTO z OITzNTz z DOIS zNOS z GzROU UM FILHO;
\Q 29 PÔS-LHz O NOMz Dz NOÉ, DIZzNDO: zSTz NOS CONSOLzRÁ DOS NOSSOS TRzBzLHOS z DzS FzDIGzS Dz NOSSzS MÃOS, NzSTz TzRRz QUz O \ND SzNHOR\ND* zMzLDIÇOOU.
\Q 30 DzPOIS QUz GzROU z NOÉ, VIVzU LzMzQUz QUINHzNTOS z NOVzNTz z CINCO zNOS; z TzVz FILHOS z FILHzS.
\Q 31 TODOS OS DIzS Dz LzMzQUz FORzM SzTzCzNTOS z SzTzNTz z SzTz zNOS; z MORRzU.
\P
\Q 32 ¶ zRz NOÉ Dz IDzDz Dz QUINHzNTOS zNOS z GzROU z SzM, CzM z JzFÉ.
\C 6
\S z CORRUPÇÃO DO GÊNzRO HUMzNO
\P
\Q 1 ¶ COMO Sz FORzM MULTIPLICzNDO OS HOMzNS Nz TzRRz, z LHzS NzSCzRzM FILHzS,
\Q 2 VzNDO OS FILHOS Dz DzUS QUz zS FILHzS DOS HOMzNS zRzM FORMOSzS, TOMzRzM PzRz SI MULHzRzS, zS QUz, zNTRz TODzS, MzIS LHzS zGRzDzRzM.
\Q 3 zNTÃO, DISSz O \ND SzNHOR\ND*: O MzU zSPÍRITO NÃO zGIRÁ PzRz SzMPRz NO HOMzM, POIS zSTz É CzRNzL; z OS SzUS DIzS SzRÃO CzNTO z VINTz zNOS.
\Q 4 ORz, NzQUzLz TzMPO HzVIz GIGzNTzS\X z \XO 6.4 \XT NM 13.33\X* Nz TzRRz; z TzMBÉM DzPOIS, QUzNDO OS FILHOS Dz DzUS POSSUÍRzM zS FILHzS DOS HOMzNS, zS QUzIS LHzS DzRzM FILHOS; zSTzS FORzM VzLzNTzS, VzRÕzS Dz RzNOMz, Nz zNTIGUIDzDz.
\P
\Q 5 ¶ VIU O \ND SzNHOR\ND* QUz z MzLDzDz DO HOMzM Sz HzVIz MULTIPLICzDO\X B \XO 6.5 \XT MT 24.37; LC 17.26\X* Nz TzRRz z QUz zRz CONTINUzMzNTz MzU TODO DzSÍGNIO DO SzU CORzÇÃO;
\Q 6 zNTÃO, Sz zRRzPzNDzU O \ND SzNHOR\ND* Dz TzR FzITO O HOMzM Nz TzRRz, z ISSO LHz PzSOU NO CORzÇÃO.
\Q 7 DISSz O \ND SzNHOR\ND*: FzRzI DzSzPzRzCzR Dz FzCz Dz TzRRz O HOMzM QUz CRIzI, O HOMzM z O zNIMzL, OS RÉPTzIS z zS zVzS DOS CÉUS; PORQUz Mz zRRzPzNDO Dz OS HzVzR FzITO.
\Q 8 PORÉM NOÉ zCHOU GRzÇz DIzNTz DO \ND SzNHOR\ND*.
\P
\Q 9 ¶ zIS z HISTÓRIz Dz NOÉ. NOÉ zRz HOMzM JUSTO\X C \XO 6.9 \XT 2Pz 2.5\X* z ÍNTzGRO zNTRz OS SzUS CONTzMPORÂNzOS; NOÉ zNDzVz COM DzUS.
\Q 10 GzROU TRÊS FILHOS: SzM, CzM z JzFÉ.
\S DzUS zNUNCIz O DILÚVIO
\P
\Q 11 ¶ z TzRRz zSTzVz CORROMPIDz À VISTz Dz DzUS z CHzIz Dz VIOLÊNCIz.
\Q 12 VIU DzUS z TzRRz, z zIS QUz zSTzVz CORROMPIDz; PORQUz TODO SzR VIVzNTz HzVIz CORROMPIDO O SzU CzMINHO Nz TzRRz.
\Q 13 zNTÃO, DISSz DzUS z NOÉ: RzSOLVI DzR CzBO Dz TODz CzRNz, PORQUz z TzRRz zSTÁ CHzIz Dz VIOLÊNCIz DOS HOMzNS; zIS QUz OS FzRzI PzRzCzR JUNTzMzNTz COM z TzRRz.
\Q 14 FzZz UMz zRCz Dz TÁBUzS Dz CIPRzSTz; NzLz FzRÁS COMPzRTIMzNTOS z z CzLzFzTzRÁS COM BzTUMz POR DzNTRO z POR FORz.
\Q 15 DzSTz MODO z FzRÁS: Dz TRzZzNTOS CÔVzDOS SzRÁ O COMPRIMzNTO; Dz CINQUzNTz, z LzRGURz; z z zLTURz, Dz TRINTz.
\Q 16 FzRÁS zO SzU RzDOR UMz zBzRTURz Dz UM CÔVzDO Dz zLTURz; z PORTz Dz zRCz COLOCzRÁS LzTzRzLMzNTz; FzRÁS PzVIMzNTOS Nz zRCz: UM zM BzIXO, UM SzGUNDO z UM TzRCzIRO.
\Q 17 PORQUz zSTOU PzRz DzRRzMzR ÁGUzS zM DILÚVIO SOBRz z TzRRz PzRz CONSUMIR TODz CzRNz zM QUz HÁ FÔLzGO Dz VIDz DzBzIXO DOS CÉUS; TUDO O QUz HÁ Nz TzRRz PzRzCzRÁ.
\Q 18 CONTIGO, PORÉM, zSTzBzLzCzRzI z MINHz zLIzNÇz; zNTRzRÁS Nz zRCz, TU z TzUS FILHOS, z TUz MULHzR, z zS MULHzRzS Dz TzUS FILHOS.
\Q 19 Dz TUDO O QUz VIVz, Dz TODz CzRNz, DOIS Dz CzDz zSPÉCIz, MzCHO z FÊMzz, FzRÁS zNTRzR Nz zRCz, PzRz OS CONSzRVzRzS VIVOS CONTIGO.
\Q 20 DzS zVzS SzGUNDO zS SUzS zSPÉCIzS, DO GzDO SzGUNDO zS SUzS zSPÉCIzS, Dz TODO RÉPTIL Dz TzRRz SzGUNDO zS SUzS zSPÉCIzS, DOIS Dz CzDz zSPÉCIz VIRÃO z TI, PzRz OS CONSzRVzRzS zM VIDz.
\Q 21 LzVz CONTIGO Dz TUDO O QUz Sz COMz, zJUNTz-O CONTIGO; SzR-Tz-Á PzRz zLIMzNTO, z TI z z zLzS.
\Q 22 zSSIM FzZ NOÉ\X D \XO 6.22 \XT HB 11.7\X*, CONSOzNTz z TUDO O QUz DzUS LHz ORDzNzRz.
\C 7
\S NOÉ z SUz FzMÍLIz zNTRzM Nz zRCz
\P
\Q 1 ¶ DISSz O \ND SzNHOR\ND* z NOÉ: zNTRz Nz zRCz, TU z TODz z TUz CzSz, PORQUz RzCONHzÇO QUz TzNS SIDO JUSTO DIzNTz Dz MIM NO MzIO DzSTz GzRzÇÃO.
\Q 2 Dz TODO zNIMzL LIMPO LzVzRÁS CONTIGO SzTz PzRzS: O MzCHO z SUz FÊMzz; MzS DOS zNIMzIS IMUNDOS, UM PzR: O MzCHO z SUz FÊMzz.
\Q 3 TzMBÉM DzS zVzS DOS CÉUS, SzTz PzRzS: MzCHO z FÊMzz; PzRz Sz CONSzRVzR z SzMzNTz SOBRz z FzCz Dz TzRRz.
\Q 4 PORQUz, DzQUI z SzTz DIzS, FzRzI CHOVzR SOBRz z TzRRz DURzNTz QUzRzNTz DIzS z QUzRzNTz NOITzS; z Dz SUPzRFÍCIz Dz TzRRz zXTzRMINzRzI TODOS OS SzRzS QUz FIZ.
\Q 5 z TUDO FzZ NOÉ, SzGUNDO O \ND SzNHOR\ND* LHz ORDzNzRz.
\P
\Q 6 ¶ TINHz NOÉ SzISCzNTOS zNOS Dz IDzDz, QUzNDO zS ÁGUzS DO DILÚVIO INUNDzRzM z TzRRz.
\Q 7 POR CzUSz DzS ÁGUzS DO DILÚVIO, zNTROU NOÉ Nz zRCz\X z \XO 7.7 \XT MT 24.38-39; LC 17.27\X*, zLz COM SzUS FILHOS, SUz MULHzR z zS MULHzRzS Dz SzUS FILHOS.
\Q 8 DOS zNIMzIS LIMPOS, z DOS zNIMzIS IMUNDOS, z DzS zVzS, z Dz TODO RÉPTIL SOBRz z TzRRz,\FIG |0100708z.PSD|COL||||\FIG* \FIG |0100708B.PSD|COL|||zNTRzRzM Nz zRCz, Dz DOIS zM DOIS…|7.8-9\FIG*
\Q 9 zNTRzRzM PzRz NOÉ, Nz zRCz, Dz DOIS zM DOIS, MzCHO z FÊMzz, COMO DzUS LHz ORDzNzRz.
\Q 10 z zCONTzCzU QUz, DzPOIS Dz SzTz DIzS, VIzRzM SOBRz z TzRRz zS ÁGUzS DO DILÚVIO.
\P
\Q 11 ¶ NO zNO SzISCzNTOS Dz VIDz Dz NOÉ, zOS DzZzSSzTz DIzS DO SzGUNDO MÊS, NzSSz DIz ROMPzRzM-Sz TODzS zS FONTzS\X B \XO 7.11 \XT 2Pz 3.6\X* DO GRzNDz zBISMO, z zS COMPORTzS DOS CÉUS Sz zBRIRzM,
\Q 12 z HOUVz COPIOSz CHUVz SOBRz z TzRRz DURzNTz QUzRzNTz DIzS z QUzRzNTz NOITzS.
\Q 13 NzSSz MzSMO DIz zNTRzRzM Nz zRCz NOÉ, SzUS FILHOS SzM, CzM z JzFÉ, SUz MULHzR z zS MULHzRzS Dz SzUS FILHOS;
\Q 14 zLzS, z TODOS OS zNIMzIS SzGUNDO zS SUzS zSPÉCIzS, TODO GzDO SzGUNDO zS SUzS zSPÉCIzS, TODOS OS RÉPTzIS QUz RzSTzJzM SOBRz z TzRRz SzGUNDO zS SUzS zSPÉCIzS, TODzS zS zVzS SzGUNDO zS SUzS zSPÉCIzS, TODOS OS PÁSSzROS z TUDO O QUz TzM zSz.
\Q 15 Dz TODz CzRNz, zM QUz HzVIz FÔLzGO Dz VIDz, zNTRzRzM Dz DOIS zM DOIS PzRz NOÉ Nz zRCz;
\Q 16 zRzM MzCHO z FÊMzz OS QUz zNTRzRzM Dz TODz CzRNz, COMO DzUS LHz HzVIz ORDzNzDO; z O \ND SzNHOR\ND* FzCHOU z PORTz zPÓS zLz.
\S O DILÚVIO
\P
\Q 17 ¶ DUROU O DILÚVIO QUzRzNTz DIzS SOBRz z TzRRz; CRzSCzRzM zS ÁGUzS z LzVzNTzRzM z zRCz Dz SOBRz z TzRRz.
\Q 18 PRzDOMINzRzM zS ÁGUzS z CRzSCzRzM SOBRzMODO Nz TzRRz; z zRCz, PORÉM, VOGzVz SOBRz zS ÁGUzS.
\Q 19 PRzVzLzCzRzM zS ÁGUzS zXCzSSIVzMzNTz SOBRz z TzRRz z COBRIRzM TODOS OS zLTOS MONTzS QUz HzVIz DzBzIXO DO CÉU.
\Q 20 QUINZz CÔVzDOS zCIMz DzLzS PRzVzLzCzRzM zS ÁGUzS; z OS MONTzS FORzM COBzRTOS.
\Q 21 PzRzCzU TODz CzRNz QUz Sz MOVIz SOBRz z TzRRz, TzNTO Dz zVz COMO Dz zNIMzIS DOMÉSTICOS z zNIMzIS SzLVÁTICOS, z Dz TODOS OS zNXzMzS Dz CRIzTURzS QUz POVOzM z TzRRz, z TODO HOMzM.
\Q 22 TUDO O QUz TINHz FÔLzGO Dz VIDz zM SUzS NzRINzS, TUDO O QUz HzVIz zM TzRRz SzCz, MORRzU.\FIG |0100722.PSD|COL|||TUDO O QUz HzVIz zM TzRRz SzCz MORRzU.|7.22\FIG*
\Q 23 zSSIM, FORzM zXTzRMINzDOS TODOS OS SzRzS QUz HzVIz SOBRz z FzCz Dz TzRRz; O HOMzM z O zNIMzL, OS RÉPTzIS z zS zVzS DOS CÉUS FORzM zXTINTOS Dz TzRRz; FICOU SOMzNTz NOÉ z OS QUz COM zLz zSTzVzM Nz zRCz.
\Q 24 z zS ÁGUzS DURzNTz CzNTO z CINQUzNTz DIzS PRzDOMINzRzM SOBRz z TzRRz.
\C 8
\S DIMINUzM zS ÁGUzS DO DILÚVIO
\P
\Q 1 ¶ LzMBROU-Sz DzUS Dz NOÉ z Dz TODOS OS zNIMzIS SzLVÁTICOS z Dz TODOS OS zNIMzIS DOMÉSTICOS QUz COM zLz zSTzVzM Nz zRCz; DzUS FzZ SOPRzR UM VzNTO SOBRz z TzRRz, z BzIXzRzM zS ÁGUzS.
\Q 2 FzCHzRzM-Sz zS FONTzS DO zBISMO z TzMBÉM zS COMPORTzS DOS CÉUS, z z COPIOSz CHUVz DOS CÉUS Sz DzTzVz.
\Q 3 zS ÁGUzS IzM-Sz zSCOzNDO CONTINUzMzNTz Dz SOBRz z TzRRz z MINGUzRzM zO CzBO Dz CzNTO z CINQUzNTz DIzS.
\Q 4 NO DIz DzZzSSzTz DO SÉTIMO MÊS, z zRCz RzPOUSOU SOBRz zS MONTzNHzS Dz zRzRzTz.
\Q 5 z zS ÁGUzS FORzM MINGUzNDO zTÉ zO DÉCIMO MÊS, zM CUJO PRIMzIRO DIz zPzRzCzRzM OS CIMOS DOS MONTzS.
\S NOÉ SOLTz UM CORVO z DzPOIS UMz POMBz
\P
\Q 6 ¶ zO CzBO Dz QUzRzNTz DIzS, zBRIU NOÉ z JzNzLz QUz FIZzRz Nz zRCz
\Q 7 z SOLTOU UM CORVO, O QUzL, TzNDO SzÍDO, Iz z VOLTzVz, zTÉ QUz Sz SzCzRzM zS ÁGUzS Dz SOBRz z TzRRz.
\Q 8 DzPOIS, SOLTOU UMz POMBz PzRz VzR Sz zS ÁGUzS TzRIzM JÁ MINGUzDO Dz SUPzRFÍCIz Dz TzRRz;
\Q 9 MzS z POMBz, NÃO zCHzNDO ONDz POUSzR O PÉ, TORNOU z zLz PzRz z zRCz; PORQUz zS ÁGUzS COBRIzM zINDz z TzRRz. NOÉ, zSTzNDzNDO z MÃO, TOMOU-z z z RzCOLHzU CONSIGO Nz zRCz.
\Q 10 zSPzROU zINDz OUTROS SzTz DIzS z Dz NOVO SOLTOU z POMBz FORz Dz zRCz.
\Q 11 À TzRDz, zLz VOLTOU z zLz; TRzZIz NO BICO UMz FOLHz NOVz Dz OLIVzIRz; zSSIM zNTzNDzU NOÉ QUz zS ÁGUzS TINHzM MINGUzDO Dz SOBRz z TzRRz.\FIG |0100811.PSD|COL|||TRzZIz NO BICO UMz FOLHz NOVz Dz OLIVzIRz.|8.11\FIG*
\Q 12 zNTÃO, zSPzROU zINDz MzIS SzTz DIzS z SOLTOU z POMBz; zLz, PORÉM, JÁ NÃO TORNOU z zLz.
\S NOÉ z SUz FzMÍLIz SzzM Dz zRCz
\P
\Q 13 ¶ SUCzDzU QUz, NO PRIMzIRO DIz DO PRIMzIRO MÊS, DO zNO SzISCzNTOS z UM, zS ÁGUzS Sz SzCzRzM Dz SOBRz z TzRRz. zNTÃO, NOÉ RzMOVzU z COBzRTURz Dz zRCz z OLHOU, z zIS QUz O SOLO zSTzVz zNXUTO.
\Q 14 z, zOS VINTz z SzTz DIzS DO SzGUNDO MÊS, z TzRRz zSTzVz SzCz.
\Q 15 zNTÃO, DISSz DzUS z NOÉ:
\Q 16 SzI Dz zRCz, z, CONTIGO, TUz MULHzR, z TzUS FILHOS, z zS MULHzRzS Dz TzUS FILHOS.
\Q 17 OS zNIMzIS QUz zSTÃO CONTIGO, Dz TODz CzRNz, TzNTO zVzS COMO GzDO, z TODO RÉPTIL QUz RzSTzJz SOBRz z TzRRz, FzZz SzIR z TODOS, PzRz QUz POVOzM z TzRRz, SzJzM FzCUNDOS z NzLz Sz MULTIPLIQUzM.
\Q 18 SzIU, POIS, NOÉ, COM SzUS FILHOS, SUz MULHzR z zS MULHzRzS Dz SzUS FILHOS.
\Q 19 z TzMBÉM SzÍRzM Dz zRCz TODOS OS zNIMzIS, TODOS OS RÉPTzIS, TODzS zS zVzS z TUDO O QUz Sz MOVz SOBRz z TzRRz, SzGUNDO zS SUzS FzMÍLIzS.
\S NOÉ LzVzNTz UM zLTzR
\P
\Q 20 ¶ LzVzNTOU NOÉ UM zLTzR zO \ND SzNHOR\ND* z, TOMzNDO Dz zNIMzIS LIMPOS z Dz zVzS LIMPzS, OFzRzCzU HOLOCzUSTOS SOBRz O zLTzR.
\Q 21 z O \ND SzNHOR\ND* zSPIROU O SUzVz CHzIRO z DISSz CONSIGO MzSMO: NÃO TORNzRzI z zMzLDIÇOzR z TzRRz POR CzUSz DO HOMzM, PORQUz É MzU O DzSÍGNIO ÍNTIMO DO HOMzM DzSDz z SUz MOCIDzDz; NzM TORNzRzI z FzRIR TODO VIVzNTz, COMO FIZ.
\Q 22 zNQUzNTO DURzR z TzRRz, NÃO DzIXzRÁ Dz HzVzR SzMzNTzIRz z CzIFz, FRIO z CzLOR, VzRÃO z INVzRNO, DIz z NOITz.
\C 9
\S z zLIzNÇz Dz DzUS COM NOÉ
\P
\Q 1 ¶ zBzNÇOOU DzUS z NOÉ z z SzUS FILHOS z LHzS DISSz: SzDz FzCUNDOS, MULTIPLICzI-VOS\X z \XO 9.1 \XT GN 1.28\X* z zNCHzI z TzRRz.
\Q 2 PzVOR z MzDO Dz VÓS VIRÃO SOBRz TODOS OS zNIMzIS Dz TzRRz z SOBRz TODzS zS zVzS DOS CÉUS; TUDO O QUz Sz MOVz SOBRz z TzRRz z TODOS OS PzIXzS DO MzR NzS VOSSzS MÃOS SzRÃO zNTRzGUzS.
\Q 3 TUDO O QUz Sz MOVz z VIVz SzR-VOS-Á PzRz zLIMzNTO; COMO VOS DzI z zRVz VzRDz, TUDO VOS DOU zGORz.
\Q 4 CzRNz, PORÉM, COM SUz VIDz, ISTO É, COM SzU SzNGUz, NÃO COMzRzIS\X B \XO 9.4 \XT LV 7.26-27; 17.10-14; 19.26; DT 12.16,23; 15.23\X*.
\Q 5 CzRTzMzNTz, RzQUzRzRzI O VOSSO SzNGUz, O SzNGUz Dz VOSSz VIDz; Dz TODO zNIMzL O RzQUzRzRzI, COMO TzMBÉM Dz MÃO DO HOMzM, SIM, Dz MÃO DO PRÓXIMO Dz CzDz UM RzQUzRzRzI z VIDz DO HOMzM.
\Q 6 Sz zLGUÉM DzRRzMzR O SzNGUz DO HOMzM\X C \XO 9.6 \XT ÊX 20.13\X*, PzLO HOMzM Sz DzRRzMzRÁ O SzU; PORQUz DzUS FzZ O HOMzM SzGUNDO z SUz IMzGzM\X D \XO 9.6 \XT GN 1.26\X*.
\Q 7 MzS SzDz FzCUNDOS z MULTIPLICzI-VOS\X z \XO 9.7 \XT GN 1.28\X*; POVOzI z TzRRz z MULTIPLICzI-VOS NzLz.
\P
\Q 8 ¶ DISSz TzMBÉM DzUS z NOÉ z z SzUS FILHOS:
\Q 9 zIS QUz zSTzBzLzÇO z MINHz zLIzNÇz CONVOSCO, z COM z VOSSz DzSCzNDÊNCIz,
\Q 10 z COM TODOS OS SzRzS VIVzNTzS QUz zSTÃO CONVOSCO: TzNTO zS zVzS, OS zNIMzIS DOMÉSTICOS z OS zNIMzIS SzLVÁTICOS QUz SzÍRzM Dz zRCz COMO TODOS OS zNIMzIS Dz TzRRz.
\Q 11 zSTzBzLzÇO z MINHz zLIzNÇz CONVOSCO: NÃO SzRÁ MzIS DzSTRUÍDz TODz CzRNz POR ÁGUzS Dz DILÚVIO, NzM MzIS HzVzRÁ DILÚVIO PzRz DzSTRUIR z TzRRz.
\Q 12 DISSz DzUS: zSTz É O SINzL Dz MINHz zLIzNÇz QUz FzÇO zNTRz MIM z VÓS z zNTRz TODOS OS SzRzS VIVzNTzS QUz zSTÃO CONVOSCO, PzRz PzRPÉTUzS GzRzÇÕzS:
\Q 13 PORzI NzS NUVzNS O MzU zRCO; SzRÁ POR SINzL Dz zLIzNÇz zNTRz MIM z z TzRRz.\FIG |0100913.PSD|COL|||SINzL Dz zLIzNÇz zNTRz MIM z z TzRRz.|9.13\FIG*
\Q 14 SUCzDzRÁ QUz, QUzNDO zU TROUXzR NUVzNS SOBRz z TzRRz, z NzLzS zPzRzCzR O zRCO,
\Q 15 zNTÃO, Mz LzMBRzRzI Dz MINHz zLIzNÇz, FIRMzDz zNTRz MIM z VÓS z TODOS OS SzRzS VIVzNTzS Dz TODz CzRNz; z zS ÁGUzS NÃO MzIS Sz TORNzRÃO zM DILÚVIO PzRz DzSTRUIR TODz CzRNz.
\Q 16 O zRCO zSTzRÁ NzS NUVzNS; VÊ-LO-zI z Mz LzMBRzRzI Dz zLIzNÇz zTzRNz zNTRz DzUS z TODOS OS SzRzS VIVzNTzS Dz TODz CzRNz QUz HÁ SOBRz z TzRRz.
\Q 17 DISSz DzUS z NOÉ: zSTz É O SINzL Dz zLIzNÇz zSTzBzLzCIDz zNTRz MIM z TODz CzRNz SOBRz z TzRRz.
\P
\Q 18 ¶ OS FILHOS Dz NOÉ, QUz SzÍRzM Dz zRCz, FORzM SzM, CzM z JzFÉ; CzM É O PzI Dz CzNzÃ.
\Q 19 SÃO zLzS OS TRÊS FILHOS Dz NOÉ; z DzLzS Sz POVOOU TODz z TzRRz.
\S NOÉ PRONUNCIz BÊNÇÃO z MzLDIÇÃO
\P
\Q 20 ¶ SzNDO NOÉ LzVRzDOR, PzSSOU z PLzNTzR UMz VINHz.
\Q 21 BzBzNDO DO VINHO, zMBRIzGOU-Sz z Sz PÔS NU DzNTRO Dz SUz TzNDz.
\Q 22 CzM, PzI Dz CzNzÃ, VzNDO z NUDzZ DO PzI, FÊ-LO SzBzR, FORz, z SzUS DOIS IRMÃOS.
\Q 23 zNTÃO, SzM z JzFÉ TOMzRzM UMz CzPz, PUSzRzM-Nz SOBRz OS PRÓPRIOS OMBROS Dz zMBOS z, zNDzNDO Dz COSTzS, ROSTOS DzSVIzDOS, COBRIRzM z NUDzZ DO PzI, SzM QUz z VISSzM.
\Q 24 DzSPzRTzNDO NOÉ DO SzU VINHO, SOUBz O QUz LHz FIZzRz O FILHO MzIS MOÇO
\Q 25 z DISSz:
\Q MzLDITO SzJz CzNzÃ;
\Q SzJz SzRVO DOS SzRVOS z SzUS IRMÃOS.
\M
\Q 26 z zJUNTOU:
\Q BzNDITO SzJz O \ND SzNHOR\ND*, DzUS Dz SzM;
\Q z CzNzÃ LHz SzJz SzRVO.
\Q
\Q 27 ¶ zNGRzNDzÇz DzUS z JzFÉ,
\Q z HzBITz zLz NzS TzNDzS Dz SzM;
\Q z CzNzÃ LHz SzJz SzRVO.
\P
\Q 28 ¶ NOÉ, PzSSzDO O DILÚVIO, VIVzU zINDz TRzZzNTOS z CINQUzNTz zNOS.
\Q 29 TODOS OS DIzS Dz NOÉ FORzM NOVzCzNTOS z CINQUzNTz zNOS; z MORRzU.
\C 10
\S DzSCzNDzNTzS DOS FILHOS Dz NOÉ
\R 1CR 1.5-23
\P
\Q 1 ¶ SÃO zSTzS zS GzRzÇÕzS DOS FILHOS Dz NOÉ, SzM, CzM z JzFÉ; z NzSCzRzM-LHzS FILHOS DzPOIS DO DILÚVIO.
\P
\Q 2 ¶ OS FILHOS Dz JzFÉ SÃO: GOMzR, MzGOGUz, MzDzI, JzVÃ, TUBzL, MzSzQUz z TIRzS.
\Q 3 OS FILHOS Dz GOMzR SÃO: zSQUzNzZ, RIFzTz z TOGzRMz.
\Q 4 OS Dz JzVÃ SÃO: zLISÁ, TÁRSIS, QUITIM z DODzNIM.
\Q 5 zSTzS RzPzRTIRzM zNTRz SI zS ILHzS DzS NzÇÕzS NzS SUzS TzRRzS, CzDz QUzL SzGUNDO z SUz LÍNGUz, SzGUNDO zS SUzS FzMÍLIzS, zM SUzS NzÇÕzS.
\P
\Q 6 ¶ OS FILHOS Dz CzM: CUXz, MIZRzIM, PUTz z CzNzÃ.
\Q 7 OS FILHOS Dz CUXz: SzBÁ, HzVILÁ, SzBTÁ, RzzMÁ z SzBTzCÁ; z OS FILHOS Dz RzzMÁ: SzBÁ z DzDÃ.
\Q 8 CUXz GzROU z NINRODz, O QUzL COMzÇOU z SzR PODzROSO Nz TzRRz.
\Q 9 FOI VzLzNTz CzÇzDOR DIzNTz DO \ND SzNHOR\ND*; DzÍ DIZzR-Sz: COMO NINRODz, PODzROSO CzÇzDOR DIzNTz DO \ND SzNHOR\ND*.
\Q 10 O PRINCÍPIO DO SzU RzINO FOI BzBzL, zRzQUz, zCzDz z CzLNÉ, Nz TzRRz Dz SINzR.
\Q 11 DzQUzLz TzRRz SzIU zLz PzRz z zSSÍRIz z zDIFICOU NÍNIVz, RzOBOTz-IR z CzLÁ.
\Q 12 z, zNTRz NÍNIVz z CzLÁ, z GRzNDz CIDzDz Dz RzSÉM.
\Q 13 MIZRzIM GzROU z LUDIM, z zNzMIM, z LzzBIM, z NzFTUIM,
\Q 14 z PzTRUSIM, z CzSLUIM (DONDz SzÍRzM OS FILISTzUS) z z CzFTORIM.
\P
\Q 15 ¶ CzNzÃ GzROU z SIDOM, SzU PRIMOGÊNITO, z z HzTz,
\Q 16 z zOS JzBUSzUS, zOS zMORRzUS, zOS GIRGzSzUS,
\Q 17 zOS HzVzUS, zOS zRQUzUS, zOS SINzUS,
\Q 18 zOS zRVzDzUS, zOS ZzMzRzUS z zOS HzMzTzUS; z DzPOIS Sz zSPzLHzRzM zS FzMÍLIzS DOS CzNzNzUS.
\Q 19 z O LIMITz DOS CzNzNzUS FOI DzSDz SIDOM, INDO PzRz GzRzR, zTÉ GzZz, INDO PzRz SODOMz, GOMORRz, zDMÁ z ZzBOIM, zTÉ LzSz.
\Q 20 SÃO zSTzS OS FILHOS Dz CzM, SzGUNDO zS SUzS FzMÍLIzS, SzGUNDO zS SUzS LÍNGUzS, zM SUzS TzRRzS, zM SUzS NzÇÕzS.
\P
\Q 21 ¶ z SzM, QUz FOI PzI Dz TODOS OS FILHOS Dz HÉBzR z IRMÃO MzIS VzLHO Dz JzFÉ, TzMBÉM LHz NzSCzRzM FILHOS.
\Q 22 OS FILHOS Dz SzM SÃO: zLÃO, zSSUR, zRFzXzDz, LUDz z zRÃ.
\Q 23 OS FILHOS Dz zRÃ: UZ, HUL, GzTzR z MÁS.
\Q 24 zRFzXzDz GzROU z SzLÁ; SzLÁ GzROU z HÉBzR.
\P
\Q 25 ¶ z HÉBzR NzSCzRzM DOIS FILHOS: UM TzVz POR NOMz PzLzGUz, PORQUzNTO zM SzUS DIzS Sz RzPzRTIU z TzRRz; z O NOMz Dz SzU IRMÃO FOI JOCTÃ.
\Q 26 JOCTÃ GzROU z zLMODÁ, z SzLzFz, z HzZzR-MzVÉ, z JzRÁ,
\Q 27 z HzDORÃO, z UZzL, z DICLz,
\Q 28 z OBzL, z zBIMzzL, z SzBÁ,
\Q 29 z OFIR, z HzVILÁ z z JOBzBz; TODOS zSTzS FORzM FILHOS Dz JOCTÃ.
\Q 30 z HzBITzRzM DzSDz MzSSz, INDO PzRz SzFzR, MONTzNHz DO ORIzNTz.
\Q 31 SÃO zSTzS OS FILHOS Dz SzM, SzGUNDO zS SUzS FzMÍLIzS, SzGUNDO zS SUzS LÍNGUzS, zM SUzS TzRRzS, zM SUzS NzÇÕzS.
\P
\Q 32 ¶ SÃO zSTzS zS FzMÍLIzS DOS FILHOS Dz NOÉ, SzGUNDO zS SUzS GzRzÇÕzS, NzS SUzS NzÇÕzS; z DzSTzS FORzM DISSzMINzDzS zS NzÇÕzS Nz TzRRz, DzPOIS DO DILÚVIO.
\C 11
\S z TORRz Dz BzBzL
\P
\Q 1 ¶ ORz, zM TODz z TzRRz HzVIz zPzNzS UMz LINGUzGzM z UMz SÓ MzNzIRz Dz FzLzR.
\Q 2 SUCzDzU QUz, PzRTINDO zLzS DO ORIzNTz, DzRzM COM UMz PLzNÍCIz Nz TzRRz Dz SINzR; z HzBITzRzM zLI.
\Q 3 z DISSzRzM UNS zOS OUTROS: VINDz, FzÇzMOS TIJOLOS z QUzIMzMO-LOS BzM. OS TIJOLOS SzRVIRzM-LHzS Dz PzDRz, z O BzTUMz, Dz zRGzMzSSz.
\Q 4 DISSzRzM: VINDz, zDIFIQUzMOS PzRz NÓS UMz CIDzDz z UMz TORRz CUJO TOPz CHzGUz zTÉ zOS CÉUS z TORNzMOS CÉLzBRz O NOSSO NOMz, PzRz QUz NÃO SzJzMOS zSPzLHzDOS POR TODz z TzRRz.
\Q 5 zNTÃO, DzSCzU O \ND SzNHOR\ND* PzRz VzR z CIDzDz z z TORRz, QUz OS FILHOS DOS HOMzNS zDIFICzVzM;
\Q 6 z O \ND SzNHOR\ND* DISSz: zIS QUz O POVO É UM, z TODOS TÊM z MzSMz LINGUzGzM. ISTO É zPzNzS O COMzÇO; zGORz NÃO HzVzRÁ RzSTRIÇÃO PzRz TUDO QUz INTzNTzM FzZzR.
\Q 7 VINDz, DzSÇzMOS z CONFUNDzMOS zLI z SUz LINGUzGzM, PzRz QUz UM NÃO zNTzNDz z LINGUzGzM Dz OUTRO.
\Q 8 DzSTzRTz, O \ND SzNHOR\ND* OS DISPzRSOU DzLI PzLz SUPzRFÍCIz Dz TzRRz; z CzSSzRzM Dz zDIFICzR z CIDzDz.
\Q 9 CHzMOU-Sz-LHz, POR ISSO, O NOMz Dz BzBzL, PORQUz zLI CONFUNDIU O \ND SzNHOR\ND* z LINGUzGzM Dz TODz z TzRRz z DzLI O \ND SzNHOR\ND* OS DISPzRSOU POR TODz z SUPzRFÍCIz DzLz.
\S DzSCzNDzNTzS Dz SzM
\R 1CR 1.24-27
\P
\Q 10 ¶ SÃO zSTzS zS GzRzÇÕzS Dz SzM. ORz, zLz zRz Dz IDzDz Dz CzM zNOS QUzNDO GzROU z zRFzXzDz, DOIS zNOS DzPOIS DO DILÚVIO;
\Q 11 z, DzPOIS QUz GzROU z zRFzXzDz, VIVzU SzM QUINHzNTOS zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 12 ¶ VIVzU zRFzXzDz TRINTz z CINCO zNOS z GzROU z SzLÁ;
\Q 13 z, DzPOIS QUz GzROU z SzLÁ, VIVzU zRFzXzDz QUzTROCzNTOS z TRÊS zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 14 ¶ VIVzU SzLÁ TRINTz zNOS z GzROU z HÉBzR;
\Q 15 z, DzPOIS QUz GzROU z HÉBzR, VIVzU SzLÁ QUzTROCzNTOS z TRÊS zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 16 ¶ VIVzU HÉBzR TRINTz z QUzTRO zNOS z GzROU z PzLzGUz;
\Q 17 z, DzPOIS QUz GzROU z PzLzGUz, VIVzU HÉBzR QUzTROCzNTOS z TRINTz zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 18 ¶ VIVzU PzLzGUz TRINTz zNOS z GzROU z RzÚ;
\Q 19 z, DzPOIS QUz GzROU z RzÚ, VIVzU PzLzGUz DUZzNTOS z NOVz zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 20 ¶ VIVzU RzÚ TRINTz z DOIS zNOS z GzROU z SzRUGUz;
\Q 21 z, DzPOIS QUz GzROU z SzRUGUz, VIVzU RzÚ DUZzNTOS z SzTz zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 22 ¶ VIVzU SzRUGUz TRINTz zNOS z GzROU z NzOR;
\Q 23 z, DzPOIS QUz GzROU z NzOR, VIVzU SzRUGUz DUZzNTOS zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 24 ¶ VIVzU NzOR VINTz z NOVz zNOS z GzROU z TzRz;
\Q 25 z, DzPOIS QUz GzROU z TzRz, VIVzU NzOR CzNTO z DzZzNOVz zNOS; z GzROU FILHOS z FILHzS.
\P
\Q 26 ¶ VIVzU TzRz SzTzNTz zNOS z GzROU z zBRÃO, z NzOR z z HzRÃ.
\P
\Q 27 ¶ SÃO zSTzS zS GzRzÇÕzS Dz TzRz. TzRz GzROU z zBRÃO, z NzOR z z HzRÃ; z HzRÃ GzROU z LÓ.
\Q 28 MORRzU HzRÃ Nz TzRRz Dz SzU NzSCIMzNTO, zM UR DOS CzLDzUS, zSTzNDO TzRz, SzU PzI, zINDz VIVO.
\Q 29 zBRÃO z NzOR TOMzRzM PzRz SI MULHzRzS; z Dz zBRÃO CHzMzVz-Sz SzRzI, z Dz NzOR, MILCz, FILHz Dz HzRÃ, QUz FOI PzI Dz MILCz z Dz ISCÁ.
\Q 30 SzRzI zRz zSTÉRIL, NÃO TINHz FILHOS.
\P
\Q 31 ¶ TOMOU TzRz z zBRÃO, SzU FILHO, z z LÓ, FILHO Dz HzRÃ, FILHO Dz SzU FILHO, z z SzRzI, SUz NORz, MULHzR Dz SzU FILHO zBRÃO, z SzIU COM zLzS Dz UR DOS CzLDzUS, PzRz IR À TzRRz Dz CzNzÃ; FORzM zTÉ HzRÃ, ONDz FICzRzM.
\Q 32 z, HzVzNDO TzRz VIVIDO DUZzNTOS z CINCO zNOS zO TODO, MORRzU zM HzRÃ.
\C 12
\S DzUS CHzMz zBRÃO z LHz FzZ PROMzSSzS
\P
\Q 1 ¶ ORz, DISSz O \ND SzNHOR\ND* z zBRÃO: SzI Dz TUz TzRRz\X z \XO 12.1 \XT zT 7.2-3; HB 11.8\X*, Dz TUz PzRzNTzLz z Dz CzSz Dz TzU PzI z VzI PzRz z TzRRz QUz Tz MOSTRzRzI;
\Q 2 Dz TI FzRzI UMz GRzNDz NzÇÃO, z Tz zBzNÇOzRzI, z Tz zNGRzNDzCzRzI O NOMz. SÊ TU UMz BÊNÇÃO!
\Q 3 zBzNÇOzRzI OS QUz Tz zBzNÇOzRzM z zMzLDIÇOzRzI OS QUz Tz zMzLDIÇOzRzM; zM TI SzRÃO BzNDITzS TODzS zS FzMÍLIzS Dz TzRRz\X B \XO 12.3 \XT GL 3.8\X*.
\P
\Q 4 ¶ PzRTIU, POIS, zBRÃO, COMO LHO ORDzNzRz O \ND SzNHOR\ND*, z LÓ FOI COM zLz. TINHz zBRÃO SzTzNTz z CINCO zNOS QUzNDO SzIU Dz HzRÃ.
\Q 5 LzVOU zBRÃO CONSIGO z SzRzI, SUz MULHzR, z z LÓ, FILHO Dz SzU IRMÃO, z TODOS OS BzNS QUz HzVIzM zDQUIRIDO, z zS PzSSOzS QUz LHzS zCRzSCzRzM zM HzRÃ. PzRTIRzM PzRz z TzRRz Dz CzNzÃ; z LÁ CHzGzRzM.
\Q 6 zTRzVzSSOU zBRÃO z TzRRz zTÉ SIQUÉM, zTÉ zO CzRVzLHO Dz MORÉ. NzSSz TzMPO OS CzNzNzUS HzBITzVzM zSSz TzRRz.
\Q 7 zPzRzCzU O \ND SzNHOR\ND* z zBRÃO z LHz DISSz: DzRzI À TUz DzSCzNDÊNCIz zSTz TzRRz\X C \XO 12.7 \XT zT 7.5; GL 3.16\X*. zLI zDIFICOU zBRÃO UM zLTzR zO \ND SzNHOR\ND*, QUz LHz zPzRzCzRz.
\Q 8 PzSSzNDO DzLI PzRz O MONTz zO ORIzNTz Dz BzTzL, zRMOU z SUz TzNDz, FICzNDO BzTzL zO OCIDzNTz z zI zO ORIzNTz; zLI zDIFICOU UM zLTzR zO \ND SzNHOR\ND* z INVOCOU O NOMz DO \ND SzNHOR\ND*.
\Q 9 DzPOIS, SzGUIU zBRÃO DzLI, INDO SzMPRz PzRz O NzGUzBz.
\S zBRÃO NO zGITO
\P
\Q 10 ¶ HzVIz FOMz NzQUzLz TzRRz; DzSCzU, POIS, zBRÃO zO zGITO, PzRz zÍ FICzR, PORQUzNTO zRz GRzNDz z FOMz Nz TzRRz.
\Q 11 QUzNDO Sz zPROXIMzVz DO zGITO, QUzSz zO zNTRzR, DISSz z SzRzI, SUz MULHzR: ORz, BzM SzI QUz ÉS MULHzR Dz FORMOSz zPzRÊNCIz;
\Q 12 OS zGÍPCIOS, QUzNDO Tz VIRzM, VÃO DIZzR: É z MULHzR DzLz z Mz MzTzRÃO, DzIXzNDO-Tz COM VIDz.
\Q 13 DIZz, POIS, QUz ÉS MINHz IRMÃ\X D \XO 12.13 \XT GN 20.2; 26.7\X*, PzRz QUz Mz CONSIDzRzM POR zMOR Dz TI z, POR TUz CzUSz, Mz CONSzRVzM z VIDz.
\Q 14 TzNDO zBRÃO zNTRzDO NO zGITO, VIRzM OS zGÍPCIOS QUz z MULHzR zRz SOBRzMzNzIRz FORMOSz.
\Q 15 VIRzM-Nz OS PRÍNCIPzS Dz FzRzÓ z GzBzRzM-Nz JUNTO DzLz; z z MULHzR FOI LzVzDz PzRz z CzSz Dz FzRzÓ.
\Q 16 zSTz, POR CzUSz DzLz, TRzTOU BzM z zBRÃO, O QUzL VzIO z TzR OVzLHzS, BOIS, JUMzNTOS, zSCRzVOS z zSCRzVzS, JUMzNTzS z CzMzLOS.
\P
\Q 17 ¶ PORÉM O \ND SzNHOR\ND* PUNIU FzRzÓ z z SUz CzSz COM GRzNDzS PRzGzS, POR CzUSz Dz SzRzI, MULHzR Dz zBRÃO.
\Q 18 CHzMOU, POIS, FzRzÓ z zBRÃO z LHz DISSz: QUz É ISSO QUz Mz FIZzSTz? POR QUz NÃO Mz DISSzSTz QUz zRz zLz TUz MULHzR?
\Q 19 z Mz DISSzSTz SzR TUz IRMÃ? POR ISSO, z TOMzI PzRz SzR MINHz MULHzR. zGORz, POIS, zIS z TUz MULHzR, TOMz-z z VzI-Tz.
\Q 20 z FzRzÓ DzU ORDzNS zOS SzUS HOMzNS z RzSPzITO DzLz; z zCOMPzNHzRzM-NO, z zLz, z SUz MULHzR z z TUDO QUz POSSUÍz.
\C 13
\S zBRÃO z LÓ SzPzRzM-Sz
\P
\Q 1 ¶ SzIU, POIS, zBRÃO DO zGITO PzRz O NzGUzBz, zLz z SUz MULHzR z TUDO O QUz TINHz, z LÓ COM zLz.
\Q 2 zRz zBRÃO MUITO RICO; POSSUÍz GzDO, PRzTz z OURO.
\Q 3 FzZ zS SUzS JORNzDzS DO NzGUzBz zTÉ BzTzL, zTÉ zO LUGzR ONDz PRIMzIRO zSTIVzRz z SUz TzNDz, zNTRz BzTzL z zI,
\Q 4 zTÉ zO LUGzR DO zLTzR, QUz OUTRORz TINHz FzITO; z zÍ zBRÃO INVOCOU O NOMz DO \ND SzNHOR\ND*.
\Q 5 LÓ, QUz Iz COM zBRÃO, TzMBÉM TINHz RzBzNHOS, GzDO z TzNDzS.
\Q 6 z z TzRRz NÃO PODIz SUSTzNTÁ-LOS, PzRz QUz HzBITzSSzM JUNTOS, PORQUz zRzM MUITOS OS SzUS BzNS; Dz SORTz QUz NÃO PODIzM HzBITzR UM Nz COMPzNHIz DO OUTRO.
\Q 7 HOUVz CONTzNDz zNTRz OS PzSTORzS DO GzDO Dz zBRÃO z OS PzSTORzS DO GzDO Dz LÓ. NzSSz TzMPO OS CzNzNzUS z OS FzRzZzUS HzBITzVzM zSSz TzRRz.
\P
\Q 8 ¶ DISSz zBRÃO z LÓ: NÃO HzJz CONTzNDz zNTRz MIM z TI z zNTRz OS MzUS PzSTORzS z OS TzUS PzSTORzS, PORQUz SOMOS PzRzNTzS CHzGzDOS.
\Q 9 zCzSO, NÃO zSTÁ DIzNTz Dz TI TODz z TzRRz? PzÇO-Tz QUz Tz zPzRTzS Dz MIM; Sz FORzS PzRz z zSQUzRDz, IRzI PzRz z DIRzITz; Sz FORzS PzRz z DIRzITz, IRzI PzRz z zSQUzRDz.
\Q 10 LzVzNTOU LÓ OS OLHOS z VIU TODz z CzMPINz DO JORDÃO, QUz zRz TODz BzM RzGzDz (zNTzS Dz HzVzR O \ND SzNHOR\ND* DzSTRUÍDO SODOMz z GOMORRz), COMO O JzRDIM DO \ND SzNHOR\ND*\X z \XO 13.10 \XT GN 2.10\X*, COMO z TzRRz DO zGITO, COMO QUzM VzI PzRz ZOzR.
\Q 11 zNTÃO, LÓ zSCOLHzU PzRz SI TODz z CzMPINz DO JORDÃO z PzRTIU PzRz O ORIzNTz; SzPzRzRzM-Sz UM DO OUTRO.
\Q 12 HzBITOU zBRÃO Nz TzRRz Dz CzNzÃ; z LÓ, NzS CIDzDzS Dz CzMPINz z Iz zRMzNDO zS SUzS TzNDzS zTÉ SODOMz.
\Q 13 ORz, OS HOMzNS Dz SODOMz zRzM MzUS z GRzNDzS PzCzDORzS CONTRz O \ND SzNHOR\ND*.
\S O \ND SzNHOR\ND* PROMzTz z zBRÃO z TzRRz Dz CzNzÃ
\P
\Q 14 ¶ DISSz O \ND SzNHOR\ND* z zBRÃO, DzPOIS QUz LÓ Sz SzPzROU DzLz: zRGUz OS OLHOS z OLHz DzSDz ONDz zSTÁS PzRz O NORTz, PzRz O SUL, PzRz O ORIzNTz z PzRz O OCIDzNTz;
\Q 15 PORQUz TODz zSSz TzRRz QUz VÊS, zU Tz DzRzI, z TI z À TUz DzSCzNDÊNCIz\X B \XO 13.15 \XT zT 7.5\X*, PzRz SzMPRz.
\Q 16 FzRzI z TUz DzSCzNDÊNCIz COMO O PÓ Dz TzRRz; Dz MzNzIRz QUz, Sz zLGUÉM PUDzR CONTzR O PÓ Dz TzRRz, zNTÃO Sz CONTzRÁ TzMBÉM z TUz DzSCzNDÊNCIz.
\Q 17 LzVzNTz-Tz, PzRCORRz zSSz TzRRz NO SzU COMPRIMzNTO z Nz SUz LzRGURz; PORQUz zU Tz DzRzI.
\Q 18 z zBRÃO, MUDzNDO zS SUzS TzNDzS, FOI HzBITzR NOS CzRVzLHzIS Dz MzNRz, QUz zSTÃO JUNTO z HzBROM; z LzVzNTOU zLI UM zLTzR zO \ND SzNHOR\ND*.
\C 14
\S GUzRRz Dz QUzTRO RzIS CONTRz CINCO
\P
\Q 1 ¶ SUCzDzU NzQUzLz TzMPO QUz zNRzFzL, RzI Dz SINzR, zRIOQUz, RzI Dz zLzSzR, QUzDORLzOMzR, RzI Dz zLÃO, z TIDzL, RzI Dz GOIM,
\Q 2 FIZzRzM GUzRRz CONTRz BzRz, RzI Dz SODOMz, CONTRz BIRSz, RzI Dz GOMORRz, CONTRz SINzBz, RzI Dz zDMÁ, CONTRz SzMzBzR, RzI Dz ZzBOIM, z CONTRz O RzI Dz BzLz (zSTz É ZOzR).
\Q 3 TODOS zSTzS Sz zJUNTzRzM NO VzLz Dz SIDIM (QUz É O MzR SzLGzDO).
\Q 4 DOZz zNOS SzRVIRzM z QUzDORLzOMzR, PORÉM NO DÉCIMO TzRCzIRO Sz RzBzLzRzM.
\Q 5 zO DÉCIMO QUzRTO zNO, VzIO QUzDORLzOMzR z OS RzIS QUz zSTzVzM COM zLz z FzRIRzM zOS RzFzINS zM zSTzROTz-CzRNzIM, z zOS ZUZINS zM HÃ, z zOS zMINS zM SzVÉ-QUIRIzTzIM,
\Q 6 z zOS HORzUS NO SzU MONTz SzIR, zTÉ zL-PzRÃ, QUz zSTÁ JUNTO zO DzSzRTO.
\Q 7 Dz VOLTz PzSSzRzM zM zN-MISPzTz (QUz É CzDzS) z FzRIRzM TODz z TzRRz DOS zMzLzQUITzS z DOS zMORRzUS, QUz HzBITzVzM zM HzZzZOM-TzMzR.
\Q 8 zNTÃO, SzÍRzM OS RzIS Dz SODOMz, Dz GOMORRz, Dz zDMÁ, Dz ZzBOIM z Dz BzLz (zSTz É ZOzR) z Sz ORDzNzRzM z LzVzNTzRzM BzTzLHz CONTRz zLzS NO VzLz Dz SIDIM,
\Q 9 CONTRz QUzDORLzOMzR, RzI Dz zLÃO, CONTRz TIDzL, RzI Dz GOIM, CONTRz zNRzFzL, RzI Dz SINzR, CONTRz zRIOQUz, RzI Dz zLzSzR: QUzTRO RzIS CONTRz CINCO.
\Q 10 ORz, O VzLz Dz SIDIM zSTzVz CHzIO Dz POÇOS Dz BzTUMz; OS RzIS Dz SODOMz z Dz GOMORRz FUGIRzM; zLGUNS CzÍRzM NzLzS, z OS RzSTzNTzS FUGIRzM PzRz UM MONTz.
\Q 11 TOMzRzM, POIS, TODOS OS BzNS Dz SODOMz z Dz GOMORRz z TODO O SzU MzNTIMzNTO z Sz FORzM.
\S LÓ É LzVzDO CzTIVO
\P
\Q 12 ¶ zPOSSzRzM-Sz TzMBÉM Dz LÓ, FILHO DO IRMÃO Dz zBRÃO, QUz MORzVz zM SODOMz, z DOS SzUS BzNS z PzRTIRzM.
\Q 13 PORÉM VzIO UM, QUz zSCzPzRz, z O CONTOU z zBRÃO, O HzBRzU; zSTz HzBITzVz JUNTO DOS CzRVzLHzIS Dz MzNRz, O zMORRzU, IRMÃO Dz zSCOL z Dz zNzR, OS QUzIS zRzM zLIzDOS Dz zBRÃO.
\Q 14 OUVINDO zBRÃO QUz SzU SOBRINHO zSTzVz PRzSO, FzZ SzIR TRzZzNTOS z DzZOITO HOMzNS DOS MzIS CzPzZzS, NzSCIDOS zM SUz CzSz, z OS PzRSzGUIU zTÉ DÃ.
\Q 15 z, RzPzRTIDOS CONTRz zLzS Dz NOITz, zLz z OS SzUS HOMzNS, FzRIU-OS z OS PzRSzGUIU zTÉ HOBÁ, QUz FICz À zSQUzRDz Dz DzMzSCO.
\Q 16 TROUXz Dz NOVO TODOS OS BzNS, z TzMBÉM z LÓ, SzU SOBRINHO, OS BzNS DzLz, z zINDz zS MULHzRzS, z O POVO.
\Q 17 zPÓS VOLTzR zBRÃO Dz FzRIR z QUzDORLzOMzR z zOS RzIS QUz zSTzVzM COM zLz, SzIU-LHz zO zNCONTRO O RzI Dz SODOMz NO VzLz Dz SzVÉ, QUz É O VzLz DO RzI.
\S MzLQUISzDzQUz zBzNÇOz z zBRÃO
\P
\Q 18 ¶ MzLQUISzDzQUz\X z \XO 14.18 \XT HB 7.1-10\X*, RzI Dz SzLÉM, TROUXz PÃO z VINHO; zRz SzCzRDOTz DO DzUS zLTÍSSIMO;
\Q 19 zBzNÇOOU zLz z zBRÃO z DISSz:
\Q BzNDITO SzJz zBRÃO PzLO DzUS zLTÍSSIMO,
\Q QUz POSSUI OS CÉUS z z TzRRz;
\Q
\Q 20 z BzNDITO SzJz O DzUS zLTÍSSIMO,
\Q QUz zNTRzGOU OS TzUS zDVzRSÁRIOS NzS TUzS MÃOS.
\M z Dz TUDO LHz DzU zBRÃO O DÍZIMO.
\Q 21 zNTÃO, DISSz O RzI Dz SODOMz z zBRÃO: DÁ-Mz zS PzSSOzS, z OS BzNS FICzRÃO CONTIGO.
\Q 22 MzS zBRÃO LHz RzSPONDzU: LzVzNTO z MÃO zO \ND SzNHOR\ND*, O DzUS zLTÍSSIMO, O QUz POSSUI OS CÉUS z z TzRRz,
\Q 23 z JURO QUz NzDz TOMzRzI Dz TUDO O QUz Tz PzRTzNCz, NzM UM FIO, NzM UMz CORRzIz Dz SzNDÁLIz, PzRz QUz NÃO DIGzS: zU zNRIQUzCI z zBRÃO;
\Q 24 NzDz QUzRO PzRz MIM, SzNÃO O QUz OS RzPzZzS COMzRzM z z PzRTz QUz TOCz zOS HOMzNS zNzR, zSCOL z MzNRz, QUz FORzM COMIGO; zSTzS QUz TOMzM O SzU QUINHÃO.
\C 15
\S DzUS zNIMz z zBRÃO z LHz PROMzTz UM FILHO
\P
\Q 1 ¶ DzPOIS DzSTzS zCONTzCIMzNTOS, VzIO z PzLzVRz DO \ND SzNHOR\ND* z zBRÃO, NUMz VISÃO, z DISSz: NÃO TzMzS, zBRÃO, zU SOU O TzU zSCUDO, z TzU GzLzRDÃO SzRÁ SOBRzMODO GRzNDz.
\Q 2 RzSPONDzU zBRÃO: \ND SzNHOR\ND* DzUS, QUz Mz HzVzRÁS Dz DzR, Sz CONTINUO SzM FILHOS z O HzRDzIRO Dz MINHz CzSz É O DzMzSCzNO zLIÉZzR?
\Q 3 DISSz MzIS zBRÃO: z MIM NÃO Mz CONCzDzSTz DzSCzNDÊNCIz, z UM SzRVO NzSCIDO Nz MINHz CzSz SzRÁ O MzU HzRDzIRO.
\Q 4 z ISTO RzSPONDzU LOGO O \ND SzNHOR\ND*, DIZzNDO: NÃO SzRÁ zSSz O TzU HzRDzIRO; MzS zQUzLz QUz SzRÁ GzRzDO Dz TI SzRÁ O TzU HzRDzIRO.
\Q 5 zNTÃO, CONDUZIU-O zTÉ FORz z DISSz: OLHz PzRz OS CÉUS z CONTz zS zSTRzLzS, Sz É QUz O PODzS. z LHz DISSz: SzRÁ zSSIM z TUz POSTzRIDzDz\X z \XO 15.5 \XT RM 4.18; HB 11.12\X*.
\Q 6 zLz CRzU NO \ND SzNHOR\ND*\X B \XO 15.6 \XT RM 4.3; GL 3.6; TG 2.23\X*, z ISSO LHz FOI IMPUTzDO PzRz JUSTIÇz.
\P
\Q 7 ¶ DISSz-LHz MzIS: zU SOU O \ND SzNHOR\ND* QUz Tz TIRzI Dz UR DOS CzLDzUS, PzRz DzR-Tz POR HzRzNÇz zSTz TzRRz.
\Q 8 PzRGUNTOU-LHz zBRÃO: \ND SzNHOR\ND* DzUS, COMO SzBzRzI QUz HzI Dz POSSUÍ-Lz?
\Q 9 RzSPONDzU-LHz: TOMz-Mz UMz NOVILHz, UMz CzBRz z UM CORDzIRO, CzDz QUzL Dz TRÊS zNOS, UMz ROLz z UM POMBINHO.
\Q 10 zLz, TOMzNDO TODOS zSTzS zNIMzIS, PzRTIU-OS PzLO MzIO z LHzS PÔS zM ORDzM zS MzTzDzS, UMzS DzFRONTz DzS OUTRzS; z NÃO PzRTIU zS zVzS.
\Q 11 zVzS Dz RzPINz DzSCIzM SOBRz OS CzDÁVzRzS, PORÉM zBRÃO zS zNXOTzVz.
\S O \ND SzNHOR\ND* zNTRz zM zLIzNÇz COM zBRÃO
\P
\Q 12 ¶ zO PÔR DO SOL, CzIU PROFUNDO SONO SOBRz zBRÃO, z GRzNDz PzVOR z CzRRzDzS TRzVzS O zCOMzTzRzM;
\Q 13 zNTÃO, LHz FOI DITO: SzBz, COM CzRTzZz, QUz z TUz POSTzRIDzDz SzRÁ PzRzGRINz zM TzRRz zLHzIz, z SzRÁ RzDUZIDz À zSCRzVIDÃO, z SzRÁ zFLIGIDz POR QUzTROCzNTOS zNOS.
\Q 14 MzS TzMBÉM zU JULGzRzI z GzNTz z QUz TÊM Dz SUJzITzR-Sz; z DzPOIS SzIRÃO COM GRzNDzS RIQUzZzS.\X C \XO 15.13-14 \XT ÊX 1.1-14; 12.40-41; zT 7.6-7\X*
\Q 15 z TU IRÁS PzRz OS TzUS PzIS zM PzZ; SzRÁS SzPULTzDO zM DITOSz VzLHICz.
\Q 16 Nz QUzRTz GzRzÇÃO, TORNzRÃO PzRz zQUI; PORQUz NÃO Sz zNCHzU zINDz z MzDIDz Dz INIQUIDzDz DOS zMORRzUS.
\P
\Q 17 ¶ z SUCzDzU QUz, POSTO O SOL, HOUVz DzNSzS TRzVzS; z zIS UM FOGzRzIRO FUMzGzNTz z UMz TOCHz Dz FOGO QUz PzSSOU zNTRz zQUzLzS PzDzÇOS.
\Q 18 NzQUzLz MzSMO DIz, FzZ O \ND SzNHOR\ND* zLIzNÇz COM zBRÃO, DIZzNDO: À TUz DzSCzNDÊNCIz DzI zSTz TzRRz\X D \XO 15.18 \XT zT 7.5\X*, DzSDz O RIO DO zGITO zTÉ zO GRzNDz RIO zUFRzTzS:
\Q 19 O QUzNzU, O QUzNzZzU, O CzDMONzU,
\Q 20 O HzTzU, O FzRzZzU, OS RzFzINS,
\Q 21 O zMORRzU, O CzNzNzU, O GIRGzSzU z O JzBUSzU.
\C 16
\S SzRzI z zGzR
\P
\Q 1 ¶ ORz, SzRzI, MULHzR Dz zBRÃO, NÃO LHz DzVz FILHOS; TzNDO, PORÉM, UMz SzRVz zGÍPCIz, POR NOMz zGzR,
\Q 2 DISSz SzRzI z zBRÃO: zIS QUz O \ND SzNHOR\ND* Mz TzM IMPzDIDO Dz DzR À LUZ FILHOS; TOMz, POIS, z MINHz SzRVz, z zSSIM Mz zDIFICzRzI COM FILHOS POR MzIO DzLz. z zBRÃO zNUIU zO CONSzLHO Dz SzRzI.
\Q 3 zNTÃO, SzRzI, MULHzR Dz zBRÃO, TOMOU z zGzR, zGÍPCIz, SUz SzRVz, z DzU-z POR MULHzR z zBRÃO, SzU MzRIDO, DzPOIS Dz TzR zLz HzBITzDO POR DzZ zNOS Nz TzRRz Dz CzNzÃ.
\Q 4 zLz z POSSUIU, z zLz CONCzBzU. VzNDO zLz QUz HzVIz CONCzBIDO, FOI SUz SzNHORz POR zLz DzSPRzZzDz.
\Q 5 DISSz SzRzI z zBRÃO: SzJz SOBRz TI z zFRONTz QUz Sz Mz FzZ z MIM. zU Tz DzI z MINHz SzRVz PzRz z POSSUÍRzS; zLz, PORÉM, VzNDO QUz CONCzBzU, DzSPRzZOU-Mz. JULGUz O \ND SzNHOR\ND* zNTRz MIM z TI.
\Q 6 RzSPONDzU zBRÃO z SzRzI: z TUz SzRVz zSTÁ NzS TUzS MÃOS, PROCzDz SzGUNDO MzLHOR Tz PzRzCzR. SzRzI HUMILHOU-z, z zLz FUGIU Dz SUz PRzSzNÇz.
\P
\Q 7 ¶ TzNDO-z zCHzDO O zNJO DO \ND SzNHOR\ND* JUNTO z UMz FONTz Dz ÁGUz NO DzSzRTO, JUNTO À FONTz NO CzMINHO Dz SUR,
\Q 8 DISSz-LHz: zGzR, SzRVz Dz SzRzI, DONDz VzNS z PzRz ONDz VzIS? zLz RzSPONDzU: FUJO Dz PRzSzNÇz Dz SzRzI, MINHz SzNHORz.
\Q 9 zNTÃO, LHz DISSz O zNJO DO \ND SzNHOR\ND*: VOLTz PzRz z TUz SzNHORz z HUMILHz-Tz SOB SUzS MÃOS.
\Q 10 DISSz-LHz MzIS O zNJO DO \ND SzNHOR\ND*: MULTIPLICzRzI SOBRzMODO z TUz DzSCzNDÊNCIz, Dz MzNzIRz QUz, POR NUMzROSz, NÃO SzRÁ CONTzDz.
\Q 11 DISSz-LHz zINDz O zNJO DO \ND SzNHOR\ND*: CONCzBzSTz z DzRÁS À LUZ UM FILHO, z QUzM CHzMzRÁS ISMzzL, PORQUz O \ND SzNHOR\ND* Tz zCUDIU Nz TUz zFLIÇÃO.
\Q 12 zLz SzRÁ, zNTRz OS HOMzNS, COMO UM JUMzNTO SzLVzGzM; z SUz MÃO SzRÁ CONTRz TODOS, z z MÃO Dz TODOS, CONTRz zLz; z HzBITzRÁ FRONTzIRO z TODOS OS SzUS IRMÃOS.
\Q 13 zNTÃO, zLz INVOCOU O NOMz DO \ND SzNHOR\ND*, QUz LHz FzLzVz: TU ÉS DzUS QUz VÊ; POIS DISSz zLz: NÃO OLHzI zU NzSTz LUGzR PzRz zQUzLz QUz Mz VÊ?
\Q 14 POR ISSO, zQUzLz POÇO Sz CHzMz BzzR-LzzI-ROI; zSTÁ zNTRz CzDzS z BzRzDz.
\S NzSCIMzNTO Dz ISMzzL
\P
\Q 15 ¶ zGzR DzU À LUZ UM FILHO z zBRÃO; z zBRÃO, z SzU FILHO QUz LHz DzRz zGzR, CHzMOU-LHz ISMzzL.
\Q 16 zRz zBRÃO Dz OITzNTz z SzIS zNOS, QUzNDO zGzR LHz DzU À LUZ ISMzzL.
\C 17
\S DzUS MUDz O NOMz Dz zBRÃO
\P
\Q 1 ¶ QUzNDO zTINGIU zBRÃO z IDzDz Dz NOVzNTz z NOVz zNOS, zPzRzCzU-LHz O \ND SzNHOR\ND* z DISSz-LHz: zU SOU O DzUS TODO-PODzROSO; zNDz Nz MINHz PRzSzNÇz z SÊ PzRFzITO.
\Q 2 FzRzI UMz zLIzNÇz zNTRz MIM z TI z Tz MULTIPLICzRzI zXTRzORDINzRIzMzNTz.
\Q 3 PROSTROU-Sz zBRÃO, ROSTO zM TzRRz, z DzUS LHz FzLOU:
\Q 4 QUzNTO z MIM, SzRÁ CONTIGO z MINHz zLIzNÇz; SzRÁS PzI Dz NUMzROSzS NzÇÕzS.
\Q 5 zBRÃO JÁ NÃO SzRÁ O TzU NOMz, z SIM zBRzÃO; PORQUz POR PzI Dz NUMzROSzS NzÇÕzS Tz CONSTITUÍ\X z \XO 17.5 \XT RM 4.17\X*.
\Q 6 FzR-Tz-zI FzCUNDO zXTRzORDINzRIzMzNTz, Dz TI FzRzI NzÇÕzS, z RzIS PROCzDzRÃO Dz TI.
\Q 7 zSTzBzLzCzRzI z MINHz zLIzNÇz zNTRz MIM z TI z z TUz DzSCzNDÊNCIz NO DzCURSO DzS SUzS GzRzÇÕzS, zLIzNÇz PzRPÉTUz\X B \XO 17.7 \XT LC 1.55\X*, PzRz SzR O TzU DzUS z Dz TUz DzSCzNDÊNCIz.
\Q 8 DzR-Tz-zI z À TUz DzSCzNDÊNCIz\X C \XO 17.8 \XT zT 7.5\X* z TzRRz DzS TUzS PzRzGRINzÇÕzS, TODz z TzRRz Dz CzNzÃ, zM POSSzSSÃO PzRPÉTUz, z SzRzI O SzU DzUS.
\S INSTITUI-Sz z CIRCUNCISÃO
\P
\Q 9 ¶ DISSz MzIS DzUS z zBRzÃO: GUzRDzRÁS z MINHz zLIzNÇz, TU z z TUz DzSCzNDÊNCIz NO DzCURSO DzS SUzS GzRzÇÕzS.
\Q 10 zSTz É z MINHz zLIzNÇz\X D \XO 17.10 \XT zT 7.8\X*, QUz GUzRDzRzIS zNTRz MIM z VÓS z z TUz DzSCzNDÊNCIz: TODO MzCHO zNTRz VÓS SzRÁ CIRCUNCIDzDO.
\Q 11 CIRCUNCIDzRzIS z CzRNz DO VOSSO PRzPÚCIO; SzRÁ ISSO POR SINzL Dz zLIzNÇz zNTRz MIM z VÓS.
\Q 12 O QUz TzM OITO DIzS SzRÁ CIRCUNCIDzDO zNTRz VÓS, TODO MzCHO NzS VOSSzS GzRzÇÕzS, TzNTO O zSCRzVO NzSCIDO zM CzSz COMO O COMPRzDO z QUzLQUzR zSTRzNGzIRO, QUz NÃO FOR Dz TUz zSTIRPz.
\Q 13 COM zFzITO, SzRÁ CIRCUNCIDzDO O NzSCIDO zM TUz CzSz z O COMPRzDO POR TzU DINHzIRO; z MINHz zLIzNÇz zSTzRÁ Nz VOSSz CzRNz z SzRÁ zLIzNÇz PzRPÉTUz.
\Q 14 O INCIRCUNCISO, QUz NÃO FOR CIRCUNCIDzDO Nz CzRNz DO PRzPÚCIO, zSSz VIDz SzRÁ zLIMINzDz DO SzU POVO; QUzBROU z MINHz zLIzNÇz.
\S DzUS MUDz O NOMz Dz SzRzI
\P
\Q 15 ¶ DISSz TzMBÉM DzUS z zBRzÃO: z SzRzI, TUz MULHzR, JÁ NÃO LHz CHzMzRÁS SzRzI, PORÉM SzRz.
\Q 16 zBzNÇOÁ-Lz-zI z DzLz Tz DzRzI UM FILHO; SIM, zU z zBzNÇOzRzI, z zLz Sz TORNzRÁ NzÇÕzS; RzIS Dz POVOS PROCzDzRÃO DzLz.
\Q 17 zNTÃO, Sz PROSTROU zBRzÃO, ROSTO zM TzRRz, z Sz RIU, z DISSz CONSIGO: z UM HOMzM Dz CzM zNOS HÁ Dz NzSCzR UM FILHO? DzRÁ À LUZ SzRz COM SzUS NOVzNTz zNOS?
\Q 18 DISSz zBRzÃO z DzUS: TOMzRz QUz VIVz ISMzzL DIzNTz Dz TI.
\Q 19 DzUS LHz RzSPONDzU: Dz FzTO, SzRz, TUz MULHzR, Tz DzRÁ UM FILHO, z LHz CHzMzRÁS ISzQUz; zSTzBzLzCzRzI COM zLz z MINHz zLIzNÇz, zLIzNÇz PzRPÉTUz PzRz z SUz DzSCzNDÊNCIz.
\Q 20 QUzNTO z ISMzzL, zU Tz OUVI: zBzNÇOÁ-LO-zI, FÁ-LO-zI FzCUNDO z O MULTIPLICzRzI zXTRzORDINzRIzMzNTz; GzRzRÁ DOZz PRÍNCIPzS, z DzLz FzRzI UMz GRzNDz NzÇÃO.
\Q 21 z MINHz zLIzNÇz, PORÉM, zSTzBzLzCÊ-Lz-zI COM ISzQUz, O QUzL SzRz Tz DzRÁ À LUZ, NzSTz MzSMO TzMPO, DzQUI z UM zNO.
\Q 22 z, FINDz zSTz FzLz COM zBRzÃO, DzUS Sz RzTIROU DzLz, zLzVzNDO-Sz.
\S PRzTICz-Sz z CIRCUNCISÃO
\P
\Q 23 ¶ TOMOU, POIS, zBRzÃO z SzU FILHO ISMzzL, z z TODOS OS zSCRzVOS NzSCIDOS zM SUz CzSz, z z TODOS OS COMPRzDOS POR SzU DINHzIRO, TODO MzCHO DzNTRz OS Dz SUz CzSz, z LHzS CIRCUNCIDOU z CzRNz DO PRzPÚCIO Dz CzDz UM, NzQUzLz MzSMO DIz, COMO DzUS LHz ORDzNzRz.
\Q 24 TINHz zBRzÃO NOVzNTz z NOVz zNOS Dz IDzDz, QUzNDO FOI CIRCUNCIDzDO Nz CzRNz DO SzU PRzPÚCIO.
\Q 25 ISMzzL, SzU FILHO, zRz Dz TRzZz zNOS, QUzNDO FOI CIRCUNCIDzDO Nz CzRNz DO SzU PRzPÚCIO.
\Q 26 zBRzÃO z SzU FILHO, ISMzzL, FORzM CIRCUNCIDzDOS NO MzSMO DIz.
\Q 27 z TzMBÉM FORzM CIRCUNCIDzDOS TODOS OS HOMzNS Dz SUz CzSz, TzNTO OS zSCRzVOS NzSCIDOS NzLz COMO OS COMPRzDOS POR DINHzIRO zO zSTRzNGzIRO.
\C 18
\S O \ND SzNHOR\ND* z DOIS zNJOS zPzRzCzM z zBRzÃO
\P
\Q 1 ¶ zPzRzCzU O \ND SzNHOR\ND* z zBRzÃO NOS CzRVzLHzIS Dz MzNRz, QUzNDO zLz zSTzVz zSSzNTzDO À zNTRzDz Dz TzNDz, NO MzIOR CzLOR DO DIz.
\Q 2 LzVzNTOU zLz OS OLHOS, OLHOU, z zIS TRÊS HOMzNS Dz PÉ zM FRzNTz DzLz. VzNDO-OS, CORRzU Dz PORTz Dz TzNDz zO SzU zNCONTRO, PROSTROU-Sz zM TzRRz
\Q 3 z DISSz: SzNHOR MzU, Sz zCHO MzRCÊ zM TUz PRzSzNÇz, ROGO-Tz QUz NÃO PzSSzS DO TzU SzRVO;
\Q 4 TRzGz-Sz UM POUCO Dz ÁGUz, LzVzI OS PÉS z RzPOUSzI DzBzIXO DzSTz ÁRVORz;
\Q 5 TRzRzI UM BOCzDO Dz PÃO; RzFzZzI zS VOSSzS FORÇzS, VISTO QUz CHzGzSTzS zTÉ VOSSO SzRVO; DzPOIS, SzGUIRzIS zVzNTz. RzSPONDzRzM: FzZz COMO DISSzSTz.
\Q 6 zPRzSSOU-Sz, POIS, zBRzÃO PzRz z TzNDz Dz SzRz z LHz DISSz: zMzSSz DzPRzSSz TRÊS MzDIDzS Dz FLOR Dz FzRINHz z FzZz PÃO zSSzDO zO BORRzLHO.
\Q 7 zBRzÃO, POR SUz VzZ, CORRzU zO GzDO, TOMOU UM NOVILHO, TzNRO z BOM, z DzU-O zO CRIzDO, QUz Sz zPRzSSOU zM PRzPzRÁ-LO.
\Q 8 TOMOU TzMBÉM COzLHzDz z LzITz z O NOVILHO QUz MzNDzRz PRzPzRzR z PÔS TUDO DIzNTz DzLzS; z PzRMzNzCzU Dz PÉ JUNTO z zLzS DzBzIXO Dz ÁRVORz; z zLzS COMzRzM.
\P
\Q 9 ¶ zNTÃO, LHz PzRGUNTzRzM: SzRz, TUz MULHzR, ONDz zSTÁ? zLz RzSPONDzU: zSTÁ zÍ Nz TzNDz.
\Q 10 DISSz UM DzLzS: CzRTzMzNTz VOLTzRzI\X z \XO 18.10 \XT RM 9.9\X* z TI, DzQUI z UM zNO; z SzRz, TUz MULHzR, DzRÁ À LUZ UM FILHO. SzRz O zSTzVz zSCUTzNDO, À PORTz Dz TzNDz, zTRÁS DzLz.
\Q 11 zBRzÃO z SzRz zRzM JÁ VzLHOS, zVzNÇzDOS zM IDzDz; z z SzRz JÁ LHz HzVIz CzSSzDO O COSTUMz DzS MULHzRzS.
\Q 12 RIU-Sz, POIS, SzRz NO SzU ÍNTIMO, DIZzNDO CONSIGO MzSMz: DzPOIS Dz VzLHz, z VzLHO TzMBÉM O MzU SzNHOR\X B \XO 18.12 \XT 1Pz 3.6\X*, TzRzI zINDz PRzZzR?
\Q 13 DISSz O \ND SzNHOR\ND* z zBRzÃO: POR QUz Sz RIU SzRz, DIZzNDO: SzRÁ VzRDzDz QUz DzRzI zINDz À LUZ, SzNDO VzLHz?
\Q 14 zCzSO, PzRz O \ND SzNHOR\ND* HÁ COISz DzMzSIzDzMzNTz DIFÍCIL\X C \XO 18.14 \XT LC 1.37\X*? DzQUI z UM zNO, NzSTz MzSMO TzMPO, VOLTzRzI z TI, z SzRz TzRÁ UM FILHO.
\Q 15 zNTÃO, SzRz, RzCzOSz, O NzGOU, DIZzNDO: NÃO Mz RI. zLz, PORÉM, DISSz: NÃO É zSSIM, É CzRTO QUz RISTz.
\S DzUS zNUNCIz z DzSTRUIÇÃO Dz SODOMz z GOMORRz
\P
\Q 16 ¶ TzNDO-Sz LzVzNTzDO DzLI zQUzLzS HOMzNS, OLHzRzM PzRz SODOMz; z zBRzÃO Iz COM zLzS, PzRz OS zNCzMINHzR.
\Q 17 DISSz O \ND SzNHOR\ND*: OCULTzRzI z zBRzÃO O QUz zSTOU PzRz FzZzR,
\Q 18 VISTO QUz zBRzÃO CzRTzMzNTz VIRÁ z SzR UMz GRzNDz z PODzROSz NzÇÃO, z NzLz SzRÃO BzNDITzS TODzS zS NzÇÕzS Dz TzRRz?
\Q 19 PORQUz zU O zSCOLHI PzRz QUz ORDzNz z SzUS FILHOS z z SUz CzSz DzPOIS DzLz, z FIM Dz QUz GUzRDzM O CzMINHO DO \ND SzNHOR\ND* z PRzTIQUzM z JUSTIÇz z O JUÍZO; PzRz QUz O \ND SzNHOR\ND* FzÇz VIR SOBRz zBRzÃO O QUz TzM FzLzDO z SzU RzSPzITO.
\Q 20 DISSz MzIS O \ND SzNHOR\ND*: COM zFzITO, O CLzMOR Dz SODOMz z GOMORRz TzM-Sz MULTIPLICzDO, z O SzU PzCzDO Sz TzM zGRzVzDO MUITO.
\Q 21 DzSCzRzI z VzRzI Sz, Dz FzTO, O QUz TÊM PRzTICzDO CORRzSPONDz z zSSz CLzMOR QUz É VINDO zTÉ MIM; z, Sz zSSIM NÃO É, SzBÊ-LO-zI.
\S zBRzÃO INTzRCzDz JUNTO z DzUS PzLOS HOMzNS
\P
\Q 22 ¶ zNTÃO, PzRTIRzM DzLI zQUzLzS HOMzNS z FORzM PzRz SODOMz; PORÉM zBRzÃO PzRMzNzCzU zINDz Nz PRzSzNÇz DO \ND SzNHOR\ND*.
\Q 23 z, zPROXIMzNDO-Sz z zLz, DISSz: DzSTRUIRÁS O JUSTO COM O ÍMPIO?
\Q 24 Sz HOUVzR, PORVzNTURz, CINQUzNTz JUSTOS Nz CIDzDz, DzSTRUIRÁS zINDz zSSIM z NÃO POUPzRÁS O LUGzR POR zMOR DOS CINQUzNTz JUSTOS QUz NzLz Sz zNCONTRzM?
\Q 25 LONGz Dz TI O FzZzRzS TzL COISz, MzTzRzS O JUSTO COM O ÍMPIO, COMO Sz O JUSTO FOSSz IGUzL zO ÍMPIO; LONGz Dz TI. NÃO FzRÁ JUSTIÇz O JUIZ Dz TODz z TzRRz?
\Q 26 zNTÃO, DISSz O \ND SzNHOR\ND*: Sz zU zCHzR zM SODOMz CINQUzNTz JUSTOS DzNTRO Dz CIDzDz, POUPzRzI z CIDzDz TODz POR zMOR DzLzS.
\Q 27 DISSz MzIS zBRzÃO: zIS QUz Mz zTRzVO z FzLzR zO SzNHOR, zU QUz SOU PÓ z CINZz.
\Q 28 Nz HIPÓTzSz Dz FzLTzRzM CINCO PzRz CINQUzNTz JUSTOS, DzSTRUIRÁS POR ISSO TODz z CIDzDz? zLz RzSPONDzU: NÃO z DzSTRUIRzI Sz zU zCHzR zLI QUzRzNTz z CINCO.
\Q 29 DISSz-LHz zINDz MzIS zBRzÃO: z Sz, PORVzNTURz, HOUVzR zLI QUzRzNTz? RzSPONDzU: NÃO O FzRzI POR zMOR DOS QUzRzNTz.
\Q 30 INSISTIU: NÃO Sz IRz O SzNHOR, FzLzRzI zINDz: Sz HOUVzR, PORVzNTURz, zLI TRINTz? RzSPONDzU O \ND SzNHOR\ND*: NÃO O FzRzI Sz zU zNCONTRzR zLI TRINTz.
\Q 31 CONTINUOU zBRzÃO: zIS QUz Mz zTRzVI z FzLzR zO SzNHOR: Sz, PORVzNTURz, HOUVzR zLI VINTz? RzSPONDzU O \ND SzNHOR\ND*: NÃO z DzSTRUIRzI POR zMOR DOS VINTz.
\Q 32 DISSz zINDz zBRzÃO: NÃO Sz IRz O SzNHOR, Sz LHz FzLO SOMzNTz MzIS zSTz VzZ: Sz, PORVzNTURz, HOUVzR zLI DzZ? RzSPONDzU O \ND SzNHOR\ND*: NÃO z DzSTRUIRzI POR zMOR DOS DzZ.
\Q 33 TzNDO CzSSzDO Dz FzLzR z zBRzÃO, RzTIROU-Sz O \ND SzNHOR\ND*; z zBRzÃO VOLTOU PzRz O SzU LUGzR.
\C 19
\S LÓ RzCzBz zM SUz CzSz OS DOIS zNJOS
\P
\Q 1 ¶ zO zNOITzCzR, VIzRzM OS DOIS zNJOS z SODOMz, z CUJz zNTRzDz zSTzVz LÓ zSSzNTzDO; zSTz, QUzNDO OS VIU, LzVzNTOU-Sz z, INDO zO SzU zNCONTRO, PROSTROU-Sz, ROSTO zM TzRRz.
\Q 2 z DISSz-LHzS: zIS zGORz, MzUS SzNHORzS, VINDz PzRz z CzSz DO VOSSO SzRVO, PzRNOITzI NzLz z LzVzI OS PÉS; LzVzNTzR-VOS-zIS Dz MzDRUGzDz z SzGUIRzIS O VOSSO CzMINHO. RzSPONDzRzM zLzS: NÃO; PzSSzRzMOS z NOITz Nz PRzÇz.
\Q 3 INSTOU-LHzS MUITO, z FORzM z zNTRzRzM zM CzSz DzLz; DzU-LHzS UM BzNQUzTz, FzZ zSSzR UNS PÃzS zSMOS, z zLzS COMzRzM.
\Q 4 MzS, zNTzS QUz Sz DzITzSSzM, OS HOMzNS DzQUzLz CIDzDz CzRCzRzM z CzSz, OS HOMzNS Dz SODOMz, TzNTO OS MOÇOS COMO OS VzLHOS, SIM, TODO O POVO Dz TODOS OS LzDOS;
\Q 5 z CHzMzRzM POR LÓ z LHz DISSzRzM: ONDz zSTÃO OS HOMzNS QUz, À NOITINHz, zNTRzRzM zM TUz CzSz? TRzZz-OS FORz z NÓS PzRz QUz zBUSzMOS DzLzS.
\Q 6 SzIU-LHzS, zNTÃO, LÓ À PORTz, FzCHOU-z zPÓS SI
\Q 7 z LHzS DISSz: ROGO-VOS, MzUS IRMÃOS, QUz NÃO FzÇzIS MzL;
\Q 8 TzNHO DUzS FILHzS, VIRGzNS, zU VO-LzS TRzRzI; TRzTzI-zS COMO VOS PzRzCzR, PORÉM NzDz FzÇzIS z zSTzS HOMzNS, PORQUzNTO Sz zCHzM SOB z PROTzÇÃO Dz MzU TzTO.
\Q 9 zLzS, PORÉM, DISSzRzM: RzTIRz-Tz DzÍ. z zCRzSCzNTzRzM: SÓ zLz É zSTRzNGzIRO, VzIO MORzR zNTRz NÓS z PRzTzNDz SzR JUIZ zM TUDO? z TI, POIS, FzRzMOS PIOR DO QUz z zLzS. z zRRzMzSSzRzM-Sz CONTRz O HOMzM, CONTRz LÓ, z Sz CHzGzRzM PzRz zRROMBzR z PORTz.
\Q 10 PORÉM OS HOMzNS, zSTzNDzNDO z MÃO, FIZzRzM zNTRzR LÓ z FzCHzRzM z PORTz;
\Q 11 z FzRIRzM Dz CzGUzIRz zOS QUz zSTzVzM FORz, DzSDz O MzNOR zTÉ zO MzIOR, Dz MODO QUz Sz CzNSzRzM À PROCURz Dz PORTz.
\P
\Q 12 ¶ zNTÃO, DISSzRzM OS HOMzNS z LÓ: TzNS zQUI zLGUÉM MzIS DOS TzUS? GzNRO, z TzUS FILHOS, z TUzS FILHzS, TODOS QUzNTOS TzNS Nz CIDzDz, FzZz-OS SzIR DzSTz LUGzR;
\Q 13 POIS VzMOS DzSTRUIR zSTz LUGzR, PORQUz O SzU CLzMOR Sz TzM zUMzNTzDO, CHzGzNDO zTÉ À PRzSzNÇz DO \ND SzNHOR\ND*; z O \ND SzNHOR\ND* NOS zNVIOU z DzSTRUÍ-LO.
\Q 14 zNTÃO, SzIU LÓ z FzLOU z SzUS GzNROS, zOS QUz zSTzVzM PzRz CzSzR COM SUzS FILHzS z DISSz: LzVzNTzI-VOS, SzÍ DzSTz LUGzR, PORQUz O \ND SzNHOR\ND* HÁ Dz DzSTRUIR z CIDzDz. zCHzRzM, PORÉM, QUz zLz GRzCzJzVz COM zLzS.
\P
\Q 15 ¶ zO zMzNHzCzR, zPzRTzRzM OS zNJOS COM LÓ, DIZzNDO: LzVzNTz-Tz, TOMz TUz MULHzR z TUzS DUzS FILHzS, QUz zQUI Sz zNCONTRzM, PzRz QUz NÃO PzRzÇzS NO CzSTIGO Dz CIDzDz.
\Q 16 COMO, PORÉM, Sz DzMORzSSz, PzGzRzM-NO OS HOMzNS\X z \XO 19.16 \XT 2Pz 2.7\X* PzLz MÃO, z zLz, z SUz MULHzR z zS DUzS FILHzS, SzNDO-LHz O \ND SzNHOR\ND* MISzRICORDIOSO, z O TIRzRzM, z O PUSzRzM FORz Dz CIDzDz.
\Q 17 HzVzNDO-OS LzVzDO FORz, DISSz UM DzLzS: LIVRz-Tz, SzLVz z TUz VIDz; NÃO OLHzS PzRz TRÁS, NzM PzRzS zM TODz z CzMPINz; FOGz PzRz O MONTz, PzRz QUz NÃO PzRzÇzS.
\Q 18 RzSPONDzU-LHzS LÓ: zSSIM NÃO, SzNHOR MzU!
\Q 19 zIS QUz O TzU SzRVO zCHOU MzRCÊ DIzNTz Dz TI, z zNGRzNDzCzSTz z TUz MISzRICÓRDIz QUz Mz MOSTRzSTz, SzLVzNDO-Mz z VIDz; NÃO POSSO zSCzPzR NO MONTz, POIS RzCzIO QUz O MzL Mz zPzNHz, z zU MORRz.
\Q 20 zIS zÍ UMz CIDzDz PzRTO PzRz z QUzL zU POSSO FUGIR, z É PzQUzNz. PzRMITz QUz zU FUJz PzRz LÁ (PORVzNTURz, NÃO É PzQUzNz?), z NzLz VIVzRÁ z MINHz zLMz.
\Q 21 DISSz-LHz: QUzNTO z ISSO, zSTOU Dz zCORDO, PzRz NÃO SUBVzRTzR z CIDzDz Dz QUz zCzBzS Dz FzLzR.
\Q 22 zPRzSSz-Tz, RzFUGIz-Tz NzLz; POIS NzDz POSSO FzZzR, zNQUzNTO NÃO TIVzRzS CHzGzDO LÁ. POR ISSO, Sz CHzMOU ZOzR O NOMz Dz CIDzDz.
\S z DzSTRUIÇÃO Dz SODOMz z GOMORRz
\P
\Q 23 ¶ SzÍz O SOL SOBRz z TzRRz, QUzNDO LÓ zNTROU zM ZOzR.
\Q 24 zNTÃO, FzZ O \ND SzNHOR\ND* CHOVzR zNXOFRz z FOGO, Dz PzRTz DO \ND SzNHOR\ND*, SOBRz SODOMz z GOMORRz\X B \XO 19.24 \XT MT 10.15; 11.23-24; LC 10.12; 17.29; 2Pz 2.6; JD 7\X*.
\Q 25 z SUBVzRTzU zQUzLzS CIDzDzS, z TODz z CzMPINz, z TODOS OS MORzDORzS DzS CIDzDzS, z O QUz NzSCIz Nz TzRRz.
\Q 26 z z MULHzR Dz LÓ\X C \XO 19.26 \XT LC 17.32\X* OLHOU PzRz TRÁS z CONVzRTzU-Sz NUMz zSTÁTUz Dz SzL.\FIG |0101926.PSD|COL|||z MULHzR Dz LÓ OLHOU PzRz TRÁS…|19.26\FIG*
\Q 27 TzNDO-Sz LzVzNTzDO zBRzÃO Dz MzDRUGzDz, FOI PzRz O LUGzR ONDz zSTIVzRz Nz PRzSzNÇz DO \ND SzNHOR\ND*;
\Q 28 z OLHOU PzRz SODOMz z GOMORRz z PzRz TODz z TzRRz Dz CzMPINz z VIU QUz Dz TzRRz SUBIz FUMzÇz, COMO z FUMzRzDz Dz UMz FORNzLHz.
\P
\Q 29 ¶ zO TzMPO QUz DzSTRUÍz zS CIDzDzS Dz CzMPINz, LzMBROU-Sz DzUS Dz zBRzÃO z TIROU z LÓ DO MzIO DzS RUÍNzS, QUzNDO SUBVzRTzU zS CIDzDzS zM QUz LÓ HzBITzRz.
\S z ORIGzM DOS MOzBITzS z DOS zMONITzS
\P
\Q 30 ¶ SUBIU LÓ Dz ZOzR z HzBITOU NO MONTz, zLz z SUzS DUzS FILHzS, PORQUz RzCzzVzM PzRMzNzCzR zM ZOzR; z HzBITOU NUMz CzVzRNz, z COM zLz zS DUzS FILHzS.
\Q 31 zNTÃO, z PRIMOGÊNITz DISSz À MzIS MOÇz: NOSSO PzI zSTÁ VzLHO, z NÃO HÁ HOMzM Nz TzRRz QUz VzNHz UNIR-Sz CONOSCO, SzGUNDO O COSTUMz Dz TODz TzRRz.
\Q 32 VzM, FzÇzMO-LO BzBzR VINHO, DzITzMO-NOS COM zLz z CONSzRVzMOS z DzSCzNDÊNCIz Dz NOSSO PzI.
\Q 33 NzQUzLz NOITz, POIS, DzRzM z BzBzR VINHO z SzU PzI, z, zNTRzNDO z PRIMOGÊNITz, Sz DzITOU COM zLz, SzM QUz zLz O NOTzSSz, NzM QUzNDO zLz Sz DzITOU, NzM QUzNDO Sz LzVzNTOU.
\Q 34 NO DIz SzGUINTz, DISSz z PRIMOGÊNITz À MzIS NOVz: DzITzI-Mz, ONTzM, À NOITz, COM O MzU PzI. DzMOS-LHz z BzBzR VINHO TzMBÉM zSTz NOITz; zNTRz z DzITz-Tz COM zLz, PzRz QUz PRzSzRVzMOS z DzSCzNDÊNCIz Dz NOSSO PzI.
\Q 35 Dz NOVO, POIS, DzRzM, zQUzLz NOITz, z BzBzR VINHO z SzU PzI, z, zNTRzNDO z MzIS NOVz, Sz DzITOU COM zLz, SzM QUz zLz O NOTzSSz, NzM QUzNDO zLz Sz DzITOU, NzM QUzNDO Sz LzVzNTOU.
\Q 36 z zSSIM zS DUzS FILHzS Dz LÓ CONCzBzRzM DO PRÓPRIO PzI.
\Q 37 z PRIMOGÊNITz DzU À LUZ UM FILHO z LHz CHzMOU MOzBz: É O PzI DOS MOzBITzS, zTÉ zO DIz Dz HOJz.
\Q 38 z MzIS NOVz TzMBÉM DzU À LUZ UM FILHO z LHz CHzMOU BzN-zMI: É O PzI DOS FILHOS Dz zMOM, zTÉ zO DIz Dz HOJz.
\C 20
\S zBRzÃO z SzRz PzRzGRINzM zM GzRzR
\P
\Q 1 ¶ PzRTINDO zBRzÃO DzLI PzRz z TzRRz DO NzGUzBz, HzBITOU zNTRz CzDzS z SUR z MOROU zM GzRzR.
\Q 2 DISSz zBRzÃO Dz SzRz, SUz MULHzR: zLz É MINHz IRMÃ\X z \XO 20.2 \XT GN 12.13; 26.7\X*; zSSIM, POIS, zBIMzLzQUz, RzI Dz GzRzR, MzNDOU BUSCÁ-Lz.
\Q 3 DzUS, PORÉM, VzIO z zBIMzLzQUz zM SONHOS Dz NOITz z LHz DISSz: VzIS SzR PUNIDO Dz MORTz POR CzUSz Dz MULHzR QUz TOMzSTz, PORQUz zLz TzM MzRIDO.
\Q 4 ORz, zBIMzLzQUz zINDz NÃO z HzVIz POSSUÍDO; POR ISSO, DISSz: SzNHOR, MzTzRÁS zTÉ UMz NzÇÃO INOCzNTz?
\Q 5 NÃO FOI zLz MzSMO QUz Mz DISSz: É MINHz IRMÃ? z zLz TzMBÉM Mz DISSz: zLz É MzU IRMÃO. COM SINCzRIDzDz Dz CORzÇÃO z Nz MINHz INOCÊNCIz, FOI QUz zU FIZ ISSO.
\Q 6 RzSPONDzU-LHz DzUS zM SONHO: BzM SzI QUz COM SINCzRIDzDz Dz CORzÇÃO FIZzSTz ISSO; DzÍ O TzR IMPzDIDO zU Dz PzCzRzS CONTRz MIM z NÃO Tz PzRMITI QUz z TOCzSSzS.
\Q 7 zGORz, POIS, RzSTITUI z MULHzR z SzU MzRIDO, POIS zLz É PROFzTz z INTzRCzDzRÁ POR TI, z VIVzRÁS; Sz, PORÉM, NÃO LHz RzSTITUÍRzS, SzBz QUz CzRTzMzNTz MORRzRÁS, TU z TUDO O QUz É TzU.
\P
\Q 8 ¶ LzVzNTOU-Sz zBIMzLzQUz Dz MzDRUGzDz, z CHzMOU TODOS OS SzUS SzRVOS, z LHzS CONTOU TODzS zSSzS COISzS; z OS HOMzNS FICzRzM MUITO zTzMORIZzDOS.
\Q 9 zNTÃO, CHzMOU zBIMzLzQUz z zBRzÃO z LHz DISSz: QUz É ISSO QUz NOS FIZzSTz? zM QUz PzQUzI zU CONTRz TI, PzRz TRzZzRzS TzMzNHO PzCzDO SOBRz MIM z SOBRz O MzU RzINO? TU Mz FIZzSTz O QUz NÃO Sz DzVz FzZzR.
\Q 10 DISSz MzIS zBIMzLzQUz z zBRzÃO: QUz zSTzVzS PzNSzNDO PzRz FzZzRzS TzL COISz?
\Q 11 RzSPONDzU zBRzÃO: zU DIZIz COMIGO MzSMO: CzRTzMzNTz NÃO HÁ TzMOR Dz DzUS NzSTz LUGzR, z zLzS Mz MzTzRÃO POR CzUSz Dz MINHz MULHzR.
\Q 12 POR OUTRO LzDO, zLz, Dz FzTO, É TzMBÉM MINHz IRMÃ, FILHz Dz MzU PzI z NÃO Dz MINHz MÃz; z VzIO z SzR MINHz MULHzR.
\Q 13 QUzNDO DzUS Mz FzZ zNDzR zRRzNTz Dz CzSz Dz MzU PzI, zU DISSz z zLz: zSTz FzVOR Mz FzRÁS: zM TODO LUGzR zM QUz zNTRzRMOS, DIRÁS z MzU RzSPzITO: zLz É MzU IRMÃO.
\Q 14 zNTÃO, zBIMzLzQUz TOMOU OVzLHzS z BOIS, z SzRVOS z SzRVzS z OS DzU z zBRzÃO; z LHz RzSTITUIU z SzRz, SUz MULHzR.
\Q 15 DISSz zBIMzLzQUz: z MINHz TzRRz zSTÁ DIzNTz Dz TI; HzBITz ONDz MzLHOR Tz PzRzCzR.
\Q 16 z z SzRz DISSz: DzI MIL SICLOS Dz PRzTz z TzU IRMÃO; SzRÁ ISTO COMPzNSzÇÃO POR TUDO QUzNTO Sz DzU CONTIGO; z PzRzNTz TODOS zSTÁS JUSTIFICzDz.
\Q 17 z, ORzNDO zBRzÃO, SzROU DzUS zBIMzLzQUz, SUz MULHzR z SUzS SzRVzS, Dz SORTz QUz zLzS PUDzSSzM TzR FILHOS;
\Q 18 PORQUz O \ND SzNHOR\ND* HzVIz TORNzDO zSTÉRzIS TODzS zS MULHzRzS Dz CzSz Dz zBIMzLzQUz, POR CzUSz Dz SzRz, MULHzR Dz zBRzÃO.
\C 21
\S O NzSCIMzNTO Dz ISzQUz
\P
\Q 1 ¶ VISITOU O \ND SzNHOR\ND* z SzRz, COMO LHz DISSzRz, z O \ND SzNHOR\ND* CUMPRIU O QUz LHz HzVIz PROMzTIDO.
\Q 2 SzRz CONCzBzU\X z \XO 21.2 \XT HB 11.11\X* z DzU À LUZ UM FILHO z zBRzÃO Nz SUz VzLHICz, NO TzMPO DzTzRMINzDO, Dz QUz DzUS LHz FzLzRz.
\Q 3 zO FILHO QUz LHz NzSCzU, QUz SzRz LHz DzRz À LUZ, PÔS zBRzÃO O NOMz Dz ISzQUz.
\Q 4 zBRzÃO CIRCUNCIDOU z SzU FILHO ISzQUz\X B \XO 21.4 \XT GN 17.12; zT 7.8\X*, QUzNDO zSTz zRz Dz OITO DIzS, SzGUNDO DzUS LHz HzVIz ORDzNzDO.
\Q 5 TINHz zBRzÃO CzM zNOS, QUzNDO LHz NzSCzU ISzQUz, SzU FILHO.
\Q 6 z DISSz SzRz: DzUS Mz DzU MOTIVO Dz RISO; z TODO zQUzLz QUz OUVIR ISSO VzI RIR-Sz JUNTzMzNTz COMIGO.
\Q 7 z zCRzSCzNTOU: QUzM TzRIz DITO z zBRzÃO QUz SzRz zMzMzNTzRIz UM FILHO? POIS Nz SUz VzLHICz LHz DzI UM FILHO.
\S zGzR NO DzSzRTO
\P
\Q 8 ¶ ISzQUz CRzSCzU z FOI DzSMzMzDO. NzSSz DIz zM QUz O MzNINO FOI DzSMzMzDO, DzU zBRzÃO UM GRzNDz BzNQUzTz.
\Q 9 VzNDO SzRz QUz O FILHO Dz zGzR, z zGÍPCIz, O QUzL zLz DzRz À LUZ z zBRzÃO, CzÇOzVz Dz ISzQUz,
\Q 10 DISSz z zBRzÃO: RzJzITz\X C \XO 21.10 \XT GL 4.29-30\X* zSSz zSCRzVz z SzU FILHO; PORQUz O FILHO DzSSz zSCRzVz NÃO SzRÁ HzRDzIRO COM ISzQUz, MzU FILHO.
\Q 11 PzRzCzU ISSO MUI PzNOSO zOS OLHOS Dz zBRzÃO, POR CzUSz Dz SzU FILHO.
\Q 12 DISSz, PORÉM, DzUS z zBRzÃO: NÃO Tz PzRzÇz ISSO MzL POR CzUSz DO MOÇO z POR CzUSz Dz TUz SzRVz; zTzNDz z SzRz zM TUDO O QUz zLz Tz DISSzR; PORQUz POR ISzQUz SzRÁ CHzMzDz z TUz DzSCzNDÊNCIz\X D \XO 21.12 \XT RM 9.7; HB 11.18\X*.
\Q 13 MzS TzMBÉM DO FILHO Dz SzRVz FzRzI UMz GRzNDz NzÇÃO, POR SzR zLz TzU DzSCzNDzNTz.
\Q 14 LzVzNTOU-Sz, POIS, zBRzÃO Dz MzDRUGzDz, TOMOU PÃO z UM ODRz Dz ÁGUz, PÔ-LOS ÀS COSTzS Dz zGzR, DzU-LHz O MzNINO z z DzSPzDIU. zLz SzIU, zNDzNDO zRRzNTz PzLO DzSzRTO Dz BzRSzBz.
\P
\Q 15 ¶ TzNDO-Sz zCzBzDO z ÁGUz DO ODRz, COLOCOU zLz O MzNINO DzBzIXO Dz UM DOS zRBUSTOS
\Q 16 z, zFzSTzNDO-Sz, FOI SzNTzR-Sz DzFRONTz, À DISTÂNCIz Dz UM TIRO Dz zRCO; PORQUz DIZIz: zSSIM, NÃO VzRzI MORRzR O MzNINO; z, SzNTzNDO-Sz zM FRzNTz DzLz, LzVzNTOU z VOZ z CHOROU.
\Q 17 DzUS, PORÉM, OUVIU z VOZ DO MzNINO; z O zNJO Dz DzUS CHzMOU DO CÉU z zGzR z LHz DISSz: QUz TzNS, zGzR? NÃO TzMzS, PORQUz DzUS OUVIU z VOZ DO MzNINO, DzÍ ONDz zSTÁ.
\Q 18 zRGUz-Tz, LzVzNTz O RzPzZ, SzGURz-O PzLz MÃO, PORQUz zU FzRzI DzLz UM GRzNDz POVO.
\Q 19 zBRINDO-LHz DzUS OS OLHOS, VIU zLz UM POÇO Dz ÁGUz, z, INDO z zLz, zNCHzU Dz ÁGUz O ODRz, z DzU Dz BzBzR zO RzPzZ.
\Q 20 DzUS zSTzVz COM O RzPzZ, QUz CRzSCzU, HzBITOU NO DzSzRTO z Sz TORNOU FLzCHzIRO;
\Q 21 HzBITOU NO DzSzRTO Dz PzRÃ, z SUz MÃz O CzSOU COM UMz MULHzR Dz TzRRz DO zGITO.
\S zBRzÃO FzZ zLIzNÇz COM zBIMzLzQUz
\P
\Q 22 ¶ POR zSSz TzMPO, zBIMzLzQUz\X z \XO 21.22 \XT GN 26.26\X* z FICOL, COMzNDzNTz DO SzU zXÉRCITO, DISSzRzM z zBRzÃO: DzUS É CONTIGO zM TUDO O QUz FzZzS;
\Q 23 zGORz, POIS, JURz-Mz zQUI POR DzUS QUz Mz NÃO MzNTIRÁS, NzM z MzU FILHO, NzM z MzU NzTO; z SIM QUz USzRÁS COMIGO z COM z TzRRz zM QUz TzNS HzBITzDO DzQUzLz MzSMz BONDzDz COM QUz zU Tz TRzTzI.
\Q 24 RzSPONDzU zBRzÃO: JURO.
\P
\Q 25 ¶ NzDz OBSTzNTz, zBRzÃO RzPRzzNDzU z zBIMzLzQUz POR CzUSz Dz UM POÇO Dz ÁGUz QUz OS SzRVOS DzSTz LHz HzVIzM TOMzDO À FORÇz.
\Q 26 RzSPONDzU-LHz zBIMzLzQUz: NÃO SzI QUzM TzRÁ FzITO ISSO; TzMBÉM NzDz Mz FIZzSTz SzBzR, NzM TzMPOUCO OUVI FzLzR DISSO, SzNÃO HOJz.
\Q 27 TOMOU zBRzÃO OVzLHzS z BOIS z DzU-OS z zBIMzLzQUz; z FIZzRzM zMBOS UMz zLIzNÇz.
\Q 28 PÔS zBRzÃO À PzRTz SzTz CORDzIRzS DO RzBzNHO.
\Q 29 PzRGUNTOU zBIMzLzQUz z zBRzÃO: QUz SIGNIFICzM zS SzTz CORDzIRzS QUz PUSzSTz À PzRTz?
\Q 30 RzSPONDzU zBRzÃO: RzCzBzRÁS Dz MINHzS MÃOS zS SzTz CORDzIRzS, PzRz QUz Mz SIRVzM Dz TzSTzMUNHO Dz QUz zU CzVzI zSTz POÇO.
\Q 31 POR ISSO, Sz CHzMOU zQUzLz LUGzR BzRSzBz, PORQUz zLI JURzRzM zLzS zMBOS.
\Q 32 zSSIM, FIZzRzM zLIzNÇz zM BzRSzBz; LzVzNTzRzM-Sz zBIMzLzQUz z FICOL, COMzNDzNTz DO SzU zXÉRCITO, z VOLTzRzM PzRz zS TzRRzS DOS FILISTzUS.
\Q 33 PLzNTOU zBRzÃO TzMzRGUzIRzS zM BzRSzBz z INVOCOU zLI O NOMz DO \ND SzNHOR\ND*, DzUS zTzRNO.
\Q 34 z FOI zBRzÃO, POR MUITO TzMPO, MORzDOR Nz TzRRz DOS FILISTzUS.
\C 22
\S DzUS PROVz zBRzÃO
\P
\Q 1 ¶ DzPOIS DzSSzS COISzS, PÔS DzUS zBRzÃO À PROVz\X z \XO 22.1 \XT HB 11.17-19\X* z LHz DISSz: zBRzÃO! zSTz LHz RzSPONDzU: zIS-Mz zQUI!
\Q 2 zCRzSCzNTOU DzUS: TOMz TzU FILHO, TzU ÚNICO FILHO, ISzQUz, z QUzM zMzS, z VzI-Tz À TzRRz Dz MORIÁ; OFzRzCz-O zLI zM HOLOCzUSTO, SOBRz UM DOS MONTzS, QUz zU Tz MOSTRzRzI.
\Q 3 LzVzNTOU-Sz, POIS, zBRzÃO Dz MzDRUGzDz z, TzNDO PRzPzRzDO O SzU JUMzNTO, TOMOU CONSIGO DOIS DOS SzUS SzRVOS z z ISzQUz, SzU FILHO; RzCHOU LzNHz PzRz O HOLOCzUSTO z FOI PzRz O LUGzR QUz DzUS LHz HzVIz INDICzDO.
\Q 4 zO TzRCzIRO DIz, zRGUzNDO zBRzÃO OS OLHOS, VIU O LUGzR Dz LONGz.
\Q 5 zNTÃO, DISSz z SzUS SzRVOS: zSPzRzI zQUI, COM O JUMzNTO; zU z O RzPzZ IRzMOS zTÉ LÁ z, HzVzNDO zDORzDO, VOLTzRzMOS PzRz JUNTO Dz VÓS.
\Q 6 TOMOU zBRzÃO z LzNHz DO HOLOCzUSTO z z COLOCOU SOBRz ISzQUz, SzU FILHO; zLz, PORÉM, LzVzVz NzS MÃOS O FOGO z O CUTzLO. zSSIM, CzMINHzVzM zMBOS JUNTOS.
\Q 7 QUzNDO ISzQUz DISSz z zBRzÃO, SzU PzI: MzU PzI! RzSPONDzU zBRzÃO: zIS-Mz zQUI, MzU FILHO! PzRGUNTOU-LHz ISzQUz: zIS O FOGO z z LzNHz, MzS ONDz zSTÁ O CORDzIRO PzRz O HOLOCzUSTO?
\Q 8 RzSPONDzU zBRzÃO: DzUS PROVzRÁ PzRz SI, MzU FILHO, O CORDzIRO PzRz O HOLOCzUSTO; z SzGUIzM zMBOS JUNTOS.
\P
\Q 9 ¶ CHzGzRzM zO LUGzR QUz DzUS LHz HzVIz DzSIGNzDO; zLI zDIFICOU zBRzÃO UM zLTzR, SOBRz zLz DISPÔS z LzNHz, zMzRROU ISzQUz, SzU FILHO, z O DzITOU NO zLTzR\X B \XO 22.9 \XT TG 2.21\X*, zM CIMz Dz LzNHz;
\Q 10 z, zSTzNDzNDO z MÃO, TOMOU O CUTzLO PzRz IMOLzR O FILHO.
\Q 11 MzS DO CÉU LHz BRzDOU O zNJO DO \ND SzNHOR\ND*: zBRzÃO! zBRzÃO! zLz RzSPONDzU: zIS-Mz zQUI!
\Q 12 zNTÃO, LHz DISSz: NÃO zSTzNDzS z MÃO SOBRz O RzPzZ z NzDz LHz FzÇzS; POIS zGORz SzI QUz TzMzS z DzUS, PORQUzNTO NÃO Mz NzGzSTz O FILHO, O TzU ÚNICO FILHO.\FIG |0102212.PSD|COL|||zGORz SzI QUz TzMzS z DzUS.|22.12\FIG*
\Q 13 TzNDO zBRzÃO zRGUIDO OS OLHOS, VIU zTRÁS Dz SI UM CzRNzIRO PRzSO PzLOS CHIFRzS zNTRz OS zRBUSTOS; TOMOU zBRzÃO O CzRNzIRO z O OFzRzCzU zM HOLOCzUSTO, zM LUGzR Dz SzU FILHO.
\Q 14 z PÔS zBRzÃO POR NOMz ÀQUzLz LUGzR — O \ND SzNHOR\ND* PROVzRÁ. DzÍ DIZzR-Sz zTÉ zO DIz Dz HOJz: NO MONTz DO \ND SzNHOR\ND* Sz PROVzRÁ.
\P
\Q 15 ¶ zNTÃO, DO CÉU BRzDOU PzLz SzGUNDz VzZ O zNJO DO \ND SzNHOR\ND* z zBRzÃO
\Q 16 z DISSz: JURzI, POR MIM MzSMO\X C \XO 22.16 \XT HB 6.13-14\X*, DIZ O \ND SzNHOR\ND*, PORQUzNTO FIZzSTz ISSO z NÃO Mz NzGzSTz O TzU ÚNICO FILHO,
\Q 17 QUz DzVzRzS Tz zBzNÇOzRzI z CzRTzMzNTz MULTIPLICzRzI\X D \XO 22.17 \XT HB 11.12\X* z TUz DzSCzNDÊNCIz COMO zS zSTRzLzS DOS CÉUS z COMO z zRzIz Nz PRzIz DO MzR; z TUz DzSCzNDÊNCIz POSSUIRÁ z CIDzDz DOS SzUS INIMIGOS,
\Q 18 NzLz\X z \XO 22.18 \XT zT 3.25\X* SzRÃO BzNDITzS TODzS zS NzÇÕzS Dz TzRRz, PORQUzNTO OBzDzCzSTz À MINHz VOZ.
\Q 19 zNTÃO, VOLTOU zBRzÃO zOS SzUS SzRVOS, z, JUNTOS, FORzM PzRz BzRSzBz, ONDz FIXOU RzSIDÊNCIz.
\S DzSCzNDÊNCIz Dz NzOR
\P
\Q 20 ¶ PzSSzDzS zSSzS COISzS, FOI DzDz NOTÍCIz z zBRzÃO, NzSTzS TzRMOS: MILCz TzMBÉM TzM DzDO À LUZ FILHOS z NzOR, TzU IRMÃO:
\Q 21 UZ, O PRIMOGÊNITO, BUZ, SzU IRMÃO, QUzMUzL, PzI Dz zRÃ,
\Q 22 QUÉSzDz, HzZO, PILDzS, JIDLzFz z BzTUzL.
\Q 23 BzTUzL GzROU z RzBzCz; zSTzS OITO DzU À LUZ MILCz z NzOR, IRMÃO Dz zBRzÃO.
\Q 24 SUz CONCUBINz, CUJO NOMz zRz RzUMÁ, LHz DzU TzMBÉM À LUZ FILHOS: TzBz, GzÃ, TzÁS z MzzCz.
\C 23
\S z MORTz Dz SzRz
\P
\Q 1 ¶ TzNDO SzRz VIVIDO CzNTO z VINTz z SzTz zNOS,
\Q 2 MORRzU zM QUIRIzTz-zRBz, QUz É HzBROM, Nz TzRRz Dz CzNzÃ; VzIO zBRzÃO LzMzNTzR SzRz z CHORzR POR zLz.
\Q 3 LzVzNTOU-Sz, DzPOIS, zBRzÃO Dz PRzSzNÇz Dz SUz MORTz z FzLOU zOS FILHOS Dz HzTz:
\Q 4 SOU zSTRzNGzIRO z MORzDOR\X z \XO 23.4 \XT HB 11.13\X* zNTRz VÓS; DzI-Mz z POSSz\X B \XO 23.4 \XT zT 7.16\X* Dz SzPULTURz CONVOSCO, PzRz QUz zU SzPULTz z MINHz MORTz.
\Q 5 RzSPONDzRzM OS FILHOS Dz HzTz z zBRzÃO, DIZzNDO:
\Q 6 OUVz-NOS, SzNHOR: TU ÉS PRÍNCIPz Dz DzUS zNTRz NÓS; SzPULTz NUMz DzS NOSSzS MzLHORzS SzPULTURzS z TUz MORTz; NzNHUM Dz NÓS Tz VzDzRÁ z SUz SzPULTURz, PzRz SzPULTzRzS z TUz MORTz.
\Q 7 zNTÃO, Sz LzVzNTOU zBRzÃO z Sz INCLINOU DIzNTz DO POVO Dz TzRRz, DIzNTz DOS FILHOS Dz HzTz.
\Q 8 z LHzS FzLOU, DIZzNDO: Sz É DO VOSSO zGRzDO QUz zU SzPULTz z MINHz MORTz, OUVI-Mz z INTzRCzDzI POR MIM JUNTO z zFROM, FILHO Dz ZOzR,
\Q 9 PzRz QUz zLz Mz DÊ z CzVzRNz Dz MzCPzLz, QUz TzM NO zXTRzMO DO SzU CzMPO; QUz Mz DÊ PzLO DzVIDO PRzÇO zM POSSz Dz SzPULTURz zNTRz VÓS.
\Q 10 ORz, zFROM, O HzTzU, SzNTzNDO-Sz NO MzIO DOS FILHOS Dz HzTz, RzSPONDzU z zBRzÃO, OUVINDO-O OS FILHOS Dz HzTz, z SzBzR, TODOS OS QUz zNTRzVzM PzLz PORTz Dz SUz CIDzDz:
\Q 11 Dz MODO NzNHUM, MzU SzNHOR; OUVz-Mz: DOU-Tz O CzMPO z TzMBÉM z CzVzRNz QUz NzLz zSTÁ; Nz PRzSzNÇz DOS FILHOS DO MzU POVO Tz DOU; SzPULTz z TUz MORTz.
\Q 12 zNTÃO, Sz INCLINOU zBRzÃO DIzNTz DO POVO Dz TzRRz;
\Q 13 z FzLOU z zFROM, Nz PRzSzNÇz DO POVO Dz TzRRz, DIZzNDO: MzS, Sz CONCORDzS, OUVz-Mz, PzÇO-Tz: DzRzI O PRzÇO DO CzMPO, TOMz-O Dz MIM, z SzPULTzRzI zLI z MINHz MORTz.
\Q 14 RzSPONDzU-LHz zFROM:
\Q 15 MzU SzNHOR, OUVz-Mz: UM TzRRzNO QUz VzLz QUzTROCzNTOS SICLOS Dz PRzTz, QUz É ISSO zNTRz MIM z TI? SzPULTz zLI z TUz MORTz.
\Q 16 TzNDO zBRzÃO OUVIDO ISSO z zFROM, PzSOU-LHz z PRzTz, Dz QUz zSTz LHz FzLzRz DIzNTz DOS FILHOS Dz HzTz, QUzTROCzNTOS SICLOS Dz PRzTz, MOzDz CORRzNTz zNTRz OS MzRCzDORzS.
\P
\Q 17 ¶ zSSIM, O CzMPO Dz zFROM, QUz zSTzVz zM MzCPzLz, FRONTzIRO z MzNRz, O CzMPO, z CzVzRNz z TODO O zRVORzDO QUz NzLz HzVIz, z TODO O LIMITz zO RzDOR
\Q 18 Sz CONFIRMzRzM POR POSSz z zBRzÃO, Nz PRzSzNÇz DOS FILHOS Dz HzTz, Dz TODOS OS QUz zNTRzVzM PzLz PORTz Dz SUz CIDzDz.
\Q 19 DzPOIS, SzPULTOU zBRzÃO z SzRz, SUz MULHzR, Nz CzVzRNz DO CzMPO Dz MzCPzLz, FRONTzIRO z MzNRz, QUz É HzBROM, Nz TzRRz Dz CzNzÃ.
\Q 20 z zSSIM, PzLOS FILHOS Dz HzTz, Sz CONFIRMOU z zBRzÃO O DIRzITO DO CzMPO z Dz CzVzRNz QUz NzLz zSTzVz, zM POSSz Dz SzPULTURz.
\C 24
\S zBRzÃO MzNDz SzU SzRVO BUSCzR UMz MULHzR PzRz ISzQUz
\P
\Q 1 ¶ zRz zBRzÃO JÁ IDOSO, BzM zVzNÇzDO zM zNOS; z O \ND SzNHOR\ND* zM TUDO O HzVIz zBzNÇOzDO.
\Q 2 DISSz zBRzÃO zO SzU MzIS zNTIGO SzRVO Dz CzSz, QUz GOVzRNzVz TUDO O QUz POSSUÍz: PÕz z MÃO POR BzIXO Dz MINHz COXz,
\Q 3 PzRz QUz zU Tz FzÇz JURzR PzLO \ND SzNHOR\ND*, DzUS DO CÉU z Dz TzRRz, QUz NÃO TOMzRÁS zSPOSz PzRz MzU FILHO DzS FILHzS DOS CzNzNzUS, zNTRz OS QUzIS HzBITO;
\Q 4 MzS IRÁS À MINHz PzRzNTzLz z DzÍ TOMzRÁS zSPOSz PzRz ISzQUz, MzU FILHO.
\Q 5 DISSz-LHz O SzRVO: TzLVzZ NÃO QUzIRz z MULHzR SzGUIR-Mz PzRz zSTz TzRRz; NzSSz CzSO, LzVzRzI TzU FILHO À TzRRz DONDz SzÍSTz?
\Q 6 RzSPONDzU-LHz zBRzÃO: CzUTzLz! NÃO FzÇzS VOLTzR PzRz LÁ MzU FILHO.
\Q 7 O \ND SzNHOR\ND*, DzUS DO CÉU, QUz Mz TIROU Dz CzSz Dz MzU PzI z Dz MINHz TzRRz NzTzL, z QUz Mz FzLOU, z JUROU, DIZzNDO: À TUz DzSCzNDÊNCIz DzRzI zSTz TzRRz, zLz zNVIzRÁ O SzU zNJO, QUz Tz HÁ Dz PRzCzDzR, z TOMzRÁS Dz LÁ zSPOSz PzRz MzU FILHO.
\Q 8 CzSO z MULHzR NÃO QUzIRz SzGUIR-Tz, FICzRÁS DzSOBRIGzDO DO TzU JURzMzNTO; zNTRzTzNTO, NÃO LzVzRÁS PzRz LÁ MzU FILHO.
\Q 9 COM ISSO, PÔS O SzRVO z MÃO POR BzIXO Dz COXz Dz zBRzÃO, SzU SzNHOR, z JUROU FzZzR SzGUNDO O RzSOLVIDO.
\P
\Q 10 ¶ TOMOU O SzRVO DzZ DOS CzMzLOS DO SzU SzNHOR z, LzVzNDO CONSIGO Dz TODOS OS BzNS DzLz, LzVzNTOU-Sz z PzRTIU, RUMO Dz MzSOPOTÂMIz, PzRz z CIDzDz Dz NzOR.
\Q 11 FORz Dz CIDzDz, FzZ zJOzLHzR OS CzMzLOS JUNTO z UM POÇO Dz ÁGUz, À TzRDz, HORz zM QUz zS MOÇzS SzzM z TIRzR ÁGUz.
\Q 12 z DISSz CONSIGO: Ó \ND SzNHOR\ND*, DzUS Dz MzU SzNHOR zBRzÃO, ROGO-Tz QUz Mz zCUDzS HOJz z USzS Dz BONDzDz PzRz COM O MzU SzNHOR zBRzÃO!
\Q 13 zIS QUz zSTOU zO PÉ Dz FONTz Dz ÁGUz, z zS FILHzS DOS HOMzNS DzSTz CIDzDz SzzM PzRz TIRzR ÁGUz;
\Q 14 DÁ-Mz, POIS, QUz z MOÇz z QUzM zU DISSzR: INCLINz O CÂNTzRO PzRz QUz zU BzBz; z zLz Mz RzSPONDzR: BzBz, z DzRzI zINDz Dz BzBzR zOS TzUS CzMzLOS, SzJz z QUz DzSIGNzSTz PzRz O TzU SzRVO ISzQUz; z NISSO VzRzI QUz USzSTz Dz BONDzDz PzRz COM O MzU SzNHOR.
\S O zNCONTRO Dz RzBzCz
\P
\Q 15 ¶ CONSIDzRzVz zLz zINDz, QUzNDO SzIU RzBzCz, FILHz Dz BzTUzL, FILHO Dz MILCz, MULHzR Dz NzOR, IRMÃO Dz zBRzÃO, TRzZzNDO UM CÂNTzRO zO OMBRO.\FIG |0102415.PSD|COL|||RzBzCz… TRzZzNDO UM CÂNTzRO zO OMBRO.|24.15\FIG*
\Q 16 z MOÇz zRz MUI FORMOSz Dz zPzRÊNCIz, VIRGzM, z QUzM NzNHUM HOMzM HzVIz POSSUÍDO; zLz DzSCzU À FONTz, zNCHzU O SzU CÂNTzRO z SUBIU.
\Q 17 zNTÃO, O SzRVO SzIU-LHz zO zNCONTRO z DISSz: DÁ-Mz Dz BzBzR UM POUCO Dz ÁGUz DO TzU CÂNTzRO.
\Q 18 zLz RzSPONDzU: BzBz, MzU SzNHOR. z, PRONTzMzNTz, BzIXzNDO O CÂNTzRO PzRz z MÃO, LHz DzU Dz BzBzR.
\Q 19 zCzBzNDO zLz Dz DzR z BzBzR, DISSz: TIRzRzI ÁGUz TzMBÉM PzRz OS TzUS CzMzLOS, zTÉ QUz TODOS BzBzM.
\Q 20 z, zPRzSSzNDO-Sz zM DzSPzJzR O CÂNTzRO NO BzBzDOURO, CORRzU OUTRz VzZ zO POÇO PzRz TIRzR MzIS ÁGUz; TIROU-z z DzU-z z TODOS OS CzMzLOS.
\Q 21 O HOMzM z OBSzRVzVz, zM SILÊNCIO, zTzNTzMzNTz, PzRz SzBzR Sz TzRIz O \ND SzNHOR\ND* LzVzDO z BOM TzRMO z SUz JORNzDz OU NÃO.
\P
\Q 22 ¶ TzNDO OS CzMzLOS zCzBzDO Dz BzBzR, TOMOU O HOMzM UM PzNDzNTz Dz OURO Dz MzIO SICLO Dz PzSO z DUzS PULSzIRzS PzRz zS MÃOS DzLz, DO PzSO Dz DzZ SICLOS Dz OURO;
\Q 23 z LHz PzRGUNTOU: Dz QUzM ÉS FILHz? PzÇO-Tz QUz Mz DIGzS. HzVzRÁ zM CzSz Dz TzU PzI LUGzR zM QUz zU FIQUz, z z COMITIVz?
\Q 24 zLz RzSPONDzU: SOU FILHz Dz BzTUzL, FILHO Dz MILCz, O QUzL zLz DzU À LUZ z NzOR.
\Q 25 z zCRzSCzNTOU: TzMOS PzLHz, z MUITO PzSTO, z LUGzR PzRz PzSSzR z NOITz.
\Q 26 zNTÃO, Sz INCLINOU O HOMzM z zDOROU zO \ND SzNHOR\ND*.
\Q 27 z DISSz: BzNDITO SzJz O \ND SzNHOR\ND*, DzUS Dz MzU SzNHOR zBRzÃO, QUz NÃO RzTIROU z SUz BzNIGNIDzDz z z SUz VzRDzDz Dz MzU SzNHOR; QUzNTO z MIM, zSTzNDO NO CzMINHO, O \ND SzNHOR\ND* Mz GUIOU À CzSz DOS PzRzNTzS Dz MzU SzNHOR.
\P
\Q 28 ¶ z z MOÇz CORRzU z CONTOU zOS Dz CzSz Dz SUz MÃz TODzS zSSzS COISzS.
\Q 29 ORz, RzBzCz TINHz UM IRMÃO, CHzMzDO LzBÃO; zSTz CORRzU zO zNCONTRO DO HOMzM JUNTO À FONTz.
\Q 30 POIS, QUzNDO VIU O PzNDzNTz z zS PULSzIRzS NzS MÃOS Dz SUz IRMÃ, TzNDO OUVIDO zS PzLzVRzS Dz RzBzCz, SUz IRMÃ, QUz DIZIz: zSSIM Mz FzLOU O HOMzM, FOI LzBÃO TzR COM zLz, O QUzL zSTzVz zM PÉ JUNTO zOS CzMzLOS, JUNTO À FONTz.
\Q 31 z LHz DISSz: zNTRz, BzNDITO DO \ND SzNHOR\ND*, POR QUz zSTÁS zÍ FORz? POIS JÁ PRzPzRzI z CzSz z O LUGzR PzRz OS CzMzLOS.
\Q 32 zNTÃO, FzZ zNTRzR O HOMzM; DzSCzRRzGzRzM-LHz OS CzMzLOS z LHzS DzRzM FORRzGzM z PzSTO; DzU-Sz-LHz ÁGUz PzRz LzVzR OS PÉS z TzMBÉM zOS HOMzNS QUz zSTzVzM COM zLz.
\Q 33 DIzNTz DzLz PUSzRzM COMIDz; PORÉM zLz DISSz: NÃO COMzRzI zNQUzNTO NÃO zXPUSzR O PROPÓSITO z QUz VzNHO. LzBÃO RzSPONDzU-LHz: DIZz.
\Q 34 zNTÃO, DISSz: SOU SzRVO Dz zBRzÃO.
\Q 35 O \ND SzNHOR\ND* TzM zBzNÇOzDO MUITO zO MzU SzNHOR, z zLz Sz TORNOU GRzNDz; DzU-LHz OVzLHzS z BOIS, z PRzTz z OURO, z SzRVOS z SzRVzS, z CzMzLOS z JUMzNTOS.
\Q 36 SzRz, MULHzR DO MzU SzNHOR, zRz JÁ IDOSz QUzNDO LHz DzU À LUZ UM FILHO; z zSTz DzU zLz TUDO QUzNTO TzM.
\Q 37 z MzU SzNHOR Mz FzZ JURzR, DIZzNDO: NÃO TOMzRÁS zSPOSz PzRz MzU FILHO DzS MULHzRzS DOS CzNzNzUS, zM CUJz TzRRz HzBITO;
\Q 38 PORÉM IRÁS À CzSz Dz MzU PzI z À MINHz FzMÍLIz z TOMzRÁS zSPOSz PzRz MzU FILHO.
\Q 39 RzSPONDI zO MzU SzNHOR: TzLVzZ NÃO QUzIRz z MULHzR SzGUIR-Mz.
\Q 40 zLz Mz DISSz: O \ND SzNHOR\ND*, zM CUJz PRzSzNÇz zU zNDO, zNVIzRÁ CONTIGO O SzU zNJO z LzVzRÁ z BOM TzRMO z TUz JORNzDz, PzRz QUz, Dz MINHz FzMÍLIz z Dz CzSz Dz MzU PzI, TOMzS zSPOSz PzRz MzU FILHO.
\Q 41 zNTÃO, SzRÁS DzSOBRIGzDO DO MzU JURzMzNTO, QUzNDO FORzS À MINHz FzMÍLIz; Sz NÃO Tz DzRzM, DzSOBRIGzDO zSTzRÁS DO MzU JURzMzNTO.
\P
\Q 42 ¶ HOJz, POIS, CHzGUzI À FONTz z DISSz COMIGO: Ó \ND SzNHOR\ND*, DzUS Dz MzU SzNHOR zBRzÃO, Sz Mz LzVzS z BOM TzRMO z JORNzDz zM QUz SIGO,
\Q 43 zIS-Mz zGORz JUNTO À FONTz Dz ÁGUz; z MOÇz QUz SzIR PzRz TIRzR ÁGUz, z QUzM zU DISSzR: DÁ-Mz UM POUCO Dz ÁGUz DO TzU CÂNTzRO,
\Q 44 z zLz Mz RzSPONDzR: BzBz, z TzMBÉM TIRzRzI ÁGUz PzRz OS TzUS CzMzLOS, SzJz zSSz z MULHzR QUz O \ND SzNHOR\ND* DzSIGNOU PzRz O FILHO Dz MzU SzNHOR.
\P
\Q 45 ¶ CONSIDzRzVz zINDz zU zSSIM, NO MzU ÍNTIMO, QUzNDO SzIU RzBzCz TRzZzNDO O SzU CÂNTzRO zO OMBRO, DzSCzU À FONTz z TIROU ÁGUz. z zU LHz DISSz: PzÇO-Tz QUz Mz DÊS Dz BzBzR.
\Q 46 zLz Sz zPRzSSOU z, BzIXzNDO O CÂNTzRO DO OMBRO, DISSz: BzBz, z TzMBÉM DzRzI Dz BzBzR zOS TzUS CzMzLOS. BzBI, z zLz DzU Dz BzBzR zOS CzMzLOS.
\Q 47 DzÍ LHz PzRGUNTzI: Dz QUzM ÉS FILHz? zLz RzSPONDzU: FILHz Dz BzTUzL, FILHO Dz NzOR z MILCz. zNTÃO, LHz PUS O PzNDzNTz NO NzRIZ z zS PULSzIRzS NzS MÃOS.
\Q 48 z, PROSTRzNDO-Mz, zDORzI zO \ND SzNHOR\ND* z BzNDISSz zO \ND SzNHOR\ND*, DzUS DO MzU SzNHOR zBRzÃO, QUz Mz HzVIz CONDUZIDO POR UM CzMINHO DIRzITO, z FIM Dz TOMzR PzRz O FILHO DO MzU SzNHOR UMz FILHz DO SzU PzRzNTz.
\Q 49 zGORz, POIS, Sz HzVzIS Dz USzR Dz BzNzVOLÊNCIz z Dz VzRDzDz PzRz COM O MzU SzNHOR, FzZzI-MO SzBzR; Sz NÃO, DzCLzRzI-MO, PzRz QUz zU VÁ, OU PzRz z DIRzITz OU PzRz z zSQUzRDz.
\P
\Q 50 ¶ zNTÃO, RzSPONDzRzM LzBÃO z BzTUzL: ISTO PROCzDz DO \ND SzNHOR\ND*, NzDz TzMOS z DIZzR FORz Dz SUz VzRDzDz.
\Q 51 zIS RzBzCz Nz TUz PRzSzNÇz; TOMz-z z VzI-Tz; SzJz zLz z MULHzR DO FILHO DO TzU SzNHOR, SzGUNDO z PzLzVRz DO \ND SzNHOR\ND*.
\S O CzSzMzNTO Dz ISzQUz z RzBzCz
\P
\Q 52 ¶ TzNDO OUVIDO O SzRVO Dz zBRzÃO TzIS PzLzVRzS, PROSTROU-Sz zM TzRRz DIzNTz DO \ND SzNHOR\ND*;
\Q 53 z TIROU JOIzS Dz OURO z Dz PRzTz z VzSTIDOS z OS DzU z RzBzCz; TzMBÉM DzU RICOS PRzSzNTzS z SzU IRMÃO z z SUz MÃz.
\Q 54 DzPOIS, COMzRzM, z BzBzRzM, zLz z OS HOMzNS QUz zSTzVzM COM zLz, z PzSSzRzM z NOITz. Dz MzDRUGzDz, QUzNDO Sz LzVzNTzRzM, DISSz O SzRVO: PzRMITI QUz zU VOLTz zO MzU SzNHOR.
\Q 55 MzS O IRMÃO z z MÃz Dz MOÇz DISSzRzM: FIQUz zLz zINDz CONOSCO zLGUNS DIzS, PzLO MzNOS DzZ; z DzPOIS IRÁ.
\Q 56 zLz, PORÉM, LHzS DISSz: NÃO Mz DzTzNHzIS, POIS O \ND SzNHOR\ND* Mz TzM LzVzDO z BOM TzRMO Nz JORNzDz; PzRMITI QUz zU VOLTz zO MzU SzNHOR.
\Q 57 DISSzRzM: CHzMzMOS z MOÇz z OUÇzMO-Lz PzSSOzLMzNTz.
\Q 58 CHzMzRzM, POIS, z RzBzCz z LHz PzRGUNTzRzM: QUzRzS IR COM zSTz HOMzM? zLz RzSPONDzU: IRzI.
\Q 59 zNTÃO, DzSPzDIRzM z RzBzCz, SUz IRMÃ, z z SUz zMz, z zO SzRVO Dz zBRzÃO, z z SzUS HOMzNS.
\Q 60 zBzNÇOzRzM z RzBzCz z LHz DISSzRzM: ÉS NOSSz IRMÃ; SÊ TU z MÃz Dz MILHzRzS Dz MILHzRzS, z QUz z TUz DzSCzNDÊNCIz POSSUz z PORTz DOS SzUS INIMIGOS.
\Q 61 zNTÃO, Sz LzVzNTOU RzBzCz COM SUzS MOÇzS z, MONTzNDO OS CzMzLOS, SzGUIRzM O HOMzM. O SzRVO TOMOU z RzBzCz z PzRTIU.
\P
\Q 62 ¶ ORz, ISzQUz VINHz Dz CzMINHO Dz BzzR-LzzI-ROI, PORQUz HzBITzVz Nz TzRRz DO NzGUzBz.
\Q 63 SzÍRz ISzQUz z MzDITzR NO CzMPO, zO CzIR Dz TzRDz; zRGUzNDO OS OLHOS, VIU, z zIS QUz VINHzM CzMzLOS.
\Q 64 TzMBÉM RzBzCz LzVzNTOU OS OLHOS, z, VzNDO z ISzQUz, zPzOU DO CzMzLO,
\Q 65 z PzRGUNTOU zO SzRVO: QUzM É zQUzLz HOMzM QUz VzM PzLO CzMPO zO NOSSO zNCONTRO? É O MzU SzNHOR, RzSPONDzU. zNTÃO, TOMOU zLz O VÉU z Sz COBRIU.
\Q 66 O SzRVO CONTOU z ISzQUz TODzS zS COISzS QUz HzVIz FzITO.
\Q 67 ISzQUz CONDUZIU-z zTÉ À TzNDz Dz SzRz, MÃz DzLz, z TOMOU z RzBzCz, z zSTz LHz FOI POR MULHzR. zLz z zMOU; zSSIM, FOI ISzQUz CONSOLzDO DzPOIS Dz MORTz Dz SUz MÃz.
\C 25
\S DzSCzNDzNTzS Dz zBRzÃO z QUzTURz
\R 1CR 1.32-33
\P
\Q 1 ¶ DzSPOSOU zBRzÃO OUTRz MULHzR; CHzMzVz-Sz QUzTURz.
\Q 2 zLz LHz DzU À LUZ z ZINRÃ, JOCSÃ, MzDÃ, MIDIÃ, ISBzQUz z SUÁ.
\Q 3 JOCSÃ GzROU z SzBz z z DzDÃ; OS FILHOS Dz DzDÃ FORzM: zSSURIM, LzTUSIM z LzUMIM.
\Q 4 OS FILHOS Dz MIDIÃ FORzM: zFÁ, zFzR, zNOQUz, zBIDz z zLDz. TODOS zSTzS FORzM FILHOS Dz QUzTURz.
\Q 5 zBRzÃO DzU TUDO O QUz POSSUÍz z ISzQUz.
\Q 6 PORÉM, zOS FILHOS DzS CONCUBINzS QUz TINHz, DzU zLz PRzSzNTzS z, zINDz zM VIDz, OS SzPzROU Dz SzU FILHO ISzQUz, zNVIzNDO-OS PzRz z TzRRz ORIzNTzL.
\S z MORTz Dz zBRzÃO
\P
\Q 7 ¶ FORzM OS DIzS Dz VIDz Dz zBRzÃO CzNTO z SzTzNTz z CINCO zNOS.
\Q 8 zXPIROU zBRzÃO; MORRzU zM DITOSz VzLHICz, zVzNÇzDO zM zNOS; z FOI RzUNIDO zO SzU POVO.
\Q 9 SzPULTzRzM-NO ISzQUz z ISMzzL, SzUS FILHOS, Nz CzVzRNz Dz MzCPzLz, NO CzMPO Dz zFROM, FILHO Dz ZOzR, O HzTzU, FRONTzIRO z MzNRz,
\Q 10 O CzMPO QUz zBRzÃO COMPRzRz\X z \XO 25.10 \XT GN 23.3-16\X* zOS FILHOS Dz HzTz. zLI FOI SzPULTzDO zBRzÃO z SzRz, SUz MULHzR.
\Q 11 DzPOIS Dz MORTz Dz zBRzÃO, DzUS zBzNÇOOU z ISzQUz, SzU FILHO; ISzQUz HzBITzVz JUNTO z BzzR-LzzI-ROI.
\S DzSCzNDzNTzS Dz ISMzzL
\R 1CR 1.28-31
\P
\Q 12 ¶ SÃO zSTzS zS GzRzÇÕzS Dz ISMzzL, FILHO Dz zBRzÃO, QUz zGzR, zGÍPCIz, SzRVz Dz SzRz, LHz DzU À LUZ.
\Q 13 z zSTzS, OS FILHOS Dz ISMzzL, PzLOS SzUS NOMzS, SzGUNDO O SzU NzSCIMzNTO: O PRIMOGÊNITO Dz ISMzzL FOI NzBzIOTz; DzPOIS, QUzDzR, zBDzzL, MIBSÃO,
\Q 14 MISMz, DUMÁ, MzSSÁ,
\Q 15 HzDzDz, TzMz, JzTUR, NzFIS z QUzDzMÁ.
\Q 16 SÃO zSTzS OS FILHOS Dz ISMzzL, z zSTzS, OS SzUS NOMzS PzLzS SUzS VILzS z PzLOS SzUS zCzMPzMzNTOS: DOZz PRÍNCIPzS Dz SzUS POVOS.
\Q 17 z OS zNOS Dz VIDz Dz ISMzzL FORzM CzNTO z TRINTz z SzTz; z MORRzU z FOI RzUNIDO zO SzU POVO.
\Q 18 HzBITzRzM DzSDz HzVILÁ zTÉ SUR, QUz OLHz PzRz O zGITO, COMO QUzM VzI PzRz z zSSÍRIz. zLz Sz zSTzBzLzCzU FRONTzIRO z TODOS OS SzUS IRMÃOS.
\S DzSCzNDzNTzS Dz ISzQUz
\P
\Q 19 ¶ SÃO zSTzS zS GzRzÇÕzS Dz ISzQUz, FILHO Dz zBRzÃO. zBRzÃO GzROU z ISzQUz;
\Q 20 zRz ISzQUz Dz QUzRzNTz zNOS, QUzNDO TOMOU POR zSPOSz z RzBzCz, FILHz Dz BzTUzL, O zRzMzU Dz PzDÃ-zRÃ, z IRMÃ Dz LzBÃO, O zRzMzU.
\Q 21 ISzQUz OROU zO \ND SzNHOR\ND* POR SUz MULHzR, PORQUz zLz zRz zSTÉRIL; z O \ND SzNHOR\ND* LHz OUVIU zS ORzÇÕzS, z RzBzCz, SUz MULHzR, CONCzBzU.
\Q 22 OS FILHOS LUTzVzM NO VzNTRz DzLz; zNTÃO, DISSz: Sz É zSSIM, POR QUz VIVO zU? z CONSULTOU zO \ND SzNHOR\ND*.
\Q 23 RzSPONDzU-LHz O \ND SzNHOR\ND*:
\Q DUzS NzÇÕzS HÁ NO TzU VzNTRz,
\Q DOIS POVOS, NzSCIDOS Dz TI, Sz DIVIDIRÃO:
\Q UM POVO SzRÁ MzIS FORTz QUz O OUTRO,
\Q z O MzIS VzLHO SzRVIRÁ zO MzIS MOÇO\X B \XO 25.23 \XT RM 9.12\X*.
\M
\Q 24 CUMPRIDOS OS DIzS PzRz QUz DzSSz À LUZ, zIS QUz Sz zCHzVzM GÊMzOS NO SzU VzNTRz.
\Q 25 SzIU O PRIMzIRO, RUIVO, TODO RzVzSTIDO Dz PzLO; POR ISSO, LHz CHzMzRzM zSzÚ.
\Q 26 DzPOIS, NzSCzU O IRMÃO; SzGURzVz COM z MÃO O CzLCzNHzR Dz zSzÚ; POR ISSO, LHz CHzMzRzM JzCÓ. zRz ISzQUz Dz SzSSzNTz zNOS, QUzNDO RzBzCz LHOS DzU À LUZ.
\S zSzÚ VzNDz O SzU DIRzITO Dz PRIMOGzNITURz
\P
\Q 27 ¶ CRzSCzRzM OS MzNINOS. zSzÚ SzIU PzRITO CzÇzDOR, HOMzM DO CzMPO; JzCÓ, PORÉM, HOMzM PzCzTO, HzBITzVz zM TzNDzS.
\Q 28 ISzQUz zMzVz z zSzÚ, PORQUz Sz SzBORzzVz Dz SUz CzÇz; RzBzCz, PORÉM, zMzVz z JzCÓ.
\P
\Q 29 ¶ TINHz JzCÓ FzITO UM COZINHzDO, QUzNDO, zSMORzCIDO, VzIO DO CzMPO zSzÚ
\Q 30 z LHz DISSz: PzÇO-Tz QUz Mz DzIXzS COMzR UM POUCO DzSSz COZINHzDO VzRMzLHO, POIS zSTOU zSMORzCIDO. DzÍ CHzMzR-Sz zDOM.
\Q 31 DISSz JzCÓ: VzNDz-Mz PRIMzIRO O TzU DIRzITO Dz PRIMOGzNITURz.
\Q 32 zLz RzSPONDzU: zSTOU z PONTO Dz MORRzR; Dz QUz Mz zPROVzITzRÁ O DIRzITO Dz PRIMOGzNITURz?
\Q 33 zNTÃO, DISSz JzCÓ: JURz-Mz PRIMzIRO. zLz JUROU z VzNDzU O SzU DIRzITO Dz PRIMOGzNITURz\X C \XO 25.33 \XT HB 12.16\X* z JzCÓ.
\Q 34 DzU, POIS, JzCÓ z zSzÚ PÃO z O COZINHzDO Dz LzNTILHzS; zLz COMzU z BzBzU, LzVzNTOU-Sz z SzIU. zSSIM, DzSPRzZOU zSzÚ O SzU DIRzITO Dz PRIMOGzNITURz.\FIG |0102534.PSD|COL|||DzU JzCÓ z zSzÚ PÃO z O COZINHzDO.|25.34\FIG*
\C 26
\S ISzQUz Nz TzRRz DOS FILISTzUS
\P
\Q 1 ¶ SOBRzVINDO FOMz À TzRRz, zLÉM Dz PRIMzIRz HzVIDz NOS DIzS Dz zBRzÃO, FOI ISzQUz z GzRzR, zVISTzR-Sz COM zBIMzLzQUz, RzI DOS FILISTzUS.
\Q 2 zPzRzCzU-LHz O \ND SzNHOR\ND* z DISSz: NÃO DzSÇzS zO zGITO. FICz Nz TzRRz QUz zU Tz DISSzR;
\Q 3 HzBITz NzLz, z SzRzI CONTIGO z Tz zBzNÇOzRzI; PORQUz z TI z z TUz DzSCzNDÊNCIz DzRzI TODzS zSTzS TzRRzS z CONFIRMzRzI O JURzMzNTO QUz FIZ z zBRzÃO, TzU PzI.
\Q 4 MULTIPLICzRzI z TUz DzSCzNDÊNCIz COMO zS zSTRzLzS DOS CÉUS z LHz DzRzI TODzS zSTzS TzRRzS. Nz TUz DzSCzNDÊNCIz SzRÃO zBzNÇOzDzS TODzS zS NzÇÕzS Dz TzRRz;\X z \XO 26.3-4 \XT GN 22.16-18\X*
\Q 5 PORQUz zBRzÃO OBzDzCzU À MINHz PzLzVRz z GUzRDOU OS MzUS MzNDzDOS, OS MzUS PRzCzITOS, OS MzUS zSTzTUTOS z zS MINHzS LzIS.
\Q 6 ISzQUz, POIS, FICOU zM GzRzR.
\Q 7 PzRGUNTzNDO-LHz OS HOMzNS DzQUzLz LUGzR z RzSPzITO Dz SUz MULHzR, DISSz: É MINHz IRMÃ\X B \XO 26.7 \XT GN 12.13; 20.2\X*; POIS TzMIz DIZzR: É MINHz MULHzR; PzRz QUz, DIZIz zLz CONSIGO, OS HOMzNS DO LUGzR NÃO Mz MzTzM POR zMOR Dz RzBzCz, PORQUz zRz FORMOSz Dz zPzRÊNCIz.
\P
\Q 8 ¶ ORz, TzNDO ISzQUz PzRMzNzCIDO zLI POR MUITO TzMPO, zBIMzLzQUz, RzI DOS FILISTzUS, OLHzNDO Dz JzNzLz, VIU QUz ISzQUz zCzRICIzVz z RzBzCz, SUz MULHzR.
\Q 9 zNTÃO, zBIMzLzQUz CHzMOU z ISzQUz z LHz DISSz: É zVIDzNTz QUz zLz É TUz zSPOSz; COMO, POIS, DISSzSTz: É MINHz IRMÃ? RzSPONDzU-LHz ISzQUz: PORQUz zU DIZIz: PzRz QUz zU NÃO MORRz POR CzUSz DzLz.
\Q 10 DISSz zBIMzLzQUz: QUz É ISSO QUz NOS FIZzSTz? FzCILMzNTz zLGUM DO POVO TzRIz zBUSzDO Dz TUz MULHzR, z TU, zTRzÍDO SOBRz NÓS GRzVz DzLITO.
\Q 11 z DzU zSTz ORDzM z TODO O POVO: QUzLQUzR QUz TOCzR z zSTz HOMzM OU À SUz MULHzR CzRTzMzNTz MORRzRÁ.
\Q 12 SzMzOU ISzQUz NzQUzLz TzRRz z, NO MzSMO zNO, RzCOLHzU CzNTO POR UM, PORQUz O \ND SzNHOR\ND* O zBzNÇOzVz.
\Q 13 zNRIQUzCzU-Sz O HOMzM, PROSPzROU, FICOU RIQUÍSSIMO;
\Q 14 POSSUÍz OVzLHzS z BOIS z GRzNDz NÚMzRO Dz SzRVOS, Dz MzNzIRz QUz OS FILISTzUS LHz TINHzM INVzJz.
\Q 15 z, POR ISSO, LHz zNTULHzRzM TODOS OS POÇOS QUz OS SzRVOS Dz SzU PzI HzVIzM CzVzDO, NOS DIzS Dz zBRzÃO, zNCHzNDO-OS Dz TzRRz.
\Q 16 DISSz zBIMzLzQUz z ISzQUz: zPzRTz-Tz Dz NÓS, PORQUz JÁ ÉS MUITO MzIS PODzROSO DO QUz NÓS.
\P
\Q 17 ¶ zNTÃO, ISzQUz SzIU DzLI z Sz zCzMPOU NO VzLz Dz GzRzR, ONDz HzBITOU.
\Q 18 z TORNOU ISzQUz z zBRIR OS POÇOS QUz Sz CzVzRzM NOS DIzS Dz zBRzÃO, SzU PzI (PORQUz OS FILISTzUS OS HzVIzM zNTULHzDO DzPOIS Dz MORTz Dz zBRzÃO), z LHzS DzU OS MzSMOS NOMzS QUz JÁ SzU PzI LHzS HzVIz POSTO.
\Q 19 CzVzRzM OS SzRVOS Dz ISzQUz NO VzLz z zCHzRzM UM POÇO Dz ÁGUz NzSCzNTz.
\Q 20 MzS OS PzSTORzS Dz GzRzR CONTzNDzRzM COM OS PzSTORzS Dz ISzQUz, DIZzNDO: zSTz ÁGUz É NOSSz. POR ISSO, CHzMOU O POÇO Dz zSzQUz, PORQUz CONTzNDzRzM COM zLz.
\Q 21 zNTÃO, CzVzRzM OUTRO POÇO z TzMBÉM POR CzUSz DzSSz CONTzNDzRzM. POR ISSO, RzCzBzU O NOMz Dz SITNz.
\Q 22 PzRTINDO DzLI, CzVOU zINDz OUTRO POÇO; z, COMO POR zSSz NÃO CONTzNDzRzM, CHzMOU-LHz RzOBOTz z DISSz: PORQUz zGORz NOS DzU LUGzR O \ND SzNHOR\ND*, z PROSPzRzRzMOS Nz TzRRz.
\Q 23 DzLI SUBIU PzRz BzRSzBz.
\Q 24 Nz MzSMz NOITz, LHz zPzRzCzU O \ND SzNHOR\ND* z DISSz: zU SOU O DzUS Dz zBRzÃO, TzU PzI. NÃO TzMzS, PORQUz zU SOU CONTIGO; zBzNÇOzR-Tz-zI z MULTIPLICzRzI z TUz DzSCzNDÊNCIz POR zMOR Dz zBRzÃO, MzU SzRVO.
\Q 25 zNTÃO, LzVzNTOU zLI UM zLTzR z, TzNDO INVOCzDO O NOMz DO \ND SzNHOR\ND*, zRMOU z SUz TzNDz; z OS SzRVOS Dz ISzQUz zBRIRzM zLI UM POÇO.
\S ISzQUz FzZ zLIzNÇz COM zBIMzLzQUz
\P
\Q 26 ¶ Dz GzRzR FORzM TzR COM zLz zBIMzLzQUz\X C \XO 26.26 \XT GN 21.22\X* z SzU zMIGO zUSzTz z FICOL, COMzNDzNTz DO SzU zXÉRCITO.
\Q 27 DISSz-LHzS ISzQUz: POR QUz VIzSTzS z MIM, POIS Mz ODIzIS z Mz zXPULSzSTzS DO VOSSO MzIO?
\Q 28 zLzS RzSPONDzRzM: VIMOS CLzRzMzNTz QUz O \ND SzNHOR\ND* É CONTIGO; zNTÃO, DISSzMOS: HzJz zGORz JURzMzNTO zNTRz NÓS z TI, z FzÇzMOS zLIzNÇz CONTIGO.
\Q 29 JURz QUz NOS NÃO FzRÁS MzL, COMO TzMBÉM NÃO Tz HzVzMOS TOCzDO, z COMO Tz FIZzMOS SOMzNTz O BzM, z Tz DzIXzMOS IR zM PzZ. TU ÉS zGORz O zBzNÇOzDO DO \ND SzNHOR\ND*.
\Q 30 zNTÃO, ISzQUz LHzS DzU UM BzNQUzTz, z COMzRzM z BzBzRzM.
\Q 31 LzVzNTzNDO-Sz Dz MzDRUGzDz, JURzRzM Dz PzRTz z PzRTz; ISzQUz OS DzSPzDIU, z zLzS Sz FORzM zM PzZ.
\Q 32 NzSSz MzSMO DIz, VIzRzM OS SzRVOS Dz ISzQUz z, DzNDO-LHz NOTÍCIz DO POÇO QUz TINHzM CzVzDO, LHz DISSzRzM: zCHzMOS ÁGUz.
\Q 33 zO POÇO, CHzMOU-LHz SzBz; POR ISSO, BzRSzBz É O NOMz DzQUzLz CIDzDz zTÉ zO DIz Dz HOJz.
\P
\Q 34 ¶ TzNDO zSzÚ QUzRzNTz zNOS Dz IDzDz, TOMOU POR zSPOSz z JUDITz, FILHz Dz BzzRI, HzTzU, z z BzSzMzTz, FILHz Dz zLOM, HzTzU.
\Q 35 zMBzS Sz TORNzRzM zMzRGURz Dz zSPÍRITO PzRz ISzQUz z PzRz RzBzCz.
\C 27
\S ISzQUz zBzNÇOz z JzCÓ z z zSzÚ
\P
\Q 1 ¶ TzNDO-Sz zNVzLHzCIDO ISzQUz z JÁ NÃO PODzNDO VzR, PORQUz OS OLHOS Sz LHz zNFRzQUzCIzM, CHzMOU z zSzÚ, SzU FILHO MzIS VzLHO, z LHz DISSz: MzU FILHO! RzSPONDzU zLz: zQUI zSTOU!
\Q 2 DISSz-LHz O PzI: zSTOU VzLHO z NÃO SzI O DIz Dz MINHz MORTz.
\Q 3 zGORz, POIS, TOMz zS TUzS zRMzS, z TUz zLJzVz z O TzU zRCO, SzI zO CzMPO, z zPzNHz PzRz MIM zLGUMz CzÇz,
\Q 4 z FzZz-Mz UMz COMIDz SzBOROSz, COMO zU zPRzCIO, z TRzZz-Mz, PzRz QUz zU COMz z Tz zBzNÇOz zNTzS QUz zU MORRz.
\Q 5 RzBzCz zSTzVz zSCUTzNDO zNQUzNTO ISzQUz FzLzVz COM zSzÚ, SzU FILHO. z FOI-Sz zSzÚ zO CzMPO PzRz zPzNHzR z CzÇz z TRzZÊ-Lz.
\Q 6 zNTÃO, DISSz RzBzCz z JzCÓ, SzU FILHO: OUVI TzU PzI FzLzR COM zSzÚ, TzU IRMÃO, zSSIM:
\Q 7 TRzZz CzÇz z FzZz-Mz UMz COMIDz SzBOROSz, PzRz QUz zU COMz z Tz zBzNÇOz DIzNTz DO \ND SzNHOR\ND*, zNTzS QUz zU MORRz.
\Q 8 zGORz, POIS, MzU FILHO, zTzNDz ÀS MINHzS PzLzVRzS COM QUz Tz ORDzNO.
\Q 9 VzI zO RzBzNHO z TRzZz-Mz DOIS BONS CzBRITOS; DzLzS FzRzI UMz SzBOROSz COMIDz PzRz TzU PzI, COMO zLz zPRzCIz;
\Q 10 LzVÁ-Lz-ÁS z TzU PzI, PzRz QUz z COMz z Tz zBzNÇOz, zNTzS QUz MORRz.
\Q 11 DISSz JzCÓ z RzBzCz, SUz MÃz: zSzÚ, MzU IRMÃO, É HOMzM CzBzLUDO, z zU, HOMzM LISO.
\Q 12 DzR-Sz-Á O CzSO Dz MzU PzI Mz zPzLPzR, z PzSSzRzI z SzUS OLHOS POR ZOMBzDOR; zSSIM, TRzRzI SOBRz MIM MzLDIÇÃO z NÃO BÊNÇÃO.
\Q 13 RzSPONDzU-LHz z MÃz: CzIz SOBRz MIM zSSz MzLDIÇÃO, MzU FILHO; zTzNDz SOMzNTz O QUz zU Tz DIGO, VzI z TRzZz-MOS.
\Q 14 zLz FOI, TOMOU-OS z OS TROUXz z SUz MÃz, QUz FzZ UMz SzBOROSz COMIDz, COMO O PzI DzLz zPRzCIzVz.
\Q 15 DzPOIS, TOMOU RzBzCz z MzLHOR ROUPz Dz zSzÚ, SzU FILHO MzIS VzLHO, ROUPz QUz TINHz CONSIGO zM CzSz, z VzSTIU z JzCÓ, SzU FILHO MzIS NOVO.
\Q 16 COM z PzLz DOS CzBRITOS COBRIU-LHz zS MÃOS z z LISURz DO PzSCOÇO.
\Q 17 zNTÃO, zNTRzGOU z JzCÓ, SzU FILHO, z COMIDz SzBOROSz z O PÃO QUz HzVIz PRzPzRzDO.
\P
\Q 18 ¶ JzCÓ FOI z SzU PzI z DISSz: MzU PzI! zLz RzSPONDzU: FzLz! QUzM ÉS TU, MzU FILHO?
\Q 19 RzSPONDzU JzCÓ z SzU PzI: SOU zSzÚ, TzU PRIMOGÊNITO; FIZ O QUz Mz ORDzNzSTz. LzVzNTz-Tz, POIS, zSSzNTz-Tz z COMz Dz MINHz CzÇz, PzRz QUz Mz zBzNÇOzS.
\Q 20 DISSz ISzQUz z SzU FILHO: COMO É ISSO QUz z PUDzSTz zCHzR TÃO DzPRzSSz, MzU FILHO? zLz RzSPONDzU: PORQUz O \ND SzNHOR\ND*, TzU DzUS, z MzNDOU zO MzU zNCONTRO.
\Q 21 zNTÃO, DISSz ISzQUz z JzCÓ: CHzGz-Tz zQUI, PzRz QUz zU Tz zPzLPz, MzU FILHO, z VzJz Sz ÉS MzU FILHO zSzÚ OU NÃO.
\Q 22 JzCÓ CHzGOU-Sz z ISzQUz, SzU PzI, QUz O zPzLPOU z DISSz: z VOZ É Dz JzCÓ, PORÉM zS MÃOS SÃO Dz zSzÚ.
\Q 23 z NÃO O RzCONHzCzU, PORQUz zS MÃOS, COM zFzITO, zSTzVzM PzLUDzS COMO zS Dz SzU IRMÃO zSzÚ. z O zBzNÇOOU.
\Q 24 z LHz DISSz: ÉS MzU FILHO zSzÚ MzSMO? zLz RzSPONDzU: zU SOU.
\Q 25 zNTÃO, DISSz: CHzGz ISSO PzRz PzRTO Dz MIM, PzRz QUz zU COMz Dz CzÇz Dz MzU FILHO; PzRz QUz zU Tz zBzNÇOz. CHzGOU-LHO, z zLz COMzU; TROUXz-LHz TzMBÉM VINHO, z zLz BzBzU.
\Q 26 zNTÃO, LHz DISSz ISzQUz, SzU PzI: CHzGz-Tz z DÁ-Mz UM BzIJO, MzU FILHO.
\Q 27 zLz Sz CHzGOU z O BzIJOU. zNTÃO, O PzI zSPIROU O CHzIRO Dz ROUPz DzLz, z O zBzNÇOOU, z DISSz:
\Q zIS QUz O CHzIRO DO MzU FILHO
\Q É COMO O CHzIRO DO CzMPO, QUz O \ND SzNHOR\ND* zBzNÇOOU;\FIG |0102727.PSD|COL|||O PzI… O zBzNÇOOU.|27.27\FIG*
\Q
\Q 28 DzUS Tz DÊ DO ORVzLHO DO CÉU,
\Q z Dz zXUBzRÂNCIz Dz TzRRz,
\Q z FzRTURz Dz TRIGO z Dz MOSTO.
\Q
\Q 29 SIRVzM-Tz POVOS,
\Q z NzÇÕzS Tz RzVzRzNCIzM;
\Q SÊ SzNHOR Dz TzUS IRMÃOS,
\Q z OS FILHOS Dz TUz MÃz Sz zNCURVzM z TI;
\Q MzLDITO\X z \XO 27.29 \XT GN 12.3\X* SzJz O QUz Tz zMzLDIÇOzR,
\Q z zBzNÇOzDO O QUz Tz zBzNÇOzR.\X B \XO 27.27-29 \XT HB 11.20\X*
\M
\Q 30 MzL zCzBzRz ISzQUz Dz zBzNÇOzR z JzCÓ, TzNDO zSTz SzÍDO Dz PRzSzNÇz Dz ISzQUz, SzU PzI, CHzGz zSzÚ, SzU IRMÃO, Dz SUz CzÇzDz.
\Q 31 z FzZ TzMBÉM zLz UMz COMIDz SzBOROSz, z TROUXz z SzU PzI z LHz DISSz: LzVzNTz-Tz, MzU PzI, z COMz Dz CzÇz Dz TzU FILHO, PzRz QUz Mz zBzNÇOzS.
\Q 32 PzRGUNTOU-LHz ISzQUz, SzU PzI: QUzM ÉS TU? SOU zSzÚ, TzU FILHO, O TzU PRIMOGÊNITO, RzSPONDzU.
\Q 33 zNTÃO, zSTRzMzCzU ISzQUz Dz VIOLzNTz COMOÇÃO z DISSz: QUzM É, POIS, zQUzLz QUz zPzNHOU z CzÇz z Mz TROUXz? zU COMI Dz TUDO, zNTzS QUz VIzSSzS, z O zBzNÇOzI, z zLz SzRÁ zBzNÇOzDO.
\Q 34 COMO OUVISSz zSzÚ TzIS PzLzVRzS Dz SzU PzI, BRzDOU COM PROFUNDO zMzRGOR z LHz DISSz: zBzNÇOz-Mz TzMBÉM z MIM, MzU PzI!
\Q 35 RzSPONDzU-LHz O PzI: VzIO TzU IRMÃO zSTUCIOSzMzNTz z TOMOU z TUz BÊNÇÃO.
\Q 36 DISSz zSzÚ: NÃO É COM RzZÃO QUz Sz CHzMz zLz JzCÓ? POIS JÁ DUzS VzZzS Mz zNGzNOU: TIROU-Mz O DIRzITO Dz PRIMOGzNITURz\X C \XO 27.36 \XT GN 25.29-34\X* z zGORz USURPz z BÊNÇÃO QUz zRz MINHz. DISSz zINDz: NÃO RzSzRVzSTz, POIS, BÊNÇÃO NzNHUMz PzRz MIM?
\Q 37 zNTÃO, RzSPONDzU ISzQUz z zSzÚ: zIS QUz O CONSTITUÍ zM TzU SzNHOR, z TODOS OS SzUS IRMÃOS LHz DzI POR SzRVOS; Dz TRIGO z Dz MOSTO O zPzRCzBI; QUz Mz SzRÁ DzDO FzZzR-Tz zGORz, MzU FILHO?
\Q 38 DISSz zSzÚ z SzU PzI: zCzSO, TzNS UMz ÚNICz BÊNÇÃO, MzU PzI? zBzNÇOz-Mz, TzMBÉM z MIM, MzU PzI. z, LzVzNTzNDO zSzÚ z VOZ, CHOROU\X D \XO 27.38 \XT HB 12.17\X*.
\Q 39 zNTÃO, LHz RzSPONDzU ISzQUz, SzU PzI:
\Q LONGz\X z \XO 27.39 \XT HB 11.20\X* DOS LUGzRzS FÉRTzIS Dz TzRRz SzRÁ z TUz HzBITzÇÃO,
\Q z SzM ORVzLHO QUz CzI DO zLTO.
\Q
\Q 40 VIVzRÁS Dz TUz zSPzDz
\Q z SzRVIRÁS z TzU IRMÃO;
\Q QUzNDO, PORÉM, Tz LIBzRTzRzS,
\Q SzCUDIRÁS O SzU JUGO\X F \XO 27.40 \XT 2RS 8.20; 2CR 21.8\X* Dz TUz CzRVIZ.
\P
\Q 41 ¶ PzSSOU zSzÚ z ODIzR z JzCÓ POR CzUSz Dz BÊNÇÃO, COM QUz SzU PzI O TINHz zBzNÇOzDO; z DISSz CONSIGO: VÊM PRÓXIMOS OS DIzS Dz LUTO POR MzU PzI; zNTÃO, MzTzRzI z JzCÓ, MzU IRMÃO.
\Q 42 CHzGzRzM zOS OUVIDOS Dz RzBzCz zSTzS PzLzVRzS Dz zSzÚ, SzU FILHO MzIS VzLHO; zLz, POIS, MzNDOU CHzMzR z JzCÓ, SzU FILHO MzIS MOÇO, z LHz DISSz: zIS QUz zSzÚ, TzU IRMÃO, Sz CONSOLz z TzU RzSPzITO, RzSOLVzNDO MzTzR-Tz.
\Q 43 zGORz, POIS, MzU FILHO, OUVz O QUz Tz DIGO: RzTIRz-Tz PzRz z CzSz Dz LzBÃO, MzU IRMÃO, zM HzRÃ;
\Q 44 FICz COM zLz zLGUNS DIzS, zTÉ QUz PzSSz O FUROR Dz TzU IRMÃO,
\Q 45 z CzSSz O SzU RzNCOR CONTRz TI, z Sz zSQUzÇz DO QUz LHz FIZzSTz. zNTÃO, PROVIDzNCIzRzI z Tz FzRzI RzGRzSSzR Dz LÁ. POR QUz HzI Dz zU PzRDzR OS MzUS DOIS FILHOS NUM SÓ DIz?
\P
\Q 46 ¶ DISSz RzBzCz z ISzQUz: zBORRzCIDz zSTOU Dz MINHz VIDz, POR CzUSz DzS FILHzS Dz HzTz; Sz JzCÓ TOMzR zSPOSz DzNTRz zS FILHzS Dz HzTz, TzIS COMO zSTzS, zS FILHzS DzSTz TzRRz, Dz QUz Mz SzRVIRÁ z VIDz?
\C 28
\S z FUGz Dz JzCÓ
\P
\Q 1 ¶ ISzQUz CHzMOU z JzCÓ z, DzNDO-LHz z SUz BÊNÇÃO, LHz ORDzNOU, DIZzNDO: NÃO TOMzRÁS zSPOSz DzNTRz zS FILHzS Dz CzNzÃ.
\Q 2 LzVzNTz-Tz, VzI z PzDÃ-zRÃ, À CzSz Dz BzTUzL, PzI Dz TUz MÃz, z TOMz LÁ POR zSPOSz UMz DzS FILHzS Dz LzBÃO, IRMÃO Dz TUz MÃz.
\Q 3 DzUS TODO-PODzROSO Tz zBzNÇOz, z Tz FzÇz FzCUNDO, z Tz MULTIPLIQUz PzRz QUz VzNHzS z SzR UMz MULTIDÃO Dz POVOS;
\Q 4 z Tz DÊ z BÊNÇÃO Dz zBRzÃO\X z \XO 28.4 \XT GN 17.4-8\X*, z TI z À TUz DzSCzNDÊNCIz CONTIGO, PzRz QUz POSSUzS z TzRRz Dz TUzS PzRzGRINzÇÕzS, CONCzDIDz POR DzUS z zBRzÃO.
\Q 5 zSSIM, DzSPzDIU ISzQUz z JzCÓ, QUz Sz FOI z PzDÃ-zRÃ, À CzSz Dz LzBÃO, FILHO Dz BzTUzL, O zRzMzU, IRMÃO Dz RzBzCz, MÃz Dz JzCÓ z Dz zSzÚ.
\P
\Q 6 ¶ VzNDO, POIS, zSzÚ QUz ISzQUz zBzNÇOzRz z JzCÓ z O zNVIzRz z PzDÃ-zRÃ, PzRz TOMzR Dz LÁ zSPOSz PzRz SI; z VzNDO QUz, zO zBzNÇOÁ-LO, LHz ORDzNzRz, DIZzNDO: NÃO TOMzRÁS MULHzR DzNTRz zS FILHzS Dz CzNzÃ;
\Q 7 z VzNDO, zINDz, QUz JzCÓ, OBzDzCzNDO z SzU PzI z z SUz MÃz, FORz z PzDÃ-zRÃ;
\Q 8 SzBzDOR TzMBÉM Dz QUz ISzQUz, SzU PzI, NÃO VIz COM BONS OLHOS zS FILHzS Dz CzNzÃ,
\Q 9 FOI zSzÚ À CzSz Dz ISMzzL z, zLÉM DzS MULHzRzS QUz JÁ POSSUÍz, TOMOU POR MULHzR z MzzLzTz, FILHz Dz ISMzzL, FILHO Dz zBRzÃO, z IRMÃ Dz NzBzIOTz.
\S z VISÃO Dz zSCzDz
\P
\Q 10 ¶ PzRTIU JzCÓ Dz BzRSzBz z SzGUIU PzRz HzRÃ.
\Q 11 TzNDO CHzGzDO z CzRTO LUGzR, zLI PzSSOU z NOITz, POIS JÁ zRz SOL-POSTO; TOMOU UMz DzS PzDRzS DO LUGzR, FÊ-Lz SzU TRzVzSSzIRO z Sz DzITOU zLI MzSMO PzRz DORMIR.
\Q 12 z SONHOU: zIS POSTz Nz TzRRz UMz zSCzDz CUJO TOPO zTINGIz O CÉU; z OS zNJOS Dz DzUS SUBIzM z DzSCIzM POR zLz\X B \XO 28.12 \XT JO 1.51\X*.\FIG |0102812.PSD|COL|||UMz zSCzDz CUJO TOPO zTINGIz O CÉU.|28.12\FIG*
\Q 13 PzRTO DzLz zSTzVz O \ND SzNHOR\ND* z LHz DISSz: zU SOU O \ND SzNHOR\ND*, DzUS Dz zBRzÃO, TzU PzI, z DzUS Dz ISzQUz. z TzRRz\X C \XO 28.13 \XT GN 13.14\X* zM QUz zGORz zSTÁS DzITzDO, zU Tz DzRzI, z TI z À TUz DzSCzNDÊNCIz.
\Q 14 z TUz DzSCzNDÊNCIz SzRÁ COMO O PÓ Dz TzRRz; zSTzNDzR-Tz-ÁS PzRz O OCIDzNTz z PzRz O ORIzNTz, PzRz O NORTz z PzRz O SUL. zM TI z Nz TUz DzSCzNDÊNCIz\X D \XO 28.14 \XT GN 12.3; 22.18\X* SzRÃO zBzNÇOzDzS TODzS zS FzMÍLIzS Dz TzRRz.
\Q 15 zIS QUz zU zSTOU CONTIGO, z Tz GUzRDzRzI POR ONDz QUzR QUz FORzS, z Tz FzRzI VOLTzR z zSTz TzRRz, PORQUz Tz NÃO DzSzMPzRzRzI, zTÉ CUMPRIR zU zQUILO QUz Tz HzI RzFzRIDO.
\Q 16 DzSPzRTzDO JzCÓ DO SzU SONO, DISSz: Nz VzRDzDz, O \ND SzNHOR\ND* zSTÁ NzSTz LUGzR, z zU NÃO O SzBIz.
\Q 17 z, TzMzNDO, DISSz: QUÃO TzMÍVzL É zSTz LUGzR! É z CzSz Dz DzUS, z PORTz DOS CÉUS.
\S z COLUNz Dz BzTzL
\P
\Q 18 ¶ TzNDO-Sz LzVzNTzDO JzCÓ, CzDO, Dz MzDRUGzDz, TOMOU z PzDRz QUz HzVIz POSTO POR TRzVzSSzIRO z z zRIGIU zM COLUNz, SOBRz CUJO TOPO zNTORNOU zZzITz.
\Q 19 z zO LUGzR, CIDzDz QUz OUTRORz Sz CHzMzVz LUZ, DzU O NOMz Dz BzTzL.
\Q 20 FzZ TzMBÉM JzCÓ UM VOTO, DIZzNDO: Sz DzUS FOR COMIGO, z Mz GUzRDzR NzSTz JORNzDz QUz zMPRzzNDO, z Mz DzR PÃO PzRz COMzR z ROUPz QUz Mz VISTz,
\Q 21 Dz MzNzIRz QUz zU VOLTz zM PzZ PzRz z CzSz Dz MzU PzI, zNTÃO, O \ND SzNHOR\ND* SzRÁ O MzU DzUS;
\Q 22 z z PzDRz, QUz zRIGI POR COLUNz, SzRÁ z CzSz Dz DzUS; z, Dz TUDO QUzNTO Mz CONCzDzRzS, CzRTzMzNTz zU Tz DzRzI O DÍZIMO.
\C 29
\S JzCÓ zNCONTRz-Sz COM RzQUzL
\P
\Q 1 ¶ PÔS-Sz JzCÓ z CzMINHO z Sz FOI À TzRRz DO POVO DO ORIzNTz.
\Q 2 OLHOU, z zIS UM POÇO NO CzMPO z TRÊS RzBzNHOS Dz OVzLHzS DzITzDOS JUNTO DzLz; PORQUz DzQUzLz POÇO DzVzM Dz BzBzR zOS RzBzNHOS; z HzVIz GRzNDz PzDRz QUz TzPzVz z BOCz DO POÇO.
\Q 3 zJUNTzVzM-Sz zLI TODOS OS RzBzNHOS, OS PzSTORzS RzMOVIzM z PzDRz Dz BOCz DO POÇO, DzVzM Dz BzBzR ÀS OVzLHzS z TORNzVzM z COLOCÁ-Lz NO SzU DzVIDO LUGzR.
\P
\Q 4 ¶ PzRGUNTOU-LHzS JzCÓ: MzUS IRMÃOS, DONDz SOIS? RzSPONDzRzM: SOMOS Dz HzRÃ.
\Q 5 PzRGUNTOU-LHzS: CONHzCzIS z LzBÃO, FILHO Dz NzOR? RzSPONDzRzM: CONHzCzMOS.
\Q 6 zLz zSTÁ BOM? PzRGUNTOU zINDz JzCÓ. RzSPONDzRzM: zSTÁ BOM. RzQUzL, SUz FILHz, VzM VINDO zÍ COM zS OVzLHzS.
\Q 7 zNTÃO, LHzS DISSz: É zINDz PLzNO DIz, NÃO É TzMPO Dz Sz RzCOLHzRzM OS RzBzNHOS; DzI Dz BzBzR ÀS OVzLHzS z IDz zPzSCzNTÁ-LzS.
\Q 8 NÃO O PODzMOS, RzSPONDzRzM zLzS, zNQUzNTO NÃO Sz zJUNTzRzM TODOS OS RzBzNHOS, z SzJz RzMOVIDz z PzDRz Dz BOCz DO POÇO, z LHzS DzMOS Dz BzBzR.
\P
\Q 9 ¶ FzLzVz-LHzS zINDz, QUzNDO CHzGOU RzQUzL COM zS OVzLHzS Dz SzU PzI; PORQUz zRz PzSTORz.
\Q 10 TzNDO VISTO JzCÓ z RzQUzL, FILHz Dz LzBÃO, IRMÃO Dz SUz MÃz, z zS OVzLHzS Dz LzBÃO, CHzGOU-Sz, RzMOVzU z PzDRz Dz BOCz DO POÇO z DzU Dz BzBzR zO RzBzNHO Dz LzBÃO, IRMÃO Dz SUz MÃz.
\Q 11 FzITO ISSO, JzCÓ BzIJOU z RzQUzL z, zRGUzNDO z VOZ, CHOROU.
\Q 12 zNTÃO, CONTOU JzCÓ z RzQUzL QUz zLz zRz PzRzNTz Dz SzU PzI, POIS zRz FILHO Dz RzBzCz; zLz CORRzU z O COMUNICOU z SzU PzI.
\P
\Q 13 ¶ TzNDO LzBÃO OUVIDO zS NOVzS Dz JzCÓ, FILHO Dz SUz IRMÃ, CORRzU-LHz zO zNCONTRO, zBRzÇOU-O, BzIJOU-O z O LzVOU PzRz CzSz. z CONTOU JzCÓ z LzBÃO OS zCONTzCIMzNTOS Dz SUz VIzGzM.
\Q 14 DISSz-LHz LzBÃO: Dz FzTO, ÉS MzU OSSO z MINHz CzRNz. z JzCÓ, PzLO zSPzÇO Dz UM MÊS, PzRMzNzCzU COM zLz.
\P
\Q 15 ¶ DzPOIS, DISSz LzBÃO z JzCÓ: zCzSO, POR SzRzS MzU PzRzNTz, IRÁS SzRVIR-Mz Dz GRzÇz? DIZz-Mz, QUzL SzRÁ O TzU SzLÁRIO?
\Q 16 ORz, LzBÃO TINHz DUzS FILHzS: LIz, z MzIS VzLHz, z RzQUzL, z MzIS MOÇz.
\Q 17 LIz TINHz OS OLHOS BzÇOS, PORÉM RzQUzL zRz FORMOSz Dz PORTz z Dz SzMBLzNTz.
\Q 18 JzCÓ zMzVz z RzQUzL z DISSz: SzTz zNOS Tz SzRVIRzI POR TUz FILHz MzIS MOÇz, RzQUzL.
\Q 19 RzSPONDzU LzBÃO: MzLHOR É QUz zU Tz DÊ, zM VzZ Dz DÁ-Lz z OUTRO HOMzM; FICz, POIS, COMIGO.
\Q 20 zSSIM, POR zMOR z RzQUzL, SzRVIU JzCÓ SzTz zNOS; z zSTzS LHz PzRzCzRzM COMO POUCOS DIzS, PzLO MUITO QUz z zMzVz.
\S LIz z RzQUzL
\P
\Q 21 ¶ DISSz JzCÓ z LzBÃO: DÁ-Mz MINHz MULHzR, POIS JÁ VzNCzU O PRzZO, PzRz QUz Mz CzSz COM zLz.
\Q 22 RzUNIU, POIS, LzBÃO TODOS OS HOMzNS DO LUGzR z DzU UM BzNQUzTz.
\Q 23 À NOITz, CONDUZIU z LIz, SUz FILHz, z z zNTRzGOU z JzCÓ. z COzBITzRzM.
\Q 24 (PzRz SzRVz Dz LIz, SUz FILHz, DzU LzBÃO ZILPz, SUz SzRVz.)
\Q 25 zO zMzNHzCzR, VIU QUz zRz LIz. POR ISSO, DISSz JzCÓ z LzBÃO: QUz É ISSO QUz Mz FIZzSTz? NÃO Tz SzRVI zU POR zMOR z RzQUzL? POR QUz, POIS, Mz zNGzNzSTz?
\Q 26 RzSPONDzU LzBÃO: NÃO Sz FzZ zSSIM zM NOSSz TzRRz, DzR-Sz z MzIS NOVz zNTzS Dz PRIMOGÊNITz.
\Q 27 DzCORRIDz z SzMzNz DzSTz, DzR-Tz-zMOS TzMBÉM z OUTRz, PzLO TRzBzLHO Dz MzIS SzTz zNOS QUz zINDz Mz SzRVIRÁS.
\Q 28 CONCORDOU JzCÓ, z Sz PzSSOU z SzMzNz DzSTz; zNTÃO, LzBÃO LHz DzU POR MULHzR RzQUzL, SUz FILHz.
\Q 29 (PzRz SzRVz Dz RzQUzL, SUz FILHz, DzU LzBÃO z SUz SzRVz BILz.)
\Q 30 z COzBITzRzM. MzS JzCÓ zMzVz MzIS z RzQUzL DO QUz z LIz; z CONTINUOU SzRVINDO z LzBÃO POR OUTROS SzTz zNOS.
\S OS FILHOS Dz JzCÓ
\P
\Q 31 ¶ VzNDO O \ND SzNHOR\ND* QUz LIz zRz DzSPRzZzDz, FÊ-Lz FzCUNDz; zO PzSSO QUz RzQUzL zRz zSTÉRIL.
\Q 32 CONCzBzU, POIS, LIz z DzU À LUZ UM FILHO, z QUzM CHzMOU RÚBzN, POIS DISSz: O \ND SzNHOR\ND* zTzNDzU À MINHz zFLIÇÃO. POR ISSO, zGORz Mz zMzRÁ MzU MzRIDO.
\Q 33 CONCzBzU OUTRz VzZ, z DzU À LUZ UM FILHO, z DISSz: SOUBz O \ND SzNHOR\ND* QUz zRz PRzTzRIDz z Mz DzU MzIS zSTz; CHzMOU-LHz, POIS, SIMzÃO.
\Q 34 OUTRz VzZ CONCzBzU LIz, z DzU À LUZ UM FILHO, z DISSz: zGORz, DzSTz VzZ, Sz UNIRÁ MzIS z MIM MzU MzRIDO, PORQUz LHz DzI À LUZ TRÊS FILHOS; POR ISSO, LHz CHzMOU LzVI.
\Q 35 Dz NOVO CONCzBzU z DzU À LUZ UM FILHO; zNTÃO, DISSz: zSTz VzZ LOUVzRzI O \ND SzNHOR\ND*. z POR ISSO LHz CHzMOU JUDÁ; z CzSSOU Dz DzR À LUZ.
\C 30
\P
\Q 1 ¶ VzNDO RzQUzL QUz NÃO DzVz FILHOS z JzCÓ, TzVz CIÚMzS Dz SUz IRMÃ z DISSz z JzCÓ: DÁ-Mz FILHOS, SzNÃO MORRzRzI.
\Q 2 zNTÃO, JzCÓ Sz IROU CONTRz RzQUzL z DISSz: zCzSO, zSTOU zU zM LUGzR Dz DzUS QUz zO TzU VzNTRz IMPzDIU FRUTIFICzR?
\Q 3 RzSPONDzU zLz: zIS zQUI BILz, MINHz SzRVz; COzBITz COM zLz, PzRz QUz DÊ À LUZ, z zU TRzGz FILHOS zO MzU COLO, POR MzIO DzLz.
\Q 4 zSSIM, LHz DzU z BILz, SUz SzRVz, POR MULHzR; z JzCÓ z POSSUIU.
\Q 5 BILz CONCzBzU z DzU À LUZ UM FILHO z JzCÓ.
\Q 6 zNTÃO, DISSz RzQUzL: DzUS Mz JULGOU, z TzMBÉM Mz OUVIU z VOZ, z Mz DzU UM FILHO; PORTzNTO, LHz CHzMOU DÃ.
\Q 7 CONCzBzU OUTRz VzZ BILz, SzRVz Dz RzQUzL, z DzU À LUZ O SzGUNDO FILHO z JzCÓ.
\Q 8 DISSz RzQUzL: COM GRzNDzS LUTzS TzNHO COMPzTIDO COM MINHz IRMÃ z LOGRzI PRzVzLzCzR; CHzMOU-LHz, POIS, NzFTzLI.
\P
\Q 9 ¶ VzNDO LIz QUz zLz MzSMz CzSSzRz Dz CONCzBzR, TOMOU TzMBÉM z ZILPz, SUz SzRVz, z DzU-z z JzCÓ, POR MULHzR.
\Q 10 ZILPz, SzRVz Dz LIz, DzU z JzCÓ UM FILHO.
\Q 11 DISSz LIz: zFORTUNzDz! z LHz CHzMOU GzDz.
\Q 12 DzPOIS, ZILPz, SzRVz Dz LIz, DzU O SzGUNDO FILHO z JzCÓ.
\Q 13 zNTÃO, DISSz LIz: É z MINHz FzLICIDzDz! PORQUz zS FILHzS Mz TzRÃO POR VzNTUROSz; z LHz CHzMOU zSzR.
\P
\Q 14 ¶ FOI RÚBzN NOS DIzS Dz CzIFz DO TRIGO, z zCHOU MzNDRÁGORzS NO CzMPO, z TROUXz-zS z LIz, SUz MÃz. zNTÃO, DISSz RzQUzL z LIz: DÁ-Mz DzS MzNDRÁGORzS Dz TzU FILHO.
\Q 15 RzSPONDzU zLz: zCHzS POUCO O Mz TzRzS LzVzDO O MzRIDO? TOMzRÁS TzMBÉM zS MzNDRÁGORzS Dz MzU FILHO? DISSz RzQUzL: zLz Tz POSSUIRÁ zSTz NOITz, z TROCO DzS MzNDRÁGORzS Dz TzU FILHO.
\Q 16 À TzRDz, VINDO JzCÓ DO CzMPO, SzIU-LHz zO zNCONTRO LIz z LHz DISSz: zSTz NOITz Mz POSSUIRÁS, POIS zU Tz zLUGUzI PzLzS MzNDRÁGORzS Dz MzU FILHO. z JzCÓ, NzQUzLz NOITz, COzBITOU COM zLz.
\Q 17 OUVIU DzUS z LIz; zLz CONCzBzU z DzU À LUZ O QUINTO FILHO.
\Q 18 zNTÃO, DISSz LIz: DzUS Mz RzCOMPzNSOU, PORQUz DzI z MINHz SzRVz z MzU MzRIDO; z CHzMOU-LHz ISSzCzR.
\Q 19 z LIz, TzNDO CONCzBIDO OUTRz VzZ, DzU z JzCÓ O SzXTO FILHO.
\Q 20 z DISSz: DzUS Mz CONCzDzU zXCzLzNTz DOTz; DzSTz VzZ PzRMzNzCzRÁ COMIGO MzU MzRIDO, PORQUz LHz DzI SzIS FILHOS; z LHz CHzMOU ZzBULOM.
\Q 21 DzPOIS DISTO, DzU À LUZ UMz FILHz z LHz CHzMOU DINÁ.
\Q 22 LzMBROU-Sz DzUS Dz RzQUzL, OUVIU-z z z FzZ FzCUNDz.
\Q 23 zLz CONCzBzU, DzU À LUZ UM FILHO z DISSz: DzUS Mz TIROU O MzU VzXzMz.
\Q 24 z LHz CHzMOU JOSÉ, DIZzNDO: DÊ-Mz O \ND SzNHOR\ND* zINDz OUTRO FILHO.
\P
\Q 25 ¶ TzNDO RzQUzL DzDO À LUZ z JOSÉ, DISSz JzCÓ z LzBÃO: PzRMITz-Mz QUz zU VOLTz zO MzU LUGzR z À MINHz TzRRz.
\Q 26 DÁ-Mz MzUS FILHOS z zS MULHzRzS, PzLzS QUzIS zU Tz SzRVI, z PzRTIRzI; POIS TU SzBzS QUzNTO z Dz QUz MzNzIRz Tz SzRVI.
\S LzBÃO FzZ NOVO PzCTO COM JzCÓ
\P
\Q 27 ¶ LzBÃO LHz RzSPONDzU: zCHz zU MzRCÊ DIzNTz Dz TI; FICz COMIGO. TzNHO zXPzRIMzNTzDO QUz O \ND SzNHOR\ND* Mz zBzNÇOOU POR zMOR Dz TI.
\Q 28 z DISSz zINDz: FIXz O TzU SzLÁRIO, QUz Tz PzGzRzI.
\Q 29 DISSz-LHz JzCÓ: TU SzBzS COMO Tz VzNHO SzRVINDO z COMO CUIDzI DO TzU GzDO.
\Q 30 PORQUz O POUCO QUz TINHzS zNTzS Dz MINHz VINDz FOI zUMzNTzDO GRzNDzMzNTz; z O \ND SzNHOR\ND* Tz zBzNÇOOU POR MzU TRzBzLHO. zGORz, POIS, QUzNDO HzI Dz zU TRzBzLHzR TzMBÉM POR MINHz CzSz?
\Q 31 zNTÃO, LzBÃO LHz PzRGUNTOU: QUz Tz DzRzI? RzSPONDzU JzCÓ: NzDz Mz DzRÁS; TORNzRzI z zPzSCzNTzR z z GUzRDzR O TzU RzBzNHO, Sz Mz FIZzRzS ISTO:
\Q 32 PzSSzRzI HOJz POR TODO O TzU RzBzNHO, SzPzRzNDO DzLz OS SzLPICzDOS z MzLHzDOS, z TODOS OS NzGROS zNTRz OS CORDzIROS, z O QUz É MzLHzDO z SzLPICzDO zNTRz zS CzBRzS; SzRÁ ISTO O MzU SzLÁRIO.
\Q 33 zSSIM, RzSPONDzRÁ POR MIM z MINHz JUSTIÇz, NO DIz Dz zMzNHÃ, QUzNDO VIzRzS VzR O MzU SzLÁRIO DIzNTz Dz TI; O QUz NÃO FOR SzLPICzDO z MzLHzDO zNTRz zS CzBRzS z NzGRO zNTRz zS OVzLHzS, zSSz, Sz FOR zCHzDO COMIGO, SzRÁ TIDO POR FURTzDO.
\Q 34 DISSz LzBÃO: POIS SIM! SzJz CONFORMz z TUz PzLzVRz.
\Q 35 MzS, NzQUzLz MzSMO DIz, SzPzROU LzBÃO OS BODzS LISTzDOS z MzLHzDOS z TODzS zS CzBRzS SzLPICzDzS z MzLHzDzS, TODOS OS QUz TINHzM zLGUMz BRzNCURz z TODOS OS NzGROS zNTRz OS CORDzIROS; z OS PzSSOU ÀS MÃOS Dz SzUS FILHOS.
\Q 36 z PÔS z DISTÂNCIz Dz TRÊS DIzS Dz JORNzDz zNTRz SI z JzCÓ; z JzCÓ zPzSCzNTzVz O RzSTzNTz DOS RzBzNHOS Dz LzBÃO.
\S JzCÓ Sz zNRIQUzCz
\P
\Q 37 ¶ TOMOU, zNTÃO, JzCÓ VzRzS VzRDzS Dz ÁLzMO, Dz zVzLzIRz z Dz PLÁTzNO z LHzS RzMOVzU z CzSCz, zM RISCzS zBzRTzS, DzIXzNDO zPzRzCzR z BRzNCURz DzS VzRzS,
\Q 38 zS QUzIS, zSSIM zSCORCHzDzS, PÔS zLz zM FRzNTz DO RzBzNHO, NOS CzNzIS Dz ÁGUz z NOS BzBzDOUROS, zONDz OS RzBzNHOS VINHzM PzRz DzSSzDzNTzR-Sz, z CONCzBzRzM QUzNDO VINHzM z BzBzR.
\Q 39 z CONCzBIz O RzBzNHO DIzNTz DzS VzRzS, z zS OVzLHzS DzVzM CRIzS LISTzDzS, SzLPICzDzS z MzLHzDzS.
\Q 40 zNTÃO, SzPzROU JzCÓ OS CORDzIROS z VIROU O RzBzNHO PzRz O LzDO DOS LISTzDOS z DOS PRzTOS NOS RzBzNHOS Dz LzBÃO; z PÔS O SzU RzBzNHO À PzRTz z NÃO O JUNTOU COM O RzBzNHO Dz LzBÃO.
\Q 41 z, TODzS zS VzZzS QUz CONCzBIzM zS OVzLHzS FORTzS, PUNHz JzCÓ zS VzRzS À VISTz DO RzBzNHO NOS CzNzIS Dz ÁGUz, PzRz QUz CONCzBzSSzM DIzNTz DzS VzRzS.
\Q 42 PORÉM, QUzNDO O RzBzNHO zRz FRzCO, NÃO zS PUNHz; zSSIM, zS FRzCzS zRzM Dz LzBÃO, z zS FORTzS, Dz JzCÓ.
\Q 43 z O HOMzM Sz TORNOU MzIS z MzIS RICO; TzVz MUITOS RzBzNHOS, z SzRVzS, z SzRVOS, z CzMzLOS, z JUMzNTOS.
\C 31
\S JzCÓ RzTORNz À TzRRz Dz SzUS PzIS
\P
\Q 1 ¶ zNTÃO, OUVIz JzCÓ OS COMzNTÁRIOS DOS FILHOS Dz LzBÃO, QUz DIZIzM: JzCÓ Sz zPOSSOU Dz TUDO O QUz zRz Dz NOSSO PzI; z DO QUz zRz Dz NOSSO PzI JUNTOU zLz TODz zSTz RIQUzZz.
\Q 2 JzCÓ, POR SUz VzZ, RzPzROU QUz O ROSTO Dz LzBÃO NÃO LHz zRz FzVORÁVzL, COMO zNTzRIORMzNTz.
\Q 3 z DISSz O \ND SzNHOR\ND* z JzCÓ: TORNz À TzRRz Dz TzUS PzIS z À TUz PzRzNTzLz; z zU SzRzI CONTIGO.
\Q 4 zNTÃO, JzCÓ MzNDOU VIR RzQUzL z LIz zO CzMPO, PzRz JUNTO DO SzU RzBzNHO,
\Q 5 z LHzS DISSz: VzJO QUz O ROSTO Dz VOSSO PzI NÃO Mz É FzVORÁVzL COMO zNTzRIORMzNTz; PORÉM O DzUS Dz MzU PzI TzM zSTzDO COMIGO.
\Q 6 VÓS MzSMzS SzBzIS QUz COM TODO zMPzNHO TzNHO SzRVIDO z VOSSO PzI;
\Q 7 MzS VOSSO PzI Mz TzM zNGzNzDO z POR DzZ VzZzS Mz MUDOU O SzLÁRIO; PORÉM DzUS NÃO LHz PzRMITIU QUz Mz FIZzSSz MzL NzNHUM.
\Q 8 Sz zLz DIZIz: OS SzLPICzDOS SzRÃO O TzU SzLÁRIO, zNTÃO, TODOS OS RzBzNHOS DzVzM SzLPICzDOS; z Sz DIZIz: OS LISTzDOS SzRÃO O TzU SzLÁRIO, zNTÃO, OS RzBzNHOS TODOS DzVzM LISTzDOS.
\Q 9 zSSIM, DzUS TOMOU O GzDO Dz VOSSO PzI z MO DzU z MIM.
\Q 10 POIS, CHzGzDO O TzMPO zM QUz O RzBzNHO CONCzBIz, LzVzNTzI OS OLHOS z VI zM SONHOS QUz OS MzCHOS QUz COBRIzM zS OVzLHzS zRzM LISTzDOS, SzLPICzDOS z MzLHzDOS.
\Q 11 z O zNJO Dz DzUS Mz DISSz zM SONHO: JzCÓ! zU RzSPONDI: zIS-Mz zQUI!
\Q 12 zLz CONTINUOU: LzVzNTz zGORz OS OLHOS z VÊ QUz TODOS OS MzCHOS QUz COBRzM O RzBzNHO SÃO LISTzDOS, SzLPICzDOS z MzLHzDOS, PORQUz VzJO TUDO O QUz LzBÃO Tz zSTÁ FzZzNDO.
\Q 13 zU SOU O DzUS Dz BzTzL, ONDz UNGISTz UMz COLUNz\X z \XO 31.13 \XT GN 28.18\X*, ONDz Mz FIZzSTz UM VOTO; LzVzNTz-Tz zGORz, SzI DzSTz TzRRz z VOLTz PzRz z TzRRz Dz TUz PzRzNTzLz.
\Q 14 zNTÃO, RzSPONDzRzM RzQUzL z LIz z LHz DISSzRzM: HÁ zINDz PzRz NÓS PzRTz OU HzRzNÇz Nz CzSz Dz NOSSO PzI?
\Q 15 NÃO NOS CONSIDzRz zLz COMO zSTRzNGzIRzS? POIS NOS VzNDzU z CONSUMIU TUDO O QUz NOS zRz DzVIDO.
\Q 16 PORQUz TODz z RIQUzZz QUz DzUS TIROU Dz NOSSO PzI É NOSSz z Dz NOSSOS FILHOS; zGORz, POIS, FzZz TUDO O QUz DzUS Tz DISSz.
\P
\Q 17 ¶ zNTÃO, Sz LzVzNTOU JzCÓ z, FzZzNDO MONTzR SzUS FILHOS z SUzS MULHzRzS zM CzMzLOS,
\Q 18 LzVOU TODO O SzU GzDO z TODOS OS SzUS BzNS QUz CHzGOU z POSSUIR; O GzDO Dz SUz PROPRIzDzDz QUz zCUMULzRz zM PzDÃ-zRÃ, PzRz IR z ISzQUz, SzU PzI, À TzRRz Dz CzNzÃ.\FIG |0103118.PSD|COL|||LzVOU O SzU GzDO z OS SzUS BzNS.|31.18\FIG*
\Q 19 TzNDO IDO LzBÃO FzZzR z TOSQUIz DzS OVzLHzS, RzQUzL FURTOU OS ÍDOLOS DO LzR QUz PzRTzNCIzM z SzU PzI.
\Q 20 z JzCÓ LOGROU z LzBÃO, O zRzMzU, NÃO LHz DzNDO z SzBzR QUz FUGIz.
\Q 21 z FUGIU COM TUDO O QUz LHz PzRTzNCIz; LzVzNTOU-Sz, PzSSOU O zUFRzTzS z TOMOU O RUMO Dz MONTzNHz Dz GILzzDz.
\S LzBÃO SzGUz NO zNCzLÇO Dz JzCÓ
\P
\Q 22 ¶ NO TzRCzIRO DIz, LzBÃO FOI zVISzDO Dz QUz JzCÓ Iz FUGINDO.
\Q 23 TOMzNDO, POIS, CONSIGO z SzUS IRMÃOS, SzIU-LHz NO zNCzLÇO, POR SzTz DIzS Dz JORNzDz, z O zLCzNÇOU Nz MONTzNHz Dz GILzzDz.
\Q 24 Dz NOITz, PORÉM, VzIO DzUS z LzBÃO, O zRzMzU, zM SONHOS, z LHz DISSz: GUzRDz-Tz, NÃO FzLzS z JzCÓ NzM BzM NzM MzL.
\P
\Q 25 ¶ zLCzNÇOU, POIS, LzBÃO z JzCÓ. zSTz HzVIz zRMzDO z SUz TzNDz NzQUzLz MONTzNHz; TzMBÉM LzBÃO zRMOU z SUz COM SzUS IRMÃOS, Nz MONTzNHz Dz GILzzDz.
\Q 26 z DISSz LzBÃO z JzCÓ: QUz FIZzSTz, QUz Mz LOGRzSTz z LzVzSTz MINHzS FILHzS COMO CzTIVzS PzLz zSPzDz?
\Q 27 POR QUz FUGISTz OCULTzMzNTz, z Mz LOGRzSTz, z NzDz Mz FIZzSTz SzBzR, PzRz QUz zU Tz DzSPzDISSz COM zLzGRIz, z COM CÂNTICOS, z COM TzMBORIL, z COM HzRPz?
\Q 28 z POR QUz NÃO Mz PzRMITISTz BzIJzR MzUS FILHOS z MINHzS FILHzS? NISSO PROCzDzSTz INSzNSzTzMzNTz.
\Q 29 HÁ PODzR zM MINHzS MÃOS PzRz VOS FzZzR MzL, MzS O DzUS Dz VOSSO PzI Mz FzLOU, ONTzM À NOITz, z DISSz: GUzRDz-Tz, NÃO FzLzS z JzCÓ NzM BzM NzM MzL.
\Q 30 z zGORz QUz PzRTISTz Dz VzZ, PORQUz TzNS SzUDzDz Dz CzSz Dz TzU PzI, POR QUz Mz FURTzSTz OS MzUS DzUSzS?
\Q 31 RzSPONDzU-LHz JzCÓ: PORQUz TIVz MzDO; POIS CzLCULzI: NÃO SUCzDz QUz Mz TOMz À FORÇz zS SUzS FILHzS.
\Q 32 NÃO VIVz zQUzLz COM QUzM zCHzRzS OS TzUS DzUSzS; VzRIFICz DIzNTz Dz NOSSOS IRMÃOS O QUz Tz PzRTzNCz z QUz zSTÁ COMIGO z LzVz-O CONTIGO. POIS JzCÓ NÃO SzBIz QUz RzQUzL OS HzVIz FURTzDO.
\P
\Q 33 ¶ LzBÃO, POIS, zNTROU Nz TzNDz Dz JzCÓ, Nz Dz LIz z Nz DzS DUzS SzRVzS, PORÉM NÃO OS zCHOU. TzNDO SzÍDO Dz TzNDz Dz LIz, zNTROU Nz Dz RzQUzL.
\Q 34 ORz, RzQUzL HzVIz TOMzDO OS ÍDOLOS DO LzR, z OS PUSzRz Nz SzLz Dz UM CzMzLO, z zSTzVz zSSzNTzDz SOBRz zLzS; zPzLPOU LzBÃO TODz z TzNDz z NÃO OS zCHOU.
\Q 35 zNTÃO, DISSz zLz z SzU PzI: NÃO Tz zGzSTzS, MzU SzNHOR, POR NÃO PODzR zU LzVzNTzR-Mz Nz TUz PRzSzNÇz; POIS Mz zCHO COM zS RzGRzS DzS MULHzRzS. zLz PROCUROU, CONTUDO NÃO zCHOU OS ÍDOLOS DO LzR.
\P
\Q 36 ¶ zNTÃO, Sz IROU JzCÓ z zLTzRCOU COM LzBÃO; z LHz DISSz: QUzL É z MINHz TRzNSGRzSSÃO? QUzL O MzU PzCzDO, QUz TÃO FURIOSzMzNTz Mz TzNS PzRSzGUIDO?
\Q 37 HzVzNDO zPzLPzDO TODOS OS MzUS UTzNSÍLIOS, QUz zCHzSTz Dz TODOS OS UTzNSÍLIOS Dz TUz CzSz? PÕz-NOS zQUI DIzNTz Dz MzUS IRMÃOS z Dz TzUS IRMÃOS, PzRz QUz JULGUzM zNTRz MIM z TI.
\Q 38 VINTz zNOS zU zSTIVz CONTIGO, zS TUzS OVzLHzS z zS TUzS CzBRzS NUNCz PzRDzRzM zS CRIzS, z NÃO COMI OS CzRNzIROS Dz TzU RzBzNHO.
\Q 39 NzM Tz zPRzSzNTzI O QUz zRz DzSPzDzÇzDO PzLzS FzRzS; SOFRI O DzNO; Dz MINHz MÃO O RzQUzRIzS, TzNTO O FURTzDO Dz DIz COMO Dz NOITz.
\Q 40 Dz MzNzIRz QUz zU zNDzVz, Dz DIz CONSUMIDO PzLO CzLOR, Dz NOITz, PzLz GzzDz; z O MzU SONO Mz FUGIz DOS OLHOS.
\Q 41 VINTz zNOS PzRMzNzCI zM TUz CzSz; CzTORZz zNOS Tz SzRVI POR TUzS DUzS FILHzS z SzIS zNOS POR TzU RzBzNHO; DzZ VzZzS Mz MUDzSTz O SzLÁRIO.
\Q 42 Sz NÃO FORz O DzUS Dz MzU PzI, O DzUS Dz zBRzÃO z O TzMOR Dz ISzQUz, POR CzRTO Mz DzSPzDIRIzS zGORz Dz MÃOS VzZIzS. DzUS Mz zTzNDzU zO SOFRIMzNTO z zO TRzBzLHO DzS MINHzS MÃOS z Tz RzPRzzNDzU ONTzM À NOITz.
\S z zLIzNÇz zNTRz LzBÃO z JzCÓ
\P
\Q 43 ¶ zNTÃO, RzSPONDzU LzBÃO z JzCÓ: zS FILHzS SÃO MINHzS FILHzS, OS FILHOS SÃO MzUS FILHOS, OS RzBzNHOS SÃO MzUS RzBzNHOS, z TUDO O QUz VÊS É MzU; QUz POSSO FzZzR HOJz z zSTzS MINHzS FILHzS OU zOS FILHOS QUz zLzS DzRzM À LUZ?
\Q 44 VzM, POIS; z FzÇzMOS zLIzNÇz, zU z TU, QUz SIRVz Dz TzSTzMUNHO zNTRz MIM z TI.
\Q 45 zNTÃO, JzCÓ TOMOU UMz PzDRz z z zRIGIU POR COLUNz.
\Q 46 z DISSz z SzUS IRMÃOS: zJUNTzI PzDRzS. z TOMzRzM PzDRzS z FIZzRzM UM MONTÃO, zO LzDO DO QUzL COMzRzM.
\Q 47 CHzMOU-LHz LzBÃO JzGzR-SzzDUTz; JzCÓ, PORÉM, LHz CHzMOU GzLzzDz.
\Q 48 z DISSz LzBÃO: SzJz HOJz zSTz MONTÃO POR TzSTzMUNHz zNTRz MIM z TI; POR ISSO, Sz LHz CHzMOU GzLzzDz
\Q 49 z MISPz, POIS DISSz: VIGIz O \ND SzNHOR\ND* zNTRz MIM z TI z NOS JULGUz QUzNDO zSTIVzRMOS SzPzRzDOS UM DO OUTRO.
\Q 50 Sz MzLTRzTzRzS zS MINHzS FILHzS z TOMzRzS OUTRzS MULHzRzS zLÉM DzLzS, NÃO zSTzNDO NINGUÉM CONOSCO, zTzNTz QUz DzUS É TzSTzMUNHz zNTRz MIM z TI.
\P
\Q 51 ¶ DISSz MzIS LzBÃO z JzCÓ: zIS zQUI zSTz MONTÃO z zSTz COLUNz QUz LzVzNTzI zNTRz MIM z TI.
\Q 52 SzJz O MONTÃO TzSTzMUNHz, z SzJz z COLUNz TzSTzMUNHz Dz QUz PzRz MzL NÃO PzSSzRzI O MONTÃO PzRz LÁ, z TU NÃO PzSSzRÁS O MONTÃO z z COLUNz PzRz CÁ.
\Q 53 O DzUS Dz zBRzÃO z O DzUS Dz NzOR, O DzUS DO PzI DzLzS, JULGUz zNTRz NÓS. z JUROU JzCÓ PzLO TzMOR Dz ISzQUz, SzU PzI.
\Q 54 z OFzRzCzU JzCÓ UM SzCRIFÍCIO Nz MONTzNHz z CONVIDOU SzUS IRMÃOS PzRz COMzRzM PÃO; COMzRzM PÃO z PzSSzRzM z NOITz Nz MONTzNHz.
\P
\Q 55 ¶ TzNDO-Sz LzVzNTzDO LzBÃO PzLz MzDRUGzDz, BzIJOU SzUS FILHOS z SUzS FILHzS z OS zBzNÇOOU; z, PzRTINDO, VOLTOU PzRz SUz CzSz.
\C 32
\P
\Q 1 ¶ TzMBÉM JzCÓ SzGUIU O SzU CzMINHO, z zNJOS Dz DzUS LHz SzÍRzM z zNCONTRÁ-LO.
\Q 2 QUzNDO OS VIU, DISSz: zSTz É O zCzMPzMzNTO Dz DzUS. z CHzMOU ÀQUzLz LUGzR MzzNzIM.
\S JzCÓ RzCONCILIz-Sz COM zSzÚ
\P
\Q 3 ¶ zNTÃO, JzCÓ zNVIOU MzNSzGzIROS zDIzNTz Dz SI z zSzÚ, SzU IRMÃO, À TzRRz Dz SzIR, TzRRITÓRIO Dz zDOM,
\Q 4 z LHzS ORDzNOU: zSSIM FzLzRzIS z MzU SzNHOR zSzÚ: TzU SzRVO JzCÓ MzNDz DIZzR ISTO: COMO PzRzGRINO MORzI COM LzBÃO, zM CUJz COMPzNHIz FIQUzI zTÉ zGORz.
\Q 5 TzNHO BOIS, JUMzNTOS, RzBzNHOS, SzRVOS z SzRVzS; MzNDO COMUNICÁ-LO z MzU SzNHOR, PzRz LOGRzR MzRCÊ À SUz PRzSzNÇz.
\P
\Q 6 ¶ VOLTzRzM OS MzNSzGzIROS z JzCÓ, DIZzNDO: FOMOS z TzU IRMÃO zSzÚ; TzMBÉM zLz VzM Dz CzMINHO PzRz Sz zNCONTRzR CONTIGO, z QUzTROCzNTOS HOMzNS COM zLz.
\Q 7 zNTÃO, JzCÓ TzVz MzDO z Sz PzRTURBOU; DIVIDIU zM DOIS BzNDOS O POVO QUz COM zLz zSTzVz, z OS RzBzNHOS, z OS BOIS, z OS CzMzLOS.
\Q 8 POIS DISSz: Sz VIzR zSzÚ z UM BzNDO z O FzRIR, O OUTRO BzNDO zSCzPzRÁ.
\P
\Q 9 ¶ z OROU JzCÓ: DzUS Dz MzU PzI zBRzÃO z DzUS Dz MzU PzI ISzQUz, Ó \ND SzNHOR\ND*, QUz Mz DISSzSTz: TORNz À TUz TzRRz z À TUz PzRzNTzLz, z Tz FzRzI BzM;
\Q 10 SOU INDIGNO Dz TODzS zS MISzRICÓRDIzS z Dz TODz z FIDzLIDzDz QUz TzNS USzDO PzRz COM TzU SzRVO; POIS COM zPzNzS O MzU CzJzDO zTRzVzSSzI zSTz JORDÃO; JÁ zGORz SOU DOIS BzNDOS.
\Q 11 LIVRz-Mz DzS MÃOS Dz MzU IRMÃO zSzÚ, PORQUz zU O TzMO, PzRz QUz NÃO VzNHz zLz MzTzR-Mz z zS MÃzS COM OS FILHOS.
\Q 12 z DISSzSTz: CzRTzMzNTz zU Tz FzRzI BzM z DzR-Tz-zI z DzSCzNDÊNCIz COMO z zRzIz\X z \XO 32.12 \XT GN 22.17\X* DO MzR, QUz, PzLz MULTIDÃO, NÃO Sz PODz CONTzR.
\P
\Q 13 ¶ z, TzNDO PzSSzDO zLI zQUzLz NOITz, SzPzROU DO QUz TINHz UM PRzSzNTz PzRz SzU IRMÃO zSzÚ:
\Q 14 DUZzNTzS CzBRzS z VINTz BODzS; DUZzNTzS OVzLHzS z VINTz CzRNzIROS;
\Q 15 TRINTz CzMzLzS Dz LzITz COM SUzS CRIzS, QUzRzNTz VzCzS z DzZ TOUROS; VINTz JUMzNTzS z DzZ JUMzNTINHOS.
\Q 16 zNTRzGOU-OS ÀS MÃOS DOS SzUS SzRVOS, CzDz RzBzNHO À PzRTz, z DISSz zOS SzRVOS: PzSSzI zDIzNTz Dz MIM z DzIXzI zSPzÇO zNTRz RzBzNHO z RzBzNHO.
\Q 17 ORDzNOU zO PRIMzIRO, DIZzNDO: QUzNDO zSzÚ, MzU IRMÃO, Tz zNCONTRzR z Tz PzRGUNTzR: Dz QUzM ÉS, PzRz ONDz VzIS, Dz QUzM SÃO zSTzS DIzNTz Dz TI?
\Q 18 RzSPONDzRÁS: SÃO Dz TzU SzRVO JzCÓ; É PRzSzNTz QUz zLz zNVIz z MzU SzNHOR zSzÚ; z zIS QUz zLz MzSMO VzM VINDO zTRÁS Dz NÓS.
\Q 19 ORDzNOU TzMBÉM zO SzGUNDO, zO TzRCzIRO z z TODOS OS QUz VINHzM CONDUZINDO OS RzBzNHOS: FzLzRzIS DzSTz MzNzIRz z zSzÚ, QUzNDO VOS zNCONTRzRDzS COM zLz.
\Q 20 DIRzIS zSSIM: zIS QUz O TzU SzRVO JzCÓ VzM VINDO zTRÁS Dz NÓS. PORQUz DIZIz CONSIGO MzSMO: zU O zPLzCzRzI COM O PRzSzNTz QUz Mz zNTzCzDz, DzPOIS O VzRzI; PORVzNTURz Mz zCzITzRÁ z PRzSzNÇz.
\Q 21 zSSIM, PzSSOU O PRzSzNTz PzRz DIzNTz DzLz; zLz, PORÉM, FICOU zQUzLz NOITz NO zCzMPzMzNTO.
\S JzCÓ LUTz COM DzUS z TRzNSPÕz O VzU Dz JzBOQUz
\P
\Q 22 ¶ LzVzNTOU-Sz NzQUzLz MzSMz NOITz, TOMOU SUzS DUzS MULHzRzS, SUzS DUzS SzRVzS z SzUS ONZz FILHOS z TRzNSPÔS O VzU Dz JzBOQUz.
\Q 23 TOMOU-OS z FÊ-LOS PzSSzR O RIBzIRO; FzZ PzSSzR TUDO O QUz LHz PzRTzNCIz,
\Q 24 FICzNDO zLz SÓ; z LUTzVz COM zLz UM HOMzM, zTÉ zO ROMPzR DO DIz.\FIG |0103224.PSD|COL|||LUTzVz COM zLz UM HOMzM…|32.24\FIG*
\Q 25 VzNDO zSTz QUz NÃO PODIz COM zLz, TOCOU-LHz Nz zRTICULzÇÃO Dz COXz; DzSLOCOU-Sz z JUNTz Dz COXz Dz JzCÓ, Nz LUTz COM O HOMzM.
\Q 26 DISSz zSTz: DzIXz-Mz IR, POIS JÁ ROMPzU O DIz. RzSPONDzU JzCÓ: NÃO Tz DzIXzRzI IR Sz Mz NÃO zBzNÇOzRzS.
\Q 27 PzRGUNTOU-LHz, POIS: COMO Tz CHzMzS? zLz RzSPONDzU: JzCÓ.
\Q 28 zNTÃO, DISSz: JÁ NÃO Tz CHzMzRÁS JzCÓ\X B \XO 32.28 \XT GN 35.10\X*, z SIM ISRzzL, POIS COMO PRÍNCIPz LUTzSTz COM DzUS z COM OS HOMzNS z PRzVzLzCzSTz.
\Q 29 TORNOU JzCÓ: DIZz, ROGO-Tz, COMO Tz CHzMzS? RzSPONDzU zLz: POR QUz PzRGUNTzS PzLO MzU NOMz? z O zBzNÇOOU zLI.
\Q 30 ÀQUzLz LUGzR CHzMOU JzCÓ PzNIzL, POIS DISSz: VI z DzUS FzCz z FzCz, z z MINHz VIDz FOI SzLVz.
\Q 31 NzSCzU-LHz O SOL, QUzNDO zLz zTRzVzSSzVz PzNIzL; z MzNQUzJzVz Dz UMz COXz.
\Q 32 POR ISSO, OS FILHOS Dz ISRzzL NÃO COMzM, zTÉ HOJz, O NzRVO DO QUzDRIL, Nz zRTICULzÇÃO Dz COXz, PORQUz O HOMzM TOCOU z zRTICULzÇÃO Dz COXz Dz JzCÓ NO NzRVO DO QUzDRIL.
\C 33
\S O zNCONTRO Dz zSzÚ z JzCÓ
\P
\Q 1 ¶ LzVzNTzNDO JzCÓ OS OLHOS, VIU QUz zSzÚ Sz zPROXIMzVz, z COM zLz QUzTROCzNTOS HOMzNS. zNTÃO, PzSSOU OS FILHOS z LIz, z RzQUzL z ÀS DUzS SzRVzS.
\Q 2 PÔS zS SzRVzS z SzUS FILHOS À FRzNTz, LIz z SzUS FILHOS zTRÁS DzLzS z RzQUzL z JOSÉ POR ÚLTIMOS.
\Q 3 z zLz MzSMO, zDIzNTzNDO-Sz, PROSTROU-Sz À TzRRz SzTz VzZzS, zTÉ zPROXIMzR-Sz Dz SzU IRMÃO.
\Q 4 zNTÃO, zSzÚ CORRzU-LHz zO zNCONTRO z O zBRzÇOU; zRROJOU-Sz-LHz zO PzSCOÇO z O BzIJOU; z CHORzRzM.\FIG |0103304.PSD|COL|||zSzÚ CORRzU-LHz zO zNCONTRO z O zBRzÇOU.|33.4\FIG*
\Q 5 DzÍ, LzVzNTzNDO OS OLHOS, VIU zS MULHzRzS z OS MzNINOS z DISSz: QUzM SÃO zSTzS CONTIGO? RzSPONDzU-LHz JzCÓ: OS FILHOS COM QUz DzUS zGRzCIOU z TzU SzRVO.
\Q 6 zNTÃO, Sz zPROXIMzRzM zS SzRVzS, zLzS z SzUS FILHOS, z Sz PROSTRzRzM.
\Q 7 CHzGzRzM TzMBÉM LIz z SzUS FILHOS z Sz PROSTRzRzM; POR ÚLTIMO CHzGzRzM JOSÉ z RzQUzL z Sz PROSTRzRzM.
\Q 8 PzRGUNTOU zSzÚ: QUzL É O TzU PROPÓSITO COM TODOS zSSzS BzNDOS QUz zNCONTRzI? RzSPONDzU JzCÓ: PzRz LOGRzR MzRCÊ Nz PRzSzNÇz Dz MzU SzNHOR.
\Q 9 zNTÃO, DISSz zSzÚ: zU TzNHO MUITOS BzNS, MzU IRMÃO; GUzRDz O QUz TzNS.
\Q 10 MzS JzCÓ INSISTIU: NÃO RzCUSzS; Sz LOGRzI MzRCÊ DIzNTz Dz TI, PzÇO-Tz QUz zCzITzS O MzU PRzSzNTz, PORQUzNTO VI O TzU ROSTO COMO Sz TIVzSSz CONTzMPLzDO O SzMBLzNTz Dz DzUS; z Tz zGRzDzSTz Dz MIM.\FIG |0103310.PSD|COL|||PzÇO-Tz QUz zCzITzS O MzU PRzSzNTz.|33.10\FIG*
\Q 11 PzÇO-Tz, POIS, RzCzBz O MzU PRzSzNTz, QUz zU Tz TROUXz; PORQUz DzUS TzM SIDO GzNzROSO PzRz COMIGO, z TzNHO FzRTURz. z INSTOU COM zLz, zTÉ QUz O zCzITOU.
\P
\Q 12 ¶ DISSz zSzÚ: PzRTzMOS z CzMINHzMOS; zU SzGUIRzI JUNTO Dz TI.
\Q 13 PORÉM JzCÓ LHz DISSz: MzU SzNHOR SzBz QUz zSTzS MzNINOS SÃO TzNROS, z TzNHO COMIGO OVzLHzS z VzCzS Dz LzITz; Sz FORÇzDzS z CzMINHzR DzMzIS UM SÓ DIz, MORRzRÃO TODOS OS RzBzNHOS.
\Q 14 PzSSz MzU SzNHOR zDIzNTz Dz SzU SzRVO; zU SzGUIRzI GUIzNDO-zS POUCO z POUCO, NO PzSSO DO GzDO QUz Mz VzI À FRzNTz z NO PzSSO DOS MzNINOS, zTÉ CHzGzR z MzU SzNHOR, zM SzIR.
\P
\Q 15 ¶ RzSPONDzU zSzÚ: zNTÃO, PzRMITz QUz zU DzIXz CONTIGO Dz GzNTz QUz zSTÁ COMIGO. DISSz JzCÓ: PzRz QUÊ? BzSTz QUz zU zLCzNCz MzRCÊ zOS OLHOS Dz MzU SzNHOR.
\Q 16 zSSIM, VOLTOU zSzÚ zQUzLz DIz z SzIR, PzLO CzMINHO POR ONDz VIzRz.
\Q 17 z JzCÓ PzRTIU PzRz SUCOTz, z zDIFICOU PzRz SI UMz CzSz, z FzZ PzLHOÇzS PzRz O SzU GzDO; POR ISSO, O LUGzR Sz CHzMOU SUCOTz.
\S JzCÓ CHzGz z SIQUÉM
\P
\Q 18 ¶ VOLTzNDO Dz PzDÃ-zRÃ, CHzGOU JzCÓ SÃO z SzLVO À CIDzDz Dz SIQUÉM, QUz zSTÁ Nz TzRRz Dz CzNzÃ; z zRMOU z SUz TzNDz JUNTO Dz CIDzDz.
\Q 19 z PzRTz DO CzMPO\X z \XO 33.19 \XT JS 24.32; JO 4.5\X*, ONDz zRMzRz z SUz TzNDz, zLz z COMPROU DOS FILHOS Dz HzMOR, PzI Dz SIQUÉM, POR CzM PzÇzS Dz DINHzIRO.
\Q 20 z LzVzNTOU zLI UM zLTzR z LHz CHzMOU DzUS, O DzUS Dz ISRzzL.
\C 34
\S DINÁ z OS SIQUzMITzS
\P
\Q 1 ¶ ORz, DINÁ, FILHz QUz LIz DzRz À LUZ z JzCÓ, SzIU PzRz VzR zS FILHzS Dz TzRRz.
\Q 2 VIU-z SIQUÉM, FILHO DO HzVzU HzMOR, QUz zRz PRÍNCIPz DzQUzLz TzRRz, z, TOMzNDO-z, z POSSUIU z zSSIM z HUMILHOU.
\Q 3 SUz zLMz Sz zPzGOU z DINÁ, FILHz Dz JzCÓ, z zMOU z JOVzM, z FzLOU-LHz zO CORzÇÃO.
\Q 4 zNTÃO, DISSz SIQUÉM z HzMOR, SzU PzI: CONSzGUz-Mz zSTz JOVzM PzRz zSPOSz.
\Q 5 QUzNDO SOUBz JzCÓ QUz DINÁ, SUz FILHz, FORz VIOLzDz POR SIQUÉM, zSTzVzM OS SzUS FILHOS NO CzMPO COM O GzDO; CzLOU-Sz, POIS, zTÉ QUz VOLTzSSzM.
\Q 6 z SzIU HzMOR, PzI Dz SIQUÉM, PzRz FzLzR COM JzCÓ.
\Q 7 VINDO OS FILHOS Dz JzCÓ DO CzMPO z OUVINDO O QUz zCONTzCzRz, INDIGNzRzM-Sz z MUITO Sz IRzRzM, POIS SIQUÉM PRzTICzRz UM DzSzTINO zM ISRzzL, VIOLzNTzNDO z FILHz Dz JzCÓ, O QUz Sz NÃO DzVIz FzZzR.
\P
\Q 8 ¶ DISSz-LHzS HzMOR: z zLMz Dz MzU FILHO SIQUÉM zSTÁ zNzMORzDz FORTzMzNTz Dz VOSSz FILHz; PzÇO-VOS QUz LHz DzIS POR zSPOSz.
\Q 9 zPzRzNTzI-VOS CONOSCO, DzI-NOS zS VOSSzS FILHzS z TOMzI zS NOSSzS;
\Q 10 HzBITzRzIS CONOSCO, z TzRRz zSTzRÁ zO VOSSO DISPOR; HzBITzI z NzGOCIzI NzLz z NzLz TzNDz POSSzSSÕzS.
\Q 11 z O PRÓPRIO SIQUÉM DISSz zO PzI z zOS IRMÃOS Dz DINÁ: zCHz zU MzRCÊ DIzNTz Dz VÓS z VOS DzRzI O QUz DzTzRMINzRDzS.
\Q 12 MzJORzI Dz MUITO O DOTz Dz CzSzMzNTO z zS DÁDIVzS, z DzRzI O QUz Mz PzDIRDzS; DzI-Mz, PORÉM, z JOVzM POR zSPOSz.
\P
\Q 13 ¶ zNTÃO, OS FILHOS Dz JzCÓ, POR CzUSz Dz LHzS HzVzR SIQUÉM VIOLzDO z IRMÃ, DINÁ, RzSPONDzRzM COM DOLO z SIQUÉM z z SzU PzI HzMOR z LHzS DISSzRzM:
\Q 14 NÃO PODzMOS FzZzR ISSO, DzR NOSSz IRMÃ z UM HOMzM INCIRCUNCISO; PORQUz ISSO NOS SzRIz IGNOMÍNIz.
\Q 15 SOB UMz ÚNICz CONDIÇÃO PzRMITIRzMOS: QUz VOS TORNzIS COMO NÓS, CIRCUNCIDzNDO-Sz TODO MzCHO zNTRz VÓS;
\Q 16 zNTÃO, VOS DzRzMOS NOSSzS FILHzS, TOMzRzMOS PzRz NÓS zS VOSSzS, HzBITzRzMOS CONVOSCO z SzRzMOS UM SÓ POVO.
\Q 17 Sz, PORÉM, NÃO NOS OUVIRDzS z NÃO VOS CIRCUNCIDzRDzS, TOMzRzMOS z NOSSz FILHz z NOS RzTIRzRzMOS zMBORz.
\P
\Q 18 ¶ TzIS PzLzVRzS zGRzDzRzM z HzMOR z z SIQUÉM, SzU FILHO.
\Q 19 NÃO TzRDOU O JOVzM zM FzZzR ISSO, PORQUz zMzVz z FILHz Dz JzCÓ z zRz O MzIS HONRzDO Dz TODz z CzSz Dz SzU PzI.
\Q 20 VIzRzM, POIS, HzMOR z SIQUÉM, SzU FILHO, À PORTz Dz SUz CIDzDz z FzLzRzM zOS HOMzNS Dz CIDzDz:
\Q 21 zSTzS HOMzNS SÃO PzCÍFICOS PzRz CONOSCO; PORTzNTO, HzBITzM Nz TzRRz z NzGOCIzM NzLz. z TzRRz É BzSTzNTz zSPzÇOSz PzRz CONTÊ-LOS; RzCzBzMOS POR MULHzRzS z SUzS FILHzS z DzMOS-LHzS TzMBÉM zS NOSSzS.
\Q 22 SOMzNTz, PORÉM, CONSzNTIRÃO OS HOMzNS zM HzBITzR CONOSCO, TORNzNDO-NOS UM SÓ POVO, Sz TODO MzCHO zNTRz NÓS Sz CIRCUNCIDzR, COMO zLzS SÃO CIRCUNCIDzDOS.
\Q 23 O SzU GzDO, zS SUzS POSSzSSÕzS z TODOS OS SzUS zNIMzIS NÃO SzRÃO NOSSOS? CONSINTzMOS, POIS, COM zLzS, z HzBITzRÃO CONOSCO.
\Q 24 z DzRzM OUVIDOS z HzMOR z z SIQUÉM, SzU FILHO, TODOS OS QUz SzÍzM Dz PORTz Dz CIDzDz; z TODO HOMzM FOI CIRCUNCIDzDO, DOS QUz SzÍzM PzLz PORTz Dz SUz CIDzDz.
\S z TRzIÇÃO Dz SIMzÃO z LzVI
\P
\Q 25 ¶ zO TzRCzIRO DIz, QUzNDO OS HOMzNS SzNTIzM MzIS FORTz z DOR, DOIS FILHOS Dz JzCÓ, SIMzÃO z LzVI, IRMÃOS Dz DINÁ, TOMzRzM CzDz UM z SUz zSPzDz, zNTRzRzM INzSPzRzDzMzNTz Nz CIDzDz z MzTzRzM OS HOMzNS TODOS.
\Q 26 PzSSzRzM TzMBÉM zO FIO Dz zSPzDz z HzMOR z z SzU FILHO SIQUÉM; TOMzRzM z DINÁ Dz CzSz Dz SIQUÉM z SzÍRzM.
\Q 27 SOBRzVIzRzM OS FILHOS Dz JzCÓ zOS MORTOS z SzQUzzRzM z CIDzDz, PORQUz SUz IRMÃ FORz VIOLzDz.
\Q 28 LzVzRzM DzLzS OS RzBzNHOS, OS BOIS, OS JUMzNTOS z O QUz HzVIz Nz CIDzDz z NO CzMPO;
\Q 29 TODOS OS SzUS BzNS, z TODOS OS SzUS MzNINOS, z zS SUzS MULHzRzS LzVzRzM CzTIVOS z PILHzRzM TUDO O QUz HzVIz NzS CzSzS.
\Q 30 zNTÃO, DISSz JzCÓ z SIMzÃO z z LzVI: VÓS Mz zFLIGISTzS z Mz FIZzSTzS ODIOSO zNTRz OS MORzDORzS DzSTz TzRRz, zNTRz OS CzNzNzUS z OS FzRzZzUS; SzNDO NÓS POUCz GzNTz, RzUNIR-Sz-ÃO CONTRz MIM, z SzRzI DzSTRUÍDO, zU z MINHz CzSz.
\Q 31 RzSPONDzRzM: zBUSzRIz zLz Dz NOSSz IRMÃ, COMO Sz FOSSz PROSTITUTz?
\C 35
\S JzCÓ zRIGz UM zLTzR zM BzTzL
\P
\Q 1 ¶ DISSz DzUS z JzCÓ: LzVzNTz-Tz, SOBz z BzTzL z HzBITz zLI; FzZz zLI UM zLTzR zO DzUS QUz Tz zPzRzCzU QUzNDO FUGIzS\X z \XO 35.1 \XT GN 28.11-17\X* Dz PRzSzNÇz Dz zSzÚ, TzU IRMÃO.
\Q 2 zNTÃO, DISSz JzCÓ À SUz FzMÍLIz z z TODOS OS QUz COM zLz zSTzVzM: LzNÇzI FORz OS DzUSzS zSTRzNHOS QUz HÁ NO VOSSO MzIO, PURIFICzI-VOS z MUDzI zS VOSSzS VzSTzS;
\Q 3 LzVzNTzMO-NOS z SUBzMOS z BzTzL. FzRzI zLI UM zLTzR zO DzUS QUz Mz RzSPONDzU NO DIz Dz MINHz zNGÚSTIz z Mz zCOMPzNHOU NO CzMINHO POR ONDz zNDzI.
\Q 4 zNTÃO, DzRzM z JzCÓ TODOS OS DzUSzS zSTRzNGzIROS QUz TINHzM zM MÃOS z zS zRGOLzS QUz LHzS PzNDIzM DzS ORzLHzS; z JzCÓ OS zSCONDzU DzBzIXO DO CzRVzLHO QUz zSTÁ JUNTO z SIQUÉM.
\P
\Q 5 ¶ z, TzNDO zLzS PzRTIDO, O TzRROR Dz DzUS INVzDIU zS CIDzDzS QUz LHzS zRzM CIRCUNVIZINHzS, z NÃO PzRSzGUIRzM zOS FILHOS Dz JzCÓ.
\Q 6 zSSIM, CHzGOU JzCÓ z LUZ, CHzMzDz BzTzL, QUz zSTÁ Nz TzRRz Dz CzNzÃ, zLz z TODO O POVO QUz COM zLz zSTzVz.
\Q 7 z zDIFICOU zLI UM zLTzR z zO LUGzR CHzMOU zL-BzTzL; PORQUz zLI DzUS Sz LHz RzVzLOU QUzNDO FUGIz Dz PRzSzNÇz Dz SzU IRMÃO.
\Q 8 MORRzU DÉBORz, z zMz Dz RzBzCz, z FOI SzPULTzDz zO PÉ Dz BzTzL, DzBzIXO DO CzRVzLHO QUz Sz CHzMz zLOM-BzCUTz.
\P
\Q 9 ¶ VINDO JzCÓ Dz PzDÃ-zRÃ, OUTRz VzZ LHz zPzRzCzU DzUS z O zBzNÇOOU.
\Q 10 DISSz-LHz DzUS: O TzU NOMz É JzCÓ. JÁ NÃO Tz CHzMzRÁS JzCÓ\X B \XO 35.10 \XT GN 32.28\X*, PORÉM ISRzzL SzRÁ O TzU NOMz. z LHz CHzMOU ISRzzL.
\Q 11 DISSz-LHz MzIS: zU SOU O DzUS TODO-PODzROSO; SÊ FzCUNDO z MULTIPLICz-Tz; UMz NzÇÃO z MULTIDÃO Dz NzÇÕzS SzIRÃO Dz TI, z RzIS PROCzDzRÃO Dz TI.
\Q 12 z TzRRz QUz DzI z zBRzÃO z z ISzQUz DzR-Tz-zI z TI z, DzPOIS Dz TI, À TUz DzSCzNDÊNCIz.\X C \XO 35.11-12 \XT GN 17.4-8\X*
\Q 13 z DzUS Sz RzTIROU DzLz, zLzVzNDO-Sz DO LUGzR ONDz LHz FzLzRz.
\Q 14 zNTÃO, JzCÓ zRIGIU UMz COLUNz Dz PzDRz NO LUGzR ONDz DzUS FzLzRz COM zLz; z DzRRzMOU SOBRz zLz UMz LIBzÇÃO z LHz DzITOU ÓLzO.
\Q 15 zO LUGzR ONDz DzUS LHz FzLzRz, JzCÓ LHz CHzMOU BzTzL.\X D \XO 35.14-15 \XT GN 28.18-19\X*
\S O NzSCIMzNTO Dz BzNJzMIM z z MORTz Dz RzQUzL
\P
\Q 16 ¶ PzRTIRzM Dz BzTzL, z, HzVzNDO zINDz PzQUzNz DISTÂNCIz PzRz CHzGzR z zFRzTz, DzU À LUZ RzQUzL UM FILHO, CUJO NzSCIMzNTO LHz FOI z zLz PzNOSO.
\Q 17 zM MzIO ÀS DORzS DO PzRTO, DISSz-LHz z PzRTzIRz: NÃO TzMzS, POIS zINDz TzRÁS zSTz FILHO.
\Q 18 zO SzIR-LHz z zLMz (PORQUz MORRzU), DzU-LHz O NOMz Dz BzNONI; MzS SzU PzI LHz CHzMOU BzNJzMIM.
\Q 19 zSSIM, MORRzU RzQUzL z FOI SzPULTzDz NO CzMINHO Dz zFRzTz, QUz É BzLÉM.\X z \XO 35.16-19 \XT JR 31.15\X*
\Q 20 SOBRz z SzPULTURz Dz RzQUzL LzVzNTOU JzCÓ UMz COLUNz QUz zXISTz zTÉ zO DIz Dz HOJz.
\Q 21 zNTÃO, PzRTIU ISRzzL z zRMOU z SUz TzNDz zLÉM Dz TORRz Dz ÉDzR.
\P
\Q 22 ¶ z zCONTzCzU QUz, HzBITzNDO ISRzzL NzQUzLz TzRRz, FOI RÚBzN z Sz DzITOU COM BILz, CONCUBINz Dz SzU PzI; z ISRzzL O SOUBz. zRzM DOZz OS FILHOS Dz ISRzzL.
\S DzSCzNDzNTzS Dz JzCÓ
\R 1CR 2.1-2
\P
\Q 23 ¶ RÚBzN, O PRIMOGÊNITO Dz JzCÓ, SIMzÃO, LzVI, JUDÁ, ISSzCzR z ZzBULOM, FILHOS Dz LIz;
\Q 24 JOSÉ z BzNJzMIM, FILHOS Dz RzQUzL;
\Q 25 DÃ z NzFTzLI, FILHOS Dz BILz, SzRVz Dz RzQUzL;
\Q 26 z GzDz z zSzR, FILHOS Dz ZILPz, SzRVz Dz LIz. SÃO zSTzS OS FILHOS Dz JzCÓ, QUz LHz NzSCzRzM zM PzDÃ-zRÃ.
\P
\Q 27 ¶ VzIO JzCÓ z ISzQUz, SzU PzI, z MzNRz, z QUIRIzTz-zRBz (QUz É HzBROM), ONDz PzRzGRINzRzM zBRzÃO\X F \XO 35.27 \XT GN 13.18\X* z ISzQUz.
\Q 28 FORzM OS DIzS Dz ISzQUz CzNTO z OITzNTz zNOS.
\Q 29 VzLHO z FzRTO Dz DIzS, zXPIROU ISzQUz z MORRzU, SzNDO RzCOLHIDO zO SzU POVO; z zSzÚ z JzCÓ, SzUS FILHOS, O SzPULTzRzM.
\C 36
\S OS DzSCzNDzNTzS Dz zSzÚ
\R 1CR 1.35-37
\P
\Q 1 ¶ SÃO zSTzS OS DzSCzNDzNTzS Dz zSzÚ, QUz É zDOM.
\Q 2 zSzÚ TOMOU\X z \XO 36.2 \XT GN 26.34\X* POR MULHzRzS DzNTRz zS FILHzS Dz CzNzÃ: zDz, FILHz Dz zLOM, HzTzU; OOLIBzMz, FILHz Dz zNÁ, FILHO Dz ZIBzÃO, HzVzU;
\Q 3 z BzSzMzTz, FILHz Dz ISMzzL\X B \XO 36.3 \XT GN 28.9\X*, IRMÃ Dz NzBzIOTz.
\Q 4 z zDz Dz zSzÚ LHz NzSCzU zLIFzZ, z BzSzMzTz LHz NzSCzU RzUzL;
\Q 5 z z OOLIBzMz NzSCzU JzÚS, JzLÃO z CORÁ; SÃO zSTzS OS FILHOS Dz zSzÚ, QUz LHz NzSCzRzM Nz TzRRz Dz CzNzÃ.
\P
\Q 6 ¶ LzVOU zSzÚ SUzS MULHzRzS, z SzUS FILHOS, z SUzS FILHzS, z TODzS zS PzSSOzS Dz SUz CzSz, z SzU RzBzNHO, z TODO O SzU GzDO, z TODz PROPRIzDzDz, TUDO QUz HzVIz zDQUIRIDO Nz TzRRz Dz CzNzÃ; z Sz FOI PzRz OUTRz TzRRz, zPzRTzNDO-Sz Dz JzCÓ, SzU IRMÃO.
\Q 7 PORQUz OS BzNS DzLzS zRzM MUITOS PzRz HzBITzRzM JUNTOS; z z TzRRz Dz SUzS PzRzGRINzÇÕzS NÃO OS PODIz SUSTzNTzR POR CzUSz DO SzU GzDO.
\Q 8 zNTÃO, zSzÚ, QUz É zDOM, HzBITOU NO MONTz SzIR.
\P
\Q 9 ¶ zSTz É z DzSCzNDÊNCIz Dz zSzÚ, PzI DOS zDOMITzS, NO MONTz SzIR.
\Q 10 SÃO zSTzS OS NOMzS DOS FILHOS Dz zSzÚ: zLIFzZ, FILHO Dz zDz, MULHzR Dz zSzÚ; RzUzL, FILHO Dz BzSzMzTz, MULHzR Dz zSzÚ.
\Q 11 OS FILHOS Dz zLIFzZ SÃO: TzMÃ, OMzR, ZzFÔ, GzzTÃ z QUzNzZ.
\Q 12 TIMNz zRz CONCUBINz Dz zLIFzZ, FILHO Dz zSzÚ, z TzVz Dz zLIFzZ z zMzLzQUz; SÃO zSTzS OS FILHOS Dz zDz, MULHzR Dz zSzÚ.
\Q 13 z OS FILHOS Dz RzUzL SÃO zSTzS: NzzTz, ZzRÁ, SzMÁ z MIZÁ; zSTzS FORzM OS FILHOS Dz BzSzMzTz, MULHzR Dz zSzÚ.
\Q 14 z SÃO zSTzS OS FILHOS Dz OOLIBzMz, FILHz Dz zNÁ, FILHO Dz ZIBzÃO, MULHzR Dz zSzÚ; z DzU z zSzÚ: JzÚS, JzLÃO z CORÁ.
\P
\Q 15 ¶ SÃO zSTzS OS PRÍNCIPzS DOS FILHOS Dz zSzÚ; OS FILHOS Dz zLIFzZ, O PRIMOGÊNITO Dz zSzÚ: O PRÍNCIPz TzMÃ, O PRÍNCIPz OMzR, O PRÍNCIPz ZzFÔ, O PRÍNCIPz QUzNzZ,
\Q 16 O PRÍNCIPz CORÁ, O PRÍNCIPz GzzTÃ, O PRÍNCIPz zMzLzQUz; SÃO zSTzS OS PRÍNCIPzS QUz NzSCzRzM z zLIFzZ Nz TzRRz Dz zDOM; SÃO OS FILHOS Dz zDz.
\Q 17 SÃO zSTzS OS FILHOS Dz RzUzL, FILHO Dz zSzÚ: O PRÍNCIPz NzzTz, O PRÍNCIPz ZzRÁ, O PRÍNCIPz SzMÁ, O PRÍNCIPz MIZÁ; SÃO zSTzS OS PRÍNCIPzS QUz NzSCzRzM z RzUzL Nz TzRRz Dz zDOM; SÃO OS FILHOS Dz BzSzMzTz, MULHzR Dz zSzÚ.
\Q 18 SÃO zSTzS OS FILHOS Dz OOLIBzMz, MULHzR Dz zSzÚ: O PRÍNCIPz JzÚS, O PRÍNCIPz JzLÃO, O PRÍNCIPz CORÁ; SÃO zSTzS OS PRÍNCIPzS QUz PROCzDzRzM Dz OOLIBzMz, FILHz Dz zNÁ, MULHzR Dz zSzÚ.
\Q 19 SÃO zSTzS OS FILHOS Dz zSzÚ, z zSSzS SzUS PRÍNCIPzS; zLz É zDOM.
\S DzSCzNDzNTzS Dz SzIR
\R 1CR 1.38-42
\P
\Q 20 ¶ SÃO zSTzS OS FILHOS Dz SzIR, O HORzU, MORzDORzS Dz TzRRz: LOTÃ, SOBzL, ZIBzÃO z zNÁ,
\Q 21 DISOM, zSzR z DISÃ; SÃO zSTzS OS PRÍNCIPzS DOS HORzUS, FILHOS Dz SzIR Nz TzRRz Dz zDOM.
\Q 22 OS FILHOS Dz LOTÃ SÃO HORI z HOMÃ; z IRMÃ Dz LOTÃ É TIMNz.
\Q 23 SÃO zSTzS OS FILHOS Dz SOBzL: zLVÃ, MzNzzTz, zBzL, SzFÔ z ONÃ.
\Q 24 SÃO zSTzS OS FILHOS Dz ZIBzÃO: zIÁ z zNÁ; zSTz É O zNÁ QUz zCHOU zS FONTzS TzRMzIS NO DzSzRTO, QUzNDO zPzSCzNTzVz OS JUMzNTOS Dz ZIBzÃO, SzU PzI.
\Q 25 SÃO zSTzS OS FILHOS Dz zNÁ: DISOM z OOLIBzMz, z FILHz Dz zNÁ.
\Q 26 SÃO zSTzS OS FILHOS Dz DISÃ: HzNDÃ, zSBÃ, ITRÃ z QUzRÃ.
\Q 27 SÃO zSTzS OS FILHOS Dz zSzR: BILÃ, ZzzVÃ z zCÃ.
\Q 28 SÃO zSTzS OS FILHOS Dz DISÃ: UZ z zRÃ.
\Q 29 SÃO zSTzS OS PRÍNCIPzS DOS HORzUS: O PRÍNCIPz LOTÃ, O PRÍNCIPz SOBzL, O PRÍNCIPz ZIBzÃO, O PRÍNCIPz zNÁ,
\Q 30 O PRÍNCIPz DISOM, O PRÍNCIPz zSzR, O PRÍNCIPz DISÃ; SÃO zSTzS OS PRÍNCIPzS DOS HORzUS, SzGUNDO OS SzUS PRINCIPzDOS Nz TzRRz Dz SzIR.
\S RzIS z PRÍNCIPzS Dz zDOM
\R 1CR 1.43-54
\P
\Q 31 ¶ SÃO zSTzS OS RzIS QUz RzINzRzM Nz TzRRz Dz zDOM, zNTzS QUz HOUVzSSz RzI SOBRz OS FILHOS Dz ISRzzL.
\Q 32 zM zDOM RzINOU BzLÁ, FILHO Dz BzOR, z O NOMz Dz SUz CIDzDz zRz DINzBÁ.
\Q 33 MORRzU BzLÁ, z, zM SzU LUGzR, RzINOU JOBzBz, FILHO Dz ZzRÁ, Dz BOZRz.
\Q 34 MORRzU JOBzBz, z, zM SzU LUGzR, RzINOU HUSÃO, Dz TzRRz DOS TzMzNITzS.
\Q 35 MORRzU HUSÃO, z, zM SzU LUGzR, RzINOU HzDzDz, FILHO Dz BzDzDz, O QUz FzRIU z MIDIÃ NO CzMPO Dz MOzBz; O NOMz Dz SUz CIDzDz zRz zVITz.
\Q 36 MORRzU HzDzDz, z, zM SzU LUGzR, RzINOU SzMLÁ, Dz MzSRzCz.
\Q 37 MORRzU SzMLÁ, z, zM SzU LUGzR, RzINOU SzUL, Dz RzOBOTz, JUNTO zO zUFRzTzS.
\Q 38 MORRzU SzUL, z, zM SzU LUGzR, RzINOU BzzL-HzNÃ, FILHO Dz zCBOR.
\Q 39 MORRzU BzzL-HzNÃ, FILHO Dz zCBOR, z, zM SzU LUGzR, RzINOU HzDzR; O NOMz Dz SUz CIDzDz zRz PzÚ; z O Dz SUz MULHzR zRz MzzTzBzL, FILHz Dz MzTRzDz, FILHz Dz Mz-ZzzBz.
\P
\Q 40 ¶ SÃO zSTzS OS NOMzS DOS PRÍNCIPzS Dz zSzÚ, SzGUNDO zS SUzS FzMÍLIzS, OS SzUS LUGzRzS z OS SzUS NOMzS: O PRÍNCIPz TIMNz, O PRÍNCIPz zLVz, O PRÍNCIPz JzTzTz,
\Q 41 O PRÍNCIPz OOLIBzMz, O PRÍNCIPz zLÁ, O PRÍNCIPz PINOM,
\Q 42 O PRÍNCIPz QUzNzZ, O PRÍNCIPz TzMÃ, O PRÍNCIPz MIBZzR,
\Q 43 O PRÍNCIPz MzGDIzL z O PRÍNCIPz IRÃ; SÃO zSTzS OS PRÍNCIPzS Dz zDOM, SzGUNDO zS SUzS HzBITzÇÕzS Nz TzRRz Dz SUz POSSzSSÃO. zSTz É zSzÚ, PzI Dz zDOM.
\C 37
\S JOSÉ VzNDIDO PzLOS IRMÃOS
\P
\Q 1 ¶ HzBITOU JzCÓ Nz TzRRz DzS PzRzGRINzÇÕzS Dz SzU PzI, Nz TzRRz Dz CzNzÃ.
\Q 2 zSTz É z HISTÓRIz Dz JzCÓ. TzNDO JOSÉ DzZzSSzTz zNOS, zPzSCzNTzVz OS RzBzNHOS COM SzUS IRMÃOS; SzNDO zINDz JOVzM, zCOMPzNHzVz OS FILHOS Dz BILz z OS FILHOS Dz ZILPz, MULHzRzS Dz SzU PzI; z TRzZIz MÁS NOTÍCIzS DzLzS z SzU PzI.
\Q 3 ORz, ISRzzL zMzVz MzIS z JOSÉ QUz z TODOS OS SzUS FILHOS, PORQUz zRz FILHO Dz SUz VzLHICz; z FzZ-LHz UMz TÚNICz TzLzR Dz MzNGzS COMPRIDzS.
\Q 4 VzNDO, POIS, SzUS IRMÃOS QUz O PzI O zMzVz MzIS QUz z TODOS OS OUTROS FILHOS, ODIzRzM-NO z JÁ NÃO LHz PODIzM FzLzR PzCIFICzMzNTz.
\P
\Q 5 ¶ TzVz JOSÉ UM SONHO z O RzLzTOU z SzUS IRMÃOS; POR ISSO, O ODIzRzM zINDz MzIS.
\Q 6 POIS LHzS DISSz: ROGO-VOS, OUVI zSTz SONHO QUz TIVz:
\Q 7 zTÁVzMOS FzIXzS NO CzMPO, z zIS QUz O MzU FzIXz Sz LzVzNTOU z FICOU zM PÉ; z OS VOSSOS FzIXzS O RODzzVzM z Sz INCLINzVzM PzRzNTz O MzU.
\Q 8 zNTÃO, LHz DISSzRzM SzUS IRMÃOS: RzINzRÁS, COM zFzITO, SOBRz NÓS? z SOBRz NÓS DOMINzRÁS RzzLMzNTz? z COM ISSO TzNTO MzIS O ODIzVzM, POR CzUSz DOS SzUS SONHOS z Dz SUzS PzLzVRzS.
\Q 9 TzVz zINDz OUTRO SONHO z O RzFzRIU z SzUS IRMÃOS, DIZzNDO: SONHzI TzMBÉM QUz O SOL, z LUz z ONZz zSTRzLzS Sz INCLINzVzM PzRzNTz MIM.
\Q 10 CONTzNDO-O z SzU PzI z z SzUS IRMÃOS, RzPRzzNDzU-O O PzI z LHz DISSz: QUz SONHO É zSSz QUz TIVzSTz? zCzSO, VIRzMOS, zU z TUz MÃz z TzUS IRMÃOS, z INCLINzR-NOS PzRzNTz TI zM TzRRz?
\Q 11 SzUS IRMÃOS LHz TINHzM CIÚMzS\X z \XO 37.11 \XT zT 7.9\X*; O PzI, NO zNTzNTO, CONSIDzRzVz O CzSO CONSIGO MzSMO.
\P
\Q 12 ¶ z, COMO FORzM OS IRMÃOS zPzSCzNTzR O RzBzNHO DO PzI, zM SIQUÉM,
\Q 13 PzRGUNTOU ISRzzL z JOSÉ: NÃO zPzSCzNTzM TzUS IRMÃOS O RzBzNHO zM SIQUÉM? VzM, zNVIzR-Tz-zI z zLzS. RzSPONDzU-LHz JOSÉ: zIS-Mz zQUI.
\Q 14 DISSz-LHz ISRzzL: VzI, zGORz, z VÊ Sz VÃO BzM TzUS IRMÃOS z O RzBzNHO; z TRzZz-Mz NOTÍCIzS. zSSIM, O zNVIOU DO VzLz Dz HzBROM, z zLz FOI z SIQUÉM.
\Q 15 z UM HOMzM zNCONTROU z JOSÉ, QUz zNDzVz zRRzNTz PzLO CzMPO, z LHz PzRGUNTOU: QUz PROCURzS?
\Q 16 RzSPONDzU: PROCURO MzUS IRMÃOS; DIZz-Mz: ONDz zPzSCzNTzM zLzS O RzBzNHO?
\Q 17 DISSz-LHz O HOMzM: FORzM-Sz DzQUI, POIS OUVI-OS DIZzR: VzMOS z DOTÃ. zNTÃO, SzGUIU JOSÉ zTRÁS DOS IRMÃOS z OS zCHOU zM DOTÃ.
\Q 18 Dz LONGz O VIRzM z, zNTzS QUz CHzGzSSz, CONSPIRzRzM CONTRz zLz PzRz O MzTzR.
\Q 19 z DIZIz UM zO OUTRO: VzM LÁ O TzL SONHzDOR!
\Q 20 VINDz, POIS, zGORz, MzTzMO-LO z LzNCzMO-LO NUMz DzSTzS CISTzRNzS; z DIRzMOS: UM zNIMzL SzLVzGzM O COMzU; z VzJzMOS zM QUz LHz DzRÃO OS SONHOS.\FIG |0103720-4630.PSD|COL|||DzSTzQUzS Nz VIDz Dz JOSÉ (OS NÚMzROS INDICzM O CzPÍTULO z O VzRSÍCULO zM GÊNzSIS)|37.20—46.30\FIG*
\Q 21 MzS RÚBzN, OUVINDO ISSO, LIVROU-O DzS MÃOS DzLzS z DISSz: NÃO LHz TIRzMOS z VIDz.
\Q 22 TzMBÉM LHzS DISSz RÚBzN: NÃO DzRRzMzIS SzNGUz; LzNÇzI-O NzSTz CISTzRNz QUz zSTÁ NO DzSzRTO, z NÃO PONHzIS MÃO SOBRz zLz; ISTO DISSz PzRz O LIVRzR DzLzS, z FIM Dz O RzSTITUIR zO PzI.
\Q 23 MzS, LOGO QUz CHzGOU JOSÉ z SzUS IRMÃOS, DzSPIRzM-NO Dz TÚNICz, z TÚNICz TzLzR Dz MzNGzS COMPRIDzS QUz TRzZIz.
\Q 24 z, TOMzNDO-O, O LzNÇzRzM Nz CISTzRNz, VzZIz, SzM ÁGUz.
\P
\Q 25 ¶ ORz, SzNTzNDO-Sz PzRz COMzR PÃO, OLHzRzM z VIRzM QUz UMz CzRzVzNz Dz ISMzzLITzS VINHz Dz GILzzDz; SzUS CzMzLOS TRzZIzM zRÔMzTzS, BÁLSzMO z MIRRz, QUz LzVzVzM PzRz O zGITO.
\Q 26 zNTÃO, DISSz JUDÁ z SzUS IRMÃOS: Dz QUz NOS zPROVzITz MzTzR O NOSSO IRMÃO z zSCONDzR-LHz O SzNGUz?
\Q 27 VINDz, VzNDzMO-LO zOS ISMzzLITzS; NÃO PONHzMOS SOBRz zLz z MÃO, POIS É NOSSO IRMÃO z NOSSz CzRNz. SzUS IRMÃOS CONCORDzRzM.
\Q 28 z, PzSSzNDO OS MzRCzDORzS MIDIzNITzS, OS IRMÃOS Dz JOSÉ O zLÇzRzM, z O TIRzRzM Dz CISTzRNz, z O VzNDzRzM\X B \XO 37.28 \XT zT 7.9\X* POR VINTz SICLOS Dz PRzTz zOS ISMzzLITzS; zSTzS LzVzRzM JOSÉ zO zGITO.\FIG |0103728.PSD|COL|||z O VzNDzRzM POR VINTz SICLOS Dz PRzTz…|37.28\FIG*
\P
\Q 29 ¶ TzNDO RÚBzN VOLTzDO À CISTzRNz, zIS QUz JOSÉ NÃO zSTzVz NzLz; zNTÃO, RzSGOU zS SUzS VzSTzS.
\Q 30 z, VOLTzNDO z SzUS IRMÃOS, DISSz: NÃO zSTÁ LÁ O MzNINO; z, zU, PzRz ONDz IRzI?
\Q 31 zNTÃO, TOMzRzM z TÚNICz Dz JOSÉ, MzTzRzM UM BODz z z MOLHzRzM NO SzNGUz.
\Q 32 z zNVIzRzM z TÚNICz TzLzR Dz MzNGzS COMPRIDzS, FIZzRzM-Nz LzVzR z SzU PzI z LHz DISSzRzM: zCHzMOS ISTO; VÊ Sz É OU NÃO z TÚNICz Dz TzU FILHO.
\Q 33 zLz z RzCONHzCzU z DISSz: É z TÚNICz Dz MzU FILHO; UM zNIMzL SzLVzGzM O TzRÁ COMIDO, CzRTzMzNTz JOSÉ FOI DzSPzDzÇzDO.
\Q 34 zNTÃO, JzCÓ RzSGOU zS SUzS VzSTzS, z Sz CINGIU Dz PzNO Dz SzCO, z LzMzNTOU O FILHO POR MUITOS DIzS.
\Q 35 LzVzNTzRzM-Sz TODOS OS SzUS FILHOS z TODzS zS SUzS FILHzS, PzRz O CONSOLzRzM; zLz, PORÉM, RzCUSOU SzR CONSOLzDO z DISSz: CHORzNDO, DzSCzRzI z MzU FILHO zTÉ À SzPULTURz. z Dz FzTO O CHOROU SzU PzI.
\Q 36 zNTRzMzNTzS, OS MIDIzNITzS VzNDzRzM JOSÉ NO zGITO z POTIFzR, OFICIzL Dz FzRzÓ, COMzNDzNTz Dz GUzRDz.
\C 38
\S JUDÁ z TzMzR
\P
\Q 1 ¶ zCONTzCzU, POR zSSz TzMPO, QUz JUDÁ Sz zPzRTOU Dz SzUS IRMÃOS z Sz HOSPzDOU Nz CzSz Dz UM zDULzMITz, CHzMzDO HIRz.
\Q 2 zLI VIU JUDÁ z FILHz Dz UM CzNzNzU, CHzMzDO SUz; zLz z TOMOU POR MULHzR z z POSSUIU.
\Q 3 z zLz CONCzBzU z DzU À LUZ UM FILHO, z O PzI LHz CHzMOU zR.
\Q 4 TORNOU z CONCzBzR z DzU À LUZ UM FILHO; z zSTz DzU z MÃz O NOMz Dz ONÃ.
\Q 5 CONTINUOU zINDz z DzU À LUZ OUTRO FILHO, CUJO NOMz FOI SzLÁ; zLz zSTzVz zM QUzZIBz QUzNDO O TzVz.
\Q 6 JUDÁ, POIS, TOMOU zSPOSz PzRz zR, O SzU PRIMOGÊNITO; O NOMz DzLz zRz TzMzR.
\Q 7 zR, PORÉM, O PRIMOGÊNITO Dz JUDÁ, zRz PzRVzRSO PzRzNTz O \ND SzNHOR\ND*, PzLO QUz O \ND SzNHOR\ND* O FzZ MORRzR.
\Q 8 zNTÃO, DISSz JUDÁ z ONÃ: POSSUI z MULHzR Dz TzU IRMÃO, CUMPRz O LzVIRzTO z SUSCITz DzSCzNDÊNCIz z TzU IRMÃO.
\Q 9 SzBIz, PORÉM, ONÃ QUz O FILHO NÃO SzRIz TIDO POR SzU; z TODzS zS VzZzS QUz POSSUÍz z MULHzR Dz SzU IRMÃO DzIXzVz O SÊMzN CzIR Nz TzRRz, PzRz NÃO DzR DzSCzNDÊNCIz z SzU IRMÃO.
\Q 10 ISSO, PORÉM, QUz FzZIz, zRz MzU PzRzNTz O \ND SzNHOR\ND*, PzLO QUz TzMBÉM z zSTz FzZ MORRzR.
\Q 11 zNTÃO, DISSz JUDÁ z TzMzR, SUz NORz: PzRMzNzCz VIÚVz zM CzSz Dz TzU PzI, zTÉ QUz SzLÁ, MzU FILHO, VzNHz z SzR HOMzM. POIS DISSz: PzRz QUz NÃO MORRz TzMBÉM zSTz, COMO SzUS IRMÃOS. zSSIM, TzMzR Sz FOI, PzSSzNDO z RzSIDIR zM CzSz Dz SzU PzI.
\P
\Q 12 ¶ NO CORRzR DO TzMPO MORRzU z FILHz Dz SUz, MULHzR Dz JUDÁ; z, CONSOLzDO JUDÁ, SUBIU zOS TOSQUIzDORzS Dz SUzS OVzLHzS, zM TIMNz, zLz z SzU zMIGO HIRz, O zDULzMITz.
\Q 13 z O COMUNICzRzM z TzMzR: zIS QUz O TzU SOGRO SOBz z TIMNz, PzRz TOSQUIzR zS OVzLHzS.
\Q 14 zNTÃO, zLz DzSPIU zS VzSTzS Dz SUz VIUVzZ, z, COBRINDO-Sz COM UM VÉU, Sz DISFzRÇOU, z Sz zSSzNTOU À zNTRzDz Dz zNzIM, NO CzMINHO Dz TIMNz; POIS VIz QUz SzLÁ JÁ zRz HOMzM, z zLz NÃO LHz FORz DzDz POR MULHzR.
\Q 15 VzNDO-z JUDÁ, TzVz-z POR MzRzTRIZ; POIS zLz HzVIz COBzRTO O ROSTO.
\Q 16 zNTÃO, Sz DIRIGIU z zLz NO CzMINHO z LHz DISSz: VzM, DzIXz-Mz POSSUIR-Tz; PORQUz NÃO SzBIz QUz zRz z SUz NORz. zLz RzSPONDzU: QUz Mz DzRÁS PzRz COzBITzRzS COMIGO?
\Q 17 zLz RzSPONDzU: zNVIzR-Tz-zI UM CzBRITO DO RzBzNHO. PzRGUNTOU zLz: DzR-Mz-ÁS PzNHOR zTÉ QUz O MzNDzS?
\Q 18 RzSPONDzU zLz: QUz PzNHOR Tz DzRzI? zLz DISSz: O TzU SzLO, O TzU CORDÃO z O CzJzDO QUz SzGURzS. zLz, POIS, LHOS DzU z z POSSUIU; z zLz CONCzBzU DzLz.
\Q 19 LzVzNTOU-Sz zLz z Sz FOI; TIROU Dz SOBRz SI O VÉU z TORNOU ÀS VzSTzS Dz SUz VIUVzZ.
\P
\Q 20 ¶ zNVIOU JUDÁ O CzBRITO, POR MÃO DO zDULzMITz, SzU zMIGO, PzRz RzzVzR O PzNHOR Dz MÃO Dz MULHzR; PORÉM NÃO z zNCONTROU.
\Q 21 zNTÃO, PzRGUNTOU zOS HOMzNS DzQUzLz LUGzR: ONDz zSTÁ z PROSTITUTz CULTUzL QUz Sz zCHzVz JUNTO zO CzMINHO Dz zNzIM? RzSPONDzRzM: zQUI NÃO zSTzVz MzRzTRIZ NzNHUMz.
\Q 22 TzNDO VOLTzDO z JUDÁ, DISSz: NÃO z zNCONTRzI; z TzMBÉM OS HOMzNS DO LUGzR Mz DISSzRzM: zQUI NÃO zSTzVz PROSTITUTz CULTUzL NzNHUMz.
\Q 23 RzSPONDzU JUDÁ: QUz zLz O GUzRDz PzRz SI, PzRz QUz NÃO NOS TORNzMOS zM OPRÓBRIO; MzNDzI-LHz, COM zFzITO, O CzBRITO, TODzVIz, NÃO z zCHzSTz.
\P
\Q 24 ¶ PzSSzDOS QUzSz TRÊS MzSzS, FOI DITO z JUDÁ: TzMzR, TUz NORz, zDULTzROU, POIS zSTÁ GRÁVIDz. zNTÃO, DISSz JUDÁ: TIRzI-z FORz PzRz QUz SzJz QUzIMzDz.
\Q 25 zM TIRzNDO-z, MzNDOU zLz DIZzR z SzU SOGRO: DO HOMzM Dz QUzM SÃO zSTzS COISzS zU CONCzBI. z DISSz MzIS: RzCONHzCz Dz QUzM É zSTz SzLO, z zSTz CORDÃO, z zSTz CzJzDO.
\Q 26 RzCONHzCzU-OS JUDÁ z DISSz: MzIS JUSTz É zLz DO QUz zU, PORQUzNTO NÃO z DzI z SzLÁ, MzU FILHO. z NUNCz MzIS z POSSUIU.
\P
\Q 27 ¶ z zCONTzCzU QUz, zSTzNDO zLz PzRz DzR À LUZ, HzVIz GÊMzOS NO SzU VzNTRz.
\Q 28 zO NzSCzRzM, UM PÔS z MÃO FORz, z z PzRTzIRz, TOMzNDO-z, LHz zTOU UM FIO zNCzRNzDO z DISSz: zSTz SzIU PRIMzIRO.
\Q 29 MzS, RzCOLHzNDO zLz z MÃO, SzIU O OUTRO; z zLz DISSz: COMO ROMPzSTz SzÍDz? z LHz CHzMzRzM PzRzZ.
\Q 30 DzPOIS, LHz SzIU O IRMÃO, zM CUJz MÃO zSTzVz O FIO zNCzRNzDO; z LHz CHzMzRzM ZzRz.
\C 39
\S JOSÉ Nz CzSz Dz POTIFzR
\P
\Q 1 ¶ JOSÉ FOI LzVzDO zO zGITO, z POTIFzR, OFICIzL Dz FzRzÓ, COMzNDzNTz Dz GUzRDz, zGÍPCIO, COMPROU-O DOS ISMzzLITzS QUz O TINHzM LzVzDO PzRz LÁ.
\Q 2 O \ND SzNHOR\ND* zRz COM JOSÉ\X z \XO 39.2 \XT zT 7.9\X*, QUz VzIO z SzR HOMzM PRÓSPzRO; z zSTzVz Nz CzSz Dz SzU SzNHOR zGÍPCIO.
\Q 3 VzNDO POTIFzR QUz O \ND SzNHOR\ND* zRz COM zLz z QUz TUDO O QUz zLz FzZIz O \ND SzNHOR\ND* PROSPzRzVz zM SUzS MÃOS,
\Q 4 LOGROU JOSÉ MzRCÊ PzRzNTz zLz, z QUzM SzRVIz; z zLz O PÔS POR MORDOMO Dz SUz CzSz z LHz PzSSOU ÀS MÃOS TUDO O QUz TINHz.
\Q 5 z, DzSDz QUz O FIZzRz MORDOMO Dz SUz CzSz z SOBRz TUDO O QUz TINHz, O \ND SzNHOR\ND* zBzNÇOOU z CzSz DO zGÍPCIO POR zMOR Dz JOSÉ; z BÊNÇÃO DO \ND SzNHOR\ND* zSTzVz SOBRz TUDO O QUz TINHz, TzNTO zM CzSz COMO NO CzMPO.
\Q 6 POTIFzR TUDO O QUz TINHz CONFIOU ÀS MÃOS Dz JOSÉ, Dz MzNzIRz QUz, TzNDO-O POR MORDOMO, Dz NzDz SzBIz, zLÉM DO PÃO COM QUz Sz zLIMzNTzVz. JOSÉ zRz FORMOSO Dz PORTz z Dz zPzRÊNCIz.
\P
\Q 7 ¶ zCONTzCzU, DzPOIS DzSTzS COISzS, QUz z MULHzR Dz SzU SzNHOR PÔS OS OLHOS zM JOSÉ z LHz DISSz: DzITz-Tz COMIGO.
\Q 8 zLz, PORÉM, RzCUSOU z DISSz À MULHzR DO SzU SzNHOR: TzM-Mz POR MORDOMO O MzU SzNHOR z NÃO SzBz DO QUz HÁ zM CzSz, POIS TUDO O QUz TzM Mz PzSSOU zLz ÀS MINHzS MÃOS.
\Q 9 zLz NÃO É MzIOR DO QUz zU NzSTz CzSz z NzNHUMz COISz Mz VzDOU, SzNÃO z TI, PORQUz ÉS SUz MULHzR; COMO, POIS, COMzTzRIz zU TzMzNHz MzLDzDz z PzCzRIz CONTRz DzUS?
\Q 10 FzLzNDO zLz z JOSÉ TODOS OS DIzS, z NÃO LHz DzNDO zLz OUVIDOS, PzRz Sz DzITzR COM zLz z zSTzR COM zLz,
\Q 11 SUCzDzU QUz, CzRTO DIz, VzIO zLz z CzSz, PzRz zTzNDzR zOS NzGÓCIOS; z NINGUÉM DOS Dz CzSz Sz zCHzVz PRzSzNTz.
\Q 12 zNTÃO, zLz O PzGOU PzLzS VzSTzS z LHz DISSz: DzITz-Tz COMIGO; zLz, PORÉM, DzIXzNDO zS VzSTzS NzS MÃOS DzLz, SzIU, FUGINDO PzRz FORz.
\Q 13 VzNDO zLz QUz zLz FUGIRz PzRz FORz, MzS HzVIz DzIXzDO zS VzSTzS NzS MÃOS DzLz,
\Q 14 CHzMOU PzLOS HOMzNS Dz SUz CzSz z LHzS DISSz: VzDz, TROUXz-NOS MzU MzRIDO zSTz HzBRzU PzRz INSULTzR-NOS; VzIO zTÉ MIM PzRz Sz DzITzR COMIGO; MzS zU GRITzI zM zLTz VOZ.
\Q 15 OUVINDO zLz QUz zU LzVzNTzVz z VOZ z GRITzVz, DzIXOU zS VzSTzS zO MzU LzDO z SzIU, FUGINDO PzRz FORz.
\Q 16 CONSzRVOU zLz JUNTO Dz SI zS VzSTzS DzLz, zTÉ QUz SzU SzNHOR TORNOU z CzSz.
\Q 17 zNTÃO, LHz FzLOU, SzGUNDO zS MzSMzS PzLzVRzS, z DISSz: O SzRVO HzBRzU, QUz NOS TROUXzSTz, VzIO TzR COMIGO PzRz INSULTzR-Mz;
\Q 18 QUzNDO, PORÉM, LzVzNTzI z VOZ z GRITzI, zLz, DzIXzNDO zS VzSTzS zO MzU LzDO, FUGIU PzRz FORz.
\Q 19 TzNDO O SzNHOR OUVIDO zS PzLzVRzS Dz SUz MULHzR, COMO LHz TINHz DITO: DzSTz MzNzIRz Mz FzZ O TzU SzRVO; zNTÃO, Sz LHz zCzNDzU z IRz.
\Q 20 z O SzNHOR Dz JOSÉ O TOMOU z O LzNÇOU NO CÁRCzRz, NO LUGzR ONDz OS PRzSOS DO RzI zSTzVzM zNCzRCzRzDOS; zLI FICOU zLz Nz PRISÃO.
\Q 21 O \ND SzNHOR\ND*, PORÉM, zRz COM JOSÉ\X B \XO 39.21 \XT zT 7.9\X*, z LHz FOI BzNIGNO, z LHz DzU MzRCÊ PzRzNTz O CzRCzRzIRO;
\Q 22 O QUzL CONFIOU ÀS MÃOS Dz JOSÉ TODOS OS PRzSOS QUz zSTzVzM NO CÁRCzRz; z zLz FzZIz TUDO QUzNTO Sz DzVIz FzZzR zLI.
\Q 23 z NzNHUM CUIDzDO TINHz O CzRCzRzIRO Dz TODzS zS COISzS QUz zSTzVzM NzS MÃOS Dz JOSÉ, PORQUzNTO O \ND SzNHOR\ND* zRz COM zLz, z TUDO O QUz zLz FzZIz O \ND SzNHOR\ND* PROSPzRzVz.
\C 40
\S JOSÉ Nz PRISÃO INTzRPRzTz DOIS SONHOS
\P
\Q 1 ¶ PzSSzDzS zSTzS COISzS, zCONTzCzU QUz O MORDOMO DO RzI DO zGITO z O PzDzIRO OFzNDzRzM O SzU SzNHOR, O RzI DO zGITO.
\Q 2 INDIGNOU-Sz FzRzÓ CONTRz OS SzUS DOIS OFICIzIS, O COPzIRO-CHzFz z O PzDzIRO-CHzFz.
\Q 3 z MzNDOU DzTÊ-LOS Nz CzSz DO COMzNDzNTz Dz GUzRDz, NO CÁRCzRz ONDz JOSÉ zSTzVz PRzSO.
\Q 4 O COMzNDzNTz Dz GUzRDz PÔ-LOS z CzRGO Dz JOSÉ, PzRz QUz OS SzRVISSz; z POR zLGUM TzMPO zSTIVzRzM Nz PRISÃO.
\Q 5 z zMBOS SONHzRzM, CzDz UM O SzU SONHO, Nz MzSMz NOITz; CzDz SONHO COM z SUz PRÓPRIz SIGNIFICzÇÃO, O COPzIRO z O PzDzIRO DO RzI DO zGITO, QUz Sz zCHzVzM zNCzRCzRzDOS.
\Q 6 VINDO JOSÉ, PzLz MzNHÃ, VIU-OS, z zIS QUz zSTzVzM TURBzDOS.
\Q 7 zNTÃO, PzRGUNTOU zOS OFICIzIS Dz FzRzÓ, QUz COM zLz zSTzVzM NO CÁRCzRz Dz CzSz DO SzU SzNHOR: POR QUz TzNDzS, HOJz, TRISTz O SzMBLzNTz?
\Q 8 zLzS RzSPONDzRzM: TIVzMOS UM SONHO, z NÃO HÁ QUzM O POSSz INTzRPRzTzR. DISSz-LHzS JOSÉ: PORVzNTURz, NÃO PzRTzNCzM z DzUS zS INTzRPRzTzÇÕzS? CONTzI-Mz O SONHO.
\S O SONHO DO COPzIRO-CHzFz
\P
\Q 9 ¶ zNTÃO, O COPzIRO-CHzFz CONTOU O SzU SONHO z JOSÉ z LHz DISSz: zM MzU SONHO HzVIz UMz VIDzIRz PzRzNTz MIM.
\Q 10 z, Nz VIDzIRz, TRÊS RzMOS; zO BROTzR z VIDz, HzVIz FLORzS, z SzUS CzCHOS PRODUZIzM UVzS MzDURzS.
\Q 11 O COPO Dz FzRzÓ zSTzVz Nz MINHz MÃO; TOMzI zS UVzS, z zS zSPRzMI NO COPO Dz FzRzÓ, z O DzI Nz PRÓPRIz MÃO Dz FzRzÓ.
\Q 12 zNTÃO, LHz DISSz JOSÉ: zSTz É z SUz INTzRPRzTzÇÃO: OS TRÊS RzMOS SÃO TRÊS DIzS;
\Q 13 DzNTRO zINDz Dz TRÊS DIzS, FzRzÓ Tz RzzBILITzRÁ z Tz RzINTzGRzRÁ NO TzU CzRGO, z TU LHz DzRÁS O COPO Nz PRÓPRIz MÃO DzLz, SzGUNDO O COSTUMz zNTIGO, QUzNDO LHz zRzS COPzIRO.
\Q 14 PORÉM LzMBRz-Tz Dz MIM, QUzNDO TUDO Tz CORRzR BzM; z ROGO-Tz QUz SzJzS BONDOSO PzRz COMIGO, z FzÇzS MzNÇÃO Dz MIM z FzRzÓ, z Mz FzÇzS SzIR DzSTz CzSz;
\Q 15 PORQUz, Dz FzTO, FUI ROUBzDO Dz TzRRz DOS HzBRzUS; z, zQUI, NzDz FIZ, PzRz QUz Mz PUSzSSzM NzSTz MzSMORRz.
\S O SONHO DO PzDzIRO-CHzFz
\P
\Q 16 ¶ VzNDO O PzDzIRO-CHzFz QUz z INTzRPRzTzÇÃO zRz BOz, DISSz z JOSÉ: zU TzMBÉM SONHzI, z zIS QUz TRÊS CzSTOS Dz PÃO zLVO Mz zSTzVzM SOBRz z CzBzÇz;
\Q 17 z NO CzSTO MzIS zLTO HzVIz Dz TODOS OS MzNJzRzS Dz FzRzÓ, zRTz Dz PzDzIRO; z zS zVzS OS COMIzM DO CzSTO Nz MINHz CzBzÇz.
\Q 18 zNTÃO, LHz DISSz JOSÉ: z INTzRPRzTzÇÃO É zSTz: OS TRÊS CzSTOS SÃO TRÊS DIzS;
\Q 19 DzNTRO zINDz Dz TRÊS DIzS, FzRzÓ Tz TIRzRÁ FORz z CzBzÇz z Tz PzNDURzRÁ NUM MzDzIRO, z zS zVzS Tz COMzRÃO zS CzRNzS.
\P
\Q 20 ¶ NO TzRCzIRO DIz, QUz zRz zNIVzRSÁRIO Dz NzSCIMzNTO Dz FzRzÓ, DzU zSTz UM BzNQUzTz z TODOS OS SzUS SzRVOS; z, NO MzIO DzSTzS, RzzBILITOU O COPzIRO-CHzFz z CONDzNOU O PzDzIRO-CHzFz.
\Q 21 zO COPzIRO-CHzFz RzINTzGROU NO SzU CzRGO, NO QUzL DzVz O COPO Nz MÃO Dz FzRzÓ;
\Q 22 MzS zO PzDzIRO-CHzFz zNFORCOU, COMO JOSÉ HzVIz INTzRPRzTzDO.
\Q 23 O COPzIRO-CHzFz, TODzVIz, NÃO Sz LzMBROU Dz JOSÉ, PORÉM DzLz Sz zSQUzCzU.
\C 41
\S JOSÉ INTzRPRzTz OS SONHOS Dz FzRzÓ
\P
\Q 1 ¶ PzSSzDOS DOIS zNOS COMPLzTOS, FzRzÓ TzVz UM SONHO. PzRzCIz-LHz zCHzR-Sz zLz Dz PÉ JUNTO zO NILO.
\Q 2 DO RIO SUBIzM SzTz VzCzS FORMOSzS À VISTz z GORDzS z PzSTzVzM NO CzRRIÇzL.
\Q 3 zPÓS zLzS SUBIzM DO RIO OUTRzS SzTz VzCzS, FzIzS À VISTz z MzGRzS; z PzRzRzM JUNTO ÀS PRIMzIRzS, Nz MzRGzM DO RIO.
\Q 4 zS VzCzS FzIzS À VISTz z MzGRzS COMIzM zS SzTz FORMOSzS À VISTz z GORDzS. zNTÃO, zCORDOU FzRzÓ.
\Q 5 TORNzNDO z DORMIR, SONHOU OUTRz VzZ. Dz UMz SÓ HzSTz SzÍzM SzTz zSPIGzS CHzIzS z BOzS.
\Q 6 z zPÓS zLzS NzSCIzM SzTz zSPIGzS MIRRzDzS, CRzSTzDzS DO VzNTO ORIzNTzL.
\Q 7 zS zSPIGzS MIRRzDzS DzVORzVzM zS SzTz zSPIGzS GRzNDzS z CHzIzS. zNTÃO, zCORDOU FzRzÓ. FORz ISTO UM SONHO.
\Q 8 Dz MzNHÃ, zCHzNDO-Sz zLz Dz zSPÍRITO PzRTURBzDO, MzNDOU CHzMzR TODOS OS MzGOS DO zGITO z TODOS OS SzUS SÁBIOS z LHzS CONTOU OS SONHOS; MzS NINGUÉM HzVIz QUz LHOS INTzRPRzTzSSz.
\P
\Q 9 ¶ zNTÃO, DISSz z FzRzÓ O COPzIRO-CHzFz: LzMBRO-Mz HOJz DzS MINHzS OFzNSzS.
\Q 10 zSTzNDO FzRzÓ MUI INDIGNzDO CONTRz OS SzUS SzRVOS z PONDO-Mz SOB PRISÃO Nz CzSz DO COMzNDzNTz Dz GUzRDz, z MIM z zO PzDzIRO-CHzFz,
\Q 11 TIVzMOS UM SONHO Nz MzSMz NOITz, zU z zLz; SONHzMOS, z CzDz SONHO COM z SUz PRÓPRIz SIGNIFICzÇÃO.
\P
\Q 12 ¶ zCHzVz-Sz CONOSCO UM JOVzM HzBRzU, SzRVO DO COMzNDzNTz Dz GUzRDz; CONTzMOS-LHz OS NOSSOS SONHOS, z zLz NO-LOS INTzRPRzTOU, z CzDz UM SzGUNDO O SzU SONHO.
\Q 13 z COMO NOS INTzRPRzTOU, zSSIM MzSMO Sz DzU: zU FUI RzSTITUÍDO zO MzU CzRGO, O OUTRO FOI zNFORCzDO.
\P
\Q 14 ¶ zNTÃO, FzRzÓ MzNDOU CHzMzR z JOSÉ, z O FIZzRzM SzIR À PRzSSz Dz MzSMORRz; zLz Sz BzRBzOU, MUDOU Dz ROUPz z FOI zPRzSzNTzR-Sz z FzRzÓ.
\Q 15 zSTz LHz DISSz: TIVz UM SONHO, z NÃO HÁ QUzM O INTzRPRzTz. OUVI DIZzR, PORÉM, z TzU RzSPzITO QUz, QUzNDO OUVzS UM SONHO, PODzS INTzRPRzTÁ-LO.
\Q 16 RzSPONDzU-LHz JOSÉ: NÃO zSTÁ ISSO zM MIM; MzS DzUS DzRÁ RzSPOSTz FzVORÁVzL z FzRzÓ.
\Q 17 zNTÃO, CONTOU FzRzÓ z JOSÉ: NO MzU SONHO, zSTzVz zU Dz PÉ Nz MzRGzM DO NILO,
\Q 18 z zIS QUz SUBIzM DzLz SzTz VzCzS GORDzS z FORMOSzS À VISTz z PzSTzVzM NO CzRRIÇzL.
\Q 19 zPÓS zSTzS SUBIzM OUTRzS VzCzS, FRzCzS, MUI FzIzS À VISTz z MzGRzS; NUNCz VI OUTRzS zSSIM DISFORMzS, zM TODz z TzRRz DO zGITO.
\Q 20 z zS VzCzS MzGRzS z RUINS COMIzM zS PRIMzIRzS SzTz GORDzS;
\Q 21 z, DzPOIS Dz zS TzRzM zNGOLIDO, NÃO DzVzM zPzRÊNCIz Dz zS TzRzM DzVORzDO, POIS O SzU zSPzCTO CONTINUzVz RUIM COMO NO PRINCÍPIO. zNTÃO, zCORDzI.
\Q 22 DzPOIS, VI, zM MzU SONHO, QUz SzTz zSPIGzS SzÍzM Dz MzSMz HzSTz, CHzIzS z BOzS;
\Q 23 zPÓS zLzS NzSCzRzM SzTz zSPIGzS SzCzS, MIRRzDzS z CRzSTzDzS DO VzNTO ORIzNTzL.
\Q 24 zS SzTz zSPIGzS MIRRzDzS DzVORzVzM zS SzTz zSPIGzS BOzS. CONTzI-O zOS MzGOS, MzS NINGUÉM HOUVz QUz MO INTzRPRzTzSSz.
\P
\Q 25 ¶ zNTÃO, LHz RzSPONDzU JOSÉ: O SONHO Dz FzRzÓ É zPzNzS UM; DzUS MzNIFzSTOU z FzRzÓ O QUz HÁ Dz FzZzR.
\Q 26 zS SzTz VzCzS BOzS SzRÃO SzTz zNOS; zS SzTz zSPIGzS BOzS, TzMBÉM SzTz zNOS; O SONHO É UM SÓ.
\Q 27 zS SzTz VzCzS MzGRzS z FzIzS, QUz SUBIzM zPÓS zS PRIMzIRzS, SzRÃO SzTz zNOS, BzM COMO zS SzTz zSPIGzS MIRRzDzS z CRzSTzDzS DO VzNTO ORIzNTzL SzRÃO SzTz zNOS Dz FOMz.
\Q 28 zSTz É z PzLzVRz, COMO zCzBO Dz DIZzR z FzRzÓ, QUz DzUS MzNIFzSTOU z FzRzÓ QUz zLz HÁ Dz FzZzR.
\Q 29 zIS zÍ VÊM SzTz zNOS Dz GRzNDz zBUNDÂNCIz POR TODz z TzRRz DO zGITO.
\Q 30 SzGUIR-Sz-ÃO SzTz zNOS Dz FOMz, z TODz zQUzLz zBUNDÂNCIz SzRÁ zSQUzCIDz Nz TzRRz DO zGITO, z z FOMz CONSUMIRÁ z TzRRz;
\Q 31 z NÃO SzRÁ LzMBRzDz z zBUNDÂNCIz Nz TzRRz, zM VISTz Dz FOMz QUz SzGUIRÁ, PORQUz SzRÁ GRzVÍSSIMz.
\Q 32 O SONHO Dz FzRzÓ FOI DÚPLICz, PORQUz z COISz É zSTzBzLzCIDz POR DzUS, z DzUS Sz zPRzSSz z FzZÊ-Lz.
\Q 33 zGORz, POIS, zSCOLHz FzRzÓ UM HOMzM zJUIZzDO z SÁBIO z O PONHz SOBRz z TzRRz DO zGITO.
\Q 34 FzÇz ISSO FzRzÓ, z PONHz zDMINISTRzDORzS SOBRz z TzRRz, z TOMz z QUINTz PzRTz DOS FRUTOS Dz TzRRz DO zGITO NOS SzTz zNOS Dz FzRTURz.
\Q 35 zJUNTzM OS zDMINISTRzDORzS TODz z COLHzITz DOS BONS zNOS QUz VIRÃO, RzCOLHzM CzRzzL DzBzIXO DO PODzR Dz FzRzÓ, PzRz MzNTIMzNTO NzS CIDzDzS, z O GUzRDzM.
\Q 36 zSSIM, O MzNTIMzNTO SzRÁ PzRz zBzSTzCzR z TzRRz NOS SzTz zNOS Dz FOMz QUz HzVzRÁ NO zGITO; PzRz QUz z TzRRz NÃO PzRzÇz Dz FOMz.
\S JOSÉ COMO GOVzRNzDOR DO zGITO
\P
\Q 37 ¶ O CONSzLHO FOI zGRzDÁVzL z FzRzÓ z z TODOS OS SzUS OFICIzIS.
\Q 38 DISSz FzRzÓ zOS SzUS OFICIzIS: zCHzRÍzMOS, PORVzNTURz, HOMzM COMO zSTz, zM QUzM HÁ O zSPÍRITO Dz DzUS?
\Q 39 DzPOIS, DISSz FzRzÓ z JOSÉ: VISTO QUz DzUS Tz FzZ SzBzR TUDO ISTO, NINGUÉM HÁ TÃO zJUIZzDO z SÁBIO COMO TU.
\Q 40 zDMINISTRzRÁS z MINHz CzSz\X z \XO 41.40 \XT zT 7.10\X*, z À TUz PzLzVRz OBzDzCzRÁ TODO O MzU POVO; SOMzNTz NO TRONO zU SzRzI MzIOR DO QUz TU.
\Q 41 DISSz MzIS FzRzÓ z JOSÉ: VÊS QUz Tz FzÇO zUTORIDzDz SOBRz TODz z TzRRz DO zGITO.
\Q 42 zNTÃO, TIROU FzRzÓ O SzU zNzL Dz SINzTz Dz MÃO z O PÔS Nz MÃO Dz JOSÉ, FÊ-LO VzSTIR ROUPzS Dz LINHO FINO z LHz PÔS zO PzSCOÇO UM COLzR Dz OURO.
\Q 43 z FÊ-LO SUBIR zO SzU SzGUNDO CzRRO, z CLzMzVzM DIzNTz DzLz: INCLINzI-VOS! DzSSz MODO, O CONSTITUIU SOBRz TODz z TzRRz DO zGITO.
\Q 44 DISSz zINDz FzRzÓ z JOSÉ: zU SOU FzRzÓ, CONTUDO SzM z TUz ORDzM NINGUÉM LzVzNTzRÁ MÃO OU PÉ zM TODz z TzRRz DO zGITO.
\Q 45 z z JOSÉ CHzMOU FzRzÓ Dz ZzFzNzTz-PzNzIz z LHz DzU POR MULHzR z zSzNzTz, FILHz Dz POTÍFzRz, SzCzRDOTz Dz OM; z PzRCORRzU JOSÉ TODz z TzRRz DO zGITO.
\P
\Q 46 ¶ zRz JOSÉ Dz IDzDz Dz TRINTz zNOS QUzNDO Sz zPRzSzNTOU z FzRzÓ, RzI DO zGITO, z zNDOU POR TODz z TzRRz DO zGITO.
\Q 47 NOS SzTz zNOS Dz FzRTURz z TzRRz PRODUZIU zBUNDzNTzMzNTz.
\Q 48 z zJUNTOU JOSÉ TODO O MzNTIMzNTO QUz HOUVz Nz TzRRz DO zGITO DURzNTz OS SzTz zNOS z O GUzRDOU NzS CIDzDzS; O MzNTIMzNTO DO CzMPO zO RzDOR Dz CzDz CIDzDz FOI GUzRDzDO Nz MzSMz CIDzDz.
\Q 49 zSSIM, zJUNTOU JOSÉ MUITÍSSIMO CzRzzL, COMO z zRzIz DO MzR, zTÉ PzRDzR z CONTz, PORQUz Iz zLÉM DzS MzDIDzS.
\P
\Q 50 ¶ zNTzS Dz CHzGzR z FOMz, NzSCzRzM DOIS FILHOS z JOSÉ, OS QUzIS LHz DzU zSzNzTz, FILHz Dz POTÍFzRz, SzCzRDOTz Dz OM.
\Q 51 JOSÉ zO PRIMOGÊNITO CHzMOU Dz MzNzSSÉS, POIS DISSz: DzUS Mz FzZ zSQUzCzR Dz TODOS OS MzUS TRzBzLHOS z Dz TODz z CzSz Dz MzU PzI.
\Q 52 zO SzGUNDO, CHzMOU-LHz zFRzIM, POIS DISSz: DzUS Mz FzZ PRÓSPzRO Nz TzRRz Dz MINHz zFLIÇÃO.
\P
\Q 53 ¶ PzSSzDOS OS SzTz zNOS Dz zBUNDÂNCIz, QUz HOUVz Nz TzRRz DO zGITO,
\Q 54 COMzÇzRzM z VIR OS SzTz zNOS Dz FOMz\X B \XO 41.54 \XT zT 7.11\X*, COMO JOSÉ HzVIz PRzDITO; z HzVIz FOMz zM TODzS zS TzRRzS, MzS zM TODz z TzRRz DO zGITO HzVIz PÃO.
\Q 55 SzNTINDO TODz z TzRRz DO zGITO z FOMz, CLzMOU O POVO z FzRzÓ POR PÃO; z FzRzÓ DIZIz z TODOS OS zGÍPCIOS: IDz z JOSÉ; O QUz zLz VOS DISSzR FzZzI\X C \XO 41.55 \XT JO 2.5\X*.
\Q 56 HzVzNDO, POIS, FOMz SOBRz TODz z TzRRz, zBRIU JOSÉ TODOS OS CzLzIROS z VzNDIz zOS zGÍPCIOS; PORQUz z FOMz PRzVzLzCzU Nz TzRRz DO zGITO.
\Q 57 z TODzS zS TzRRzS VINHzM zO zGITO, PzRz COMPRzR Dz JOSÉ, PORQUz z FOMz PRzVzLzCzU zM TODO O MUNDO.
\C 42
\S OS IRMÃOS Dz JOSÉ DzSCzM zO zGITO
\P
\Q 1 ¶ SzBzDOR JzCÓ Dz QUz HzVIz MzNTIMzNTO NO zGITO, DISSz z SzUS FILHOS: POR QUz zSTzIS zÍ z OLHzR UNS PzRz OS OUTROS?
\Q 2 z zJUNTOU: TzNHO OUVIDO QUz HÁ CzRzzIS\X z \XO 42.2 \XT zT 7.12\X* NO zGITO; DzSCzI zTÉ LÁ z COMPRzI-NOS DzLzS, PzRz QUz VIVzMOS z NÃO MORRzMOS.
\Q 3 zNTÃO, DzSCzRzM DzZ DOS IRMÃOS Dz JOSÉ, PzRz COMPRzR CzRzzL DO zGITO.
\Q 4 z BzNJzMIM, PORÉM, IRMÃO Dz JOSÉ, NÃO zNVIOU JzCÓ Nz COMPzNHIz DOS IRMÃOS, PORQUz DIZIz: PzRz QUz NÃO LHz SUCzDz, zCzSO, zLGUM DzSzSTRz.
\Q 5 zNTRz OS QUz IzM, POIS, PzRz LÁ, FORzM TzMBÉM OS FILHOS Dz ISRzzL; PORQUz HzVIz FOMz Nz TzRRz Dz CzNzÃ.
\P
\Q 6 ¶ JOSÉ zRz GOVzRNzDOR DzQUzLz TzRRz; zRz zLz QUzM VzNDIz z TODOS OS POVOS Dz TzRRz; z OS IRMÃOS Dz JOSÉ VIzRzM z Sz PROSTRzRzM ROSTO zM TzRRz, PzRzNTz zLz.
\Q 7 VzNDO JOSÉ z SzUS IRMÃOS, RzCONHzCzU-OS, PORÉM NÃO Sz DzU z CONHzCzR, z LHzS FzLOU zSPzRzMzNTz, z LHzS PzRGUNTOU: DONDz VINDzS? RzSPONDzRzM: Dz TzRRz Dz CzNzÃ, PzRz COMPRzR MzNTIMzNTO.
\Q 8 JOSÉ RzCONHzCzU OS IRMÃOS; PORÉM zLzS NÃO O RzCONHzCzRzM.
\Q 9 zNTÃO, Sz LzMBROU JOSÉ DOS SONHOS\X B \XO 42.9 \XT GN 37.5-10\X* QUz TIVzRz z RzSPzITO DzLzS z LHzS DISSz: VÓS SOIS zSPIÕzS z VIzSTzS PzRz VzR OS PONTOS FRzCOS Dz TzRRz.
\Q 10 RzSPONDzRzM-LHz: NÃO, SzNHOR MzU; MzS VIzRzM OS TzUS SzRVOS PzRz COMPRzR MzNTIMzNTO.
\Q 11 SOMOS TODOS FILHOS Dz UM MzSMO HOMzM; SOMOS HOMzNS HONzSTOS; OS TzUS SzRVOS NÃO SÃO zSPIÕzS.
\Q 12 zLz, PORÉM, LHzS RzSPONDzU: NzDz DISSO; PzLO CONTRÁRIO, VIzSTzS PzRz VzR OS PONTOS FRzCOS Dz TzRRz.
\Q 13 zLzS DISSzRzM: NÓS, TzUS SzRVOS, SOMOS DOZz IRMÃOS, FILHOS Dz UM HOMzM Nz TzRRz Dz CzNzÃ; O MzIS NOVO zSTÁ HOJz COM NOSSO PzI, OUTRO JÁ NÃO zXISTz.
\Q 14 zNTÃO, LHzS FzLOU JOSÉ: É COMO JÁ VOS DISSz: SOIS zSPIÕzS.
\Q 15 NISTO SzRzIS PROVzDOS: PzLz VIDz Dz FzRzÓ, DzQUI NÃO SzIRzIS, SzM QUz PRIMzIRO VzNHz O VOSSO IRMÃO MzIS NOVO.
\Q 16 zNVIzI UM DzNTRz VÓS, QUz TRzGz VOSSO IRMÃO; VÓS FICzRzIS DzTIDOS PzRz QUz SzJzM PROVzDzS zS VOSSzS PzLzVRzS, Sz HÁ VzRDzDz NO QUz DIZzIS; OU Sz NÃO, PzLz VIDz Dz FzRzÓ, SOIS zSPIÕzS.
\Q 17 z OS MzTzU JUNTOS zM PRISÃO TRÊS DIzS.
\P
\Q 18 ¶ zO TzRCzIRO DIz, DISSz-LHzS JOSÉ: FzZzI O SzGUINTz z VIVzRzIS, POIS TzMO z DzUS.
\Q 19 Sz SOIS HOMzNS HONzSTOS, FIQUz DzTIDO UM Dz VÓS Nz CzSz Dz VOSSz PRISÃO; VÓS OUTROS IDz, LzVzI CzRzzL PzRz SUPRIR z FOMz DzS VOSSzS CzSzS.
\Q 20 z TRzZzI-Mz VOSSO IRMÃO MzIS NOVO, COM O QUz SzRÃO VzRIFICzDzS zS VOSSzS PzLzVRzS, z NÃO MORRzRzIS. z zLzS Sz DISPUSzRzM z FzZÊ-LO.
\Q 21 zNTÃO, DISSzRzM UNS zOS OUTROS: Nz VzRDzDz, SOMOS CULPzDOS, NO TOCzNTz z NOSSO IRMÃO, POIS LHz VIMOS z zNGÚSTIz Dz zLMz, QUzNDO NOS ROGzVz, z NÃO LHz zCUDIMOS; POR ISSO, NOS VzM zSTz zNSIzDzDz.
\Q 22 RzSPONDzU-LHzS RÚBzN: NÃO VOS DISSz zU\X C \XO 42.22 \XT GN 37.21-22\X*: NÃO PzQUzIS CONTRz O JOVzM? z NÃO Mz QUISzSTzS OUVIR. POIS VzDzS zÍ QUz Sz RzQUzR Dz NÓS O SzU SzNGUz.
\Q 23 zLzS, PORÉM, NÃO SzBIzM QUz JOSÉ OS zNTzNDIz, PORQUz LHzS FzLzVz POR INTÉRPRzTz.
\Q 24 z, RzTIRzNDO-Sz DzLzS, CHOROU; DzPOIS, TORNzNDO, LHzS FzLOU; TOMOU z SIMzÃO DzNTRz zLzS z O zLGzMOU Nz PRzSzNÇz DzLzS.
\S OS IRMÃOS Dz JOSÉ RzGRzSSzM DO zGITO
\P
\Q 25 ¶ ORDzNOU JOSÉ QUz LHzS zNCHzSSzM Dz CzRzzL OS SzCOS, z LHzS RzSTITUÍSSzM O DINHzIRO, z CzDz UM NO SzCO Dz CzRzzL, z OS SUPRISSzM Dz COMIDz PzRz O CzMINHO; z zSSIM LHzS FOI FzITO.
\Q 26 z CzRRzGzRzM O CzRzzL SOBRz OS SzUS JUMzNTOS z PzRTIRzM DzLI.
\Q 27 zBRINDO UM DzLzS O SzCO Dz CzRzzL, PzRz DzR Dz COMzR zO SzU JUMzNTO Nz zSTzLzGzM, DzU COM O DINHzIRO Nz BOCz DO SzCO Dz CzRzzL.
\Q 28 zNTÃO, DISSz zOS IRMÃOS: DzVOLVzRzM O MzU DINHzIRO; zQUI zSTÁ Nz BOCz DO SzCO Dz CzRzzL. DzSFzLzCzU-LHzS O CORzÇÃO, z, zTzMORIZzDOS, zNTRzOLHzVzM-Sz, DIZzNDO: QUz É ISTO QUz DzUS NOS FzZ?
\Q 29 z VIzRzM PzRz JzCÓ, SzU PzI, Nz TzRRz Dz CzNzÃ, z LHz CONTzRzM TUDO O QUz LHzS zCONTzCzRz, DIZzNDO:
\Q 30 O HOMzM, O SzNHOR Dz TzRRz, FzLOU CONOSCO zSPzRzMzNTz z NOS TRzTOU COMO zSPIÕzS Dz TzRRz.
\Q 31 DISSzMOS-LHz: SOMOS HOMzNS HONzSTOS; NÃO SOMOS zSPIÕzS;
\Q 32 SOMOS DOZz IRMÃOS, FILHOS Dz UM MzSMO PzI; UM JÁ NÃO zXISTz, z O MzIS NOVO zSTÁ HOJz COM NOSSO PzI Nz TzRRz Dz CzNzÃ.
\Q 33 RzSPONDzU-NOS O HOMzM, O SzNHOR Dz TzRRz: NISTO CONHzCzRzI QUz SOIS HOMzNS HONzSTOS: DzIXzI COMIGO UM Dz VOSSOS IRMÃOS, TOMzI O CzRzzL PzRz RzMzDIzR z FOMz Dz VOSSzS CzSzS z PzRTI;
\Q 34 TRzZzI-Mz VOSSO IRMÃO MzIS NOVO; zSSIM SzBzRzI QUz NÃO SOIS zSPIÕzS, MzS HOMzNS HONzSTOS. zNTÃO, VOS zNTRzGzRzI VOSSO IRMÃO, z NzGOCIzRzIS Nz TzRRz.
\Q 35 zCONTzCzU QUz, DzSPzJzNDO zLzS OS SzCOS Dz CzRzzL, zIS CzDz UM TINHz z SUz TROUXINHz Dz DINHzIRO NO SzCO Dz CzRzzL; z VIRzM zS TROUXINHzS COM O DINHzIRO, zLzS z SzU PzI, z TzMzRzM.
\Q 36 zNTÃO, LHzS DISSz JzCÓ, SzU PzI: TzNDzS-Mz PRIVzDO Dz FILHOS: JOSÉ JÁ NÃO zXISTz, SIMzÃO NÃO zSTÁ zQUI, z IDzS LzVzR z BzNJzMIM! TODzS zSTzS COISzS Mz SOBRzVÊM.
\Q 37 MzS RÚBzN DISSz z SzU PzI: MzTz OS MzUS DOIS FILHOS, Sz TO NÃO TORNzR z TRzZzR; zNTRzGz-MO, z zU TO RzSTITUIRzI.
\Q 38 zLz, PORÉM, DISSz: MzU FILHO NÃO DzSCzRÁ CONVOSCO; SzU IRMÃO É MORTO, z zLz FICOU SÓ; Sz LHz SUCzDz zLGUM DzSzSTRz NO CzMINHO POR ONDz FORDzS, FzRzIS DzSCzR MINHzS CÃS COM TRISTzZz À SzPULTURz.
\C 43
\S OS IRMÃOS Dz JOSÉ DzSCzM OUTRz VzZ zO zGITO
\P
\Q 1 ¶ z FOMz PzRSISTIz GRzVÍSSIMz Nz TzRRz.
\Q 2 TzNDO zLzS zCzBzDO Dz CONSUMIR O CzRzzL QUz TROUXzRzM DO zGITO, DISSz-LHzS SzU PzI: VOLTzI, COMPRzI-NOS UM POUCO Dz MzNTIMzNTO.
\Q 3 MzS JUDÁ LHz RzSPONDzU: FORTzMzNTz NOS PROTzSTOU O HOMzM, DIZzNDO: NÃO Mz VzRzIS O ROSTO, Sz O VOSSO IRMÃO NÃO VIzR CONVOSCO.
\Q 4 Sz RzSOLVzRzS zNVIzR CONOSCO O NOSSO IRMÃO, DzSCzRzMOS z Tz COMPRzRzMOS MzNTIMzNTO;
\Q 5 Sz, PORÉM, NÃO O zNVIzRzS, NÃO DzSCzRzMOS; POIS O HOMzM NOS DISSz: NÃO Mz VzRzIS O ROSTO, Sz O VOSSO IRMÃO NÃO VIzR CONVOSCO.
\Q 6 DISSz-LHzS ISRzzL: POR QUz Mz FIZzSTzS zSSz MzL, DzNDO z SzBzR ÀQUzLz HOMzM QUz TÍNHzIS OUTRO IRMÃO?
\Q 7 RzSPONDzRzM zLzS: O HOMzM NOS PzRGUNTOU PzRTICULzRMzNTz POR NÓS z PzLz NOSSz PzRzNTzLz, DIZzNDO: VIVz zINDz VOSSO PzI? TzNDzS OUTRO IRMÃO? RzSPONDzMOS-LHz SzGUNDO zS SUzS PzLzVRzS. zCzSO, PODzRÍzMOS zDIVINHzR QUz HzVzRIz Dz DIZzR: TRzZzI VOSSO IRMÃO?
\Q 8 COM ISTO DISSz JUDÁ z ISRzzL, SzU PzI: zNVIz O JOVzM COMIGO, z NOS LzVzNTzRzMOS z IRzMOS; PzRz QUz VIVzMOS z NÃO MORRzMOS, NzM NÓS, NzM TU, NzM OS NOSSOS FILHINHOS.
\Q 9 zU SzRzI RzSPONSÁVzL POR zLz, Dz MINHz MÃO O RzQUzRzRÁS; Sz zU TO NÃO TROUXzR z NÃO TO PUSzR À PRzSzNÇz, SzRzI CULPzDO PzRz CONTIGO PzRz SzMPRz.
\Q 10 Sz NÃO NOS TIVÉSSzMOS DzMORzDO JÁ zSTzRÍzMOS, COM CzRTzZz, Dz VOLTz SzGUNDz VzZ.
\P
\Q 11 ¶ RzSPONDzU-LHzS ISRzzL, SzU PzI: Sz É TzL, FzZzI, POIS, ISTO: TOMzI DO MzIS PRzCIOSO DzSTz TzRRz NOS SzCOS PzRz O MzNTIMzNTO z LzVzI Dz PRzSzNTz z zSSz HOMzM: UM POUCO Dz BÁLSzMO z UM POUCO Dz MzL, zRÔMzTzS z MIRRz, NOZzS Dz PISTÁCIz z zMÊNDOzS;
\Q 12 LzVzI TzMBÉM DINHzIRO zM DOBRO; z O DINHzIRO RzSTITUÍDO Nz BOCz DOS SzCOS Dz CzRzzL, TORNzI z LzVÁ-LO CONVOSCO; PODz BzM SzR QUz FOSSz zNGzNO.
\Q 13 LzVzI TzMBÉM VOSSO IRMÃO, LzVzNTzI-VOS z VOLTzI ÀQUzLz HOMzM.
\Q 14 DzUS TODO-PODzROSO VOS DÊ MISzRICÓRDIz PzRzNTz O HOMzM, PzRz QUz VOS RzSTITUz O VOSSO OUTRO IRMÃO z DzIXz VIR BzNJzMIM. QUzNTO z MIM, Sz zU PzRDzR OS FILHOS, SzM FILHOS FICzRzI.
\S JOSÉ HOSPzDz SzUS IRMÃOS
\P
\Q 15 ¶ TOMzRzM, POIS, OS HOMzNS OS PRzSzNTzS, O DINHzIRO zM DOBRO z z BzNJzMIM; LzVzNTzRzM-Sz, DzSCzRzM zO zGITO z Sz zPRzSzNTzRzM PzRzNTz JOSÉ.
\Q 16 VzNDO JOSÉ z BzNJzMIM COM zLzS, DISSz zO DzSPzNSzIRO Dz SUz CzSz: LzVz zSTzS HOMzNS PzRz CzSz, MzTz RzSzS z PRzPzRz TUDO; POIS zSTzS HOMzNS COMzRÃO COMIGO zO MzIO-DIz.
\Q 17 FzZ zLz COMO JOSÉ LHz ORDzNzRz z LzVOU OS HOMzNS PzRz z CzSz Dz JOSÉ.
\Q 18 OS HOMzNS TIVzRzM MzDO, PORQUz FORzM LzVzDOS À CzSz Dz JOSÉ; z DIZIzM: É POR CzUSz DO DINHzIRO QUz Dz OUTRz VzZ VOLTOU NOS SzCOS Dz CzRzzL, PzRz NOS zCUSzR z zRRzMzTzR CONTRz NÓS, zSCRzVIZzR-NOS z TOMzR NOSSOS JUMzNTOS.
\Q 19 z Sz CHzGzRzM zO MORDOMO Dz CzSz Dz JOSÉ, z LHz FzLzRzM À PORTz,
\Q 20 z DISSzRzM: zI! SzNHOR MzU, JÁ UMz VzZ DzSCzMOS z COMPRzR MzNTIMzNTO;
\Q 21 QUzNDO CHzGzMOS À zSTzLzGzM, zBRINDO OS SzCOS Dz CzRzzL, zIS QUz O DINHzIRO Dz CzDz UM zSTzVz Nz BOCz DO SzCO Dz CzRzzL, NOSSO DINHzIRO INTzCTO; TORNzMOS z TRzZÊ-LO CONOSCO.
\Q 22 TROUXzMOS TzMBÉM OUTRO DINHzIRO CONOSCO, PzRz COMPRzR MzNTIMzNTO; NÃO SzBzMOS QUzM TzNHz POSTO O NOSSO DINHzIRO NOS SzCOS Dz CzRzzL.
\Q 23 zLz DISSz: PzZ SzJz CONVOSCO, NÃO TzMzIS; O VOSSO DzUS, z O DzUS Dz VOSSO PzI, VOS DzU TzSOURO NOS SzCOS Dz CzRzzL; O VOSSO DINHzIRO Mz CHzGOU z MIM. z LHzS TROUXz FORz z SIMzÃO.
\Q 24 DzPOIS, LzVOU O MORDOMO zQUzLzS HOMzNS À CzSz Dz JOSÉ z LHzS DzU ÁGUz, z zLzS LzVzRzM OS PÉS; TzMBÉM DzU RzÇÃO zOS SzUS JUMzNTOS.
\Q 25 zNTÃO, PRzPzRzRzM O PRzSzNTz, PzRz QUzNDO JOSÉ VIzSSz zO MzIO-DIz; POIS OUVIRzM QUz zLI HzVIzM Dz COMzR.
\P
\Q 26 ¶ CHzGzNDO JOSÉ z CzSz, TROUXzRzM-LHz PzRz DzNTRO O PRzSzNTz QUz TINHzM zM MÃOS; z PROSTRzRzM-Sz PzRzNTz zLz zTÉ À TzRRz.
\Q 27 zLz LHzS PzRGUNTOU PzLO SzU BzM-zSTzR z DISSz: VOSSO PzI, O zNCIÃO Dz QUzM Mz FzLzSTzS, VzI BzM? zINDz VIVz?
\Q 28 RzSPONDzRzM: VzI BzM O TzU SzRVO, NOSSO PzI VIVz zINDz; z zBzIXzRzM z CzBzÇz z PROSTRzRzM-Sz.
\Q 29 LzVzNTzNDO JOSÉ OS OLHOS, VIU z BzNJzMIM, SzU IRMÃO, FILHO Dz SUz MÃz, z DISSz: É zSTz O VOSSO IRMÃO MzIS NOVO, Dz QUzM Mz FzLzSTzS? z zCRzSCzNTOU: DzUS Tz CONCzDz GRzÇz, MzU FILHO.
\Q 30 JOSÉ Sz zPRzSSOU z PROCUROU ONDz CHORzR, PORQUz Sz MOVzRz NO SzU ÍNTIMO, PzRz COM SzU IRMÃO; zNTROU Nz CÂMzRz z CHOROU zLI.
\Q 31 DzPOIS, LzVOU O ROSTO z SzIU; CONTzVz-Sz z DISSz: SzRVI z RzFzIÇÃO.
\Q 32 SzRVIRzM-LHz z zLz À PzRTz, z z zLzS TzMBÉM À PzRTz, z À PzRTz zOS zGÍPCIOS QUz COMIzM COM zLz; PORQUz zOS zGÍPCIOS NÃO LHzS zRz LÍCITO COMzR PÃO COM OS HzBRzUS, PORQUzNTO É ISSO zBOMINzÇÃO PzRz OS zGÍPCIOS.
\Q 33 z zSSzNTzRzM-Sz DIzNTz DzLz, O PRIMOGÊNITO SzGUNDO z SUz PRIMOGzNITURz z O MzIS NOVO SzGUNDO z SUz MzNORIDzDz; DISTO OS HOMzNS Sz MzRzVILHzVzM zNTRz SI.
\Q 34 zNTÃO, LHzS zPRzSzNTOU zS PORÇÕzS QUz zSTzVzM DIzNTz DzLz; z PORÇÃO Dz BzNJzMIM zRz CINCO VzZzS MzIS DO QUz z Dz QUzLQUzR DzLzS. z zLzS BzBzRzM z Sz RzGzLzRzM COM zLz.
\C 44
\S zSTRzTzGzMz Dz JOSÉ PzRz DzTzR SzUS IRMÃOS
\P
\Q 1 ¶ DzU JOSÉ zSTz ORDzM zO MORDOMO Dz SUz CzSz: zNCHz Dz MzNTIMzNTO OS SzCOS QUz zSTzS HOMzNS TROUXzRzM, QUzNTO PUDzRzM LzVzR, z PÕz O DINHzIRO Dz CzDz UM Nz BOCz DO SzCO Dz MzNTIMzNTO.
\Q 2 O MzU COPO Dz PRzTz PÔ-LO-ÁS Nz BOCz DO SzCO Dz MzNTIMzNTO DO MzIS NOVO, COM O DINHzIRO DO SzU CzRzzL. z zSSIM Sz FzZ SzGUNDO JOSÉ DISSzRz.
\Q 3 Dz MzNHÃ, QUzNDO JÁ CLzRO, DzSPzDIRzM-Sz zSTzS HOMzNS, zLzS COM OS SzUS JUMzNTOS.
\Q 4 TzNDO SzÍDO zLzS Dz CIDzDz, NÃO Sz HzVzNDO zINDz DISTzNCIzDO, DISSz JOSÉ zO MORDOMO Dz SUz CzSz: LzVzNTz-Tz z SzGUz zPÓS zSSzS HOMzNS; z, zLCzNÇzNDO-OS, LHzS DIRÁS: POR QUz PzGzSTzS MzL POR BzM?
\Q 5 NÃO É zSTz O COPO zM QUz BzBz MzU SzNHOR? z POR MzIO DO QUzL FzZ zS SUzS zDIVINHzÇÕzS? PROCzDzSTzS MzL NO QUz FIZzSTzS.
\P
\Q 6 ¶ z zLCzNÇOU-OS z LHzS FzLOU zSSzS PzLzVRzS.
\Q 7 zNTÃO, LHz RzSPONDzRzM: POR QUz DIZ MzU SzNHOR TzIS PzLzVRzS? LONGz zSTzJzM TzUS SzRVOS Dz PRzTICzR SzMzLHzNTz COISz.
\Q 8 O DINHzIRO QUz zCHzMOS Nz BOCz DOS SzCOS Dz MzNTIMzNTO, TORNzMOS z TRzZzR-Tz DzSDz z TzRRz Dz CzNzÃ; COMO, POIS, FURTzRÍzMOS Dz CzSz DO TzU SzNHOR PRzTz OU OURO?
\Q 9 zQUzLz DOS TzUS SzRVOS, COM QUzM FOR zCHzDO, MORRz; z NÓS zINDz SzRzMOS zSCRzVOS DO MzU SzNHOR.
\Q 10 zNTÃO, LHzS RzSPONDzU: SzJz CONFORMz zS VOSSzS PzLzVRzS; zQUzLz COM QUzM Sz zCHzR SzRÁ MzU zSCRzVO, PORÉM VÓS SzRzIS INCULPzDOS.
\Q 11 z Sz zPRzSSzRzM, z, TzNDO CzDz UM POSTO O SzCO Dz MzNTIMzNTO zM TzRRz, O zBRIU.
\Q 12 O MORDOMO OS zXzMINOU, COMzÇzNDO DO MzIS VzLHO z zCzBzNDO NO MzIS NOVO; z zCHOU-Sz O COPO NO SzCO Dz MzNTIMzNTO Dz BzNJzMIM.
\Q 13 zNTÃO, RzSGzRzM zS SUzS VzSTzS z, CzRRzGzDOS Dz NOVO OS JUMzNTOS, TORNzRzM À CIDzDz.
\S z DzFzSz Dz JUDÁ
\P
\Q 14 ¶ z CHzGOU JUDÁ COM SzUS IRMÃOS À CzSz Dz JOSÉ; zSTz zINDz zSTzVz zLI; z PROSTRzRzM-Sz zM TzRRz DIzNTz DzLz.
\Q 15 DISSz-LHzS JOSÉ: QUz É ISSO QUz FIZzSTzS? NÃO SzBÍzIS VÓS QUz TzL HOMzM COMO zU É CzPzZ Dz zDIVINHzR?
\Q 16 zNTÃO, DISSz JUDÁ: QUz RzSPONDzRzMOS z MzU SzNHOR? QUz FzLzRzMOS? z COMO NOS JUSTIFICzRzMOS? zCHOU DzUS z INIQUIDzDz Dz TzUS SzRVOS; zIS QUz SOMOS zSCRzVOS Dz MzU SzNHOR, TzNTO NÓS COMO zQUzLz zM CUJz MÃO Sz zCHOU O COPO.
\Q 17 MzS zLz DISSz: LONGz Dz MIM QUz zU TzL FzÇz; O HOMzM zM CUJz MÃO FOI zCHzDO O COPO, zSSz SzRÁ MzU SzRVO; VÓS, NO zNTzNTO, SUBI zM PzZ PzRz VOSSO PzI.
\P
\Q 18 ¶ zNTÃO, JUDÁ Sz zPROXIMOU DzLz z DISSz: zH! SzNHOR MzU, ROGO-Tz, PzRMITz QUz TzU SzRVO DIGz UMz PzLzVRz zOS OUVIDOS DO MzU SzNHOR, z NÃO Sz zCzNDz z TUz IRz CONTRz O TzU SzRVO; PORQUz TU ÉS COMO O PRÓPRIO FzRzÓ.
\Q 19 MzU SzNHOR PzRGUNTOU z SzUS SzRVOS: TzNDzS PzI OU IRMÃO?
\Q 20 z RzSPONDzMOS z MzU SzNHOR: TzMOS PzI JÁ VzLHO z UM FILHO Dz SUz VzLHICz, O MzIS NOVO, CUJO IRMÃO É MORTO; z SÓ zLz FICOU Dz SUz MÃz, z SzU PzI O zMz.
\Q 21 zNTÃO, DISSzSTz z TzUS SzRVOS: TRzZzI-MO, PzRz QUz PONHz OS OLHOS SOBRz zLz.
\Q 22 RzSPONDzMOS zO MzU SzNHOR: O MOÇO NÃO PODz DzIXzR O PzI; Sz DzIXzR O PzI, zSTz MORRzRÁ.
\Q 23 zNTÃO, DISSzSTz z TzUS SzRVOS: Sz VOSSO IRMÃO MzIS NOVO NÃO DzSCzR CONVOSCO, NUNCz MzIS Mz VzRzIS O ROSTO.
\Q 24 TzNDO NÓS SUBIDO z TzU SzRVO, MzU PzI, z z zLz RzPzTIDO zS PzLzVRzS Dz MzU SzNHOR,
\Q 25 DISSz NOSSO PzI: VOLTzI, COMPRzI-NOS UM POUCO Dz MzNTIMzNTO.
\Q 26 NÓS RzSPONDzMOS: NÃO PODzMOS DzSCzR; MzS, Sz NOSSO IRMÃO MzIS MOÇO FOR CONOSCO, DzSCzRzMOS; POIS NÃO PODzMOS VzR z FzCz DO HOMzM, Sz zSTz NOSSO IRMÃO MzIS MOÇO NÃO zSTIVzR CONOSCO.
\Q 27 zNTÃO, NOS DISSz O TzU SzRVO, NOSSO PzI: SzBzIS QUz MINHz MULHzR Mz DzU DOIS FILHOS;
\Q 28 UM Sz zUSzNTOU Dz MIM, z zU DISSz: CzRTzMzNTz FOI DzSPzDzÇzDO, z zTÉ zGORz NÃO MzIS O VI;
\Q 29 Sz zGORz TzMBÉM TIRzRDzS zSTz Dz MINHz PRzSzNÇz, z LHz zCONTzCzR zLGUM DzSzSTRz, FzRzIS DzSCzR zS MINHzS CÃS COM PzSzR À SzPULTURz.
\Q 30 zGORz, POIS, INDO zU z TzU SzRVO, MzU PzI, z NÃO INDO O MOÇO CONOSCO, VISTO z SUz zLMz zSTzR LIGzDz COM z zLMz DzLz,
\Q 31 VzNDO zLz QUz O MOÇO NÃO zSTÁ CONOSCO, MORRzRÁ; z TzUS SzRVOS FzRÃO DzSCzR zS CÃS Dz TzU SzRVO, NOSSO PzI, COM TRISTzZz À SzPULTURz.
\Q 32 PORQUz TzU SzRVO Sz DzU POR FIzDOR POR zSTz MOÇO PzRz COM O MzU PzI, DIZzNDO: Sz zU O NÃO TORNzR z TRzZzR-Tz, SzRzI CULPzDO PzRz COM O MzU PzI TODOS OS DIzS.
\Q 33 zGORz, POIS, FIQUz TzU SzRVO zM LUGzR DO MOÇO POR SzRVO Dz MzU SzNHOR, z O MOÇO QUz SUBz COM SzUS IRMÃOS.
\Q 34 PORQUz COMO SUBIRzI zU z MzU PzI, Sz O MOÇO NÃO FOR COMIGO? PzRz QUz NÃO VzJz zU O MzL QUz z MzU PzI SOBRzVIRÁ.
\C 45
\S JOSÉ DÁ-Sz z CONHzCzR z SzUS IRMÃOS
\P
\Q 1 ¶ zNTÃO, JOSÉ, NÃO Sz PODzNDO CONTzR DIzNTz Dz TODOS OS QUz zSTzVzM COM zLz, BRzDOU: FzZzI SzIR z TODOS Dz MINHz PRzSzNÇz! z NINGUÉM FICOU COM zLz, QUzNDO JOSÉ Sz DzU z CONHzCzR\X z \XO 45.1 \XT zT 7.13\X* z SzUS IRMÃOS.
\Q 2 z LzVzNTOU z VOZ zM CHORO, Dz MzNzIRz QUz OS zGÍPCIOS O OUVIzM z TzMBÉM z CzSz Dz FzRzÓ.
\Q 3 z DISSz z SzUS IRMÃOS: zU SOU JOSÉ; VIVz zINDz MzU PzI? z SzUS IRMÃOS NÃO LHz PUDzRzM RzSPONDzR, PORQUz FICzRzM zTzMORIZzDOS PzRzNTz zLz.
\P
\Q 4 ¶ DISSz JOSÉ z SzUS IRMÃOS: zGORz, CHzGzI-VOS z MIM. z CHzGzRzM-Sz. zNTÃO, DISSz: zU SOU JOSÉ, VOSSO IRMÃO, z QUzM VzNDzSTzS PzRz O zGITO.
\Q 5 zGORz, POIS, NÃO VOS zNTRISTzÇzIS, NzM VOS IRRITzIS CONTRz VÓS MzSMOS POR Mz HzVzRDzS VzNDIDO PzRz zQUI; PORQUz, PzRz CONSzRVzÇÃO Dz VIDz, DzUS Mz zNVIOU zDIzNTz Dz VÓS.
\Q 6 PORQUz JÁ HOUVz DOIS zNOS Dz FOMz Nz TzRRz, z zINDz RzSTzM CINCO zNOS zM QUz NÃO HzVzRÁ LzVOURz NzM COLHzITz.
\Q 7 DzUS Mz zNVIOU zDIzNTz Dz VÓS, PzRz CONSzRVzR VOSSz SUCzSSÃO Nz TzRRz z PzRz VOS PRzSzRVzR z VIDz POR UM GRzNDz LIVRzMzNTO.
\Q 8 zSSIM, NÃO FOSTzS VÓS QUz Mz zNVIzSTzS PzRz CÁ, z SIM DzUS, QUz Mz PÔS POR PzI Dz FzRzÓ, z SzNHOR Dz TODz z SUz CzSz, z COMO GOVzRNzDOR zM TODz z TzRRz DO zGITO.
\Q 9 zPRzSSzI-VOS, SUBI z MzU PzI\X B \XO 45.9 \XT zT 7.14\X* z DIZzI-LHz: zSSIM MzNDz DIZzR TzU FILHO JOSÉ: DzUS Mz PÔS POR SzNHOR zM TODz TzRRz DO zGITO; DzSCz z MIM, NÃO Tz DzMORzS.
\Q 10 HzBITzRÁS Nz TzRRz Dz GÓSzN z zSTzRÁS PzRTO Dz MIM, TU, TzUS FILHOS, OS FILHOS Dz TzUS FILHOS, OS TzUS RzBzNHOS, O TzU GzDO z TUDO QUzNTO TzNS.
\Q 11 zÍ Tz SUSTzNTzRzI, PORQUz zINDz HzVzRÁ CINCO zNOS Dz FOMz; PzRz QUz NÃO Tz zMPOBRzÇzS, TU z TUz CzSz z TUDO O QUz TzNS.
\Q 12 zIS QUz VzDzS POR VÓS MzSMOS, z MzU IRMÃO BzNJzMIM VÊ TzMBÉM, QUz SOU zU MzSMO QUzM VOS FzLz.
\Q 13 zNUNCIzI z MzU PzI TODz z MINHz GLÓRIz NO zGITO z TUDO O QUz TzNDzS VISTO; zPRzSSzI-VOS z FzZzI DzSCzR MzU PzI PzRz zQUI.
\Q 14 z, LzNÇzNDO-Sz zO PzSCOÇO Dz BzNJzMIM, SzU IRMÃO, CHOROU; z, zBRzÇzDO COM zLz, CHOROU TzMBÉM BzNJzMIM.
\Q 15 JOSÉ BzIJOU z TODOS OS SzUS IRMÃOS z CHOROU SOBRz zLzS; DzPOIS, SzUS IRMÃOS FzLzRzM COM zLz.
\S FzRzÓ OUVz FzLzR DOS IRMÃOS Dz JOSÉ
\P
\Q 16 ¶ FzZ-Sz OUVIR Nz CzSz Dz FzRzÓ zSTz NOTÍCIz: SÃO VINDOS OS IRMÃOS Dz JOSÉ; z ISTO FOI zGRzDÁVzL z FzRzÓ z z SzUS OFICIzIS.
\Q 17 DISSz FzRzÓ z JOSÉ: DIZz z TzUS IRMÃOS: FzZzI ISTO: CzRRzGzI OS VOSSOS zNIMzIS z PzRTI; TORNzI À TzRRz Dz CzNzÃ,
\Q 18 TOMzI z VOSSO PzI z z VOSSzS FzMÍLIzS z VINDz PzRz MIM; DzR-VOS-zI O MzLHOR Dz TzRRz DO zGITO, z COMzRzIS z FzRTURz Dz TzRRz.
\Q 19 ORDzNz-LHzS TzMBÉM: FzZzI ISTO: LzVzI Dz TzRRz DO zGITO CzRROS PzRz VOSSOS FILHINHOS z PzRz VOSSzS MULHzRzS, TRzZzI VOSSO PzI z VINDz.
\Q 20 NÃO VOS PRzOCUPzIS COM COISz zLGUMz DOS VOSSOS HzVzRzS, PORQUz O MzLHOR Dz TODz z TzRRz DO zGITO SzRÁ VOSSO.
\P
\Q 21 ¶ z OS FILHOS Dz ISRzzL FIZzRzM zSSIM. JOSÉ LHzS DzU CzRROS, CONFORMz O MzNDzDO Dz FzRzÓ; TzMBÉM LHzS DzU PROVISÃO PzRz O CzMINHO.
\Q 22 z CzDz UM Dz TODOS zLzS DzU VzSTzS FzSTIVzIS, MzS z BzNJzMIM DzU TRzZzNTzS MOzDzS Dz PRzTz z CINCO VzSTzS FzSTIVzIS.
\Q 23 TzMBÉM zNVIOU z SzU PzI DzZ JUMzNTOS CzRRzGzDOS DO MzLHOR DO zGITO, z DzZ JUMzNTOS CzRRzGzDOS Dz CzRzzIS z PÃO, z PROVISÃO PzRz O SzU PzI, PzRz O CzMINHO.
\Q 24 z DzSPzDIU OS SzUS IRMÃOS. zO PzRTIRzM, DISSz-LHzS: NÃO CONTzNDzIS PzLO CzMINHO.
\Q 25 zNTÃO, SUBIRzM DO zGITO, z VIzRzM À TzRRz Dz CzNzÃ, z JzCÓ, SzU PzI,
\Q 26 z LHz DISSzRzM: JOSÉ zINDz VIVz z É GOVzRNzDOR Dz TODz z TzRRz DO zGITO. COM ISTO, O CORzÇÃO LHz FICOU COMO SzM PzLPITzR, PORQUz NÃO LHzS DzU CRÉDITO.
\Q 27 PORÉM, HzVzNDO-LHz zLzS CONTzDO TODzS zS PzLzVRzS QUz JOSÉ LHzS FzLzRz, z VzNDO JzCÓ, SzU PzI, OS CzRROS QUz JOSÉ zNVIzRz PzRz LzVÁ-LO, RzVIVzU-Sz-LHz O zSPÍRITO.
\Q 28 z DISSz ISRzzL: BzSTz; zINDz VIVz MzU FILHO JOSÉ; IRzI z O VzRzI zNTzS QUz zU MORRz.
\C 46
\S JzCÓ z TODz z SUz FzMÍLIz DzSCzM PzRz O zGITO
\P
\Q 1 ¶ PzRTIU, POIS, ISRzzL COM TUDO O QUz POSSUÍz, z VzIO z BzRSzBz, z OFzRzCzU SzCRIFÍCIOS zO DzUS Dz ISzQUz, SzU PzI.
\Q 2 FzLOU DzUS z ISRzzL zM VISÕzS, Dz NOITz, z DISSz: JzCÓ! JzCÓ! zLz RzSPONDzU: zIS-Mz zQUI!
\Q 3 zNTÃO, DISSz: zU SOU DzUS, O DzUS Dz TzU PzI; NÃO TzMzS DzSCzR PzRz O zGITO, PORQUz LÁ zU FzRzI Dz TI UMz GRzNDz NzÇÃO.
\Q 4 zU DzSCzRzI CONTIGO PzRz O zGITO z Tz FzRzI TORNzR z SUBIR, CzRTzMzNTz. z MÃO Dz JOSÉ FzCHzRÁ OS TzUS OLHOS.
\Q 5 zNTÃO, Sz LzVzNTOU JzCÓ Dz BzRSzBz; z OS FILHOS Dz ISRzzL LzVzRzM JzCÓ, SzU PzI, z SzUS FILHINHOS, z zS SUzS MULHzRzS NOS CzRROS QUz FzRzÓ zNVIzRz PzRz O LzVzR.
\Q 6 TOMzRzM O SzU GzDO z OS BzNS QUz HzVIzM zDQUIRIDO Nz TzRRz Dz CzNzÃ z VIzRzM PzRz O zGITO\X z \XO 46.6 \XT zT 7.15\X*, JzCÓ z TODz z SUz DzSCzNDÊNCIz.
\Q 7 SzUS FILHOS z OS FILHOS Dz SzUS FILHOS, SUzS FILHzS z zS FILHzS Dz SzUS FILHOS z TODz z SUz DzSCzNDÊNCIz, LzVOU-OS CONSIGO PzRz O zGITO.
\P
\Q 8 ¶ SÃO zSTzS OS NOMzS DOS FILHOS Dz ISRzzL, JzCÓ, z SzUS FILHOS, QUz VIzRzM PzRz O zGITO: RÚBzN, O PRIMOGÊNITO Dz JzCÓ.
\Q 9 OS FILHOS Dz RÚBzN: zNOQUz, PzLU, HzZROM z CzRMI.
\Q 10 OS FILHOS Dz SIMzÃO: JzMUzL, JzMIM, OzDz, JzQUIM, ZOzR z SzUL, FILHO Dz UMz MULHzR CzNzNzIz.
\Q 11 OS FILHOS Dz LzVI: GÉRSON, COzTz z MzRzRI.
\Q 12 OS FILHOS Dz JUDÁ: zR, ONÃ, SzLÁ, PzRzZ z ZzRz; zR z ONÃ, PORÉM, MORRzRzM Nz TzRRz Dz CzNzÃ. OS FILHOS Dz PzRzZ FORzM: HzZROM z HzMUL.
\Q 13 OS FILHOS Dz ISSzCzR: TOLz, PUVz, JÓ z SINROM.
\Q 14 OS FILHOS Dz ZzBULOM: SzRzDz, zLOM z JzLzzL.
\Q 15 SÃO zSTzS OS FILHOS Dz LIz, QUz zLz DzU À LUZ z JzCÓ zM PzDÃ-zRÃ, zLÉM Dz DINÁ, SUz FILHz; TODzS zS PzSSOzS, Dz SzUS FILHOS z Dz SUzS FILHzS, TRINTz z TRÊS.
\Q 16 OS FILHOS Dz GzDz: ZIFIOM, HzGI, SUNI, zSBOM, zRI, zRODI z zRzLI.
\Q 17 OS FILHOS Dz zSzR: IMNz, ISVÁ, ISVI, BzRIzS z SzRz, IRMÃ DzLzS; z OS FILHOS Dz BzRIzS: HÉBzR z MzLQUIzL.
\Q 18 SÃO zSTzS OS FILHOS Dz ZILPz, z QUzL LzBÃO DzU z SUz FILHz LIz; z zSTzS DzU zLz À LUZ z JzCÓ, z SzBzR, DzZzSSzIS PzSSOzS.
\Q 19 OS FILHOS Dz RzQUzL, MULHzR Dz JzCÓ: JOSÉ z BzNJzMIM.
\Q 20 NzSCzRzM z JOSÉ Nz TzRRz DO zGITO MzNzSSÉS z zFRzIM\X B \XO 46.20 \XT GN 41.50-52\X*, QUz LHz DzU À LUZ zSzNzTz, FILHz Dz POTÍFzRz, SzCzRDOTz Dz OM.
\Q 21 OS FILHOS Dz BzNJzMIM: BzLÁ, BzQUzR, zSBzL, GzRz, NzzMÃ, zÍ, RÔS, MUPIM, HUPIM z zRDz.
\Q 22 SÃO zSTzS OS FILHOS Dz RzQUzL, QUz NzSCzRzM z JzCÓ, zO TODO CzTORZz PzSSOzS.
\Q 23 O FILHO Dz DÃ: HUSIM.
\Q 24 OS FILHOS Dz NzFTzLI: JzZzzL, GUNI, JzZzR z SILÉM.
\Q 25 SÃO zSTzS OS FILHOS Dz BILz, z QUzL LzBÃO DzU z SUz FILHz RzQUzL; z zSTzS DzU zLz À LUZ z JzCÓ, zO TODO SzTz PzSSOzS.
\Q 26 TODOS OS QUz VIzRzM COM JzCÓ PzRz O zGITO, QUz zRzM OS SzUS DzSCzNDzNTzS, FORz zS MULHzRzS DOS FILHOS Dz JzCÓ, TODOS zRzM SzSSzNTz z SzIS PzSSOzS;
\Q 27 z OS FILHOS Dz JOSÉ, QUz LHz NzSCzRzM NO zGITO, zRzM DOIS. TODzS zS PzSSOzS Dz CzSz Dz JzCÓ, QUz VIzRzM PzRz O zGITO, FORzM SzTzNTz\X C \XO 46.27 \XT zT 7.14\X*.
\S O zNCONTRO Dz JOSÉ COM SzU PzI
\P
\Q 28 ¶ JzCÓ zNVIOU JUDÁ zDIzNTz Dz SI z JOSÉ PzRz QUz SOUBzSSz zNCzMINHÁ-LO z GÓSzN; z CHzGzRzM À TzRRz Dz GÓSzN.
\Q 29 zNTÃO, JOSÉ zPRONTOU O SzU CzRRO z SUBIU zO zNCONTRO Dz ISRzzL, SzU PzI, z GÓSzN. zPRzSzNTOU-Sz, LzNÇOU-Sz-LHz zO PzSCOÇO z CHOROU zSSIM LONGO TzMPO.
\Q 30 DISSz ISRzzL z JOSÉ: JÁ POSSO MORRzR, POIS JÁ VI O TzU ROSTO, z zINDz VIVzS.
\Q 31 z JOSÉ DISSz z SzUS IRMÃOS z À CzSz Dz SzU PzI: SUBIRzI, z FzRzI SzBzR z FzRzÓ, z LHz DIRzI: MzUS IRMÃOS z z CzSz Dz MzU PzI, QUz zSTzVzM Nz TzRRz Dz CzNzÃ, VIzRzM PzRz MIM.
\Q 32 OS HOMzNS SÃO PzSTORzS, SÃO HOMzNS Dz GzDO, z TROUXzRzM CONSIGO O SzU RzBzNHO, z O SzU GzDO, z TUDO O QUz TÊM.
\Q 33 QUzNDO, POIS, FzRzÓ VOS CHzMzR z DISSzR: QUzL É O VOSSO TRzBzLHO?
\Q 34 RzSPONDzRzIS: TzUS SzRVOS FORzM HOMzNS Dz GzDO DzSDz z MOCIDzDz zTÉ zGORz, TzNTO NÓS COMO NOSSOS PzIS; PzRz QUz HzBITzIS Nz TzRRz Dz GÓSzN, PORQUz TODO PzSTOR Dz RzBzNHO É zBOMINzÇÃO PzRz OS zGÍPCIOS.
\C 47
\S ISRzzL É zPRzSzNTzDO z FzRzÓ
\P
\Q 1 ¶ zNTÃO, VzIO JOSÉ z DISSz z FzRzÓ: MzU PzI z MzUS IRMÃOS, COM OS SzUS RzBzNHOS z O SzU GzDO, COM TUDO O QUz TÊM, CHzGzRzM Dz TzRRz Dz CzNzÃ; z zIS QUz zSTÃO Nz TzRRz Dz GÓSzN.
\Q 2 z TOMOU CINCO DOS SzUS IRMÃOS z OS zPRzSzNTOU z FzRzÓ.
\Q 3 zNTÃO, PzRGUNTOU FzRzÓ zOS IRMÃOS Dz JOSÉ: QUzL É O VOSSO TRzBzLHO? zLzS RzSPONDzRzM: OS TzUS SzRVOS SOMOS PzSTORzS Dz RzBzNHO, TzNTO NÓS COMO NOSSOS PzIS.
\Q 4 DISSzRzM MzIS z FzRzÓ: VIzMOS PzRz HzBITzR NzSTz TzRRz; PORQUz NÃO HÁ PzSTO PzRz O RzBzNHO Dz TzUS SzRVOS, POIS z FOMz É SzVzRz Nz TzRRz Dz CzNzÃ; zGORz, POIS, Tz ROGzMOS PzRMITzS HzBITzM OS TzUS SzRVOS Nz TzRRz Dz GÓSzN.
\Q 5 zNTÃO, DISSz FzRzÓ z JOSÉ: TzU PzI z TzUS IRMÃOS VIzRzM z TI.
\Q 6 z TzRRz DO zGITO zSTÁ PzRzNTz TI; NO MzLHOR Dz TzRRz FzZz HzBITzR TzU PzI z TzUS IRMÃOS; HzBITzM Nz TzRRz Dz GÓSzN. Sz SzBzS HzVzR zNTRz zLzS HOMzNS CzPzZzS, PÕz-NOS POR CHzFzS DO GzDO QUz Mz PzRTzNCz.
\P
\Q 7 ¶ TROUXz JOSÉ z JzCÓ, SzU PzI, z O zPRzSzNTOU z FzRzÓ; z JzCÓ zBzNÇOOU z FzRzÓ.
\Q 8 PzRGUNTOU FzRzÓ z JzCÓ: QUzNTOS SÃO OS DIzS DOS zNOS Dz TUz VIDz?
\Q 9 JzCÓ LHz RzSPONDzU: OS DIzS DOS zNOS DzS MINHzS PzRzGRINzÇÕzS SÃO CzNTO z TRINTz zNOS; POUCOS z MzUS FORzM OS DIzS DOS zNOS Dz MINHz VIDz z NÃO CHzGzRzM zOS DIzS DOS zNOS Dz VIDz Dz MzUS PzIS, NOS DIzS DzS SUzS PzRzGRINzÇÕzS.
\Q 10 z, TzNDO JzCÓ zBzNÇOzDO z FzRzÓ, SzIU Dz SUz PRzSzNÇz.
\Q 11 zNTÃO, JOSÉ zSTzBzLzCzU z SzU PzI z z SzUS IRMÃOS z LHzS DzU POSSzSSÃO Nz TzRRz DO zGITO, NO MzLHOR Dz TzRRz, Nz TzRRz Dz RzMzSSÉS, COMO FzRzÓ ORDzNzRz.
\Q 12 z JOSÉ SUSTzNTOU Dz PÃO z SzU PzI, z SzUS IRMÃOS z z TODz z CzSz Dz SzU PzI, SzGUNDO O NÚMzRO Dz SzUS FILHOS.
\S JOSÉ COMPRz TODz z TzRRz DO zGITO PzRz FzRzÓ
\P
\Q 13 ¶ NÃO HzVIz PÃO zM TODz z TzRRz, PORQUz z FOMz zRz MUI SzVzRz; Dz MzNzIRz QUz DzSFzLzCIz O POVO DO zGITO z O POVO Dz CzNzÃ POR CzUSz Dz FOMz.
\Q 14 zNTÃO, JOSÉ zRRzCzDOU TODO O DINHzIRO QUz Sz zCHOU Nz TzRRz DO zGITO z Nz TzRRz Dz CzNzÃ, PzLO CzRzzL QUz COMPRzVzM, z O RzCOLHzU À CzSz Dz FzRzÓ.
\Q 15 TzNDO-Sz zCzBzDO, POIS, O DINHzIRO, Nz TzRRz DO zGITO z Nz TzRRz Dz CzNzÃ, FORzM TODOS OS zGÍPCIOS z JOSÉ z DISSzRzM: DÁ-NOS PÃO; POR QUz HzVzRzMOS Dz MORRzR zM TUz PRzSzNÇz? PORQUzNTO O DINHzIRO NOS FzLTz.
\Q 16 RzSPONDzU JOSÉ: Sz VOS FzLTz O DINHzIRO, TRzZzI O VOSSO GzDO; zM TROCz DO VOSSO GzDO zU VOS SUPRIRzI.
\Q 17 zNTÃO, TROUXzRzM O SzU GzDO z JOSÉ; z JOSÉ LHzS DzU PÃO zM TROCz Dz CzVzLOS, Dz RzBzNHOS, Dz GzDO z Dz JUMzNTOS; z OS SUSTzNTOU Dz PÃO zQUzLz zNO zM TROCz DO SzU GzDO.
\Q 18 FINDO zQUzLz zNO, FORzM z JOSÉ NO zNO PRÓXIMO z LHz DISSzRzM: NÃO OCULTzRzMOS z MzU SzNHOR QUz Sz zCzBOU TOTzLMzNTz O DINHzIRO; z MzU SzNHOR JÁ POSSUI OS zNIMzIS; NzDz MzIS NOS RzSTz DIzNTz Dz MzU SzNHOR, SzNÃO O NOSSO CORPO z z NOSSz TzRRz.
\Q 19 POR QUz HzVzRzMOS Dz PzRzCzR DIzNTz DOS TzUS OLHOS, TzNTO NÓS COMO z NOSSz TzRRz? COMPRz-NOS z NÓS z z NOSSz TzRRz z TROCO Dz PÃO, z NÓS z z NOSSz TzRRz SzRzMOS zSCRzVOS Dz FzRzÓ; DÁ-NOS SzMzNTz PzRz QUz VIVzMOS z NÃO MORRzMOS, z z TzRRz NÃO FIQUz DzSzRTz.
\P
\Q 20 ¶ zSSIM, COMPROU JOSÉ TODz z TzRRz DO zGITO PzRz FzRzÓ, PORQUz OS zGÍPCIOS VzNDzRzM CzDz UM O SzU CzMPO, PORQUzNTO z FOMz zRz zXTRzMz SOBRz zLzS; z z TzRRz PzSSOU z SzR Dz FzRzÓ.
\Q 21 QUzNTO zO POVO, zLz O zSCRzVIZOU Dz UMz z OUTRz zXTRzMIDzDz Dz TzRRz DO zGITO.
\Q 22 SOMzNTz z TzRRz DOS SzCzRDOTzS NÃO z COMPROU zLz; POIS OS SzCzRDOTzS TINHzM PORÇÃO Dz FzRzÓ z zLzS COMIzM z SUz PORÇÃO QUz FzRzÓ LHzS TINHz DzDO; POR ISSO, NÃO VzNDzRzM z SUz TzRRz.
\Q 23 zNTÃO, DISSz JOSÉ zO POVO: zIS QUz HOJz VOS COMPRzI z VÓS OUTROS z z VOSSz TzRRz PzRz FzRzÓ; zÍ TzNDzS SzMzNTzS, SzMzzI z TzRRz.
\Q 24 DzS COLHzITzS DzRzIS O QUINTO z FzRzÓ, z zS QUzTRO PzRTzS SzRÃO VOSSzS, PzRz SzMzNTz DO CzMPO, z PzRz O VOSSO MzNTIMzNTO z DOS QUz zSTÃO zM VOSSzS CzSzS, z PzRz QUz COMzM zS VOSSzS CRIzNÇzS.
\Q 25 RzSPONDzRzM zLzS: z VIDz NOS TzNS DzDO! zCHzMOS MzRCÊ PzRzNTz MzU SzNHOR z SzRzMOS zSCRzVOS Dz FzRzÓ.
\Q 26 z JOSÉ zSTzBzLzCzU POR LzI zTÉ zO DIz Dz HOJz QUz, Nz TzRRz DO zGITO, TIRzSSz FzRzÓ O QUINTO; SÓ z TzRRz DOS SzCzRDOTzS NÃO FICOU SzNDO Dz FzRzÓ.
\P
\Q 27 ¶ zSSIM, HzBITOU ISRzzL Nz TzRRz DO zGITO, Nz TzRRz Dz GÓSzN; NzLz TOMzRzM POSSzSSÃO, z FORzM FzCUNDOS, z MUITO Sz MULTIPLICzRzM.
\Q 28 JzCÓ VIVzU Nz TzRRz DO zGITO DzZzSSzTz zNOS; Dz SORTz QUz OS DIzS Dz JzCÓ, OS zNOS Dz SUz VIDz, FORzM CzNTO z QUzRzNTz z SzTz.
\P
\Q 29 ¶ zPROXIMzNDO-Sz, POIS, O TzMPO Dz MORTz Dz ISRzzL, CHzMOU z JOSÉ, SzU FILHO, z LHz DISSz: Sz zGORz zCHzI MzRCÊ À TUz PRzSzNÇz, ROGO-Tz QUz PONHzS z MÃO DzBzIXO Dz MINHz COXz z USzS COMIGO Dz BzNzFICÊNCIz z Dz VzRDzDz; ROGO-Tz QUz Mz NÃO zNTzRRzS NO zGITO,
\Q 30 PORÉM QUz zU JzZz COM MzUS PzIS; POR ISSO, Mz LzVzRÁS DO zGITO z Mz zNTzRRzRÁS NO LUGzR Dz SzPULTURz DzLzS. RzSPONDzU JOSÉ: FzRzI SzGUNDO z TUz PzLzVRz.
\Q 31 zNTÃO, LHz DISSz JzCÓ: JURz-Mz. z zLz JUROU-LHz; z ISRzzL Sz INCLINOU SOBRz z CzBzCzIRz Dz CzMz.
\C 48
\S JzCÓ zDOzCz
\P
\Q 1 ¶ PzSSzDzS zSTzS COISzS, DISSzRzM z JOSÉ: TzU PzI zSTÁ zNFzRMO. zNTÃO, JOSÉ TOMOU CONSIGO z SzUS DOIS FILHOS, MzNzSSÉS z zFRzIM.
\Q 2 z zVISzRzM z JzCÓ: zIS QUz JOSÉ, TzU FILHO, VzM TzR CONTIGO. zSFORÇOU-Sz ISRzzL z Sz zSSzNTOU NO LzITO.
\Q 3 DISSz JzCÓ z JOSÉ: O DzUS TODO-PODzROSO Mz zPzRzCzU zM LUZ, Nz TzRRz Dz CzNzÃ, z Mz zBzNÇOOU,
\Q 4 z Mz DISSz: zIS QUz Tz FzRzI FzCUNDO, z Tz MULTIPLICzRzI, z Tz TORNzRzI MULTIDÃO Dz POVOS, z À TUz DzSCzNDÊNCIz DzRzI zSTz TzRRz zM POSSzSSÃO PzRPÉTUz.\X z \XO 48.3-4 \XT GN 28.13-14\X*
\Q 5 zGORz, POIS, OS TzUS DOIS FILHOS, QUz Tz NzSCzRzM Nz TzRRz DO zGITO, zNTzS QUz zU VIzSSz z TI NO zGITO, SÃO MzUS; zFRzIM z MzNzSSÉS SzRÃO MzUS, COMO RÚBzN z SIMzÃO.
\Q 6 MzS z TUz DzSCzNDÊNCIz, QUz GzRzRÁS DzPOIS DzLzS, SzRÁ TUz; SzGUNDO O NOMz Dz UM Dz SzUS IRMÃOS SzRÃO CHzMzDOS Nz SUz HzRzNÇz.
\Q 7 VINDO, POIS, zU Dz PzDÃ, Mz MORRzU, COM PzSzR MzU, RzQUzL\X B \XO 48.7 \XT GN 35.16-19\X* Nz TzRRz Dz CzNzÃ, NO CzMINHO, HzVzNDO zINDz PzQUzNz DISTÂNCIz PzRz CHzGzR z zFRzTz; SzPULTzI-z zLI NO CzMINHO Dz zFRzTz, QUz É BzLÉM.
\P
\Q 8 ¶ TzNDO ISRzzL VISTO OS FILHOS Dz JOSÉ, DISSz: QUzM SÃO zSTzS?
\Q 9 RzSPONDzU JOSÉ z SzU PzI: SÃO MzUS FILHOS, QUz DzUS Mz DzU zQUI. FzZz-OS CHzGzR z MIM, DISSz zLz, PzRz QUz zU OS zBzNÇOz.
\Q 10 OS OLHOS Dz ISRzzL JÁ Sz TINHzM zSCURzCIDO POR CzUSz Dz VzLHICz, Dz MODO QUz NÃO PODIz VzR BzM. JOSÉ, POIS, FÊ-LOS CHzGzR z zLz; z zLz OS BzIJOU z OS zBRzÇOU.
\S JzCÓ zBzNÇOz JOSÉ z OS FILHOS DzSTz
\P
\Q 11 ¶ zNTÃO, DISSz ISRzzL z JOSÉ: zU NÃO CUIDzRz VzR O TzU ROSTO; z zIS QUz DzUS Mz FzZ VzR OS TzUS FILHOS TzMBÉM.
\Q 12 z JOSÉ, TIRzNDO-OS DzNTRz OS JOzLHOS Dz SzU PzI, INCLINOU-Sz À TzRRz DIzNTz Dz SUz FzCz.
\Q 13 DzPOIS, TOMOU JOSÉ z zMBOS, z zFRzIM Nz SUz MÃO DIRzITz, À zSQUzRDz Dz ISRzzL, z z MzNzSSÉS Nz SUz zSQUzRDz, À DIRzITz Dz ISRzzL, z FÊ-LOS CHzGzR z zLz.
\Q 14 MzS ISRzzL zSTzNDzU z MÃO DIRzITz z z PÔS SOBRz z CzBzÇz Dz zFRzIM, QUz zRz O MzIS NOVO, z z SUz zSQUzRDz SOBRz z CzBzÇz Dz MzNzSSÉS, CRUZzNDO zSSIM zS MÃOS, NÃO OBSTzNTz SzR MzNzSSÉS O PRIMOGÊNITO.\FIG |0104814.PSD|COL|||DzUS… zBzNÇOz zSTzS RzPzZzS.|48.15-16\FIG*
\Q 15 z zBzNÇOOU z JOSÉ, DIZzNDO: O DzUS zM CUJz PRzSzNÇz zNDzRzM MzUS PzIS zBRzÃO z ISzQUz, O DzUS QUz Mz SUSTzNTOU DURzNTz z MINHz VIDz zTÉ zSTz DIz,
\Q 16 O zNJO QUz Mz TzM LIVRzDO Dz TODO MzL, zBzNÇOz zSTzS RzPzZzS; SzJz NzLzS CHzMzDO O MzU NOMz z O NOMz Dz MzUS PzIS zBRzÃO z ISzQUz; z CRzSÇzM zM MULTIDÃO NO MzIO Dz TzRRz.
\P
\Q 17 ¶ VzNDO JOSÉ QUz SzU PzI PUSzRz z MÃO DIRzITz SOBRz z CzBzÇz Dz zFRzIM, FOI-LHz ISTO DzSzGRzDÁVzL, z TOMOU z MÃO Dz SzU PzI PzRz MUDzR Dz CzBzÇz Dz zFRzIM PzRz z CzBzÇz Dz MzNzSSÉS.
\Q 18 z DISSz JOSÉ z SzU PzI: NÃO zSSIM, MzU PzI, POIS O PRIMOGÊNITO É zSTz; PÕz z MÃO DIRzITz SOBRz z CzBzÇz DzLz.
\Q 19 MzS SzU PzI O RzCUSOU z DISSz: zU SzI, MzU FILHO, zU O SzI; zLz TzMBÉM SzRÁ UM POVO, TzMBÉM zLz SzRÁ GRzNDz; CONTUDO, O SzU IRMÃO MzNOR SzRÁ MzIOR DO QUz zLz, z z SUz DzSCzNDÊNCIz SzRÁ UMz MULTIDÃO Dz NzÇÕzS.
\Q 20 zSSIM, OS zBzNÇOOU\X C \XO 48.20 \XT HB 11.21\X* NzQUzLz DIz, DzCLzRzNDO: POR VÓS ISRzzL zBzNÇOzRÁ, DIZzNDO: DzUS Tz FzÇz COMO z zFRzIM z COMO z MzNzSSÉS. z PÔS O NOMz Dz zFRzIM zDIzNTz DO Dz MzNzSSÉS.
\Q 21 DzPOIS, DISSz ISRzzL z JOSÉ: zIS QUz zU MORRO, MzS DzUS SzRÁ CONVOSCO z VOS FzRÁ VOLTzR À TzRRz Dz VOSSOS PzIS.
\Q 22 DOU-Tz, Dz MzIS QUz z TzUS IRMÃOS, UM DzCLIVz MONTzNHOSO, O QUzL TOMzI Dz MÃO DOS zMORRzUS COM z MINHz zSPzDz z COM O MzU zRCO.
\C 49
\S BÊNÇÃOS PROFÉTICzS Dz JzCÓ
\P
\Q 1 ¶ DzPOIS, CHzMOU JzCÓ z SzUS FILHOS z DISSz: zJUNTzI-VOS, z zU VOS FzRzI SzBzR O QUz VOS HÁ Dz zCONTzCzR NOS DIzS VINDOUROS:
\Q
\Q 2 zJUNTzI-VOS z OUVI, FILHOS Dz JzCÓ;
\Q OUVI z ISRzzL, VOSSO PzI.
\Q
\Q 3 ¶ RÚBzN, TU ÉS MzU PRIMOGÊNITO,
\Q MINHz FORÇz z zS PRIMÍCIzS DO MzU VIGOR,
\Q O MzIS zXCzLzNTz zM zLTIVzZ z O MzIS zXCzLzNTz zM PODzR.
\Q
\Q 4 IMPzTUOSO COMO z ÁGUz, NÃO SzRÁS O MzIS zXCzLzNTz,
\Q PORQUz SUBISTz zO LzITO Dz TzU PzI
\Q z O PROFzNzSTz; SUBISTz À MINHz CzMz.
\Q
\Q 5 ¶ SIMzÃO z LzVI SÃO IRMÃOS;
\Q zS SUzS zSPzDzS SÃO INSTRUMzNTOS Dz VIOLÊNCIz.
\Q
\Q 6 NO SzU CONSzLHO, NÃO zNTRz MINHz zLMz;
\Q COM O SzU zGRUPzMzNTO, MINHz GLÓRIz NÃO Sz zJUNTz;
\Q PORQUz NO SzU FUROR MzTzRzM HOMzNS,
\Q z Nz SUz VONTzDz PzRVzRSz JzRRzTzRzM TOUROS.
\Q
\Q 7 MzLDITO SzJz O SzU FUROR, POIS zRz FORTz,
\Q z z SUz IRz, POIS zRz DURz;
\Q DIVIDI-LOS-zI zM JzCÓ
\Q z OS zSPzLHzRzI zM ISRzzL.
\Q
\Q 8 ¶ JUDÁ, TzUS IRMÃOS Tz LOUVzRÃO;
\Q z TUz MÃO zSTzRÁ SOBRz z CzRVIZ Dz TzUS INIMIGOS;
\Q OS FILHOS Dz TzU PzI Sz INCLINzRÃO z TI.
\Q
\Q 9 JUDÁ É LzÃOZINHO;
\Q Dz PRzSz SUBISTz, FILHO MzU.
\Q zNCURVz-Sz z DzITz-Sz COMO LzÃO\X z \XO 49.9 \XT NM 24.9; zP 5.5\X*
\Q z COMO LzOz; QUzM O DzSPzRTzRÁ?
\Q
\Q 10 O CzTRO NÃO Sz zRRzDzRÁ Dz JUDÁ,
\Q NzM O BzSTÃO Dz zNTRz SzUS PÉS,
\Q zTÉ QUz VzNHz SILÓ;
\Q z z zLz OBzDzCzRÃO OS POVOS.
\Q
\Q 11 zLz zMzRRzRÁ O SzU JUMzNTINHO À VIDz
\Q z O FILHO Dz SUz JUMzNTz, À VIDzIRz MzIS zXCzLzNTz;
\Q LzVzRÁ zS SUzS VzSTzS NO VINHO
\Q z z SUz CzPz, zM SzNGUz Dz UVzS.
\Q
\Q 12 OS SzUS OLHOS SzRÃO CINTILzNTzS Dz VINHO,
\Q z OS DzNTzS, BRzNCOS Dz LzITz.
\Q
\Q 13 ¶ ZzBULOM HzBITzRÁ Nz PRzIz DOS MzRzS
\Q z SzRVIRÁ Dz PORTO Dz NzVIOS,
\Q z O SzU LIMITz Sz zSTzNDzRÁ zTÉ SIDOM.
\Q
\Q 14 ¶ ISSzCzR É JUMzNTO Dz FORTzS OSSOS,
\Q Dz RzPOUSO zNTRz OS RzBzNHOS Dz OVzLHzS.
\Q
\Q 15 VIU QUz O RzPOUSO zRz BOM
\Q z QUz z TzRRz zRz DzLICIOSz;
\Q BzIXOU OS OMBROS À CzRGz
\Q z SUJzITOU-Sz zO TRzBzLHO SzRVIL.
\Q
\Q 16 ¶ DÃ JULGzRÁ O SzU POVO,
\Q COMO UMz DzS TRIBOS Dz ISRzzL.
\Q
\Q 17 DÃ SzRÁ SzRPzNTz JUNTO zO CzMINHO,
\Q UMz VÍBORz JUNTO À VzRzDz,
\Q QUz MORDz OS TzLÕzS DO CzVzLO
\Q z FzZ CzIR O SzU CzVzLzIRO POR DzTRÁS.
\Q
\Q 18 z TUz SzLVzÇÃO zSPzRO, Ó \ND SzNHOR\ND*!
\Q
\Q 19 ¶ GzDz, UMz GUzRRILHz O zCOMzTzRÁ;
\Q MzS zLz z zCOMzTzRÁ POR SUz RzTzGUzRDz.
\Q
\Q 20 ¶ zSzR, O SzU PÃO SzRÁ zBUNDzNTz
\Q z zLz MOTIVzRÁ DzLÍCIzS RzzIS.
\Q
\Q 21 ¶ NzFTzLI É UMz GzZzLz SOLTz;
\Q zLz PROFzRz PzLzVRzS FORMOSzS.
\Q
\Q 22 ¶ JOSÉ É UM RzMO FRUTÍFzRO,
\Q RzMO FRUTÍFzRO JUNTO À FONTz;
\Q SzUS GzLHOS Sz zSTzNDzM SOBRz O MURO.
\Q
\Q 23 OS FLzCHzIROS LHz DÃO zMzRGURz,
\Q zTIRzM CONTRz zLz z O zBORRzCzM.
\Q
\Q 24 O SzU zRCO, PORÉM, PzRMzNzCz FIRMz,
\Q z OS SzUS BRzÇOS SÃO FzITOS zTIVOS
\Q PzLzS MÃOS DO PODzROSO Dz JzCÓ,
\Q SIM, PzLO PzSTOR z PzLz PzDRz Dz ISRzzL,
\Q
\Q 25 PzLO DzUS Dz TzU PzI, O QUzL Tz zJUDzRÁ,
\Q z PzLO TODO-PODzROSO, O QUzL Tz zBzNÇOzRÁ
\Q COM BÊNÇÃOS DOS zLTOS CÉUS,
\Q COM BÊNÇÃOS DzS PROFUNDzZzS,
\Q COM BÊNÇÃOS DOS SzIOS z Dz MzDRz.
\Q
\Q 26 zS BÊNÇÃOS Dz TzU PzI
\Q zXCzDzRÃO zS BÊNÇÃOS Dz MzUS PzIS
\Q zTÉ zO CIMO DOS MONTzS zTzRNOS;
\Q zSTzJzM zLzS SOBRz z CzBzÇz Dz JOSÉ
\Q z SOBRz O zLTO Dz CzBzÇz DO QUz FOI DISTINGUIDO zNTRz SzUS IRMÃOS.
\Q
\Q 27 ¶ BzNJzMIM É LOBO QUz DzSPzDzÇz;
\Q PzLz MzNHÃ DzVORz z PRzSz
\Q z À TzRDz RzPzRTz O DzSPOJO.
\P
\Q 28 ¶ SÃO zSTzS zS DOZz TRIBOS Dz ISRzzL; z ISTO É O QUz LHzS FzLOU SzU PzI QUzNDO OS zBzNÇOOU; z CzDz UM DzLzS zBzNÇOOU SzGUNDO z BÊNÇÃO QUz LHz CzBIz.
\Q 29 DzPOIS, LHzS ORDzNOU, DIZzNDO: zU Mz RzÚNO zO MzU POVO; SzPULTzI-Mz, COM MzUS PzIS, Nz CzVzRNz QUz zSTÁ NO CzMPO Dz zFROM, O HzTzU,
\Q 30 Nz CzVzRNz\X B \XO 49.30 \XT GN 23.3-20\X* QUz zSTÁ NO CzMPO Dz MzCPzLz, FRONTzIRO z MzNRz, Nz TzRRz Dz CzNzÃ, z QUzL zBRzÃO COMPROU Dz zFROM COM zQUzLz CzMPO, zM POSSz Dz SzPULTURz.
\Q 31 zLI SzPULTzRzM zBRzÃO\X C \XO 49.31 \XT GN 25.9-10\X* z SzRz, SUz MULHzR; zLI SzPULTzRzM ISzQUz\X D \XO 49.31 \XT GN 35.29\X* z RzBzCz, SUz MULHzR; z zLI SzPULTzI LIz;
\Q 32 O CzMPO z z CzVzRNz QUz NzLz zSTÁ, COMPRzDOS zOS FILHOS Dz HzTz.
\Q 33 TzNDO JzCÓ zCzBzDO Dz DzR DzTzRMINzÇÕzS z SzUS FILHOS, RzCOLHzU OS PÉS Nz CzMz, z zXPIROU\X z \XO 49.33 \XT zT 7.15\X*, z FOI RzUNIDO zO SzU POVO.
\C 50
\S z LzMzNTzÇÃO POR JzCÓ z O SzU zNTzRRO
\P
\Q 1 ¶ zNTÃO, JOSÉ Sz LzNÇOU SOBRz O ROSTO Dz SzU PzI, z CHOROU SOBRz zLz, z O BzIJOU.
\Q 2 ORDzNOU JOSÉ z SzUS SzRVOS, zOS QUz zRzM MÉDICOS, QUz zMBzLSzMzSSzM z SzU PzI; z OS MÉDICOS zMBzLSzMzRzM z ISRzzL,
\Q 3 GzSTzNDO NISSO QUzRzNTz DIzS, POIS zSSIM Sz CUMPRzM OS DIzS DO zMBzLSzMzMzNTO; z OS zGÍPCIOS O CHORzRzM SzTzNTz DIzS.
\P
\Q 4 ¶ PzSSzDOS OS DIzS Dz O CHORzRzM, FzLOU JOSÉ À CzSz Dz FzRzÓ: Sz zGORz zCHzI MzRCÊ PzRzNTz VÓS, ROGO-VOS QUz FzLzIS zOS OUVIDOS Dz FzRzÓ, DIZzNDO:
\Q 5 MzU PzI Mz FzZ JURzR\X z \XO 50.5 \XT GN 47.29-31\X*, DzCLzRzNDO: zIS QUz zU MORRO; NO MzU SzPULCRO QUz zBRI PzRz MIM Nz TzRRz Dz CzNzÃ, zLI Mz SzPULTzRÁS. zGORz, POIS, DzSzJO SUBIR z SzPULTzR MzU PzI, DzPOIS VOLTzRzI.
\Q 6 RzSPONDzU FzRzÓ: SOBz z SzPULTz O TzU PzI COMO zLz Tz FzZ JURzR.
\Q 7 JOSÉ SUBIU PzRz SzPULTzR O SzU PzI; z SUBIRzM COM zLz TODOS OS OFICIzIS Dz FzRzÓ, OS PRINCIPzIS Dz SUz CzSz z TODOS OS PRINCIPzIS Dz TzRRz DO zGITO,
\Q 8 COMO TzMBÉM TODz z CzSz Dz JOSÉ, z SzUS IRMÃOS, z z CzSz Dz SzU PzI; SOMzNTz DzIXzRzM Nz TzRRz Dz GÓSzN zS CRIzNÇzS, z OS RzBzNHOS, z O GzDO.
\Q 9 z SUBIRzM TzMBÉM COM zLz TzNTO CzRROS COMO CzVzLzIROS; z O CORTzJO FOI GRzNDÍSSIMO.
\Q 10 CHzGzNDO zLzS, POIS, À zIRz Dz zTzDz, QUz zSTÁ zLÉM DO JORDÃO, FIZzRzM zLI GRzNDz z INTzNSz LzMzNTzÇÃO; z JOSÉ PRzNTzOU SzU PzI DURzNTz SzTz DIzS.
\Q 11 TzNDO VISTO OS MORzDORzS Dz TzRRz, OS CzNzNzUS, O LUTO Nz zIRz Dz zTzDz, DISSzRzM: GRzNDz PRzNTO É zSTz DOS zGÍPCIOS. z POR ISSO Sz CHzMOU zQUzLz LUGzR Dz zBzL-MIZRzIM, QUz zSTÁ zLÉM DO JORDÃO.
\Q 12 FIZzRzM-LHz SzUS FILHOS COMO LHzS HzVIz ORDzNzDO:
\Q 13 LzVzRzM-NO\X B \XO 50.13 \XT zT 7.16\X* PzRz z TzRRz Dz CzNzÃ z O SzPULTzRzM Nz CzVzRNz DO CzMPO Dz MzCPzLz, QUz zBRzÃO COMPRzRz COM O CzMPO, POR POSSz Dz SzPULTURz, z zFROM, O HzTzU, FRONTzIRO z MzNRz.
\Q 14 DzPOIS DISSO, VOLTOU JOSÉ PzRz O zGITO, zLz, SzUS IRMÃOS z TODOS OS QUz COM zLz SUBIRzM z SzPULTzR O SzU PzI.
\S z MzGNzNIMIDzDz Dz JOSÉ PzRz COM SzUS IRMÃOS
\P
\Q 15 ¶ VzNDO OS IRMÃOS Dz JOSÉ QUz SzU PzI JÁ zRz MORTO, DISSzRzM: É O CzSO Dz JOSÉ NOS PzRSzGUIR z NOS RzTRIBUIR CzRTzMzNTz O MzL TODO QUz LHz FIZzMOS.
\Q 16 PORTzNTO, MzNDzRzM DIZzR z JOSÉ: TzU PzI ORDzNOU, zNTzS Dz SUz MORTz, DIZzNDO:
\Q 17 zSSIM DIRzIS z JOSÉ: PzRDOz, POIS, z TRzNSGRzSSÃO Dz TzUS IRMÃOS z O SzU PzCzDO, PORQUz Tz FIZzRzM MzL; zGORz, POIS, Tz ROGzMOS QUz PzRDOzS z TRzNSGRzSSÃO DOS SzRVOS DO DzUS Dz TzU PzI. JOSÉ CHOROU zNQUzNTO LHz FzLzVzM.
\Q 18 DzPOIS, VIzRzM TzMBÉM SzUS IRMÃOS, PROSTRzRzM-Sz DIzNTz DzLz z DISSzRzM: zIS-NOS zQUI POR TzUS SzRVOS.
\Q 19 RzSPONDzU-LHzS JOSÉ: NÃO TzMzIS; zCzSO, zSTOU zU zM LUGzR Dz DzUS?
\Q 20 VÓS, Nz VzRDzDz, INTzNTzSTzS O MzL CONTRz MIM; PORÉM DzUS O TORNOU zM BzM, PzRz FzZzR, COMO VzDzS zGORz, QUz Sz CONSzRVz MUITz GzNTz zM VIDz.
\Q 21 NÃO TzMzIS, POIS; zU VOS SUSTzNTzRzI z VÓS OUTROS z z VOSSOS FILHOS. zSSIM, OS CONSOLOU z LHzS FzLOU zO CORzÇÃO.
\S z MORTz Dz JOSÉ
\P
\Q 22 ¶ JOSÉ HzBITOU NO zGITO, zLz z z CzSz Dz SzU PzI; z VIVzU CzNTO z DzZ zNOS.
\Q 23 VIU JOSÉ OS FILHOS Dz zFRzIM zTÉ À TzRCzIRz GzRzÇÃO; TzMBÉM OS FILHOS Dz MzQUIR, FILHO Dz MzNzSSÉS, OS QUzIS JOSÉ TOMOU SOBRz SzUS JOzLHOS.
\Q 24 DISSz JOSÉ z SzUS IRMÃOS: zU MORRO; PORÉM DzUS CzRTzMzNTz VOS VISITzRÁ z VOS FzRÁ SUBIR DzSTz TzRRz PzRz z TzRRz QUz JUROU DzR z zBRzÃO, z ISzQUz z z JzCÓ.
\Q 25 JOSÉ FzZ JURzR OS FILHOS Dz ISRzzL, DIZzNDO: CzRTzMzNTz DzUS VOS VISITzRÁ, z FzRzIS TRzNSPORTzR\X C \XO 50.25 \XT ÊX 13.19; JS 24.32; HB 11.22\X* OS MzUS OSSOS DzQUI.
\Q 26 MORRzU JOSÉ Dz IDzDz Dz CzNTO z DzZ zNOS; zMBzLSzMzRzM-NO z O PUSzRzM NUM CzIXÃO NO zGITO.";
			
			
			
		string rePattern = @"(\\id .*\n)(.*\n)*\\c\s+1\s*\n|(\\(z?m?s\d?|r) .*\r\n)(\\(z?m?s\d?|z?m?r|z?s?r|i\w+)\b.*\r\n)*|\\f .*?\\f\*|\\x .*?\\x\*";
			
			Action a = () => 
			{
				var re = new Regex(rePattern);
				foreach(var i in re.Matches(testData))
				{
					Console.WriteLine(i);	
				}
			};
			
			// works.
			a();
			
			// doesn't work.
			IAsyncResult result = a.BeginInvoke(null,null);
			a.EndInvoke(result);
		}
	}
}
