/* Generated by re2c 0.13.5 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2016 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yyleng) {                                 \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng && (                              \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len) {  \
	Z_STRVAL_P(retval) = zend_strndup(str, len); \
	Z_STRLEN_P(retval) = len;                    \
	Z_TYPE_P(retval) = IS_STRING;                \
}

#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh TSRMLS_DC)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(TSRMLS_D)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(TSRMLS_D)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(TSRMLS_D)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode TSRMLS_DC)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh TSRMLS_CC) == FAILURE) {
		zend_file_handle_dtor(fh TSRMLS_CC);
		return FAILURE;
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode TSRMLS_DC)
{
	int len = strlen(str);

	if (init_ini_scanner(scanner_mode, NULL TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len TSRMLS_CC);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 384 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case '\t':	goto yy4;
		case '\n':	goto yy6;
		case '\r':	goto yy8;
		case ' ':	goto yy9;
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy10;
		case '#':	goto yy12;
		case '%':
		case '\'':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case ':':
		case '<':
		case '>':
		case '?':
		case '@':
		case ']':	goto yy13;
		case ';':	goto yy14;
		case '=':	goto yy16;
		case 'F':
		case 'f':	goto yy18;
		case 'N':
		case 'n':	goto yy19;
		case 'O':
		case 'o':	goto yy20;
		case 'T':
		case 't':	goto yy21;
		case 'Y':
		case 'y':	goto yy22;
		case '[':	goto yy23;
		default:	goto yy2;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy26;
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 480 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 523 "Zend/zend_ini_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy73;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 626 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 537 "Zend/zend_ini_scanner.c"
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 631 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 549 "Zend/zend_ini_scanner.c"
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy76;
		goto yy7;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy26;
				if (yych <= '\t') goto yy72;
				goto yy76;
			} else {
				if (yych == '\r') goto yy77;
				if (yych <= 0x1F) goto yy26;
				goto yy74;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy63;
				goto yy26;
			} else {
				if (yych <= ';') goto yy58;
				if (yych == '=') goto yy56;
				goto yy26;
			}
		}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 554 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 588 "Zend/zend_ini_scanner.c"
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy64;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy26;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy59;
		YYDEBUG(15, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 609 "Zend/zend_ini_scanner.c"
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy57;
yy17:
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 490 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_VALUE TSRMLS_CC);
	}
	return '=';
}
#line 627 "Zend/zend_ini_scanner.c"
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy53;
		if (yych == 'a') goto yy53;
		goto yy26;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy44;
			if (yych <= 'T') goto yy26;
			goto yy45;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy26;
				goto yy44;
			} else {
				if (yych == 'u') goto yy45;
				goto yy26;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy38;
			if (yych <= 'M') goto yy26;
			goto yy31;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy26;
				goto yy38;
			} else {
				if (yych == 'n') goto yy31;
				goto yy26;
			}
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy36;
		if (yych == 'r') goto yy36;
		goto yy26;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy27;
		if (yych == 'e') goto yy27;
		goto yy26;
yy23:
		YYDEBUG(23, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(24, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 405 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_SECTION_VALUE TSRMLS_CC);
	}
	return TC_SECTION;
}
#line 693 "Zend/zend_ini_scanner.c"
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy26:
		YYDEBUG(26, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy25;
		}
		if (yych == '[') goto yy28;
		goto yy3;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy31;
		if (yych == 's') goto yy31;
		goto yy26;
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy28;
		}
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 430 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();
	
	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET TSRMLS_CC);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 736 "Zend/zend_ini_scanner.c"
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy31;
		}
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy34;
				} else {
					if (yych != '\r') goto yy25;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy25;
				} else {
					if (yych != '&') goto yy25;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy33;
					if (yych <= ':') goto yy25;
				} else {
					if (yych != '=') goto yy25;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy28;
					if (yych <= ']') goto yy25;
				} else {
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 468 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 786 "Zend/zend_ini_scanner.c"
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		if (yych == '\t') goto yy34;
		if (yych == ' ') goto yy34;
		goto yy33;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy37;
		if (yych != 'u') goto yy26;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy31;
		if (yych == 'e') goto yy31;
		goto yy26;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy39;
		if (yych != 'f') goto yy26;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(40, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy42;
				} else {
					if (yych != '\r') goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych >= '#') goto yy25;
				} else {
					if (yych == '%') goto yy25;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy25;
					if (yych >= '*') goto yy25;
				} else {
					if (yych == '<') goto yy25;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy25;
				} else {
					if (yych <= '^') goto yy41;
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 472 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 860 "Zend/zend_ini_scanner.c"
yy42:
		YYDEBUG(42, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(43, *YYCURSOR);
		if (yych == '\t') goto yy42;
		if (yych == ' ') goto yy42;
		goto yy41;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy42;
					goto yy41;
				} else {
					if (yych == '\r') goto yy41;
					goto yy26;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych <= '"') goto yy41;
					goto yy26;
				} else {
					if (yych == '%') goto yy26;
					if (yych <= '&') goto yy41;
					goto yy26;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy41;
					if (yych <= ':') goto yy26;
					goto yy41;
				} else {
					if (yych == '=') goto yy41;
					if (yych <= 'M') goto yy26;
					goto yy52;
				}
			} else {
				if (yych <= 'm') {
					if (yych == '^') goto yy41;
					goto yy26;
				} else {
					if (yych <= 'n') goto yy52;
					if (yych <= 'z') goto yy26;
					if (yych <= '~') goto yy41;
					goto yy26;
				}
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy46;
		if (yych != 'l') goto yy26;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy47;
		if (yych != 'l') goto yy26;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy50;
				} else {
					if (yych != '\r') goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy47;
					if (yych >= '#') goto yy25;
				} else {
					if (yych == '%') goto yy25;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy25;
					if (yych >= '*') goto yy25;
				} else {
					if (yych == '<') goto yy25;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy25;
				} else {
					if (yych <= '^') goto yy49;
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 476 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 975 "Zend/zend_ini_scanner.c"
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(51, *YYCURSOR);
		if (yych == '\t') goto yy50;
		if (yych == ' ') goto yy50;
		goto yy49;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy26;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy54;
		if (yych != 'l') goto yy26;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy55;
		if (yych != 's') goto yy26;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy26;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy57:
		YYDEBUG(57, *YYCURSOR);
		if (yych == '\t') goto yy56;
		if (yych == ' ') goto yy56;
		goto yy17;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy58;
		}
		if (yych >= '\r') goto yy62;
yy60:
		YYDEBUG(60, *YYCURSOR);
		++YYCURSOR;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 636 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1040 "Zend/zend_ini_scanner.c"
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy60;
		goto yy61;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy64:
		YYDEBUG(64, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy63;
					if (yych >= '\n') goto yy69;
				} else {
					if (yych == '\r') goto yy71;
					goto yy63;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy63;
				} else {
					if (yych != '&') goto yy63;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy65;
					if (yych <= ':') goto yy63;
				} else {
					if (yych != '=') goto yy63;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy67;
					if (yych <= ']') goto yy63;
				} else {
					if (yych <= 'z') goto yy63;
					if (yych >= 0x7F) goto yy63;
				}
			}
		}
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(66, *YYCURSOR);
		if (yych == '\n') goto yy69;
		if (yych == '\r') goto yy71;
		goto yy65;
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy65;
			if (yych <= '\t') goto yy67;
			if (yych >= '\v') goto yy65;
		} else {
			if (yych <= '\r') goto yy71;
			if (yych == ' ') goto yy67;
			goto yy65;
		}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 642 "Zend/zend_ini_scanner.l"
		{ /* #Comment */
	zend_error(E_DEPRECATED, "Comments starting with '#' are deprecated in %s on line %d", zend_ini_scanner_get_filename(TSRMLS_C), SCNG(lineno));
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1126 "Zend/zend_ini_scanner.c"
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy69;
		goto yy70;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy73:
		YYDEBUG(73, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy5;
				if (yych <= '\t') goto yy72;
				goto yy76;
			} else {
				if (yych == '\r') goto yy77;
				if (yych <= 0x1F) goto yy5;
				goto yy72;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy65;
				goto yy5;
			} else {
				if (yych <= ';') goto yy58;
				if (yych == '=') goto yy56;
				goto yy5;
			}
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy72;
				} else {
					if (yych == '\r') goto yy77;
					goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy74;
					if (yych <= '"') goto yy3;
					goto yy63;
				} else {
					if (yych == '%') goto yy25;
					goto yy3;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy25;
					if (yych <= ')') goto yy3;
					goto yy25;
				} else {
					if (yych <= ';') goto yy58;
					if (yych <= '<') goto yy25;
					goto yy56;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy25;
				} else {
					if (yych <= '^') goto yy3;
					if (yych <= 'z') goto yy25;
					if (yych <= '~') goto yy3;
					goto yy25;
				}
			}
		}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy7;
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy76;
		goto yy7;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(78, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy82;
		if (yych == '$') goto yy84;
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
yy81:
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 586 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}
		
		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	
	zend_ini_escape_string(ini_lval, yytext, yyleng, '"' TSRMLS_CC);
	return TC_QUOTED_STRING;
}
#line 1302 "Zend/zend_ini_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy88;
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 581 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state(TSRMLS_C);
	return '"';
}
#line 1316 "Zend/zend_ini_scanner.c"
yy84:
		YYDEBUG(84, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy81;
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1330 "Zend/zend_ini_scanner.c"
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy88:
		YYDEBUG(88, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy87;
		}
		goto yy83;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66, 194,  64,  66,  66,  64,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			194,  66,  64,  66,  68,  66,  66,   0, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114,  66,  64,  66,  66,  66,  66, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  72,  64,  66,  82, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
		};
		YYDEBUG(89, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy91;
					if (yych <= '\t') goto yy93;
					goto yy94;
				} else {
					if (yych == '\r') goto yy94;
					if (yych >= ' ') goto yy93;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy96;
					if (yych >= '$') goto yy98;
				} else {
					if (yych == '\'') goto yy99;
					if (yych >= '-') goto yy100;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy101;
					if (yych >= '0') goto yy102;
				} else {
					if (yych == ';') goto yy94;
					if (yych >= 'A') goto yy104;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy91;
					if (yych <= '\\') goto yy106;
					if (yych <= ']') goto yy107;
				} else {
					if (yych == '`') goto yy91;
					if (yych <= 'z') goto yy104;
				}
			}
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy110;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 572 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1434 "Zend/zend_ini_scanner.c"
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy136;
		}
		if (yych == '"') goto yy138;
		if (yych == ']') goto yy139;
		goto yy110;
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1455 "Zend/zend_ini_scanner.c"
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 576 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 1467 "Zend/zend_ini_scanner.c"
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy95;
			if (yych <= '[') goto yy109;
			goto yy114;
		} else {
			if (yych == '{') goto yy134;
			goto yy109;
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy130;
		}
		goto yy95;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy110;
		if (yych <= '9') goto yy128;
		goto yy110;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy110;
		if (yych <= '9') goto yy126;
		goto yy110;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy103;
				if (yych <= '\f') goto yy110;
			} else {
				if (yych == '"') goto yy103;
				if (yych <= '&') goto yy110;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy122;
				if (yych <= '/') goto yy110;
				goto yy124;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy110;
				} else {
					if (yych != ']') goto yy110;
				}
			}
		}
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 550 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1533 "Zend/zend_ini_scanner.c"
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy120;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy110;
			} else {
				if (yych <= '\r') goto yy105;
				if (yych <= '!') goto yy110;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy110;
			} else {
				if (yych <= ';') goto yy105;
				if (yych != ']') goto yy110;
			}
		}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 546 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1563 "Zend/zend_ini_scanner.c"
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy109;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 443 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1579 "Zend/zend_ini_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy110:
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy109;
		}
		if (yych == '$') goto yy112;
		if (yych != '\\') goto yy92;
yy111:
		YYDEBUG(111, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy109;
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy113;
			if (yych <= '[') goto yy109;
			goto yy114;
		} else {
			if (yych != '{') goto yy109;
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy92;
			} else {
				goto yy95;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy103;
			} else {
				goto yy105;
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy115;
		}
		if (yych == '\\') goto yy117;
		goto yy109;
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(116, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy115;
		}
		if (yych == '\\') goto yy119;
		goto yy109;
yy117:
		YYDEBUG(117, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(118, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy115;
		}
		if (yych == '\\') goto yy117;
		goto yy109;
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy115;
		}
		if (yych == '\\') goto yy117;
		goto yy109;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy120;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy105;
				if (yych <= '\f') goto yy109;
				goto yy105;
			} else {
				if (yych == '"') goto yy105;
				if (yych <= '#') goto yy109;
				goto yy112;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy105;
				if (yych <= ':') goto yy109;
				goto yy105;
			} else {
				if (yych <= '[') goto yy109;
				if (yych <= '\\') goto yy111;
				if (yych <= ']') goto yy105;
				goto yy109;
			}
		}
yy122:
		YYDEBUG(122, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy122;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy103;
				if (yych <= '\f') goto yy109;
				goto yy103;
			} else {
				if (yych == '"') goto yy103;
				if (yych <= '#') goto yy109;
				goto yy112;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy103;
				if (yych <= ':') goto yy109;
				goto yy103;
			} else {
				if (yych <= '[') goto yy109;
				if (yych <= '\\') goto yy111;
				if (yych <= ']') goto yy103;
				goto yy109;
			}
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(125, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy109;
					goto yy103;
				} else {
					if (yych == '\r') goto yy103;
					goto yy109;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy103;
					goto yy109;
				} else {
					if (yych <= '$') goto yy112;
					if (yych <= '&') goto yy109;
					goto yy103;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy109;
					goto yy122;
				} else {
					if (yych <= '/') goto yy109;
					if (yych <= '9') goto yy124;
					goto yy109;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy103;
					goto yy109;
				} else {
					if (yych <= '\\') goto yy111;
					if (yych <= ']') goto yy103;
					goto yy109;
				}
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(127, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy103;
				if (yych <= '\f') goto yy109;
				goto yy103;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy109;
					goto yy103;
				} else {
					if (yych == '$') goto yy112;
					goto yy109;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy103;
				if (yych <= '/') goto yy109;
				if (yych <= '9') goto yy126;
				goto yy109;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy103;
					goto yy109;
				} else {
					if (yych <= '\\') goto yy111;
					if (yych <= ']') goto yy103;
					goto yy109;
				}
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(129, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy103;
				if (yych <= '\f') goto yy109;
				goto yy103;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy109;
					goto yy103;
				} else {
					if (yych == '$') goto yy112;
					goto yy109;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy103;
				if (yych <= '/') goto yy109;
				if (yych <= '9') goto yy128;
				goto yy109;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy103;
					goto yy109;
				} else {
					if (yych <= '\\') goto yy111;
					if (yych <= ']') goto yy103;
					goto yy109;
				}
			}
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(131, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy130;
		}
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1878 "Zend/zend_ini_scanner.c"
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1889 "Zend/zend_ini_scanner.c"
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(137, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy136;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy92;
				if (yych <= '\f') goto yy109;
				goto yy92;
			} else {
				if (yych == '"') goto yy138;
				if (yych <= '#') goto yy109;
				goto yy112;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy92;
				if (yych <= ':') goto yy109;
				goto yy92;
			} else {
				if (yych <= '[') goto yy109;
				if (yych <= '\\') goto yy111;
				if (yych <= ']') goto yy139;
				goto yy109;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy97;
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy108;
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(140, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy144;
			} else {
				if (yych <= '\t') goto yy146;
				if (yych <= '\n') goto yy147;
				goto yy144;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy149;
				if (yych <= 0x1F) goto yy144;
				goto yy146;
			} else {
				if (yych == ';') goto yy150;
				goto yy144;
			}
		}
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 649 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1999 "Zend/zend_ini_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 499 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2043 "Zend/zend_ini_scanner.c"
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy145;
			if (yych <= '\n') goto yy158;
			if (yych <= '\f') goto yy145;
			goto yy158;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy145;
				goto yy158;
			} else {
				if (yych == ';') goto yy158;
				goto yy145;
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 540 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2074 "Zend/zend_ini_scanner.c"
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy156;
		goto yy148;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy152;
yy151:
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy152:
		YYDEBUG(152, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy151;
		}
		if (yych >= '\r') goto yy155;
yy153:
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 636 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2108 "Zend/zend_ini_scanner.c"
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy153;
		goto yy154;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy148;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy158:
		YYDEBUG(158, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy157;
		}
		if (yych <= '\f') {
			if (yych == '\n') goto yy156;
		} else {
			if (yych <= '\r') goto yy160;
			if (yych == ';') goto yy151;
		}
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 626 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 2142 "Zend/zend_ini_scanner.c"
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy156;
		goto yy148;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(161, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\n') goto yy165;
		} else {
			if (yych <= '\r') goto yy165;
			if (yych == ']') goto yy167;
		}
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy174;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 536 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2206 "Zend/zend_ini_scanner.c"
yy165:
		YYDEBUG(165, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(166, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2216 "Zend/zend_ini_scanner.c"
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy170;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 424 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2231 "Zend/zend_ini_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy170:
		YYDEBUG(170, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy169;
		}
		if (yych == '\n') goto yy171;
		if (yych == '\r') goto yy172;
		goto yy168;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy168;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy171;
		goto yy168;
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy174:
		YYDEBUG(174, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy173;
		}
		goto yy164;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 134, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			134, 132, 128, 132, 136, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			228, 228, 228, 228, 228, 228, 228, 228, 
			228, 228, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 144, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(175, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy177;
					if (yych <= '\t') goto yy179;
					goto yy180;
				} else {
					if (yych == '\r') goto yy180;
					if (yych >= ' ') goto yy179;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy182;
					if (yych >= '$') goto yy184;
				} else {
					if (yych == '\'') goto yy185;
					if (yych >= '-') goto yy186;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy187;
					if (yych >= '0') goto yy188;
				} else {
					if (yych == ';') goto yy180;
					if (yych >= 'A') goto yy190;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy177;
					if (yych <= '\\') goto yy192;
					if (yych <= ']') goto yy193;
				} else {
					if (yych == '`') goto yy177;
					if (yych <= 'z') goto yy190;
				}
			}
		}
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy200;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 572 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2357 "Zend/zend_ini_scanner.c"
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy226;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy226;
			if (yych == '"') goto yy228;
			goto yy200;
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2380 "Zend/zend_ini_scanner.c"
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 576 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 2392 "Zend/zend_ini_scanner.c"
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy181;
			if (yych <= '[') goto yy199;
			goto yy204;
		} else {
			if (yych == '{') goto yy224;
			goto yy199;
		}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy220;
		}
		goto yy181;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy200;
		if (yych <= '9') goto yy218;
		goto yy200;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy200;
		if (yych <= '9') goto yy216;
		goto yy200;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy189;
				if (yych <= '\f') goto yy200;
			} else {
				if (yych == '"') goto yy189;
				if (yych <= '&') goto yy200;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy212;
				if (yych <= '/') goto yy200;
				goto yy214;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy200;
				} else {
					if (yych != ']') goto yy200;
				}
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 550 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2458 "Zend/zend_ini_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy210;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy200;
			} else {
				if (yych <= '\r') goto yy191;
				if (yych <= '!') goto yy200;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy200;
			} else {
				if (yych <= ';') goto yy191;
				if (yych != ']') goto yy200;
			}
		}
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 546 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2488 "Zend/zend_ini_scanner.c"
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy199;
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy196;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 424 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2507 "Zend/zend_ini_scanner.c"
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy196:
		YYDEBUG(196, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy195;
		}
		if (yych == '\n') goto yy197;
		if (yych == '\r') goto yy198;
		goto yy194;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy194;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy197;
		goto yy194;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy200:
		YYDEBUG(200, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy199;
		}
		if (yych == '$') goto yy202;
		if (yych != '\\') goto yy178;
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy199;
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy203;
			if (yych <= '[') goto yy199;
			goto yy204;
		} else {
			if (yych != '{') goto yy199;
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy178;
			} else {
				goto yy181;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy189;
			} else {
				goto yy191;
			}
		}
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy205;
		}
		if (yych == '\\') goto yy207;
		goto yy199;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy205;
		}
		if (yych == '\\') goto yy209;
		goto yy199;
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy205;
		}
		if (yych == '\\') goto yy207;
		goto yy199;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy205;
		}
		if (yych == '\\') goto yy207;
		goto yy199;
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy210;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy191;
				if (yych <= '\f') goto yy199;
				goto yy191;
			} else {
				if (yych == '"') goto yy191;
				if (yych <= '#') goto yy199;
				goto yy202;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy191;
				if (yych <= ':') goto yy199;
				goto yy191;
			} else {
				if (yych <= '[') goto yy199;
				if (yych <= '\\') goto yy201;
				if (yych <= ']') goto yy191;
				goto yy199;
			}
		}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy212;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy189;
				if (yych <= '\f') goto yy199;
				goto yy189;
			} else {
				if (yych == '"') goto yy189;
				if (yych <= '#') goto yy199;
				goto yy202;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy189;
				if (yych <= ':') goto yy199;
				goto yy189;
			} else {
				if (yych <= '[') goto yy199;
				if (yych <= '\\') goto yy201;
				if (yych <= ']') goto yy189;
				goto yy199;
			}
		}
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy199;
					goto yy189;
				} else {
					if (yych == '\r') goto yy189;
					goto yy199;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy189;
					goto yy199;
				} else {
					if (yych <= '$') goto yy202;
					if (yych <= '&') goto yy199;
					goto yy189;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy199;
					goto yy212;
				} else {
					if (yych <= '/') goto yy199;
					if (yych <= '9') goto yy214;
					goto yy199;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy189;
					goto yy199;
				} else {
					if (yych <= '\\') goto yy201;
					if (yych <= ']') goto yy189;
					goto yy199;
				}
			}
		}
yy216:
		YYDEBUG(216, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy189;
				if (yych <= '\f') goto yy199;
				goto yy189;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy199;
					goto yy189;
				} else {
					if (yych == '$') goto yy202;
					goto yy199;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy189;
				if (yych <= '/') goto yy199;
				if (yych <= '9') goto yy216;
				goto yy199;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy189;
					goto yy199;
				} else {
					if (yych <= '\\') goto yy201;
					if (yych <= ']') goto yy189;
					goto yy199;
				}
			}
		}
yy218:
		YYDEBUG(218, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy189;
				if (yych <= '\f') goto yy199;
				goto yy189;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy199;
					goto yy189;
				} else {
					if (yych == '$') goto yy202;
					goto yy199;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy189;
				if (yych <= '/') goto yy199;
				if (yych <= '9') goto yy218;
				goto yy199;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy189;
					goto yy199;
				} else {
					if (yych <= '\\') goto yy201;
					if (yych <= ']') goto yy189;
					goto yy199;
				}
			}
		}
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy220;
		}
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2828 "Zend/zend_ini_scanner.c"
yy224:
		YYDEBUG(224, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(225, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 2839 "Zend/zend_ini_scanner.c"
yy226:
		YYDEBUG(226, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(227, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy199;
				if (yych <= '\t') goto yy226;
				if (yych <= '\n') goto yy178;
				goto yy199;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy178;
					goto yy199;
				} else {
					if (yych <= ' ') goto yy226;
					if (yych <= '!') goto yy199;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '$') {
					if (yych <= '#') goto yy199;
					goto yy202;
				} else {
					if (yych == '\'') goto yy178;
					goto yy199;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy178;
					goto yy199;
				} else {
					if (yych <= '\\') goto yy201;
					if (yych <= ']') goto yy178;
					goto yy199;
				}
			}
		}
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy183;
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			160, 162, 162, 162, 162, 162, 162, 162, 
			162, 176, 128, 162, 162, 128, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			176, 160, 160, 162, 168, 162, 160,  32, 
			160, 160, 162, 162, 162, 162, 162, 162, 
			230, 230, 230, 230, 230, 230, 230, 230, 
			230, 230, 162, 160, 162, 160, 162, 162, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 162, 162, 160, 166, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 160, 162, 160, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
		};
		YYDEBUG(229, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:	goto yy231;
		case '\t':
		case ' ':	goto yy235;
		case '\n':	goto yy237;
		case '\r':	goto yy239;
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy240;
		case '"':	goto yy242;
		case '$':	goto yy244;
		case '\'':	goto yy245;
		case '-':	goto yy246;
		case '.':	goto yy247;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy248;
		case ';':	goto yy250;
		case '=':	goto yy251;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy253;
		case 'F':
		case 'f':	goto yy255;
		case 'N':
		case 'n':	goto yy256;
		case 'O':
		case 'o':	goto yy257;
		case 'T':
		case 't':	goto yy258;
		case 'Y':
		case 'y':	goto yy259;
		default:	goto yy233;
		}
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 649 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3025 "Zend/zend_ini_scanner.c"
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy261;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 568 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 3038 "Zend/zend_ini_scanner.c"
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy315;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 622 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 3051 "Zend/zend_ini_scanner.c"
yy237:
		YYDEBUG(237, *YYCURSOR);
		++YYCURSOR;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 540 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 3064 "Zend/zend_ini_scanner.c"
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy313;
		goto yy238;
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy312;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 558 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 3082 "Zend/zend_ini_scanner.c"
yy242:
		YYDEBUG(242, *YYCURSOR);
		++YYCURSOR;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 576 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 3094 "Zend/zend_ini_scanner.c"
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy232;
			if (yych <= '[') goto yy260;
			goto yy267;
		} else {
			if (yych == '{') goto yy309;
			goto yy260;
		}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy305;
		}
		goto yy232;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy261;
		if (yych <= '9') goto yy303;
		goto yy261;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy261;
		if (yych <= '9') goto yy301;
		goto yy261;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy249;
					if (yych <= 0x08) goto yy261;
				} else {
					if (yych != '\r') goto yy261;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy249;
					if (yych <= '%') goto yy261;
				} else {
					if (yych == '.') goto yy297;
					goto yy261;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy299;
					if (yych <= ':') goto yy261;
				} else {
					if (yych != '=') goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy249;
					if (yych <= '{') goto yy261;
				} else {
					if (yych != '~') goto yy261;
				}
			}
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 550 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 3173 "Zend/zend_ini_scanner.c"
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy293;
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 562 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3190 "Zend/zend_ini_scanner.c"
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy262;
		}
		if (yych <= ':') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy261;
				} else {
					if (yych <= '\n') goto yy254;
					if (yych <= '\f') goto yy261;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy261;
				} else {
					if (yych <= '%') goto yy261;
					if (yych >= '*') goto yy261;
				}
			}
		} else {
			if (yych <= '^') {
				if (yych <= '<') {
					if (yych >= '<') goto yy261;
				} else {
					if (yych <= '=') goto yy254;
					if (yych <= ']') goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy261;
				} else {
					if (yych != '~') goto yy261;
				}
			}
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 546 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 3237 "Zend/zend_ini_scanner.c"
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					goto yy261;
				} else {
					if (yych <= '9') goto yy262;
					if (yych == ';') goto yy254;
					goto yy261;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy254;
					if (yych <= '@') goto yy261;
					goto yy289;
				} else {
					if (yych <= 'Z') goto yy262;
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy261;
					if (yych <= 'a') goto yy289;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					if (yych <= '\n') goto yy254;
					goto yy261;
				} else {
					if (yych <= '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					if (yych <= '"') goto yy254;
					goto yy261;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					if (yych <= '9') goto yy262;
					goto yy261;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy254;
						goto yy261;
					} else {
						if (yych <= '=') goto yy254;
						if (yych <= '@') goto yy261;
						goto yy262;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy281;
					if (yych == 'U') goto yy282;
					goto yy262;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy261;
						goto yy254;
					} else {
						if (yych == '`') goto yy261;
						goto yy262;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy281;
					if (yych == 'u') goto yy282;
					goto yy262;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy261;
						goto yy254;
					} else {
						if (yych == '~') goto yy254;
						goto yy261;
					}
				}
			}
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					if (yych <= '\n') goto yy254;
					goto yy261;
				} else {
					if (yych <= '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					if (yych <= '"') goto yy254;
					goto yy261;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					if (yych <= '9') goto yy262;
					goto yy261;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy254;
						goto yy261;
					} else {
						if (yych <= '=') goto yy254;
						if (yych <= '@') goto yy261;
						goto yy262;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy276;
					if (yych == 'N') goto yy270;
					goto yy262;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy261;
						goto yy254;
					} else {
						if (yych == '`') goto yy261;
						goto yy262;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy276;
					if (yych == 'n') goto yy270;
					goto yy262;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy261;
						goto yy254;
					} else {
						if (yych == '~') goto yy254;
						goto yy261;
					}
				}
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych == 'R') goto yy274;
					goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy274;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych == 'E') goto yy264;
					goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy264;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy261:
		YYDEBUG(261, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy260;
		}
		if (yych == '$') goto yy265;
		goto yy234;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy262;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy254;
					goto yy260;
				} else {
					if (yych <= '\n') goto yy254;
					if (yych <= '\f') goto yy260;
					goto yy254;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy260;
					if (yych <= '"') goto yy254;
					goto yy260;
				} else {
					if (yych <= '$') goto yy265;
					if (yych <= '%') goto yy260;
					goto yy254;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy260;
					goto yy254;
				} else {
					if (yych == '=') goto yy254;
					goto yy260;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy254;
					if (yych <= '{') goto yy260;
					goto yy254;
				} else {
					if (yych == '~') goto yy254;
					goto yy260;
				}
			}
		}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych == 'S') goto yy270;
					goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy270;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy265:
		YYDEBUG(265, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy266;
			if (yych <= '[') goto yy260;
			goto yy267;
		} else {
			if (yych != '{') goto yy260;
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy234;
				} else {
					goto yy236;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy232;
				} else {
					goto yy249;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy254;
				} else {
					goto yy271;
				}
			} else {
				if (yyaccept <= 6) {
					goto yy278;
				} else {
					goto yy285;
				}
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy268;
		}
		goto yy260;
yy268:
		YYDEBUG(268, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(269, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy268;
		}
		if (yych <= 0x00) goto yy234;
		if (yych == '\\') goto yy267;
		goto yy260;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy272;
		}
		if (yych <= ';') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy271;
					if (yych <= '\t') goto yy261;
				} else {
					if (yych != '\r') goto yy261;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy271;
					if (yych <= '%') goto yy261;
				} else {
					if (yych <= '/') goto yy261;
					if (yych <= '9') goto yy262;
					if (yych <= ':') goto yy261;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') {
					if (yych != '=') goto yy261;
				} else {
					if (yych <= 'Z') goto yy262;
					if (yych <= ']') goto yy261;
					if (yych >= '_') goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy261;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych >= 0x7F) goto yy261;
				}
			}
		}
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 468 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 3753 "Zend/zend_ini_scanner.c"
yy272:
		YYDEBUG(272, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(273, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy272;
		}
		goto yy271;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych != 'U') goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy275;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych == 'E') goto yy270;
					goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy270;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych != 'F') goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy277;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy262;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy261;
				} else {
					if (yych <= '\t') goto yy279;
					if (yych >= '\v') goto yy261;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy278;
					if (yych <= 0x1F) goto yy261;
					goto yy279;
				} else {
					if (yych <= '"') goto yy278;
					if (yych <= '%') goto yy261;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy261;
				} else {
					if (yych != '=') goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy278;
					if (yych <= '{') goto yy261;
				} else {
					if (yych != '~') goto yy261;
				}
			}
		}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 472 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 3963 "Zend/zend_ini_scanner.c"
yy279:
		YYDEBUG(279, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(280, *YYCURSOR);
		if (yych == '\t') goto yy279;
		if (yych == ' ') goto yy279;
		goto yy278;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy278;
					if (yych <= 0x08) goto yy261;
					if (yych <= '\t') goto yy279;
					goto yy278;
				} else {
					if (yych == '\r') goto yy278;
					if (yych <= 0x1F) goto yy261;
					goto yy279;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy278;
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy278;
					goto yy261;
				} else {
					if (yych <= '9') goto yy262;
					if (yych == ';') goto yy278;
					goto yy261;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy278;
					if (yych <= '@') goto yy261;
					if (yych <= 'M') goto yy262;
					goto yy288;
				} else {
					if (yych <= 'Z') goto yy262;
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy278;
					goto yy262;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy261;
					if (yych == 'n') goto yy288;
					goto yy262;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy261;
						goto yy278;
					} else {
						if (yych == '~') goto yy278;
						goto yy261;
					}
				}
			}
		}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych != 'L') goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy283;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych != 'L') goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy284;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy262;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy261;
				} else {
					if (yych <= '\t') goto yy286;
					if (yych >= '\v') goto yy261;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy285;
					if (yych <= 0x1F) goto yy261;
					goto yy286;
				} else {
					if (yych <= '"') goto yy285;
					if (yych <= '%') goto yy261;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy261;
				} else {
					if (yych != '=') goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy285;
					if (yych <= '{') goto yy261;
				} else {
					if (yych != '~') goto yy261;
				}
			}
		}
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 476 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 4178 "Zend/zend_ini_scanner.c"
yy286:
		YYDEBUG(286, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(287, *YYCURSOR);
		if (yych == '\t') goto yy286;
		if (yych == ' ') goto yy286;
		goto yy285;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych == 'E') goto yy277;
					goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy277;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych != 'L') goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy290;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych != 'S') goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy291;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy254;
					if (yych <= 0x08) goto yy261;
					goto yy254;
				} else {
					if (yych == '\r') goto yy254;
					if (yych <= 0x1F) goto yy261;
					goto yy254;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy254;
					if (yych <= '/') goto yy261;
					goto yy262;
				} else {
					if (yych == ';') goto yy254;
					if (yych <= '<') goto yy261;
					goto yy254;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy261;
					if (yych == 'E') goto yy277;
					goto yy262;
				} else {
					if (yych <= ']') goto yy261;
					if (yych <= '^') goto yy254;
					if (yych <= '_') goto yy262;
					goto yy261;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy277;
					if (yych <= 'z') goto yy262;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy254;
					goto yy261;
				}
			}
		}
yy292:
		YYDEBUG(292, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy293:
		YYDEBUG(293, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy292;
		}
		if (yych >= '\r') goto yy296;
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 636 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 4413 "Zend/zend_ini_scanner.c"
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy294;
		goto yy295;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(298, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy297;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy249;
					goto yy260;
				} else {
					if (yych <= '\n') goto yy249;
					if (yych <= '\f') goto yy260;
					goto yy249;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy260;
					if (yych <= '"') goto yy249;
					goto yy260;
				} else {
					if (yych <= '$') goto yy265;
					if (yych <= '%') goto yy260;
					goto yy249;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy260;
					goto yy249;
				} else {
					if (yych == '=') goto yy249;
					goto yy260;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy249;
					if (yych <= '{') goto yy260;
					goto yy249;
				} else {
					if (yych == '~') goto yy249;
					goto yy260;
				}
			}
		}
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(300, *YYCURSOR);
		if (yych <= '.') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy249;
					if (yych <= 0x08) goto yy260;
					goto yy249;
				} else {
					if (yych == '\r') goto yy249;
					goto yy260;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy249;
					if (yych <= '#') goto yy260;
					goto yy265;
				} else {
					if (yych <= '%') goto yy260;
					if (yych <= ')') goto yy249;
					if (yych <= '-') goto yy260;
					goto yy297;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '/') goto yy260;
					if (yych <= '9') goto yy299;
					goto yy260;
				} else {
					if (yych == '<') goto yy260;
					goto yy249;
				}
			} else {
				if (yych <= '{') {
					if (yych == '^') goto yy249;
					goto yy260;
				} else {
					if (yych == '}') goto yy260;
					if (yych <= '~') goto yy249;
					goto yy260;
				}
			}
		}
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(302, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy249;
					if (yych <= 0x08) goto yy260;
					goto yy249;
				} else {
					if (yych == '\r') goto yy249;
					goto yy260;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy249;
					if (yych <= '#') goto yy260;
					goto yy265;
				} else {
					if (yych <= '%') goto yy260;
					if (yych <= ')') goto yy249;
					goto yy260;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy301;
					if (yych <= ':') goto yy260;
					goto yy249;
				} else {
					if (yych == '=') goto yy249;
					goto yy260;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy249;
					if (yych <= '{') goto yy260;
					goto yy249;
				} else {
					if (yych == '~') goto yy249;
					goto yy260;
				}
			}
		}
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(304, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy249;
					if (yych <= 0x08) goto yy260;
					goto yy249;
				} else {
					if (yych == '\r') goto yy249;
					goto yy260;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy249;
					if (yych <= '#') goto yy260;
					goto yy265;
				} else {
					if (yych <= '%') goto yy260;
					if (yych <= ')') goto yy249;
					goto yy260;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy303;
					if (yych <= ':') goto yy260;
					goto yy249;
				} else {
					if (yych == '=') goto yy249;
					goto yy260;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy249;
					if (yych <= '{') goto yy260;
					goto yy249;
				} else {
					if (yych == '~') goto yy249;
					goto yy260;
				}
			}
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(306, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy305;
		}
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(308, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 4640 "Zend/zend_ini_scanner.c"
yy309:
		YYDEBUG(309, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(310, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 4651 "Zend/zend_ini_scanner.c"
yy311:
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy312:
		YYDEBUG(312, *YYCURSOR);
		if (yych == '\t') goto yy311;
		if (yych == ' ') goto yy311;
		goto yy241;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy238;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy315:
		YYDEBUG(315, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy236;
				if (yych <= '\t') goto yy314;
				goto yy313;
			} else {
				if (yych == '\r') goto yy317;
				goto yy236;
			}
		} else {
			if (yych <= '"') {
				if (yych <= ' ') goto yy314;
				if (yych <= '!') goto yy236;
			} else {
				if (yych == ';') goto yy292;
				goto yy236;
			}
		}
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy243;
yy317:
		YYDEBUG(317, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy313;
		goto yy238;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(318, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy320;
					if (yych <= '\n') goto yy322;
				} else {
					if (yych <= '\r') goto yy322;
					if (yych >= '!') goto yy322;
				}
			} else {
				if (yych <= '%') {
					if (yych == '$') goto yy322;
				} else {
					if (yych != '\'') goto yy322;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= '<') {
					if (yych == ';') goto yy322;
				} else {
					if (yych <= '=') goto yy322;
					if (yych >= '[') goto yy322;
				}
			} else {
				if (yych <= 'z') {
					if (yych == '^') goto yy322;
				} else {
					if (yych == '}') goto yy324;
					if (yych <= '~') goto yy322;
				}
			}
		}
yy320:
		YYDEBUG(320, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy327;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 453 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 4792 "Zend/zend_ini_scanner.c"
yy322:
		YYDEBUG(322, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(323, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 4802 "Zend/zend_ini_scanner.c"
yy324:
		YYDEBUG(324, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 463 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state(TSRMLS_C);
	return '}';
}
#line 4813 "Zend/zend_ini_scanner.c"
yy326:
		YYDEBUG(326, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy327:
		YYDEBUG(327, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy326;
		}
		goto yy321;
	}
}
#line 658 "Zend/zend_ini_scanner.l"

}
